<?php
/* SVN FILE: $Id: POP3.php 342 2008-05-11 02:27:14Z bb_yujiro $ */
/**
 * POP3からのインポート
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 342 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 11:27:14 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * BLOB_Attach_POP3クラス
 *
 * @category        Binary Large OBject
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 342 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 11:27:14 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class BLOB_Attach_POP3 extends BLOB_Attach_Common
{
    /**
     * ディレクトリ
     * @var string
     */
    private $_host = null;

    /**
     * ディレクトリ
     * @var string
     */
    private $_account = null;

    /**
     * ディレクトリ
     * @var string
     */
    private $_password = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $dsn
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        include LIB_DIR.'PEAR/Net/POP3.php';        
        
        $this->_host     = POP3_HOST;
        $this->_account  = POP3_ACCOUNT;
        $this->_password = POP3_PASSWORD;
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $pop3 = new Net_POP3();            // オブジェクトの作成
        $pop3->connect($this->_host);       // 接続

        /* ログイン */
        $result = $pop3->login($this->_account, $this->_password, true);
        if (PEAR::isError($result)){
            $pop3->disconnect();            // POP3との接続を終了
            return false;
        }

        $num = $pop3->numMsg();             // メッセージ数の取得
        for ($row=1; $row<=$num; $row++){
            $msg = $pop3->getMsg($row);

            /* メールソースの解析 */
            $this->parse($msg);

            $pop3->deleteMsg($row);         // メッセージの削除
        } // for ($row=1; $row<=$num; $row++)

        $pop3->disconnect();                // POP3との接続を終了

        return true;
    }

    /**
     * アカウントの指定
     *
     * @access public
     * @param string $account
     * @return void
     **/
    public function setAccount($account)
    {
        $this->_account = $account;
    }

    /**
     * ホストの指定
     *
     * @access public
     * @param string $host
     * @return void
     **/
    public function setHost($host)
    {
        $this->_host = $host;
    }

    /**
     * パスワードの指定
     *
     * @access public
     * @param string $password
     * @return void
     **/
    public function setPassword($password)
    {
        $this->_password = $password;
    }
} // BLOB_Attach_POP3の終了
?>