<?php
/* SVN FILE: $Id: Common.php 378 2008-05-15 02:36:17Z bb_yujiro $ */
/**
 * BLOB_Attach共通
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 378 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:36:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'PEAR/Mail/mimeDecode.php';

/**
 * BLOB_Attach_Commonクラス
 *
 * @category        Binary Large OBject
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 378 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:36:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class BLOB_Attach_Common
{
    /**
     * 携帯アドレス
     * @var string
     */
    protected $email = '';

    /**
     * アカウントID
     * @var string
     */
    protected $ref_account = '';

    /**
     * 添付データ
     * @var binary
     */
    protected $buffer = null;

    /**
     * 添付ファイルの種類
     * @var string
     */
    protected $format = '';

    /**
     * 添付画像テーブル処理オジェクト
     * @var object
     */
    protected $act_attach = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct()
    {
        if (!class_exists('Model_Manip')){
            include LIB_DIR.'rktModel/manip.php';
        }

        if (!class_exists('act_attach')){
            include MODEL_DIR.'manips/act_attach.php';
        }

        if (!class_exists('RKT_Blob')){
            include LIB_DIR.'rkt_blob.php';
        }

        if (!class_exists('RKT_Image')){
            include LIB_DIR.'rkt_image.php';
        }
        $this->act_attach = new act_attach();
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        return true;
    }

    /**
     * メールメッセージの解析
     *
     * @access protected
     * @return boolean
     */
    protected function parse($msg)
    {
        $params = array(
            'include_bodies'=> true,
            'decode_bodies'=>  true,
            'decode_headers'=> true,
        );

        $objdcdr = new Mail_mimeDecode($msg);
        $objmail = $objdcdr->decode($params);

        $email = $objmail->headers['return-path'];
        $email = preg_replace('/<|>/i', '', $email);
        if (!$this->_setAccount($email)){
            return ;
        }

        /* 添付ファイルがある場合 */
        $num = count($objmail->parts);
        for ($row=0; $row<$num; $row++){
            if ($objmail->parts[$row]->ctype_primary == 'image'){
                $this->buffer = $objmail->parts[$row]->body;
                $this->format = $this->_shapeFormat($objmail->parts[$row]->ctype_secondary);
                $mime_type    = $objmail->parts[$row]->ctype_primary.'/'.
                                $objmail->parts[$row]->ctype_secondary;

                $this->act_attach->setValue('ref_account', $this->ref_account);
                $this->act_attach->setValue('mime_type', $mime_type);

                $this->_save('origin');
                $this->_save('large');
                $this->_save('small');
                $this->_save('vsmall');
                $this->act_attach->setInsert();
                $this->act_attach->manip();
            }
        } // for ($row=0;$row<$num;$row++)

        /* 添付ファイルがない場合 */
        if (!$num){
            if ($objmail->ctype_primary == 'image'){
                $this->buffer = $objmail->body;
                $this->format = $this->_shapeFormat($objmail->ctype_secondary);

                $mime_type = $objmail->ctype_primary.'/'.
                             $objmail->ctype_secondary;
                $this->act_attach->setValue('mime_type', $mime_type);

                $this->_save('origin');
                $this->_save('large');
                $this->_save('small');
                $this->_save('vsmall');
                $this->act_attach->setInsert();
                $this->act_attach->manip();
            }
        } // if (!$num)
    }

    /**
     * データの保存
     *
     * @access private
     * @param string $format
     * @return integer  データ操作結果
     */
    private function _save($type)
    {
        $sizes = array(
            'large'=>  PHOTO_MAX_SIZE,
            'small'=>  PHOTO_SMALL_SIZE,
            'vsmall'=> PHOTO_VSMALL_SIZE,
        );
        $names = array(
            'large'=>  'filename',
            'small'=>  'thumbnail',
            'vsmall'=> 'v_small',
        );
        $width = array(
            'large'=>  'width',
            'small'=>  't_width',
            'vsmall'=> 'v_width',
        );
        $height = array(
            'large'=>  'height',
            'small'=>  't_height',
            'vsmall'=> 'v_height',
        );

        $seed = md5($this->ref_account.time());
        $name = substr($seed, rand(0,25), 6);
        $ext  =  ($this->format == 'jpeg')? 'jpg':$this->format;
        $name = $name.'.'.$ext;

        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/'.$type.'/'.$name;
        
        if ($type == 'origin'){
            $buffer = $this->buffer;
            $this->act_attach->setValue('origin', $filename);
        } else {
            /* 画像のリサイズ */
            $objimg = RKT_Image::getInstance();
            $objimg->setBinary($this->buffer, $this->format);
            $objimg->resize($sizes[$type], $sizes[$type]);
            $infos  = $objimg->getInfo();
            $buffer = $objimg->getBinary();

            $this->act_attach->setValue($names[$type],  $filename);
            $this->act_attach->setValue($width[$type],  $infos['width']);
            $this->act_attach->setValue($height[$type], $infos['height']);
        }
        /* バイナリデータの保存 */
        $objblb = RKT_Blob::getInstance();
        $objblb->setUID($this->ref_account);
        $objblb->setBuffer($buffer);
        $objblb->save($filename);
    }

    /**
     * アカウントIDの設定
     *
     * @access protected
     * @param string $email
     * @return boolean
     */
    private function _setAccount($email)
    {
        if (!Validate::email($email)){
            return false;
        }
        $hashed_email = RKT_Crypt::getHashed($email);
        $condition = array(
            'hashed_email'=> $hashed_email
        );
        $account = RKT_DB::getRow('act_mobile', $condition);
        if (empty($account['id'])){
            $account = RKT_DB::getRow('act_account', $condition);
            if (empty($account['id'])){
                return false;
            }
        } // if (empty($account['id']))
        $this->ref_account = $account['ref_account'];

        return true;
    }

    /**
     * フォーマットの整形
     *
     * @access private
     * @param string $format
     * @return integer  データ操作結果
     */
    private function _shapeFormat($format)
    {
        $format = strtolower($format);
        return str_replace('jpeg', 'jpg', $format);
    }
} // BLOB_Attach_Commonの終了
?>