<?php
/* SVN FILE: $Id: setup.php 349 2008-05-11 22:53:40Z bb_yujiro $ */
/**
 * セットアップ
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 349 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:53:40 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/* =-=- モジュール等の読み込み -=-= */
require '../config.php';
require LIB_DIR.'rkt_functions.php';
require LIB_DIR.'rkt_db.php';
require LIB_DIR.'rkt_exception.php';
require LIB_DIR.'rkt_crypt.php';
require LIB_DIR.'rkt_account.php';
require LIB_DIR.'rkt_plugin.php';
require LIB_DIR.'rkt_request.php';
require LIB_DIR.'rkt_view.php';

require LIB_DIR.'PEAR/Net/UserAgent/Mobile.php';

/**
 * Controllerクラス
 *
 * @category        rktFW core
 * @package         rktFW
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 349 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:53:40 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class RKT_Controller
{
    /**
     * 基礎テンプレートファイル
     * @var string
     */
    public $template_base = 'common/frame/base.tpl';

    /**
     * テンプレートファイル
     * @var string
     */
    public $template_file = '';

    /**
     * 出力用
     * @var string
     */
    public $mimeType = 'text/html';

    /**
     * 入力配列
     * @var array
     */
    public $values = array();

    /**
     * 基礎用変数
     * @var array
     */
    private $_base = array();

    /**
     * テンプレート
     * @var string
     */
    private $_template = '';

    /**
     * 解析結果
     * @var string
     */
    private $_parsed = '';

    /**
     * 置換変数
     * @var array
     */
    private $_vars = array();

    /**
     * CSS読み込み用
     * @var array
     */
    private $_css = array();

    /**
     * JavaScript読み込み用
     * @var array
     */
    private $_js = array();

    /**
     * Requestオジェクト
     * @var object
     */
    protected $objrqt = null;

    /**
     * インスタンス生成
     *
     * @access public
     * @return object
     */
    public static function &getInstance()
    {
        static $__singleton = null;
        if ($__singleton == null){
            $__singleton = new RKT_View();
        }
        return $__singleton;
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct($template_file='')
    {
        $this->template_base = 'common/frame/xml.tpl';

        $this->_base['content_tpl']    = VIEW_DIR.$template_file;
        $this->_base['sidebar_tpl']    = VIEW_DIR.'common/menu/private.tpl';
        $this->_base['generalbar_tpl'] = VIEW_DIR.'common/menuBar/general.tpl';
        $this->_base['groupbar_tpl']   = VIEW_DIR.'common/menuBar/public.tpl';

        $this->objrqt = RKT_Request::getInstance();

        $this->_setRequest();
        $this->initValue();
    }

    /**
     * Modelオブジェクトの設定
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function setCondition()
    {
    }

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function assign($key, $value)
    {
        $this->_vars[$key] = $value;
    }

    /**
     * スタイルシート外部読み込みの追加
     *
     * @access public
     * @param string $file ファイルの名前
     * @return void
     */
    public function addCss($file)
    {
        $this->_css[$file] = $file;
    }

    /**
     * JavaScript外部読み込みの追加
     *
     * @access public
     * @param string $file ファイルの名前
     * @return void
     */
    public function addJavas($file)
    {
        $this->_js[$file] = $file;
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function baseAssign($key, $value)
    {
        $this->_base[$key] = $value;
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        try {
            $this->action();
        } catch (PDOException $exception){
            error_log('-----------  '.date('Y-m-d H:i:s')."  --------------\r\n", 3, ERROR_LOG_FILE);
            error_log($_SERVER['REQUEST_URI']."\r\n", 3, ERROR_LOG_FILE);
            error_log($exception->getMessage()."\r\n", 3, ERROR_LOG_FILE);
            error_log($exception->getTraceAsString()."\r\n", 3, ERROR_LOG_FILE);

            $this->objvew->setTemplate('content_tpl', 'common/error/error.tpl');
        } catch (RKT_Exception $exception) {
            $code = $exception->getCode();
            if ($code == RKT_Exception::UNKNOWN_ERROR){
                error_log('-----------  '.date('Y-m-d H:i:s')."  --------------\r\n", 3, ERROR_LOG_FILE);
                error_log($_SERVER['REQUEST_URI']."\r\n", 3, ERROR_LOG_FILE);
                error_log($exception->getMessage()."\r\n", 3, ERROR_LOG_FILE);
                error_log($exception->getTraceAsString()."\r\n", 3, ERROR_LOG_FILE);
            }

            $errortpl = array(
                RKT_Exception::UNKNOWN_ERROR=>     'error.tpl',
                RKT_Exception::ACCESS_DENIED=>     'access.tpl',
                RKT_Exception::PERMISSION_DENIED=> 'permission.tpl',
                RKT_Exception::MALICIOUS_USER=>    'error.tpl',
                RKT_Exception::BAD_REQUEST=>       'error.tpl',
                RKT_Exception::NOT_FOUND=>         'notfound.tpl',
            );

            $this->objvew->setTemplate('content_tpl', 'common/error/'.$errortpl[$code]);
        }
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function display()
    {
        $this->assign('base', $this->_base);

        header('Content-Type: '.$this->mimeType.'; charset='.ENCODE_TYPE);
        include VIEW_DIR.$this->template_base;
    }

    /**
     * テンプレートファイルの設定
     *
     * @access public
     * @param string $key
     * @param string $tpl_file
     * @return void
     */
    public function setBaseFile($tpl_file)
    {
        $this->template_base = $tpl_file;
    }

    /**
     * MimeTypeの設定
     *
     * @access public
     * @param string $mime_type
     * @return void
     */
    public function setMimeType($mime_type)
    {
        $this->mimeType = $mime_type;
    }

    /**
     * テンプレートファイルの設定
     *
     * @access public
     * @param string $key
     * @param string $tpl_file
     * @return void
     */
    public function setTemplate($key, $tpl_file)
    {
        $this->_base[$key] = VIEW_DIR.$tpl_file;
    }

    /**
     * 外部入力の取得
     *
     * @access private
     * @return void
     */
    private function _setRequest()
    {
        $this->setCondition();
        if (empty($this->conditions)){
            return ;
        }

        $this->objrqt->setRequestType('_REQUEST');
        foreach ($this->conditions as $key=>$condition){
            if ($this->objrqt->catchValidate($key, $condition)){
                $this->values[$key] = $this->objrqt->getRequest($key);
            }
        } // foreach ($this->conditions as $key=>$condition)

        $this->assign('request', $this->objrqt->getRequests());
    }
} // RKT_Controller

/**
 * WebApp
 *
 * @category        Hitsuji : Setup
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 349 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:53:40 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
function __WebApp()
{
    /* 言語設定の実行 */
    setlocale(LC_ALL, LANGUAGE);
    bindtextdomain(TEXT_DOMAIN, LOCALE_DIR);
    textdomain(TEXT_DOMAIN);
    bind_textdomain_codeset(TEXT_DOMAIN, ENCODE_TYPE);

    /* 扱えるモジュール名 */
    $pages = array (
        'check'=>    true,
        'config'=>   true,
        'database'=> true,
        'admin'=>    true,
    );

    /* モジュールの読み込み */
    $page = empty($_REQUEST['page'])? 'check':$_REQUEST['page'];
    if (empty($pages[$page])){
        $page = 'check';
    }
    include_once CONTROLLER_DIR.'setup/'.$page.'.php';

    $objController = new Controller('setup/'.$page.'.tpl');

    $objController->execute();
    $objController->display();
}
__WebApp();
?>