<?php
/* SVN FILE: $Id: headerBg.php 164 2008-04-23 00:36:15Z bb_yujiro $ */
/**
 * s
 *
 * PHP versions 4 and 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 164 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:36:15 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 摜̏o
 *
 * @access public
 * @param string $color
 * @return void
 */
function imagePngHeaderBg ($color)
{
    $body = getColors($color);
    $head = colorsMultiply($body, RATE_HEAD);
    $back = colorsMultiply($head, RATE_VERGE);

    $image = imageCreateFromPNG(dirname(__FILE__).'/../source/headerBg.png');

    $range = 62;
    $rate = array (
        'r'=> abs(($head['r'] - $back['r']) / $range),
        'g'=> abs(($head['g'] - $back['g']) / $range),
        'b'=> abs(($head['b'] - $back['b']) / $range),
    );

    for ($row=0; $row<$range; $row++) {
        $index = $row;
        $red   = colorInt($head['r'] - ($row * $rate['r']));
        $green = colorInt($head['g'] - ($row * $rate['g']));
        $blue  = colorInt($head['b'] - ($row * $rate['b']));

        imageColorSet($image, $index, $red, $green, $blue);
    }

    imagePNG($image);
    imageDestroy($image);
}
?>