<?php
/* SVN FILE: $Id: color_functions.php 164 2008-04-23 00:36:15Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 4 and 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 164 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:36:15 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

define('RATE_BACK',         1.5);
define('RATE_TILE',         0.97);
define('RATE_HEAD',         1.17);
define('RATE_VERGE',        0.5);
define('RATE_FRAME_VERGE',  2.75);

/**
 * lF͈͓̔Ɏ߂
 *
 * @access public
 * @param float $number
 * @return integer
 */
function colorInt($number) {
    $number = round($number);
    if ($number < 0) {
        $number = 0;
    } elseif ($number > 255) {
        $number = 255;
    }
    return $number;
}

/**
 * F̊|Z
 *
 * @access public
 * @param strig $color  #RRGGBB
 * @param float $rate
 * @return strig
 */
function colorMultiply($color, $rate)
{
    $red   = colorInt(hexdec(substr($color, 0, 2)) * $rate);
    $green = colorInt(hexdec(substr($color, 2, 2)) * $rate);
    $blue  = colorInt(hexdec(substr($color, 4, 2)) * $rate);

    $red   = dechex($red);
    $green = dechex($green);
    $blue  = dechex($blue);

    $color  = empty($red)?   '00':$red;
    $color .= empty($green)? '00':$green;
    $color .= empty($blue)?  '00':$blue;

    return $color;
}

/**
 * F̊|Z
 *
 * @access public
 * @param array $colors  'r'=>255, 'g'=>255, 'b'=>255
 * @param float $rate
 * @return array
 */
function colorsMultiply($colors, $rate)
{
    $red   = colorInt($colors['r'] * $rate);
    $green = colorInt($colors['g'] * $rate);
    $blue  = colorInt($colors['b'] * $rate);
    
    return array (
        'r'=> $red,
        'g'=> $green,
        'b'=> $blue,
    );
}

/**
 * F̔z擾
 *
 * @access public
 * @param strig $color  RRGGBB
 * @return array
 */
function getColors($color) 
{
    return array(
        'r' => hexdec(substr($color, 0, 2)),
        'g' => hexdec(substr($color, 2, 2)),
        'b' => hexdec(substr($color, 4, 2))
    );
}

/**
 * F̃tH[}bg`FbN
 *
 * @access public
 * @param strig $color  #RRGGBB
 * @return boolean
 */
function isColor($color) 
{
    return preg_match('/^[0-9a-f]{6}$/i', $color);
}

/**
 * NGXgꂽF擾
 *
 * @access public
 * @param strig $key
 * @return strig
 */
function chachColor($key) 
{
    $color = empty($_GET[$key])? '000000':$_GET[$key];
    return isColor($color)? $color:'000000';
}

/**
 * NGXgꂽF擾
 *
 * @access public
 * @param strig $key
 * @return array
 */
function chachColors($key) 
{
    $color = chachColor($key);
    return getColors($color);
}
?>