/* SVN FILE: $Id: smallAttaches.js 247 2008-05-05 18:04:07Z bb_yujiro $ */
/**
 * 添付ファイル一覧の表示
 *
 * JavaScript
 *
 *    Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *    Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 247 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-06 03:04:07 +0900 (火, 06 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

function Attach(count, limit, baseUrl, action, size) {
	this.offset = 1;
	this.max    = count;
	this.ul     = YAHOO.util.Dom.get('attachList');

	this.addImg = function(id, src, width, height) {
		var li  = document.createElement('li');
		var img = document.createElement('img');
		var br  = document.createElement('br');

		var small = document.createElement('img');
		var large = document.createElement('img');
		var clear = document.createElement('img');
		
		li.style.margin    = '10px';
		li.style.textAlign = 'center';
		img.src = baseUrl + src;

		margin_width  = (size - width) / 2;
		margin_height = (size - height) / 2;
		img.style.marginLeft   = margin_width + 'px';
		img.style.marginRight  = margin_width + 'px';
		img.style.marginBottom = margin_height + 'px';
		img.style.marginTop    = margin_height + 'px';

		small.src  = baseUrl + 'resource/img/icons/picture_delete.gif';
		small.name = img.src;
		clear.src  = baseUrl + 'resource/img/icons/cross.gif';
		clear.id   = id;
		clear.name = img.src;

		YAHOO.util.Event.addListener(small, 'click', this.insertSmallImage, this);
		YAHOO.util.Event.addListener(clear, 'click', this.delImg, this);

		small.setAttribute('class', 'cHand');
		clear.setAttribute('class', 'cHand');
		small.setAttribute('className', 'cHand');
		clear.setAttribute('className', 'cHand');

		li.appendChild(img);
		li.appendChild(br);
		li.appendChild(small);
		li.appendChild(clear);

		this.ul.appendChild(li);
	};

	this.insImg = function(id, src) {
		this.offset = 0;
		this.max += 1;
		setAttach();
	};

	this.insImgLink = function(name, type) {
		var href = name.replace('/small/', '/origin/');
		var src  = name.replace('/small/', '/'+ type +'/');

		var body = '<a href="'+ href +'" target="_blank">';
		body += '<img class="yui-img" src="'+ src +'">';
		body += '</a>';

		myEditor.execCommand('inserthtml', body);
	};

	this.delImgTag = function(name) {
		var body  = myEditor.getEditorHTML();
		var href  = name.replace('/small/', '/origin/');
		var large = name.replace('/small/', '/large/');
		var small = name;

		var pattern = '<a href="'+ href +'" target="*_blank"*>';
			pattern += '<img class="*yui-img"* src="'+ small +'">';
			pattern += '</a>';
			pattern = pattern.replace(/\./gim, '\\\.');
			pattern = pattern.replace(/\?/gim, '\\\?');

		var search = new RegExp(pattern, 'igm');
		body = body.replace(search, '');

		pattern = '<a href="'+ href +'" target="*_blank"*>';
		pattern += '<img class="*yui-img"* src="'+ large +'">';
		pattern += '</a>';
		pattern = pattern.replace(/\./gim, '\\\.');
		pattern = pattern.replace(/\?/gim, '\\\?');

		search = new RegExp(pattern, 'igm');
		body = body.replace(search, '');

		myEditor.setEditorHTML(body);
	};

	this.insertLargeImage = function(e, obj) {
		var node = YAHOO.util.Event.getTarget(e);
		obj.insImgLink(node.name, 'large');
	};

	this.insertSmallImage = function(e, obj) {
		var node = YAHOO.util.Event.getTarget(e);
		obj.insImgLink(node.name, 'small');
	};

	this.delImg = function(e, obj) {
		var node   = YAHOO.util.Event.getTarget(e);

		obj.delImgTag(node.name);
		obj.max -= 1;
		setAttach();
	};

	this.nextAttach = function() {
		var orver = Math.ceil(this.max / limit);

		this.offset += 1;
		if (this.offset > orver){
			this.offset = 0;
		}
		setAttach();
	};

	this.prevAttach = function() {
		var orver = Math.ceil(this.max / limit);

		this.offset -= 1;
		if (this.offset <= 0){
			this.offset = orver;
		}
		setAttach();
	}
}

function setAttach() {
	var callback =
	{
		success: function(o) {
			var attachs = YAHOO.lang.JSON.parse (o.responseText);
			var ul	    = YAHOO.util.Dom.get('attachList');

			while (ul.lastChild){
				ul.removeChild(ul.lastChild); 
			}

			if (attachs.length != 0){
				YAHOO.util.Dom.setStyle("frm_attach", "display", "inline");
			}
			for (row=0; row<attachs.length; row++){
				myAttach.addImg(attachs[row].id, attachs[row].thumbnail, attachs[row].t_width, attachs[row].t_height);
			}
		},
		failure: function(o) {
		},
		argument: []
	}
	YAHOO.util.Connect.initHeader('Cookie', document.cookie);
	YAHOO.util.Connect.asyncRequest('GET',  attachAction + 'page=' + myAttach.offset, callback);
}