<?php
/* SVN FILE: $Id: richEditor.php 183 2008-04-26 17:22:31Z bb_yujiro $ */
/**
 * リッチエディタ
 *
 * JavaScript
 *
 *    Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *    Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 183 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-27 02:22:31 +0900 (日, 27 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
require dirname(__FILE__).'/../../../config.php';
require LIB_DIR.'rkt_functions.php';
require LIB_DIR.'rkt_db.php';
require LIB_DIR.'rkt_crypt.php';
require LIB_DIR.'rkt_session.php';
require LIB_DIR.'rkt_account.php';
require LIB_DIR.'rkt_plugin.php';

require LIB_DIR.'PEAR/Net/UserAgent/Mobile.php';

/* セッションスタート */
RKT_account::exec();

header('Content-Type: application/x-javascript; charset='.ENCODE_TYPE);
?>
var myEditor = null;

function richEditor (area, title, width, height) {
	var myConfig = {
		extracss :    'object{ width:50px; height:50px; border: 1px solid #808080; }',
		width:  width + 'px',
		height: height + 'px',
		handleSubmit: true,
		dompath: false,
		animate: true,
		toolbar: {
			titlebar: title,
			buttons: [
				{ group: 'textstyle', label: 'Font Style',
					buttons: [
						{ type: 'spin', label: '13', value: 'fontsize', range: [ 9, 75 ], disabled: true },
						{ type: 'separator' },
						{ type: 'push', label: 'Bold', value: 'bold' },
						{ type: 'push', label: 'Italic', value: 'italic' },
						{ type: 'push', label: 'Underline', value: 'underline' },
						{ type: 'separator' },
						{ type: 'color', label: 'Font Color', value: 'forecolor', disabled: true },
						{ type: 'color', label: 'Background Color', value: 'backcolor', disabled: true },
						{ type: 'separator' }
					]
				},
				{ type: 'separator' },
				{ group: 'insertitem', label: 'Insert Item',
					buttons: [
						{ type: 'push', label: 'HTML Link CTRL + SHIFT + L', value: 'createlink', disabled: true }
					]
				}
			]
		}
	};

//	myEditor = new YAHOO.widget.SimpleEditor(area, myConfig);
	myEditor = new YAHOO.widget.Editor(area, myConfig);

	myEditor.STR_LINK_PROP_REMOVE = '<?php _e('Remove link from text'); ?>';
	myEditor.STR_LINK_URL         = '<?php _e('Link URL'); ?>';
	myEditor.STR_LINK_NEW_WINDOW  = '<?php _e('Open in a new window.'); ?>';
	myEditor.STR_LINK_TITLE       = '<?php _e('Description'); ?>';

<?php /* プラグインによる処理 */
    loadPlugin::exec()->editorJavaScript(); ?>


	myEditor.on('toolbarLoaded', function() { 
<?php /* プラグインによる処理 */
    loadPlugin::exec()->editorAddButtonJs(); ?>
	});
	myEditor.render();
}
