/* SVN FILE: $Id: rating.js 490 2008-05-24 11:36:23Z bb_yujiro $ */
/**
 * 評価/採点
 *
 * JavaScript
 *
 *    Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *    Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 490 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 20:36:23 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

var Rating = function(container, value) {
	this.starMv = true;
	this.ul     = YAHOO.util.Dom.get(container);
	var li      = document.createElement('li');
	
	li.style.width = (value * 8) + 'px';
	li.setAttribute('class', 'rating-bar');
	li.setAttribute('className', 'rating-bar-ie');
	this.ul.appendChild(li);

	this.starMove = function (e){
		if (!this.starMv) {return ;}
		
		var containerX = YAHOO.util.Dom.getX(container);
		var clickX     = YAHOO.util.Event.getPageX(e);
		var newWidth   = clickX - containerX;
		
		if (newWidth > 0) {
			value = Math.round(newWidth / 8);

			if (value <  0) {value =  0;}
			if (value > 10) {value = 10;}
			
			li.style.width = (value * 8) + 'px';
		}
		
	};

	this.sendRating = function (url, key, sent, bad){
		this.starMv = false;
		var callback =
		{
			success: function(o) {
				var result = YAHOO.lang.JSON.parse (o.responseText);
				var anc    = YAHOO.util.Dom.get(key);

				if (result){
					anc.innerHTML = sent;
				} else {
					anc.innerHTML = bad;
				}
			},
			failure: function(o) {},
			argument: []
		}
		var nonce = YAHOO.util.Dom.get('_mpnnc').value;
		var postData = "item_code="+ container +"&point="+ value +"&_mpnnc="+ nonce;

		YAHOO.util.Connect.initHeader('Cookie', document.cookie);
		YAHOO.util.Connect.asyncRequest('POST',  url, callback, postData);
	};

	this.getRating = function (){
		return value;
	};

	YAHOO.util.Event.addListener(container, 'mousemove', this.starMove);
	YAHOO.util.Event.addListener(container, 'click', function(){
		this.starMv = !this.starMv;
	});
}
