/* SVN FILE: $Id: feed.js 450 2008-05-22 09:19:45Z bb_yujiro $ */
/**
 * サマリーの表示
 *
 * JavaScript
 *
 *    Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *    Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 450 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:19:45 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

function clearFeed(container) {
	var ul  = YAHOO.util.Dom.get(container);
	while (ul.lastChild){
		ul.removeChild(ul.lastChild); 
	}
}

function displayFeed(node, id) {
	var ul  = YAHOO.util.Dom.get('display_' + id);
	var str = node.lastChild.src;
	var len = str.length - 16;
	var display = 1;
	
	if (str.indexOf("hidden_minus", 0) < 0){
		node.lastChild.src = str.replace("display_plus", "hidden_minus");
		ul.style.display   = 'block';
		display            = 1;
	} else {
		node.lastChild.src = str.replace("hidden_minus", "display_plus");
		ul.style.display   = 'none';
		display            = 0;
	}

	var callback =	{
		success: function(o) {
		},
		failure: function(o) {},
		argument: []
	}
	var url  = YAHOO.util.Dom.get('url').value + id + '/';
	var postData = new String('update=1&');
	postData += 'display=' + display;
	postData += "&_mpnnc="+ YAHOO.util.Dom.get('_mpnnc').value;

	YAHOO.util.Connect.initHeader('Cookie', document.cookie);
	YAHOO.util.Connect.asyncRequest('POST',  url, callback, postData);
}

function downFeed(container) 
{
	var li = YAHOO.util.Dom.get(container);
	if (li.nextSibling == null){
		return ;
	}
	li.parentNode.insertBefore(li.nextSibling, li);
	saveListFeed(li.parentNode);
}

function hideFeed(node, container) {
	YAHOO.util.Dom.setStyle(container, "display", "none");
}

function refreshFeed(container, url, max) {
	clearFeed(container);
	viewFeed(container, url, max);
}

function upFeed(container) 
{
	var li = YAHOO.util.Dom.get(container);
	if (li.previousSibling == null){
		return ;
	}
	li.parentNode.insertBefore(li, li.previousSibling);
	saveListFeed(li.parentNode);
}

function viewFeed(container, url, max) {
	var callback =
	{
		success: function(o) {
			var articles = YAHOO.lang.JSON.parse (o.responseText);
			var ul  = YAHOO.util.Dom.get(container);
			var li  = null;
			var anc = null;
			
			ul.style.listStyleType = 'circle';
			ul.style.paddingLeft = '16px';
			
			max = (articles.length < max)? articles.length:max;

			for (row=0; row<max; row++){
				li  = document.createElement('li');
				anc = document.createElement('a');
				anc.setAttribute('href', articles[row].link);
				anc.appendChild(document.createTextNode(articles[row].title));
				li.style.lineHeight = '150%';
				li.appendChild(anc);
				ul.appendChild(li);
			}
		},
		failure: function(o) {
		},
		argument: []
	}
	YAHOO.util.Connect.initHeader('Cookie', document.cookie);
	YAHOO.util.Connect.asyncRequest('GET',  url, callback);
}

function _saveListFeed(ul) {
	var str = new String('');

	for (row=0; row<ul.childNodes.length; row++){
		str += ',' + ul.childNodes[row].getAttribute("id");
	}
	document.cookie = 'feedList=' + escape(str) + '; '+
						'expires=Mon, 18-Jan-2038 00:00:00; ';
}

function saveListFeed(ul) {
	var postData = new String('manips=1&');
	for (row=0; row<ul.childNodes.length; row++){
		postData += 'updates[';
		postData += ul.childNodes[row].getAttribute("id");
		postData += ']='+ (row+1) +'&';
	}

	var callback =	{
		success: function(o) {},
		failure: function(o) {},
		argument: []
	}
	postData += "_mpnnc="+ YAHOO.util.Dom.get('_mpnnc').value;
	var url  = YAHOO.util.Dom.get('url').value;

	YAHOO.util.Connect.initHeader('Cookie', document.cookie);
	YAHOO.util.Connect.asyncRequest('POST',  url, callback, postData);
}

function saveHideFeed(container) {
	document.cookie = container + '=1; '+
						'expires=Mon, 18-Jan-2038 00:00:00; ';

	document.cookie = container + '=0; '+
						'expires=Thu, 31-Dec-1970 00:00:00; ';
}

function displayBtnFeed(container) {
	var node = YAHOO.util.Dom.get(container);
	var display = node.style.display;
	
	if (display == 'block'){
		node.style.display = 'none';
	} else {
		node.style.display = 'block';
	}
}

function setRecent(recentContainer, recentUrl){
	var callback =
	{
		success: function(o) {
			var summary = YAHOO.lang.JSON.parse (o.responseText);

			var vi  = YAHOO.util.Dom.get(recentContainer);
			var ul  = document.createElement('ul');
			var li  = null;
			var anc = null;
			var img = null;

			ul.style.listStyleType = 'circle';
			ul.style.paddingLeft = '16px';

			for (row=0; row<summary.length; row++){
				li  = document.createElement('li');
				anc = document.createElement('a');
				img = document.createElement('img');

				anc.setAttribute('href', summary[row].link);
				anc.appendChild(document.createTextNode(summary[row].title));
				li.appendChild(anc);
				if (summary[row].creator){
					li.appendChild(document.createTextNode('(' + summary[row].creator + ')'));
				}
				ul.appendChild(li);
			}
			vi.appendChild(ul);
			vi.style.textAlign = 'left';
		},
		failure: function(o) {
		},
		argument: []
	}
	YAHOO.util.Connect.initHeader('Cookie', document.cookie);
	YAHOO.util.Connect.asyncRequest('GET',  recentUrl, callback);
}