/* SVN FILE: $Id: blogRecent.js 164 2008-04-23 00:36:15Z bb_yujiro $ */
/**
 * ブログの近況表示
 *
 * JavaScript
 *
 *    Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *    Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 164 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:36:15 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
/**
 * Example:
 *
 * var blogRecentKey  = '';
 * var blogRecentUrl  = '';
 * var blogRecentIcon = '';
*/
(function(){
	var key  = blogRecentKey;
	var icon = blogRecentIcon;
	var callback =
	{
		success: function(o) {
			var summary = YAHOO.lang.JSON.parse (o.responseText);

			var div = YAHOO.util.Dom.get('frm_' + key);
			var ul  = YAHOO.util.Dom.get(key);
			var li  = null;
			var anc = null;
			var img = null;
			
			if (summary.length != 0){
				div.style.display = 'inline';
			}

			for (row=0; row<summary.length; row++){
				li  = document.createElement('li');
				anc = document.createElement('a');
				img = document.createElement('img');

				anc.setAttribute('href', summary[row].link);
				img.src = icon;
				img.setAttribute('align', 'absbottom');

				anc.appendChild(img);
				anc.appendChild(document.createTextNode(' ' + summary[row].title));

				if (key.indexOf("blg_entry", 0) >= 0){
					anc.appendChild(document.createTextNode('  (' + summary[row].creator + ')'));
				}
				li.appendChild(anc);
				ul.appendChild(li);
			}
		},
		failure: function(o) {
			var div = YAHOO.util.Dom.get('frm_' + key);
			div.style.display = 'none';
		},
		argument: []
	}
	YAHOO.util.Connect.initHeader('Cookie', document.cookie);
	YAHOO.util.Connect.asyncRequest('GET',  blogRecentUrl, callback);
})()
