<?php
/* SVN FILE: $Id: exec.php 530 2008-06-04 18:56:49Z bb_yujiro $ */
/**
 * 実行処理
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 530 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-05 03:56:49 +0900 (木, 05 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/* =-=- モジュール等の読み込み -=-= */
require '../config.php';
require LIB_DIR.'rkt_functions.php';
require LIB_DIR.'rkt_db.php';
require LIB_DIR.'rkt_exception.php';
require LIB_DIR.'rkt_crypt.php';
require LIB_DIR.'rkt_session.php';
require LIB_DIR.'rkt_access.php';
require LIB_DIR.'rkt_account.php';
require LIB_DIR.'rkt_auth.php';
require LIB_DIR.'rkt_plugin.php';
require LIB_DIR.'rkt_request.php';
require LIB_DIR.'rkt_model.php';
require LIB_DIR.'rkt_view.php';
require LIB_DIR.'rkt_controller.php';

require LIB_DIR.'PEAR/Net/UserAgent/Mobile.php';

/**
 * WebApp
 *
 * @category        Hitsuji : WebApp
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 530 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-05 03:56:49 +0900 (木, 05 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
function __WebApp()
{
    /* セッションハンドル設定 */
    RKT_session::setSaveHandler();

    /* 自動ログイン */
    Auth_AutoLogin::exec()->autoLogin();

    $status = RKT_account::exec()->getStatus();
    $default = array(
        STATUS_ADMIN=>  'private',
        STATUS_MEMBER=> 'private',
        STATUS_GUEST=>  'public',
    );

    /* 言語設定の実行 */
    setlocale(LC_ALL, LANGUAGE);
    bindtextdomain(TEXT_DOMAIN, LOCALE_DIR);
    textdomain(TEXT_DOMAIN);
    bind_textdomain_codeset(TEXT_DOMAIN, ENCODE_TYPE);

    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];

    $args   = explode('/', $path_info);
    $group  = empty($args[PATH_INFO_GROUP]) ? $default[$status] :$args[PATH_INFO_GROUP];
    $module = empty($args[PATH_INFO_MODULE])? 'content':$args[PATH_INFO_MODULE];
    $page   = empty($args[PATH_INFO_PAGE])  ? $module  :$args[PATH_INFO_PAGE];

    /* グループチェック */    
    $groups = array(
        'admin'=>     'Admin_Controller',
        'community'=> 'Community_Controller',
        'member'=>    'Member_Controller',
        'plugin'=>    'Plugin_Controller',        
        'private'=>   'Private_Controller',
        'public'=>    'Public_Controller',
    );
    if (empty($groups[$group])){
        $group = 'public';
    }

    $include =  $group.'.php';
    include CONTROLLER_DIR.$include;
    
    /* コントローラファイルの読み込み */
    $func = array($groups[$group], 'getController');
    $objController = call_user_func($func, $group, $module, $page);
    $objController->execute();

    $objController->display();
}

__WebApp();    // WebApp実行
?>