<?php
/* SVN FILE: $Id: archives.php 164 2008-04-23 00:36:15Z bb_yujiro $ */
/**
 * バイナリデータの出力
 *
 * PHP versions 5
 *
 *      rktFW : Development Framework <http://rakuto.net/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @package         rktFW
 * @version         $Revision: 164 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:36:15 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/* =-=- モジュール等の読み込み -=-= */
require '../config.php';
require LIB_DIR.'rkt_blob.php';

/**
 * 実行関数
 *
 * @access public
 * @return void
 */
function __main()
{
    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];
    $filename = ACTION_ARCHIVES.$path_info;

    /* BLOB管理オブジェクトの生成 */
    $objblb = RKT_blob::getInstance(BLOB_DRIVER,BLOB_PARAM); 
    if ($objblb->load($filename)){
        header('Cache-Control: public, max-age=86400');
        $objblb->output();
    } else {
        print ('No File.');
    }
    exit();
}

__main();    // 実行関数
?>