<?php
/* SVN FILE: $Id: config.php.default 584 2008-06-19 11:43:08Z bb_yujiro $ */
/**
 * フレームワーク基礎定義
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @package         hitSuji
 * @version         $Revision: 584 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-19 20:43:08 +0900 (木, 19 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
/**
 * このファイルのパーミッション設定をWebユーザから書き込める
 * ように設定してください。
 * 管理者ページから各定義部分を指定し、上書きします。
 */

/* ---------------------------------------- */
/* システム情報 */
define('SYSTEM_NAME', 'hitSuji');                                   // システム名
define('ADMINISTRATOR', 'admin@example.com');                       // 管理者メールアドレス
define('SNS_NAME', 'example system');                               // SNS名
define('BASE_URL', 'http://sns.example.com/');                      // ベースURL
define('SSL_URL', 'http://sns.example.com/');                       // SSLプロトコル用アクション
define('PASS_SEED', 'exampleexampleexample');                       // 暗号等に使われる種
define('PASS_PHRASE', 'exampleexampleexampleexampleexam');          // パスフレーズ
define('NONCE_LIFE_TIME', 28800);                                   // ワンタイムパスワードの有効時間 (8時間)
define('PERSISTENT_TIME', 2147353200);                              // 永続的な有効時間 (2038-01-18)
define('SYSTEM_INVITE', 1);                                         // デフォルト招待元
define('COPYRIGHT', "Copyright (C) 2007 `example.com' All Rights Reserved.");   // 制作著作

/* ---------------------------------------- */
/* アマゾンWebサービス用の設定 */
define('AMAZON_TOKEN',       '0EECRRRCGRKWFD0DGM82');               // サービスアカウントキー
define('AMAZON_ASSOCIATEID', 'rakutonet-22');                       // アクセスID
define('AMAZON_BASEURL',     'http://xml-jp.amznxslt.com/onca/xml4');
define('AMAZON_LOCALE',      'jp');

/* ---------------------------------------- */
/* ぐるなびWebサービス用の設定 */
define('GNAVI_ACCESS_KEY',   '1a8b68c3a088a6f06c96dc5bcf4aa0b4');   // サービスアカウントキー

/* ---------------------------------------- */
/* 国際化関連 */
define('ENCODE_TYPE', 'UTF-8');                                     // エンコードタイプ
ini_set('default_charset', ENCODE_TYPE);                            // マルチバイトデフォルト設定
mb_language('Japanese');                                            // 使用言語設定
mb_internal_encoding(ENCODE_TYPE);                                  // 内部エンコード設定
define('LANGUAGE', 'ja_JP');                                        // 言語
define('TEXT_DOMAIN', 'messages');                                  // カタログドメイン
putenv('LANG='.LANGUAGE);                                           // 環境変数設定
date_default_timezone_set('Asia/Tokyo');                            // タイムゾーン設定

/* ---------------------------------------- */
/* メール設定 */
define('USED_SMTP', FALSE);                                         // SMTPの使用
define('SMTP_HOST', 'mail.example.com');                            // SMTPホスト
define('SMTP_PORT', 25);                                            // SMTPポート
define('SMTP_AUTH', FALSE);                                         // SMTP認証
define('SMTP_ACCOUNT', 'send@example.com');                         // SMTPアカウント
define('SMTP_PASSWORD', 'passwd');                                  // SMTPパスワード

/* ---------------------------------------- */
/* インポート添付メール設定 */
define('ATTACH_DRIVER', 'POP3');                                    // 添付ドライバ
define('ATTACH_MAIL',   'post@example.com');                        // メールアドレス

/* POP3メール設定 */
define('POP3_HOST',     'mail.example.com');                        // POP3ホスト
define('POP3_ACCOUNT',  'post@example.com');                        // POP3アカウント
define('POP3_PASSWORD', 'passwd');                                  // POP3パスワード

/* メールボックス設定 */
define('MAIL_BOX_DIR',  '');                                        // メールボックスのディレクトリ

/* ---------------------------------------- */
/* アプリケーション情報 */
define('DS', DIRECTORY_SEPARATOR);                                  // ディレクトリの区切り
define('US', '&');                                                  // URIとパラメータの区切り
define('COOKIE_DOMAIN', 'localhost');                               // ディレクトリ区切り
define('PATH_INFO_KEY', 'QUERY_STRING');                            // パスインフォ用添え字
define('ACTION_STYLE', '.php?');                                    // フロントコントローラのスタイル
define('ACTION_METHOD', 'post');                                    // フォームアクションメソッド
define('HTTP_ACTION', BASE_URL.'exec'.ACTION_STYLE.'/');            // HTTPプロトコル用アクション
define('SSL_ACTION',  SSL_URL.'exec'.ACTION_STYLE.'/');             // SSLプロトコル用アクション
define('HTTP_ENTRANCE', HTTP_ACTION.'public/login/entrance/');      // エントランスURL
define('SSL_ENTRANCE', SSL_ACTION.'public/login/entrance/');        // SSL用エントランスURL
define('PHP_COMMAND', '/usr/local/bin/php');                        // PHPコマンド
define('CRYPT_OUTPUT_FUNC', 'base64_encode');                       // 暗号化出力関数
define('CRYPT_INPUT_FUNC',  'base64_decode');                       // 暗号化入力関数
define('HASH_FUNC', 'md5');                                         // ハッシュ関数

define('INVITE_FROM_USER', 1);                                      // デフォルト招待元
define('DATE_START_AGE', 1940);                                     // 年齢初期値
define('DATE_START_YEAR', 2006);                                    // スタート年

/* ---------------------------------------- */
/* 画像加工ドライバ */
define('IMAGEMAGICK_PATH', '/usr/local/bin/');                      // ImageMagickのパス
define('IMAGE_DRIVER', 'GD');                                       // 使用する画像加工ドライバ

/* ---------------------------------------- */
/* 各種ディレクトリ設定 */
define('BASE_DIR', dirname(__FILE__).DS);                           // ベース
define('BIN_DIR', BASE_DIR.'bin'.DS);                               // 実行系
define('DOCUMENT_DIR', BASE_DIR.'htdocs'.DS);                       // ドキュメント
define('LIB_DIR', BASE_DIR.'libs'. DS);                             // ライブラリ
define('WEBAPP_DIR',BASE_DIR.'webapp'.DS);                          // ウェブアプリケーション
define('TMP_DIR', BASE_DIR.'tmp'.DS);                               // 作業ディレクトリパス

define('LOCALE_DIR', WEBAPP_DIR.'languages'.DIRECTORY_SEPARATOR);   // 言語ディレクトリ
define('RESOURCE_DIR',DOCUMENT_DIR.'resource'.DS);                  // 各リソースファイル
define('THEME_DIR', RESOURCE_DIR.'theme'. DS);                      // デザインテーマ

define('CACHE_DIR', TMP_DIR.'caches'. DS);                          // キャッシュ

define('DB_DIR', WEBAPP_DIR.'dbs'.DS);                              // データベース
define('CONTROLLER_DIR', WEBAPP_DIR.'controllers'.DS);              // コントローラー
define('MODEL_DIR', WEBAPP_DIR.'models'.DS);                        // モデル
define('PLUGIN_DIR', WEBAPP_DIR.'plugins'.DS);                      // プラグイン
define('VIEW_DIR', WEBAPP_DIR.'views'.DS);                          // ビュー

/* ---------------------------------------- */
/* 各種ファイル設定 */
define('ERROR_LOG_FILE', TMP_DIR.'logs'.DS .'error.log');           // エラーログファイル
define('SYSTEM_DB_FILE', DB_DIR.'system.db');                       // DBファイル

/* ---------------------------------------- */
/* データベース */
define('DB_PREFIX',   'sns_');                                      // テーブル名の接頭語
define('DB_DRIVER',   'mysql');                                     // データベースドライバ
define('DB_USER',     'dbuser');                                    // 接続ユーザー
define('DB_PASSWORD', 'dbpasswd');                                  // パスワード
define('DB_DSN',      DB_DRIVER.':host=localhost;dbname=hitsuji');  // デフォルトDB Data Source Name
define('USE_SET_NAMES', '1');                                       // SET NAMESを使用するか

/* ---------------------------------------- */
/* 画像サイズ */
define('PHOTO_MAX_SIZE',   500);                                    // 保存用画像上限
define('PHOTO_LARGE_SIZE', 160);                                    // 各種表示画像上限
define('PHOTO_SMALL_SIZE',  76);                                    // サムネイル用画像上限
define('PHOTO_VSMALL_SIZE', 40);                                    // サムネイル用画像上限
define('NOPHOTO_LARGE', 'resource/img/common/nophoto.jpg');         // 180pix 非表示画像
define('NOPHOTO_SMALL', 'resource/img/common/nophoto_s.jpg');       // 76pix 非表示画像
define('NOPHOTO_VSMALL','resource/img/common/nophoto_v.jpg');       // 40pix 非表示画像

/* ---------------------------------------- */
/* HTMLタグの属性除去設定 */
define('STRIP_ATTR_DRIVER',    'HTMLSax3');                         // 使用する要素ドライバ
define('ALLOWABLE_ATTRIBUTES', 'align,class,height,href,id,name,'.
                               'src,style,type,value,width,wmode');

/* ---------------------------------------- */
/* BLOBドライバ */
define('BLOB_DRIVER', 'DB');                                        // 使用する画像加工ドライバ
define('BLOB_DB_DSN', 'sqlite:'.DB_DIR.'blob.db');                  // バイナリ保存のSQLite用DSN
define('BLOB_PARAM', DB_DSN);                                       // BLOB用引数
define('ARCHIVES_DIR', '');                                         // アーカイブスの保存先パス

/* ---------------------------------------- */
/* 形態素解析ドライバ */
define('MA_DRIVER', 'Yahoo');                                       // 使用する形態素解析ドライバ

/* ---------------------------------------- */
/* エラーログ設定 */
ini_set('error_reporting', E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);
ini_set('log_errors', true);
ini_set('error_log', ERROR_LOG_FILE);

/* ---------------------------------------- */
/* ファイルの保存先URL */
define('ACTION_ARCHIVES',         'archives'.ACTION_STYLE);         // 保存ファイルの出力
define('ARCHIVES_PATH',           ACTION_ARCHIVES.'/');             // 各種ファイルの保存先URL
define('ARCHIVES_MEMBER_PATH',    ARCHIVES_PATH.'member/');         // 会員用ファイルの保存先URL
define('ARCHIVES_COMMUNITY_PATH', ARCHIVES_PATH.'community/');      // コミュニティ用ファイルの保存先URL
define('ARCHIVES_THEME_PATH',     ARCHIVES_PATH.'theme/');          // テーマ用ファイルの保存先URL
define('ARCHIVES_UPLOAD_PATH',    ARCHIVES_PATH.'upload/');         // 一時アップロード先

/* ---------------------------------------- */
/* 表示レベル */
define('VISIBILITY_HIDDEN',   0x01);                                // 公開しない
define('VISIBILITY_PUBLIC',   0x02);                                // ネット上に公開
define('VISIBILITY_PROTECTED',0x04);                                // 会員に公開
define('VISIBILITY_FRIEND',   0x08);                                // お友達に公開
define('VISIBILITY_PRIVATE',  0x10);                                // メンバーに公開

define('VISIBILITY_OPEN',     0x06);                                // 会員まで公開
define('VISIBILITY_CLOSE',    0x0E);                                // お友達まで公開

define('VISIBILITY_ALL',      0xFF);                                // 全部

/* ---------------------------------------- */
/* アクセス権限 */
define('STATUS_ADMIN',  1);                                         // 管理者権限
define('STATUS_GUEST',  2);                                         // ゲストユーザー権限
define('STATUS_MEMBER', 3);                                         // 会員ユーザー権限

/* ---------------------------------------- */
/* 名簿の状態 */
define('PERMISSION_GUEST',   0x00);                                 // 非参加者
define('PERMISSION_LEADER',  0x01);                                 // リーダー
define('PERMISSION_MEMBER',  0x02);                                 // 参加者
define('PERMISSION_REFUSAL', 0x04);                                 // 拒絶
define('PERMISSION_REQUEST', 0x08);                                 // 参加希望者
define('PERMISSION_CHANGE',  0x10);                                 // リーダー交代
define('PERMISSION_INVITE',  0x20);                                 // 招待者

define('PERMISSION_MEMBERS', 0x13);                                 // 全参加者

/* ---------------------------------------- */
/* 有効性 */
define('STATUS_DISABLE', 0);                                        // 無効
define('STATUS_ENABLE',  1);                                        // 有効
define('STATUS_PENDING', 2);                                        // 保留

/* ---------------------------------------- */
/* 写真の状態 */
define('STATUS_PHOTO_SUB',  0);                                     // サブ
define('STATUS_PHOTO_MAIN', 1);                                     // メイン

/* ---------------------------------------- */
/* 友達名簿の状態 */
define('STATUS_FRIEND_CONNECT', 1);                                 // 友達
define('STATUS_FRIEND_THROW',   2);                                 // 友達申請送信
define('STATUS_FRIEND_CHATCH',  3);                                 // 友達申請受信
define('STATUS_FRIEND_REFUSAL', 4);                                 // 拒絶
define('STATUS_FRIEND_INVITE',  5);                                 // 友達招待

/* ---------------------------------------- */
/* コミュニティ参加条件 */
define('INVOLVED_THROUGH', 1);                                      // 誰でも可
define('INVOLVED_APPROVE', 2);                                      // 管理者の判断

/* ---------------------------------------- */
/* コンテンツステータス */
define('CONTENT_STATIC',    1);                                     // 静的ページ
define('CONTENT_ARTICLE',   2);                                     // 記事
define('CONTENT_POLL',      3);                                     // 投票

/* ---------------------------------------- */
/* PathInfoカーソル */
define('PATH_INFO_GROUP',  1);                                      // PathInfoグループ位置
define('PATH_INFO_MODULE', 2);                                      // PathInfoモジュール位置
define('PATH_INFO_PAGE',   3);                                      // PathInfoページ位置
define('PATH_INFO_START',  4);                                      // PathInfo開始位置

/* ---------------------------------------- */
/* 問合せ対応状況 */
define('CONTACT_NEW',        1);                                    // 問合せ
define('CONTACT_PENDING',    2);                                    // 検討中
define('CONTACT_RESPONDED',  3);                                    // 対応済み
define('CONTACT_TRASH',      4);                                    // ゴミ箱

define('RESPONSE_POST',      1);                                    // 対応
define('RESPONSE_SEND',      2);                                    // 返信メール
define('RESPONSE_SENT',      3);                                    // 送信済み

/* ---------------------------------------- */
/* メッセージ */
define('MESSAGE_INBOX',1);                                          // 受信箱
define('MESSAGE_SEND', 2);                                          // 送信
define('MESSAGE_SENT', 3);                                          // 送信済み
define('MESSAGE_DRAFT',4);                                          // 下書き
define('MESSAGE_TRASH',5);                                          // ゴミ箱

define('FLAG_UNREAD',1);                                            // 未読メッセージ
define('FLAG_READ',  2);                                            // 既読メッセージ
define('FLAG_RETURN',3);                                            // 返信メッセージ

/* ---------------------------------------- */
/* ガジェットタイプ */
define('GADGET_INSIDE',   1);                                       // 内部RSS
define('GADGET_OUTSIDE',  2);                                       // 外部RSS
define('GADGET_OBJECT',   3);                                       // Script系

/* ---------------------------------------- */
/* ガジェット・スポンサー表示位置 */
define('POSITION_HEAD',   1);                                       // ヘッダー部位
define('POSITION_MIDDLE', 2);                                       // 中央部位
define('POSITION_LEFT',   3);                                       // 左側面部位
define('POSITION_RIGHT',  4);                                       // 右側面部位
define('POSITION_BAR',    5);                                       // 細い
define('POSITION_MOBILE', 6);                                       // 携帯用

/* ---------------------------------------- */
/* お気に入りターゲット */
define('FAVORITE_TARGET_MEMBER',    1);                             // 会員
define('FAVORITE_TARGET_COMMUNITY', 2);                             // コミュニティ

/* ---------------------------------------- */
/* 配信設定 */
define('DELIVERY_REFUSE', 0);                                       // 配信拒否
define('DELIVERY_DAILY',  1);                                       // 毎日配信
define('DELIVERY_WEEK',   2);                                       // 週2回（月/木）

/* ---------------------------------------- */
/* レイアウトテーマ設定 */
define('DEFAULT_THEME', '1');                                       // 初期テーマ

/* ---------------------------------------- */
/* 日記のフォーマット */
define('FORMAT_PLAIN', 1);                                          // デフォルト
define('FORMAT_HTML',  2);                                          // HTML形式

/* ---------------------------------------- */
/* メッセージ送信方法 */
define('SEND_TYPE_MESSAGE', 1);                                     // メッセージボックス
define('SEND_TYPE_EMAIL',   2);                                     // 電子メール
define('SEND_TYPE_BOTH',    3);                                     // 両方

/* ---------------------------------------- */
/* 検索結果 */
define('LIMIT_ROWS',            10);                                // 各一覧
define('LIMIT_TILE',            12);                                // タイル型一覧
define('LIMIT_BLOG',            10);                                // 日記一覧
define('LIMIT_REVIEW',          10);                                // レビュー一覧
define('LIMIT_JSON_ATTACH',      5);                                // JSON用添付一覧
define('LIMIT_JSON_FRIENDS',     8);                                // JSON用友達一覧
define('LIMIT_JSON_COMMUNITYS',  8);                                // JSON用コミュニティ
define('LIMIT_ANNOUNCEMENT',     5);                                // JSON用アナウンス
define('LIMIT_MOBILE',           5);                                // 携帯用一覧

/* ---------------------------------------- */
/* フォームの種類 */
define('FORM_TYPE_TEXT',    1);                                     // テキスト
define('FORM_TYPE_TEXTAREA',2);                                     // テキストエリア
define('FORM_TYPE_SELECT',  3);                                     // 選択リスト
define('FORM_TYPE_CHECKBOX',4);                                     // チェックボックス
define('FORM_TYPE_RADIO',   5);                                     // ラジオボタン
define('FORM_TYPE_DATE',    6);                                     // 日付リスト

/* フォームの公開設定 */
define('VISIBLE_DISPLAY', 1);                                       // 常に表示
define('VISIBLE_SELECT',  2);                                       // ユーザー選択

/* ---------------------------------------- */
/* RKTフレームワーク用定義 */
define('RKT_ACCOUNT_CLASS', 'account');                             // アカウントクラス名
define('RKT_ACC_ADMIN', 1);                                         // アクセス権限:管理者
define('RKT_ACC_DEFAULT', 2);                                       // アクセス権限:デフォルト
define('RKT_TBL_ACCOUNT', DB_PREFIX.'act_account');                 // アカウントテーブル名
define('RKT_TBL_AUTOLOGIN', DB_PREFIX.'act_autologin');             // 自動ログインテーブル名
define('RKT_TBL_SESSION', DB_PREFIX.'sys_sessions');                // セッションのテーブル名
define('RKT_TBL_BLOB', DB_PREFIX.'sys_blob');                       // Binary Large OBjectテーブル名
define('RKT_CHUNK_NUMBER', 18);                                     // CHUNK文字数
define('REF_PREFIX', 'ref_');                                       // 参照項目の接頭語文字
define('REF_PREFIX_LENGTH', 4);                                     // 参照項目の接頭語文字数

/* ---------------------------------------- */
/* ---------------------------------------- */
?>