<?php
/* SVN FILE: $Id: schedule.php 325 2008-05-11 01:06:21Z bb_yujiro $ */
/**
 * スケジュール通知
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @package         hitSuji
 * @version         $Revision: 325 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:06:21 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require dirname(__FILE__).'/../config.php';
require LIB_DIR.'rkt_functions.php';
require LIB_DIR.'rkt_db.php';
require LIB_DIR.'rkt_exception.php';
require LIB_DIR.'rkt_crypt.php';

require LIB_DIR.'rkt_message.php';

/**
 * スケジュール通知
 *
 * @category        Hitsuji : Command Line Interface
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 325 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:06:21 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
function alertSchedule()
{
    $now = date('Y-m-d');
    $condition = array(
        'start_date'=> $now,
        'reminder'=>   STATUS_ENABLE,
    );
    $result = RKT_DB::getList('cal_schedule', $condition);
    if (empty($result)){
        return ;
    }
    
    $list = array();
    foreach ($result as $row){
        $row['start_date'] = fDate($_row['start_date'], _('Y-m-d'));
        $row['end_date']   = fDate($_row['end_date'], _('Y-m-d'));

        $list[$row['ref_account']][] = $row;
    }

    
    $objsnd = RKT_Message::getInstance('schedule');
    foreach ($list as $ref_account=> $schedules){
        $condition = array(
            'ref_account'=> $ref_account
        );
        $account = RKT_DB::getRow('act_account', $ref_account);
        $profile = RKT_DB::getRow('act_profile', $condition);

        $objsnd->Assign('user_name', $profile['nickname']);
        $objsnd->Assign('schedules', $schedules);
        $objsnd->Assign('url', HTTP_ACTION.'member/schedule/view/');

        $email = RKT_Crypt::getDecrypted($account['email'])
        $objsnd->send($email);
    }
}

alertSchedule();
?>
