<?php
/* SVN FILE: $Id: rss.php 316 2008-05-10 00:10:38Z bb_yujiro $ */
/**
 * RSS Reader
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @package         hitSuji
 * @version         $Revision: 316 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 09:10:38 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require dirname(__FILE__).'/../config.php';
require LIB_DIR.'rkt_functions.php';
require LIB_DIR.'rkt_db.php';
require LIB_DIR.'rkt_exception.php';
require LIB_DIR.'rkt_crypt.php';

require LIB_DIR.'PEAR/XML/RSS.php';

require LIB_DIR.'rktModel/manip.php';
require MODEL_DIR.'manips/blg_entry.php';
require MODEL_DIR.'manips/rss_feed.php';


/**
 * blogRss
 *
 * @category        Hitsuji : Command Line Interface
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 316 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 09:10:38 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
function blogRss()
{
    $blg_entry = new blg_entry();

    $condition = array(
        'rss'=> array('!=', '')
    );
    $list = RKT_DB::getList('blg_blog', $condition);
    
    foreach ($list as $row){
        $blg_entry->setValue('ref_account', $row['ref_account']);
        $blg_entry->importRss($row['rss']);
    }
}


/**
 * 共有RSS
 *
 * @category        Hitsuji : Command Line Interface
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 316 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 09:10:38 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
function commonRss()
{
    $rss_feed = new rss_feed();
    $list = RKT_DB::getList('rss_feed');
    
    foreach ($list as $row){
        $rss_feed->setCurId($row['id']);
        $rss_feed->setFeed();
        $rss_feed->manip();
    }
}


blogRss();
commonRss();
?>
