<?php
/**
 * グループ情報変更内容入力画面クラス
 *
 * グループ情報変更内容入力画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_user_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class groupmod_entry extends admin_user_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.user」でない or 前画面のActが「grouplist」 and 「groupmod_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.user' or ( $tmp_act != 'grouplist' and $tmp_act != 'groupmod_confirm' ) )
      {
        $this->obj_util->redirectTo( 'grouplist', 'admin.user' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'group_id' ] = null;

      // セッションからエラーメッセージと入力値を取得し、削除する
      $tmp_entered = $this->obj_sess->sessLoad(  $this->obj_sess->sessLoad( 'currentcage' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );
      // 前画面のエラーメッセージをクラス変数に格納
      $this->gotDat[ 'errMsg' ] = $tmp_entered[ 'message' ];



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // グループ名
      if ( isset( $_GET[ 'id' ] ) )
      {
        $tmp_entered[ 'group_id' ] = strip_tags( trim( $_GET[ 'id' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // 渡されてきたグループIDがnullか数字でなければ、グループ選択画面に遷移する
      if ( $tmp_entered[ 'group_id' ] == null or ! is_numeric( $tmp_entered[ 'group_id' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_groupname';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'grouplist', 'admin.user' );
        return false;
      } // end of if

      // 前画面が確認画面ならセッションの値をクラス変数にセットする
      if ( $this->obj_sess->sessLoad( 'lastact' ) == 'groupmod_confirm' )
      {
        $this->gotDat[ 'groupdat' ] = $tmp_entered;
        return true;
      } // end of if



      //------------------------------------------------------------------------
      // グループ情報の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisolutoDb();

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {

        // グループ情報を取得する
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `groups`.`group_id`    -- グループID
                   , `groups`.`group_name`  -- グループ名
                FROM `risoluto_m_group` groups
               WHERE `groups`.`group_id`  = ?
                 AND `groups`.`status`    = 1

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'group_id' ]
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_groupdat = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_groupdat ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'groupinfo get Failure' );
          return false;
        } // end of if

        // クラス変数に取得結果をセット
        $this->gotDat[ 'groupdat' ] = $tmp_groupdat;

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',             $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',          $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',           $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'errMsg',             $this->gotDat[ 'errMsg'    ] );
      $this->smarty->assign ( 'entered_group_id',   $this->gotDat[ 'groupdat' ][ 'group_id'   ] );
      $this->smarty->assign ( 'entered_group_name', $this->gotDat[ 'groupdat' ][ 'group_name' ] );

      // 表示
      $this->smarty->display( 'groupmod_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:groupmod_entry

?>
