<?php
/**
 * アップグレードFlavor画面(1)クラス
 *
 * アップグレードFlavor画面(1)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page01 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない or 前画面のActが「upgrade」 and 「page01」 and 「page02」でない場合、
      // アップグレードFlavorに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or  ( $tmp_act != 'upgrade' and  $tmp_act != 'page01' and  $tmp_act != 'page02' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // チェック対象をセットする
      // 他にチェック対象があれば、この配列に加えてください。
      // path: チェック対象となるパス / stat: あるべき状態（writable: 書込可 / readable: 読込可）
      // readableを指定したとき、その対象が書込可の場合はNGとなります
      $this->checklist = array(
                                array(
                                       'path' => RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' )
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_DOCROOT . '/index.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_DOCROOT . '/css/common.css'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTODIR . '/risoluto/'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_BATCH
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_CONF
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_CONF . 'config_template.ini'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_EXTLIB . 'extlib_setup.sh'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_FUNC
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_FUNC . 'risoluto_conf.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_FUNC . 'risoluto_db.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_FUNC . 'risoluto_hooks.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_FUNC . 'risoluto_log.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_FUNC . 'risoluto_session.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_FUNC . 'risoluto_util.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/admin_base.inc'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/auth.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/login.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/login.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/logout.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/logout.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/menu.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/menu.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/menu/00002_admin.user.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/menu/00003_admin.site.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/admin_site_base.inc'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headeradd_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headeradd_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headeradd_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headeradd_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headeradd_entry.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headeradd_entry.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headerdel_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headerdel_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headerdel_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headerdel_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headerlist.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headerlist.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headermod_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headermod_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headermod_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headermod_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headermod_entry.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/headermod_entry.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/sitestat_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/sitestat_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/sitestat_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/sitestat_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/sitestat_select.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/sitestat_select.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/upload_add.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/upload_del.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/uploadlist.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/uploadlist.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/site/uploadviewer.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/admin_user_base.inc'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupadd_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupadd_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupadd_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupadd_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupadd_entry.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupadd_entry.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupdel_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupdel_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupdel_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupdel_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/grouplist.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/grouplist.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupmod_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupmod_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupmod_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupmod_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupmod_entry.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/groupmod_entry.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/useradd_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/useradd_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/useradd_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/useradd_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/useradd_entry.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/useradd_entry.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/userdel_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/userdel_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/userdel_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/userdel_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/userlist.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/userlist.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/usermod_complete.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/usermod_complete.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/usermod_confirm.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/usermod_confirm.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/usermod_entry.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/user/usermod_entry.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'common/admin_footer.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'common/admin_header.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'common/footer.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'common/header.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'error/error.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'error/error.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'error/error_base.inc'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'servicestop/servicestop.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'servicestop/servicestop.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'servicestop/servicestop_base.inc'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'skeleton/skeleton.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'skeleton/skeleton.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'skeleton/skeleton_base.inc'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'welcome/welcome.php'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'welcome/welcome.tpl'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'welcome/welcome_base.inc'
                                     , 'stat' => 'writable'
                                     )
                              );

      // チェックメソッドを呼び出し、結果を整形
      foreach( $this->checklist as $dat )
      {
        $tmp_result = $this->obj_util->statChecker( $dat );
        if ( $tmp_result[ 'result' ] == 'NG' )
        {
          $this->errStatus = 'NG';
        } // end of if
        $this->checkresult[] = $tmp_result;
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(1)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page01.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page01
?>
