Convert Ring project source code to executable file (Windows, Linux & MacOS X)
==============================================================================

Usage
=====

		ring ring2exe.ring filename.ring [Options]

This will set filename.ring as input to the program 	

The next files will be generated 

		filename.ringo	  		(The Ring Object File - by Ring Compiler)
		filename.c	  			(The C Source code file
								 Contains the ringo file content
								 Will be generated by this program)
		filename_buildvc.bat 	(Will be executed to build filename.c using Visual C/C++)
		filename_buildgcc.bat 	(Will be executed to build filename.c using GNU C/C++)
		filename_buildclang.bat (Will be executed to build filename.c using CLang C/C++)
		filename.obj	  		(Will be generated by the Visual C/C++ compiler) 
		filename.exe 	  		(Will be generated by the Visual C/C++ Linker)
		filename	  			(Executable File - On Linux & MacOS X platforms)

Note
====

We can use 

		ring ring2exe.ring ring2exe.ring 

This will build ring2exe.exe

We can use ring2exe.exe 

		ring2exe filename.ring 

For Linux & MacOS X

		./ring2exe filename.ring

Testing 
=======
	
		ring2exe test.ring 
		test 

For Linux & MacOS X

		./ring2exe test.ring 
		./test

Options
=======

		-keep       	 : Don't delete Temp. Files
		-static     	 : Build Standalone Executable File (Don't use ring.dll/ring.so/ring.dylib)
		-gui        	 : Build GUI Application (Hide the Console Window)
		-dist	    	 : Prepare application for distribution 
		-allruntime 	 : Include all libraries in distribution
		-mobileqt	 : Prepare Qt Project to distribute Ring Application for Mobile
		-noqt	    	 : Remove RingQt from distribution
		-noallegro 	 : Remove RingAllegro from distribution
		-noopenssl  	 : Remove RingOpenSSL from distribution
		-nolibcurl  	 : Remove RingLibCurl from distribution
		-nomysql    	 : Remove RingMySQL from distribution
		-noodbc     	 : Remove RingODBC from distribution
		-nosqlite   	 : Remove RingSQLite from distribution
		-noopengl   	 : Remove RingOpenGL from distribution
		-nofreeglut 	 : Remove RingFreeGLUT from distribution
		-nolibzip   	 : Remove RingLibZip from distribution
		-noconsolecolors : Remove RingConsoleColors from distribution
		-nomurmurhash	 : Remove RingMurmurHash from distribution
		-nocruntime	 : Remove C Runtime from distribution
		-qt	    	 : Add RingQt to distribution
		-allegro 	 : Add RingAllegro to distribution
		-openssl  	 : Add RingOpenSSL to distribution
		-libcurl  	 : Add RingLibCurl to distribution
		-mysql    	 : Add RingMySQL to distribution
		-odbc     	 : Add RingODBC to distribution
		-sqlite   	 : Add RingSQLite to distribution
		-opengl   	 : Add RingOpenGL to distribution
		-freeglut 	 : Add RingFreeGLUT to distribution
		-libzip   	 : Add RingLibZip to distribution
		-libuv		 : Add RingLibuv to distribution
		-consolecolors   : Add RingConsoleColors to distribution
		-murmurhash	 : Add RingMurmurHash to distribution
		-cruntime	 : Add C Runtime to distribution
