/* Copyright (c) 2013-2018 Mahmoud Fayed <msfclipper@yahoo.com> */

extern "C" {
	#include "ring.h"
}

#include "gpushbutton.h"
#include "gaction.h"
#include "glineedit.h"
#include "gtextedit.h"
#include "glistwidget.h"
#include "gtreeview.h"
#include "gtreewidget.h"
#include "gcombobox.h"
#include "gtabwidget.h"
#include "gtablewidget.h"
#include "gprogressbar.h"
#include "gspinbox.h"
#include "gslider.h"
#include "gdial.h"
#include "gnetworkaccessmanager.h"
#include "gcheckbox.h"
#include "gradiobutton.h"
#include "gbuttongroup.h"
#include "gvideowidget.h"
#include "gtimer.h"
#include "gtcpserver.h"
#include "giodevice.h"
#include "gabstractsocket.h"
#include "gtcpsocket.h"
#include "gcolordialog.h"
#include "gallevents.h"
#include "gthread.h"
#include "gplaintextedit.h"
#include "gheaderview.h"
#include "gprocess.h"
#include "codeeditor.h"
#include "highlighter.h"
#include "gtoolbutton.h"
#include "gbluetoothdevicediscoveryagent.h"
#include "gbluetoothlocaldevice.h"
#include "gbluetoothserver.h"
#include "gbluetoothservicediscoveryagent.h"
#include "gbluetoothsocket.h"
#include "gbluetoothtransfermanager.h"
#include "gbluetoothtransferreply.h"
#include "gwindow.h"
#include "gguiapplication.h"
#include "gtextbrowser.h"
#include "gdockwidget.h"
#include "gstackedwidget.h"
#include "gcalendarwidget.h"

#include <QApplication>
#include <QObject>
#include <QWidget>
#include <QLabel>
#include <QPixmap>
#include <QIcon>
#include <QSize>
#include <QPushButton>
#include <QMainWindow>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLineEdit>
#include <QTextEdit>
#include <QListWidget>
#include <QTreeView>
#include <QDir>
#include <QFileSystemModel>
#include <QTreeWidget>
#include <QTreeWidgetItem>
#include <QComboBox>
#include <QVariant>
#include <QMenuBar>
#include <QMenu>
#include <QToolBar>
#include <QMainWindow>
#include <QStatusBar>
#include <QDockWidget>
#include <QTabWidget>
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QSizePolicy>
#include <QFrame>
#include <QAbstractScrollArea>
#include <QAbstractItemView>
#include <QProgressBar>
#include <QSpinBox>
#include <QSlider>
#include <QAbstractSlider>
#include <QDateEdit>
#include <QDateTimeEdit>
#include <QAbstractSpinBox>
#include <QDial>
#include <QUrl>
#include <QCheckBox>
#include <QRadioButton>
#include <QButtonGroup>
#include <QMediaPlayer>
#include <QMediaPlaylist>
#include <QVideoWidget>
#include <QPrinter>
#include <QAction>
#include <QEvent>
#include <QMessageBox>
#include <QTimer>
#include <QFileDialog>
#include <QPainter>
#include <QPicture>
#include <QPen>
#include <QColor>
#include <QPrinter>
#include <QFont>
#include <QBrush>
#include <QByteArray>
#include <QIODevice>
#include <QAbstractSocket>
#include <QTcpSocket>
#include <QTcpServer>
#include <QNetworkProxy>
#include <QHostAddress>
#include <QHostInfo>
#include <QList>
#include <QFileInfo>
#include <QDirModel>
#include <QModelIndex>
#include <QFontDialog>
#include <QDialog>
#include <QTextCursor>
#include <QTextBlock>
#include <QTextDocumentFragment>
#include <QColorDialog>
#include <QHeaderView>
#include <QStringList>
#include <QKeySequence>
#include <QLCDNumber>
#include <QInputDialog>
#include <QDesktopWidget>
#include <QRect>
#include <QTextDocument>
#include <QTime>
#include <QTest>
#include <QListWidgetItem>
#include <QSystemTrayIcon>
#include <QDate>
#include <QTextCodec>
#include <QtSql>
#include <QSqlDatabase>
#include <QSqlDriver>
#include <QSqlQuery>
#include <QSqlError>
#include <QSqlIndex>
#include <QSqlRecord>
#include <QSqlField>
#include <QSqlDriverCreatorBase>
#include <QNetworkRequest>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QPainterPath>
#include <QImage>
#include <QBitmap>
#include <QMediaContent>
#include <QTableView>
#include <QXmlStreamReader>
#include <QXmlStreamWriter>
#include <QXmlStreamNotationDeclaration>
#include <QXmlStreamNamespaceDeclaration>
#include <QXmlStreamEntityResolver>
#include <QXmlStreamEntityDeclaration>
#include <QXmlStreamAttributes>
#include <QXmlStreamAttribute>
#include <QThread>
#include <QThreadPool>
#include <QRegularExpression>
#include <QRegularExpressionMatch>
#include <QRegularExpressionMatchIterator>
#include <QJsonValue>
#include <QJsonParseError>
#include <QJsonObject>
#include <QJsonDocument>
#include <QJsonArray>
#include <iterator>
#include <QPlainTextEdit>
#include <QGridLayout>
#include <QTextCharFormat>
#include <QCameraViewfinder>
#include <QGraphicsVideoItem>
#include <QVideoWidgetControl>
#include <QCamera>
#include <QCameraImageCapture>
#include <QFontMetrics>
#include <QList>
#include <QSplashScreen>
#include <QBoxLayout>
#include <QLayout>
#include <QLinearGradient>
#include <QGradient>
#include <QPointF>
#include <QPoint>
#include <QStyleFactory>
#include <QScrollArea>
#include <QSplitter>
#include <QCompleter>
#include <QString>
#include <QProcess>
#include <QMdiArea>
#include <QMdiSubWindow>
#include <QCursor>
#include <QListView>
#include <QUuid>
#include <QDesktopServices>
#include <QToolButton>
#include <QStringRef>
#include <QMutex>
#include <QMutexLocker>
#include <QBuffer>
#include <QBluetoothAddress>
#include <QBluetoothDeviceDiscoveryAgent>
#include <QBluetoothDeviceInfo>
#include <QBluetoothUuid>
#include <QBluetoothHostInfo>
#include <QBluetoothLocalDevice>
#include <QBluetoothServer>
#include <QBluetoothServiceDiscoveryAgent>
#include <QBluetoothServiceInfo>
#include <QBluetoothSocket>
#include <QBluetoothTransferManager>
#include <QBluetoothTransferReply>
#include <QBluetoothTransferRequest>
#include <QBluetoothUuid>
#include <QDateTime>
#include <QScreen>
#include <QWindow>
#include <QGuiApplication>
#include <QTextBrowser>
#include <QRegion>
#include <QStackedWidget>
#include <QCalendarWidget>
#include <QVector2D>
#include <QVector3D>
#include <QVector4D>
#include <QQuaternion>
#include <QMatrix4x4>

#include <QTabBar>
#include "gtabbar.h"
#include <QFile>
#include <QFileDevice>
#include <QStandardPaths>

#include <QDrag>
#include "gdrag.h"
#include <QMimeData>
#include <QDropEvent>
#include <QDragMoveEvent>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QClipboard>
#include <QChar>
#include <QChildEvent>

#include <QGeoPositionInfo>
#include <QGeoCoordinate>
#include <QGeoAddress>
#include <QGeoAreaMonitorInfo>
#include <QGeoAreaMonitorSource>
#include <QGeoCircle>
#include <QGeoPositionInfoSource>
#include "ggeopositioninfosource.h"
#include <QGeoRectangle>
#include <QGeoShape>
#include <QGeoSatelliteInfo>
#include <QGeoSatelliteInfoSource>
#include <QNmeaPositionInfoSource>

#include <QPrinterInfo>
#include <QPrintPreviewWidget>
#include "gprintpreviewwidget.h"
#include <QPrintPreviewDialog>
#include "gprintpreviewdialog.h"
#include <QPageSetupDialog>
#include <QAbstractPrintDialog>
#include <QPrintDialog>
#include "gprintdialog.h"

#include <QTextStream>


#include <QQuickWidget>
#include <QQmlError>
#include "gquickwidget.h"







extern "C" {

	RING_API void ring_qt_start(RingState *pRingState);

	RING_API void ringlib_init(RingState *pRingState)
	{
		new QApplication(pRingState->argc,pRingState->argv);
	   	ring_qt_start(pRingState) ;
	}

}

// Functions Prototype - Functions used to Free Memory 

	void ring_QObject_freefunc(void *pState,void *pPointer);
	void ring_QSize_freefunc(void *pState,void *pPointer);
	void ring_QDir_freefunc(void *pState,void *pPointer);
	void ring_QDateEdit_freefunc(void *pState,void *pPointer);
	void ring_QUrl_freefunc(void *pState,void *pPointer);
	void ring_QEvent_freefunc(void *pState,void *pPointer);
	void ring_QTimer_freefunc(void *pState,void *pPointer);
	void ring_QByteArray_freefunc(void *pState,void *pPointer);
	void ring_QIODevice_freefunc(void *pState,void *pPointer);
	void ring_QFileInfo_freefunc(void *pState,void *pPointer);
	void ring_QStringList_freefunc(void *pState,void *pPointer);
	void ring_QRect_freefunc(void *pState,void *pPointer);
	void ring_QTime_freefunc(void *pState,void *pPointer);
	void ring_QDate_freefunc(void *pState,void *pPointer);
	void ring_QTextCodec_freefunc(void *pState,void *pPointer);
	void ring_QVariant_freefunc(void *pState,void *pPointer);
	void ring_QVariant2_freefunc(void *pState,void *pPointer);
	void ring_QVariant3_freefunc(void *pState,void *pPointer);
	void ring_QVariant4_freefunc(void *pState,void *pPointer);
	void ring_QVariant5_freefunc(void *pState,void *pPointer);
	void ring_QXmlStreamReader_freefunc(void *pState,void *pPointer);
	void ring_QXmlStreamWriter_freefunc(void *pState,void *pPointer);
	void ring_QXmlStreamNotationDeclaration_freefunc(void *pState,void *pPointer);
	void ring_QXmlStreamNamespaceDeclaration_freefunc(void *pState,void *pPointer);
	void ring_QXmlStreamEntityDeclaration_freefunc(void *pState,void *pPointer);
	void ring_QXmlStreamEntityResolver_freefunc(void *pState,void *pPointer);
	void ring_QXmlStreamAttributes_freefunc(void *pState,void *pPointer);
	void ring_QXmlStreamAttribute_freefunc(void *pState,void *pPointer);
	void ring_QThread_freefunc(void *pState,void *pPointer);
	void ring_QThreadPool_freefunc(void *pState,void *pPointer);
	void ring_QRegularExpression_freefunc(void *pState,void *pPointer);
	void ring_QRegularExpressionMatch_freefunc(void *pState,void *pPointer);
	void ring_QRegularExpressionMatchIterator_freefunc(void *pState,void *pPointer);
	void ring_QJsonArray_freefunc(void *pState,void *pPointer);
	void ring_QJsonDocument_freefunc(void *pState,void *pPointer);
	void ring_QJsonObject_freefunc(void *pState,void *pPointer);
	void ring_QJsonParseError_freefunc(void *pState,void *pPointer);
	void ring_QJsonValue_freefunc(void *pState,void *pPointer);
	void ring_QPointF_freefunc(void *pState,void *pPointer);
	void ring_QPoint_freefunc(void *pState,void *pPointer);
	void ring_QString2_freefunc(void *pState,void *pPointer);
	void ring_QProcess_freefunc(void *pState,void *pPointer);
	void ring_QUuid_freefunc(void *pState,void *pPointer);
	void ring_QStringRef_freefunc(void *pState,void *pPointer);
	void ring_QMutex_freefunc(void *pState,void *pPointer);
	void ring_QMutexLocker_freefunc(void *pState,void *pPointer);
	void ring_QBuffer_freefunc(void *pState,void *pPointer);
	void ring_QDateTime_freefunc(void *pState,void *pPointer);
	void ring_QCoreApplication_freefunc(void *pState,void *pPointer);
	void ring_QFile_freefunc(void *pState,void *pPointer);
	void ring_QFile2_freefunc(void *pState,void *pPointer);
	void ring_QFileDevice_freefunc(void *pState,void *pPointer);
	void ring_QStandardPaths_freefunc(void *pState,void *pPointer);
	void ring_QMimeData_freefunc(void *pState,void *pPointer);
	void ring_QChar_freefunc(void *pState,void *pPointer);
	void ring_QChildEvent_freefunc(void *pState,void *pPointer);
	void ring_QTextStream_freefunc(void *pState,void *pPointer);
	void ring_QTextStream2_freefunc(void *pState,void *pPointer);
	void ring_QTextStream3_freefunc(void *pState,void *pPointer);
	void ring_QTextStream4_freefunc(void *pState,void *pPointer);
	void ring_QTextStream5_freefunc(void *pState,void *pPointer);
	void ring_QDesktopServices_freefunc(void *pState,void *pPointer);
	void ring_QBitmap_freefunc(void *pState,void *pPointer);
	void ring_QPixmap_freefunc(void *pState,void *pPointer);
	void ring_QPixmap2_freefunc(void *pState,void *pPointer);
	void ring_QIcon_freefunc(void *pState,void *pPointer);
	void ring_QPainter_freefunc(void *pState,void *pPointer);
	void ring_QPainter2_freefunc(void *pState,void *pPointer);
	void ring_QPicture_freefunc(void *pState,void *pPointer);
	void ring_QPen_freefunc(void *pState,void *pPointer);
	void ring_QColor_freefunc(void *pState,void *pPointer);
	void ring_QFont_freefunc(void *pState,void *pPointer);
	void ring_QBrush_freefunc(void *pState,void *pPointer);
	void ring_QTextCursor_freefunc(void *pState,void *pPointer);
	void ring_QKeySequence_freefunc(void *pState,void *pPointer);
	void ring_QTextDocument_freefunc(void *pState,void *pPointer);
	void ring_QTextBlock_freefunc(void *pState,void *pPointer);
	void ring_QPainterPath_freefunc(void *pState,void *pPointer);
	void ring_QImage_freefunc(void *pState,void *pPointer);
	void ring_QTextCharFormat_freefunc(void *pState,void *pPointer);
	void ring_QFontMetrics_freefunc(void *pState,void *pPointer);
	void ring_QLinearGradient_freefunc(void *pState,void *pPointer);
	void ring_QGradient_freefunc(void *pState,void *pPointer);
	void ring_QCursor_freefunc(void *pState,void *pPointer);
	void ring_QScreen_freefunc(void *pState,void *pPointer);
	void ring_QWindow_freefunc(void *pState,void *pPointer);
	void ring_QGuiApplication_freefunc(void *pState,void *pPointer);
	void ring_QRegion_freefunc(void *pState,void *pPointer);
	void ring_QVector2D_freefunc(void *pState,void *pPointer);
	void ring_QVector3D_freefunc(void *pState,void *pPointer);
	void ring_QVector4D_freefunc(void *pState,void *pPointer);
	void ring_QQuaternion_freefunc(void *pState,void *pPointer);
	void ring_QMatrix4x4_freefunc(void *pState,void *pPointer);
	void ring_QDrag_freefunc(void *pState,void *pPointer);
	void ring_QDropEvent_freefunc(void *pState,void *pPointer);
	void ring_QDragMoveEvent_freefunc(void *pState,void *pPointer);
	void ring_QDragEnterEvent_freefunc(void *pState,void *pPointer);
	void ring_QDragLeaveEvent_freefunc(void *pState,void *pPointer);
	void ring_QClipboard_freefunc(void *pState,void *pPointer);
	void ring_QApp_freefunc(void *pState,void *pPointer);
	void ring_QWidget_freefunc(void *pState,void *pPointer);
	void ring_QLabel_freefunc(void *pState,void *pPointer);
	void ring_QPushButton_freefunc(void *pState,void *pPointer);
	void ring_QLineEdit_freefunc(void *pState,void *pPointer);
	void ring_QVBoxLayout_freefunc(void *pState,void *pPointer);
	void ring_QHBoxLayout_freefunc(void *pState,void *pPointer);
	void ring_QTextEdit_freefunc(void *pState,void *pPointer);
	void ring_QListWidget_freefunc(void *pState,void *pPointer);
	void ring_QTreeView_freefunc(void *pState,void *pPointer);
	void ring_QFileSystemModel_freefunc(void *pState,void *pPointer);
	void ring_QTreeWidget_freefunc(void *pState,void *pPointer);
	void ring_QTreeWidgetItem_freefunc(void *pState,void *pPointer);
	void ring_QComboBox_freefunc(void *pState,void *pPointer);
	void ring_QMenuBar_freefunc(void *pState,void *pPointer);
	void ring_QMenu_freefunc(void *pState,void *pPointer);
	void ring_QToolBar_freefunc(void *pState,void *pPointer);
	void ring_QMainWindow_freefunc(void *pState,void *pPointer);
	void ring_QStatusBar_freefunc(void *pState,void *pPointer);
	void ring_QDockWidget_freefunc(void *pState,void *pPointer);
	void ring_QTabWidget_freefunc(void *pState,void *pPointer);
	void ring_QTableWidgetItem_freefunc(void *pState,void *pPointer);
	void ring_QFrame_freefunc(void *pState,void *pPointer);
	void ring_QFrame2_freefunc(void *pState,void *pPointer);
	void ring_QFrame3_freefunc(void *pState,void *pPointer);
	void ring_QAbstractScrollArea_freefunc(void *pState,void *pPointer);
	void ring_QAbstractItemView_freefunc(void *pState,void *pPointer);
	void ring_QTableView_freefunc(void *pState,void *pPointer);
	void ring_QTableWidget_freefunc(void *pState,void *pPointer);
	void ring_QProgressBar_freefunc(void *pState,void *pPointer);
	void ring_QSpinBox_freefunc(void *pState,void *pPointer);
	void ring_QAbstractSlider_freefunc(void *pState,void *pPointer);
	void ring_QSlider_freefunc(void *pState,void *pPointer);
	void ring_QDateTimeEdit_freefunc(void *pState,void *pPointer);
	void ring_QAbstractSpinBox_freefunc(void *pState,void *pPointer);
	void ring_QDial_freefunc(void *pState,void *pPointer);
	void ring_QCheckBox_freefunc(void *pState,void *pPointer);
	void ring_QAbstractButton_freefunc(void *pState,void *pPointer);
	void ring_QRadioButton_freefunc(void *pState,void *pPointer);
	void ring_QButtonGroup_freefunc(void *pState,void *pPointer);
	void ring_QAction_freefunc(void *pState,void *pPointer);
	void ring_QMessageBox_freefunc(void *pState,void *pPointer);
	void ring_QFileDialog_freefunc(void *pState,void *pPointer);
	void ring_QDirModel_freefunc(void *pState,void *pPointer);
	void ring_QFontDialog_freefunc(void *pState,void *pPointer);
	void ring_QDialog_freefunc(void *pState,void *pPointer);
	void ring_QColorDialog_freefunc(void *pState,void *pPointer);
	void ring_QLCDNumber_freefunc(void *pState,void *pPointer);
	void ring_QInputDialog_freefunc(void *pState,void *pPointer);
	void ring_QAllEvents_freefunc(void *pState,void *pPointer);
	void ring_QDesktopWidget_freefunc(void *pState,void *pPointer);
	void ring_QListWidgetItem_freefunc(void *pState,void *pPointer);
	void ring_QSystemTrayIcon_freefunc(void *pState,void *pPointer);
	void ring_RingCodeHighlighter_freefunc(void *pState,void *pPointer);
	void ring_QPlainTextEdit_freefunc(void *pState,void *pPointer);
	void ring_CodeEditor_freefunc(void *pState,void *pPointer);
	void ring_QGridLayout_freefunc(void *pState,void *pPointer);
	void ring_QHeaderView_freefunc(void *pState,void *pPointer);
	void ring_QSplashScreen_freefunc(void *pState,void *pPointer);
	void ring_QBoxLayout_freefunc(void *pState,void *pPointer);
	void ring_QLayout_freefunc(void *pState,void *pPointer);
	void ring_QScrollArea_freefunc(void *pState,void *pPointer);
	void ring_QSplitter_freefunc(void *pState,void *pPointer);
	void ring_QCompleter_freefunc(void *pState,void *pPointer);
	void ring_QCompleter2_freefunc(void *pState,void *pPointer);
	void ring_QCompleter3_freefunc(void *pState,void *pPointer);
	void ring_QMdiArea_freefunc(void *pState,void *pPointer);
	void ring_QMdiSubWindow_freefunc(void *pState,void *pPointer);
	void ring_QListView_freefunc(void *pState,void *pPointer);
	void ring_QToolButton_freefunc(void *pState,void *pPointer);
	void ring_QTextBrowser_freefunc(void *pState,void *pPointer);
	void ring_QStackedWidget_freefunc(void *pState,void *pPointer);
	void ring_QCalendarWidget_freefunc(void *pState,void *pPointer);
	void ring_QTabBar_freefunc(void *pState,void *pPointer);
	void ring_QScrollBar_freefunc(void *pState,void *pPointer);
	void ring_QTest_freefunc(void *pState,void *pPointer);
	void ring_QMediaPlayer_freefunc(void *pState,void *pPointer);
	void ring_QMediaPlaylist_freefunc(void *pState,void *pPointer);
	void ring_QCamera_freefunc(void *pState,void *pPointer);
	void ring_QCameraImageCapture_freefunc(void *pState,void *pPointer);
	void ring_QMediaObject_freefunc(void *pState,void *pPointer);
	void ring_QVideoWidget_freefunc(void *pState,void *pPointer);
	void ring_QCameraViewfinder_freefunc(void *pState,void *pPointer);
	void ring_QGraphicsVideoItem_freefunc(void *pState,void *pPointer);
	void ring_QVideoWidgetControl_freefunc(void *pState,void *pPointer);
	void ring_QPrintPreviewDialog_freefunc(void *pState,void *pPointer);
	void ring_QPrintPreviewWidget_freefunc(void *pState,void *pPointer);
	void ring_QPrinter_freefunc(void *pState,void *pPointer);
	void ring_QPrinterInfo_freefunc(void *pState,void *pPointer);
	void ring_QPageSetupDialog_freefunc(void *pState,void *pPointer);
	void ring_QAbstractPrintDialog_freefunc(void *pState,void *pPointer);
	void ring_QAbstractSocket_freefunc(void *pState,void *pPointer);
	void ring_QNetworkProxy_freefunc(void *pState,void *pPointer);
	void ring_QTcpSocket_freefunc(void *pState,void *pPointer);
	void ring_QTcpServer_freefunc(void *pState,void *pPointer);
	void ring_QHostAddress_freefunc(void *pState,void *pPointer);
	void ring_QHostInfo_freefunc(void *pState,void *pPointer);
	void ring_QNetworkRequest_freefunc(void *pState,void *pPointer);
	void ring_QNetworkAccessManager_freefunc(void *pState,void *pPointer);
	void ring_QNetworkReply_freefunc(void *pState,void *pPointer);
	void ring_QSqlDatabase_freefunc(void *pState,void *pPointer);
	void ring_QSqlDriver_freefunc(void *pState,void *pPointer);
	void ring_QSqlQuery_freefunc(void *pState,void *pPointer);
	void ring_QSqlError_freefunc(void *pState,void *pPointer);
	void ring_QSqlIndex_freefunc(void *pState,void *pPointer);
	void ring_QSqlRecord_freefunc(void *pState,void *pPointer);
	void ring_QSqlField_freefunc(void *pState,void *pPointer);
	void ring_QSqlDriverCreatorBase_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothAddress_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothDeviceDiscoveryAgent_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothDeviceInfo_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothHostInfo_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothLocalDevice_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothServer_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothServiceDiscoveryAgent_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothServiceInfo_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothSocket_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothTransferManager_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothTransferReply_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothTransferRequest_freefunc(void *pState,void *pPointer);
	void ring_QBluetoothUuid_freefunc(void *pState,void *pPointer);
	void ring_QGeoPositionInfo_freefunc(void *pState,void *pPointer);
	void ring_QGeoCoordinate_freefunc(void *pState,void *pPointer);
	void ring_QGeoAddress_freefunc(void *pState,void *pPointer);
	void ring_QGeoAreaMonitorInfo_freefunc(void *pState,void *pPointer);
	void ring_QGeoAreaMonitorSource_freefunc(void *pState,void *pPointer);
	void ring_QGeoCircle_freefunc(void *pState,void *pPointer);
	void ring_QGeoPositionInfoSource_freefunc(void *pState,void *pPointer);
	void ring_QGeoRectangle_freefunc(void *pState,void *pPointer);
	void ring_QGeoShape_freefunc(void *pState,void *pPointer);
	void ring_QGeoSatelliteInfo_freefunc(void *pState,void *pPointer);
	void ring_QGeoSatelliteInfoSource_freefunc(void *pState,void *pPointer);
	void ring_QNmeaPositionInfoSource_freefunc(void *pState,void *pPointer);
	void ring_QQuickWidget_freefunc(void *pState,void *pPointer);
	void ring_QQmlError_freefunc(void *pState,void *pPointer);

// End of Functions Prototype - Functions used to Free Memory 


RING_FUNC(ring_QObject_blockSignals)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->blockSignals( (bool ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QObject_children)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	{
		QObjectList *pValue ; 
		pValue = (QObjectList *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QObjectList)) ;
		*pValue = pObject->children();
		RING_API_RETMANAGEDCPOINTER(pValue,"QObjectList",ring_state_free);
	}
}


RING_FUNC(ring_QObject_dumpObjectInfo)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	pObject->dumpObjectInfo();
}


RING_FUNC(ring_QObject_dumpObjectTree)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	pObject->dumpObjectTree();
}


RING_FUNC(ring_QObject_inherits)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->inherits(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QObject_installEventFilter)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->installEventFilter((QObject *) RING_API_GETCPOINTER(2,"QObject"));
}


RING_FUNC(ring_QObject_isWidgetType)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETNUMBER(pObject->isWidgetType());
}


RING_FUNC(ring_QObject_killTimer)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->killTimer( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QObject_moveToThread)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->moveToThread((QThread *) RING_API_GETCPOINTER(2,"QThread"));
}


RING_FUNC(ring_QObject_objectName)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETSTRING(pObject->objectName().toStdString().c_str());
}


RING_FUNC(ring_QObject_parent)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETCPOINTER(pObject->parent(),"QObject");
}


RING_FUNC(ring_QObject_property)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->property(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QVariant",ring_QVariant_freefunc);
	}
}


RING_FUNC(ring_QObject_removeEventFilter)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeEventFilter((QObject *) RING_API_GETCPOINTER(2,"QObject"));
}


RING_FUNC(ring_QObject_setObjectName)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setObjectName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QObject_setParent)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setParent((QObject *) RING_API_GETCPOINTER(2,"QObject"));
}


RING_FUNC(ring_QObject_setProperty)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setProperty(RING_API_GETSTRING(2),* (QVariant *) RING_API_GETCPOINTER(3,"QVariant")));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QVariant"));
}


RING_FUNC(ring_QObject_setProperty_2)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setProperty(RING_API_GETSTRING(2), (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QObject_setProperty_3)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setProperty(RING_API_GETSTRING(2), (float) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QObject_setProperty_4)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setProperty(RING_API_GETSTRING(2), (double) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QObject_setProperty_5)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setProperty(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QObject_signalsBlocked)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETNUMBER(pObject->signalsBlocked());
}


RING_FUNC(ring_QObject_startTimer)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->startTimer( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QObject_thread)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETCPOINTER(pObject->thread(),"QThread");
}


RING_FUNC(ring_QObject_deleteLater)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	pObject->deleteLater();
}


RING_FUNC(ring_QDir_absoluteFilePath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->absoluteFilePath(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QDir_absolutePath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETSTRING(pObject->absolutePath().toStdString().c_str());
}


RING_FUNC(ring_QDir_canonicalPath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETSTRING(pObject->canonicalPath().toStdString().c_str());
}


RING_FUNC(ring_QDir_cd)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->cd(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_cdUp)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->cdUp());
}


RING_FUNC(ring_QDir_count)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->count();
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QDir_dirName)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETSTRING(pObject->dirName().toStdString().c_str());
}


RING_FUNC(ring_QDir_entryInfoList)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QFileInfoList *pValue ; 
		pValue = (QFileInfoList *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QFileInfoList)) ;
		*pValue = pObject->entryInfoList(* (QStringList  *) RING_API_GETCPOINTER(2,"QStringList"), (QDir::Filters )  (int) RING_API_GETNUMBER(3), (QDir::SortFlags )  (int) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QFileInfoList",ring_state_free);
	}
}


RING_FUNC(ring_QDir_entryInfoList_2)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QFileInfoList *pValue ; 
		pValue = (QFileInfoList *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QFileInfoList)) ;
		*pValue = pObject->entryInfoList( (QDir::Filters )  (int) RING_API_GETNUMBER(2), (QDir::SortFlags )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QFileInfoList",ring_state_free);
	}
}


RING_FUNC(ring_QDir_entryList)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->entryList(* (QStringList  *) RING_API_GETCPOINTER(2,"QStringList"), (QDir::Filters )  (int) RING_API_GETNUMBER(3), (QDir::SortFlags )  (int) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QDir_entryList_2)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->entryList( (QDir::Filters )  (int) RING_API_GETNUMBER(2), (QDir::SortFlags )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QDir_exists)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->exists(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_exists_2)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->exists());
}


RING_FUNC(ring_QDir_filePath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->filePath(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QDir_filter)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->filter());
}


RING_FUNC(ring_QDir_isAbsolute)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->isAbsolute());
}


RING_FUNC(ring_QDir_isReadable)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->isReadable());
}


RING_FUNC(ring_QDir_isRelative)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->isRelative());
}


RING_FUNC(ring_QDir_isRoot)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->isRoot());
}


RING_FUNC(ring_QDir_makeAbsolute)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->makeAbsolute());
}


RING_FUNC(ring_QDir_mkdir)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->mkdir(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_mkpath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->mkpath(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_nameFilters)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->nameFilters();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QDir_path)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETSTRING(pObject->path().toStdString().c_str());
}


RING_FUNC(ring_QDir_refresh)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	pObject->refresh();
}


RING_FUNC(ring_QDir_relativeFilePath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->relativeFilePath(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QDir_remove)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->remove(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_removeRecursively)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->removeRecursively());
}


RING_FUNC(ring_QDir_rename)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->rename(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QDir_rmdir)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->rmdir(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_rmpath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->rmpath(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_setFilter)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFilter( (QDir::Filters )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDir_setNameFilters)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	pObject->setNameFilters(* (QStringList  *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QDir_setPath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPath(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QDir_setSorting)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSorting( (QDir::SortFlags )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDir_sorting)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETNUMBER(pObject->sorting());
}


RING_FUNC(ring_QDir_swap)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	pObject->swap(* (QDir  *) RING_API_GETCPOINTER(2,"QDir"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDir"));
}


RING_FUNC(ring_QDir_addSearchPath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addSearchPath(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QDir_cleanPath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->cleanPath(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QDir_current)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	{
		QDir *pValue ; 
		pValue = new QDir() ;
		*pValue = pObject->current();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDir",ring_QDir_freefunc);
	}
}


RING_FUNC(ring_QDir_currentPath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETSTRING(pObject->currentPath().toStdString().c_str());
}


RING_FUNC(ring_QDir_drives)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	{
		QFileInfoList *pValue ; 
		pValue = (QFileInfoList *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QFileInfoList)) ;
		*pValue = pObject->drives();
		RING_API_RETMANAGEDCPOINTER(pValue,"QFileInfoList",ring_state_free);
	}
}


RING_FUNC(ring_QDir_fromNativeSeparators)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->fromNativeSeparators(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QDir_home)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	{
		QDir *pValue ; 
		pValue = new QDir() ;
		*pValue = pObject->home();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDir",ring_QDir_freefunc);
	}
}


RING_FUNC(ring_QDir_homePath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETSTRING(pObject->homePath().toStdString().c_str());
}


RING_FUNC(ring_QDir_isAbsolutePath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isAbsolutePath(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_isRelativePath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isRelativePath(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_match)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->match(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QDir_match_2)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->match(* (QStringList  *) RING_API_GETCPOINTER(2,"QStringList"),RING_API_GETSTRING(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QDir_root)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	{
		QDir *pValue ; 
		pValue = new QDir() ;
		*pValue = pObject->root();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDir",ring_QDir_freefunc);
	}
}


RING_FUNC(ring_QDir_rootPath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETSTRING(pObject->rootPath().toStdString().c_str());
}


RING_FUNC(ring_QDir_searchPaths)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->searchPaths(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QDir_separator)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->separator();
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QDir_setCurrent)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setCurrent(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QDir_setSearchPaths)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSearchPaths(RING_API_GETSTRING(2),* (QStringList  *) RING_API_GETCPOINTER(3,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QStringList"));
}


RING_FUNC(ring_QDir_temp)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	{
		QDir *pValue ; 
		pValue = new QDir() ;
		*pValue = pObject->temp();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDir",ring_QDir_freefunc);
	}
}


RING_FUNC(ring_QDir_tempPath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETSTRING(pObject->tempPath().toStdString().c_str());
}


RING_FUNC(ring_QDir_toNativeSeparators)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->toNativeSeparators(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_authority)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->authority( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_clear)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	pObject->clear();
}


RING_FUNC(ring_QUrl_errorString)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETSTRING(pObject->errorString().toStdString().c_str());
}


RING_FUNC(ring_QUrl_fileName)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->fileName( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_fragment)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->fragment( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_hasFragment)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->hasFragment());
}


RING_FUNC(ring_QUrl_hasQuery)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->hasQuery());
}


RING_FUNC(ring_QUrl_host)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->host( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_isEmpty)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QUrl_isLocalFile)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isLocalFile());
}


RING_FUNC(ring_QUrl_isParentOf)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isParentOf(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QUrl_isRelative)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isRelative());
}


RING_FUNC(ring_QUrl_isValid)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QUrl_password)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->password( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_path)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->path( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_port)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->port( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QUrl_query)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->query( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_resolved)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	{
		QUrl *pValue ; 
		pValue = new QUrl() ;
		*pValue = pObject->resolved(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QUrl",ring_QUrl_freefunc);
	}
}


RING_FUNC(ring_QUrl_scheme)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETSTRING(pObject->scheme().toStdString().c_str());
}


RING_FUNC(ring_QUrl_setAuthority)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAuthority(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setFragment)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFragment(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setHost)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHost(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setPassword)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPassword(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setPath)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPath(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setPort)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPort( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QUrl_setQuery)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setQuery(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setScheme)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setScheme(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QUrl_setUrl)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUrl(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setUserInfo)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUserInfo(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setUserName)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUserName(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_swap)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	pObject->swap(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QUrl_toLocalFile)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETSTRING(pObject->toLocalFile().toStdString().c_str());
}


RING_FUNC(ring_QUrl_topLevelDomain)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->topLevelDomain( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_userInfo)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->userInfo( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_userName)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->userName( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_fromLocalFile)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QUrl *pValue ; 
		pValue = new QUrl() ;
		*pValue = pObject->fromLocalFile(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QUrl",ring_QUrl_freefunc);
	}
}


RING_FUNC(ring_QEvent_accept)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	pObject->accept();
}


RING_FUNC(ring_QEvent_ignore)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	pObject->ignore();
}


RING_FUNC(ring_QEvent_isAccepted)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	RING_API_RETNUMBER(pObject->isAccepted());
}


RING_FUNC(ring_QEvent_setAccepted)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAccepted( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QEvent_spontaneous)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	RING_API_RETNUMBER(pObject->spontaneous());
}


RING_FUNC(ring_QEvent_type)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	RING_API_RETNUMBER(pObject->type());
}


RING_FUNC(ring_QTimer_interval)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETNUMBER(pObject->interval());
}


RING_FUNC(ring_QTimer_isActive)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETNUMBER(pObject->isActive());
}


RING_FUNC(ring_QTimer_isSingleShot)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETNUMBER(pObject->isSingleShot());
}


RING_FUNC(ring_QTimer_setInterval)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setInterval( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTimer_setSingleShot)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSingleShot( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTimer_timerId)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETNUMBER(pObject->timerId());
}


RING_FUNC(ring_QTimer_start)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	pObject->start();
}


RING_FUNC(ring_QTimer_stop)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	pObject->stop();
}


RING_FUNC(ring_QTimer_settimeoutEvent)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->settimeoutEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTimer_gettimeoutEvent)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETSTRING(pObject->gettimeoutEvent());
}


RING_FUNC(ring_QByteArray_append)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->append(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_at)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		char *pValue ; 
		pValue = (char *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(char)) ;
		*pValue = pObject->at( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"char",ring_state_free);
	}
}


RING_FUNC(ring_QByteArray_capacity)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	RING_API_RETNUMBER(pObject->capacity());
}


RING_FUNC(ring_QByteArray_chop)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->chop( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QByteArray_clear)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	pObject->clear();
}


RING_FUNC(ring_QByteArray_constData)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	RING_API_RETSTRING(pObject->constData());
}


RING_FUNC(ring_QByteArray_contains)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->contains(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QByteArray_count)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->count(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QByteArray_data)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	RING_API_RETSTRING(pObject->data());
}


RING_FUNC(ring_QByteArray_endsWith)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->endsWith(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QByteArray_fill)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->fill(* (char  *) RING_API_GETCPOINTER(2,"char"), (int ) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"char"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_indexOf)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->indexOf(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QByteArray_insert)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->insert( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3), (int ) RING_API_GETNUMBER(4));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_isEmpty)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QByteArray_isNull)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QByteArray_lastIndexOf)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->lastIndexOf(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QByteArray_left)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->left( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_leftJustified)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->leftJustified( (int ) RING_API_GETNUMBER(2),* (char  *) RING_API_GETCPOINTER(3,"char"), (bool ) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"char"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_length)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	RING_API_RETNUMBER(pObject->length());
}


RING_FUNC(ring_QByteArray_mid)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->mid( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_prepend)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->prepend(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_push_back)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->push_back(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QByteArray_push_front)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->push_front(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QByteArray_remove)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->remove( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_repeated)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->repeated( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_replace)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray  *pValue ; 
		pValue = (QByteArray  *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QByteArray )) ;
		*pValue = pObject->replace( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),RING_API_GETSTRING(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_state_free);
	}
}


RING_FUNC(ring_QByteArray_reserve)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->reserve( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QByteArray_resize)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->resize( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QByteArray_right)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->right( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_rightJustified)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->rightJustified( (int ) RING_API_GETNUMBER(2),* (char  *) RING_API_GETCPOINTER(3,"char"), (bool ) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"char"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_setNum)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->setNum( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_setRawData)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->setRawData(RING_API_GETSTRING(2),* (uint  *) RING_API_GETCPOINTER(3,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"uint"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_simplified)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->simplified();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_size)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	RING_API_RETNUMBER(pObject->size());
}


RING_FUNC(ring_QByteArray_squeeze)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	pObject->squeeze();
}


RING_FUNC(ring_QByteArray_startsWith)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->startsWith(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QByteArray_swap)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	pObject->swap(* (QByteArray  *) RING_API_GETCPOINTER(2,"QByteArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QByteArray_toBase64)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toBase64();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_toDouble)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toDouble((bool *) RING_API_GETCPOINTER(2,"bool")));
}


RING_FUNC(ring_QByteArray_toFloat)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toFloat((bool *) RING_API_GETCPOINTER(2,"bool")));
}


RING_FUNC(ring_QByteArray_toHex)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toHex();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_toInt)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toInt((bool *) RING_API_GETCPOINTER(2,"bool"), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QByteArray_toLong)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		long *pValue ; 
		pValue = (long *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(long)) ;
		*pValue = pObject->toLong((bool *) RING_API_GETCPOINTER(2,"bool"), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"long",ring_state_free);
	}
}


RING_FUNC(ring_QByteArray_toLongLong)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		qlonglong *pValue ; 
		pValue = (qlonglong *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(qlonglong)) ;
		*pValue = pObject->toLongLong((bool *) RING_API_GETCPOINTER(2,"bool"), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"qlonglong",ring_state_free);
	}
}


RING_FUNC(ring_QByteArray_toLower)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toLower();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_toPercentEncoding)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toPercentEncoding(* (QByteArray *) RING_API_GETCPOINTER(2,"QByteArray"),* (QByteArray *) RING_API_GETCPOINTER(3,"QByteArray"),* (char  *) RING_API_GETCPOINTER(4,"char"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QByteArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"char"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_toShort)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		short *pValue ; 
		pValue = (short *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(short)) ;
		*pValue = pObject->toShort((bool *) RING_API_GETCPOINTER(2,"bool"), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"short",ring_state_free);
	}
}


RING_FUNC(ring_QByteArray_toUInt)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toUInt((bool *) RING_API_GETCPOINTER(2,"bool"), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QByteArray_toULong)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toULong((bool *) RING_API_GETCPOINTER(2,"bool"), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QByteArray_toULongLong)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toULongLong((bool *) RING_API_GETCPOINTER(2,"bool"), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QByteArray_toUShort)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toUShort((bool *) RING_API_GETCPOINTER(2,"bool"), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QByteArray_toUpper)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toUpper();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_trimmed)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->trimmed();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_truncate)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->truncate( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QByteArray_fromBase64)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->fromBase64(* (QByteArray *) RING_API_GETCPOINTER(2,"QByteArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_fromHex)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->fromHex(* (QByteArray *) RING_API_GETCPOINTER(2,"QByteArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_fromPercentEncoding)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->fromPercentEncoding(* (QByteArray *) RING_API_GETCPOINTER(2,"QByteArray"),* (char  *) RING_API_GETCPOINTER(3,"char"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"char"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_fromRawData)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->fromRawData(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QByteArray_number)
{
	QByteArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QByteArray *) RING_API_GETCPOINTER(1,"QByteArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->number( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QIODevice_errorString)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETSTRING(pObject->errorString().toStdString().c_str());
}


RING_FUNC(ring_QIODevice_getChar)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->getChar(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QIODevice_isOpen)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->isOpen());
}


RING_FUNC(ring_QIODevice_isReadable)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->isReadable());
}


RING_FUNC(ring_QIODevice_isTextModeEnabled)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->isTextModeEnabled());
}


RING_FUNC(ring_QIODevice_isWritable)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->isWritable());
}


RING_FUNC(ring_QIODevice_openMode)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->openMode());
}


RING_FUNC(ring_QIODevice_peek)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->peek(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QIODevice_putChar)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->putChar(* (char  *) RING_API_GETCPOINTER(2,"char")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"char"));
}


RING_FUNC(ring_QIODevice_read)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->read(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QIODevice_readAll)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->readAll();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QIODevice_readLine)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->readLine(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QIODevice_setTextModeEnabled)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextModeEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QIODevice_ungetChar)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	pObject->ungetChar(* (char  *) RING_API_GETCPOINTER(2,"char"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"char"));
}


RING_FUNC(ring_QIODevice_write)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->write(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QIODevice_atEnd)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->atEnd());
}


RING_FUNC(ring_QIODevice_canReadLine)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->canReadLine());
}


RING_FUNC(ring_QIODevice_close)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	pObject->close();
}


RING_FUNC(ring_QIODevice_open)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->open( (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QIODevice_pos)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->pos());
}


RING_FUNC(ring_QIODevice_seek)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->seek( (qint64 ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QIODevice_size)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETNUMBER(pObject->size());
}


RING_FUNC(ring_QIODevice_setaboutToCloseEvent)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setaboutToCloseEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QIODevice_setbytesWrittenEvent)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setbytesWrittenEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QIODevice_setreadChannelFinishedEvent)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setreadChannelFinishedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QIODevice_setreadyReadEvent)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setreadyReadEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QIODevice_getaboutToCloseEvent)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETSTRING(pObject->getaboutToCloseEvent());
}


RING_FUNC(ring_QIODevice_getbytesWrittenEvent)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETSTRING(pObject->getbytesWrittenEvent());
}


RING_FUNC(ring_QIODevice_getreadChannelFinishedEvent)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETSTRING(pObject->getreadChannelFinishedEvent());
}


RING_FUNC(ring_QIODevice_getreadyReadEvent)
{
	GIODevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GIODevice *) RING_API_GETCPOINTER(1,"QIODevice");
	RING_API_RETSTRING(pObject->getreadyReadEvent());
}


RING_FUNC(ring_QFileInfo_absoluteDir)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	{
		QDir *pValue ; 
		pValue = new QDir() ;
		*pValue = pObject->absoluteDir();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDir",ring_QDir_freefunc);
	}
}


RING_FUNC(ring_QFileInfo_absoluteFilePath)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->absoluteFilePath().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_absolutePath)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->absolutePath().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_baseName)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->baseName().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_bundleName)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->bundleName().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_caching)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->caching());
}


RING_FUNC(ring_QFileInfo_canonicalFilePath)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->canonicalFilePath().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_canonicalPath)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->canonicalPath().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_completeBaseName)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->completeBaseName().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_completeSuffix)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->completeSuffix().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_created)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->created();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QFileInfo_dir)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	{
		QDir *pValue ; 
		pValue = new QDir() ;
		*pValue = pObject->dir();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDir",ring_QDir_freefunc);
	}
}


RING_FUNC(ring_QFileInfo_exists)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->exists());
}


RING_FUNC(ring_QFileInfo_fileName)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->fileName().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_filePath)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->filePath().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_group)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->group().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_groupId)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->groupId());
}


RING_FUNC(ring_QFileInfo_isAbsolute)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isAbsolute());
}


RING_FUNC(ring_QFileInfo_isBundle)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isBundle());
}


RING_FUNC(ring_QFileInfo_isDir)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isDir());
}


RING_FUNC(ring_QFileInfo_isExecutable)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isExecutable());
}


RING_FUNC(ring_QFileInfo_isFile)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isFile());
}


RING_FUNC(ring_QFileInfo_isHidden)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isHidden());
}


RING_FUNC(ring_QFileInfo_isNativePath)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isNativePath());
}


RING_FUNC(ring_QFileInfo_isReadable)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isReadable());
}


RING_FUNC(ring_QFileInfo_isRelative)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isRelative());
}


RING_FUNC(ring_QFileInfo_isRoot)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isRoot());
}


RING_FUNC(ring_QFileInfo_isSymLink)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isSymLink());
}


RING_FUNC(ring_QFileInfo_isWritable)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->isWritable());
}


RING_FUNC(ring_QFileInfo_lastModified)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->lastModified();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QFileInfo_lastRead)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->lastRead();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QFileInfo_makeAbsolute)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->makeAbsolute());
}


RING_FUNC(ring_QFileInfo_owner)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->owner().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_ownerId)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->ownerId();
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QFileInfo_path)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->path().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_permission)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->permission( (QFileDevice::Permission )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QFileInfo_permissions)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->permissions());
}


RING_FUNC(ring_QFileInfo_refresh)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	pObject->refresh();
}


RING_FUNC(ring_QFileInfo_setCaching)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCaching( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileInfo_setFile)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFile(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFileInfo_size)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETNUMBER(pObject->size());
}


RING_FUNC(ring_QFileInfo_suffix)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->suffix().toStdString().c_str());
}


RING_FUNC(ring_QFileInfo_swap)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	pObject->swap(* (QFileInfo *) RING_API_GETCPOINTER(2,"QFileInfo"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFileInfo"));
}


RING_FUNC(ring_QFileInfo_symLinkTarget)
{
	QFileInfo *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileInfo *) RING_API_GETCPOINTER(1,"QFileInfo");
	RING_API_RETSTRING(pObject->symLinkTarget().toStdString().c_str());
}


RING_FUNC(ring_QStringList_join)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->join(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QStringList_sort)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	pObject->sort();
}


RING_FUNC(ring_QStringList_removeDuplicates)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETNUMBER(pObject->removeDuplicates());
}


RING_FUNC(ring_QStringList_filter)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->filter(RING_API_GETSTRING(2), (Qt::CaseSensitivity)  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QStringList_replaceInStrings)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->replaceInStrings(RING_API_GETSTRING(2),RING_API_GETSTRING(3), (Qt::CaseSensitivity)  (int) RING_API_GETNUMBER(4));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QStringList_append)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->append(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QStringList_at)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->at( (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QStringList_back)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETSTRING(pObject->back().toStdString().c_str());
}


RING_FUNC(ring_QStringList_clear)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	pObject->clear();
}


RING_FUNC(ring_QStringList_contains)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->contains(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QStringList_count)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETNUMBER(pObject->count());
}


RING_FUNC(ring_QStringList_empty)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETNUMBER(pObject->empty());
}


RING_FUNC(ring_QStringList_endsWith)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->endsWith(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QStringList_first)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETSTRING(pObject->first().toStdString().c_str());
}


RING_FUNC(ring_QStringList_front)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETSTRING(pObject->front().toStdString().c_str());
}


RING_FUNC(ring_QStringList_indexOf)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->indexOf(RING_API_GETSTRING(2), (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QStringList_insert)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insert( (int) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QStringList_isEmpty)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QStringList_last)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETSTRING(pObject->last().toStdString().c_str());
}


RING_FUNC(ring_QStringList_lastIndexOf)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->lastIndexOf(RING_API_GETSTRING(2), (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QStringList_length)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETNUMBER(pObject->length());
}


RING_FUNC(ring_QStringList_move)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->move( (int) RING_API_GETNUMBER(2), (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QStringList_pop_back)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	pObject->pop_back();
}


RING_FUNC(ring_QStringList_pop_front)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	pObject->pop_front();
}


RING_FUNC(ring_QStringList_prepend)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->prepend(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QStringList_push_back)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->push_back(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QStringList_push_front)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->push_front(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QStringList_removeAll)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->removeAll(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QStringList_removeAt)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeAt( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QStringList_removeFirst)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	pObject->removeFirst();
}


RING_FUNC(ring_QStringList_removeLast)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	pObject->removeLast();
}


RING_FUNC(ring_QStringList_removeOne)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->removeOne(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QStringList_replace)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->replace( (int) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QStringList_reserve)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->reserve( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QStringList_size)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETNUMBER(pObject->size());
}


RING_FUNC(ring_QStringList_startsWith)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->startsWith(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QStringList_swap)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->swap( (int) RING_API_GETNUMBER(2), (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QStringList_takeAt)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->takeAt( (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QStringList_takeFirst)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETSTRING(pObject->takeFirst().toStdString().c_str());
}


RING_FUNC(ring_QStringList_takeLast)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	RING_API_RETSTRING(pObject->takeLast().toStdString().c_str());
}


RING_FUNC(ring_QStringList_value)
{
	QStringList *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringList *) RING_API_GETCPOINTER(1,"QStringList");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->value( (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QRect_adjust)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->adjust( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QRect_adjusted)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->adjusted( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QRect_bottom)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->bottom());
}


RING_FUNC(ring_QRect_bottomLeft)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->bottomLeft();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QRect_bottomRight)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->bottomRight();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QRect_center)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->center();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QRect_contains)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->contains( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (bool ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QRect_getCoords)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getCoords(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QRect_getRect)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getRect(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QRect_height)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->height());
}


RING_FUNC(ring_QRect_intersected)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->intersected(* (QRect *) RING_API_GETCPOINTER(2,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QRect_intersects)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->intersects(* (QRect *) RING_API_GETCPOINTER(2,"QRect")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
}


RING_FUNC(ring_QRect_isEmpty)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QRect_isNull)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QRect_isValid)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QRect_left)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->left());
}


RING_FUNC(ring_QRect_moveBottom)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->moveBottom( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_moveBottomLeft)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->moveBottomLeft(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QRect_moveBottomRight)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->moveBottomRight(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QRect_moveCenter)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->moveCenter(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QRect_moveLeft)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->moveLeft( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_moveRight)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->moveRight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_moveTo)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->moveTo( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QRect_moveTop)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->moveTop( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_moveTopLeft)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->moveTopLeft(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QRect_moveTopRight)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->moveTopRight(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QRect_normalized)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->normalized();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QRect_right)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->right());
}


RING_FUNC(ring_QRect_setBottom)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBottom( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_setBottomLeft)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->setBottomLeft(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QRect_setBottomRight)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->setBottomRight(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QRect_setCoords)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCoords( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QRect_setHeight)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_setLeft)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLeft( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_setRect)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QRect_setRight)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_setSize)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->setSize(* (QSize *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QRect_setTop)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTop( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_setTopLeft)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->setTopLeft(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QRect_setTopRight)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	pObject->setTopRight(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QRect_setWidth)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_setX)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setX( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_setY)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setY( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRect_size)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->size();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QRect_top)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->top());
}


RING_FUNC(ring_QRect_topLeft)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->topLeft();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QRect_topRight)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->topRight();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QRect_translate)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->translate( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QRect_translated)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->translated( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QRect_united)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->united(* (QRect *) RING_API_GETCPOINTER(2,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QRect_width)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->width());
}


RING_FUNC(ring_QRect_x)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->x());
}


RING_FUNC(ring_QRect_y)
{
	QRect *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRect *) RING_API_GETCPOINTER(1,"QRect");
	RING_API_RETNUMBER(pObject->y());
}


RING_FUNC(ring_QTime_addMSecs)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->addMSecs( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTime",ring_QTime_freefunc);
	}
}


RING_FUNC(ring_QTime_addSecs)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->addSecs( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTime",ring_QTime_freefunc);
	}
}


RING_FUNC(ring_QTime_elapsed)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->elapsed());
}


RING_FUNC(ring_QTime_hour)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->hour());
}


RING_FUNC(ring_QTime_isNull)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QTime_isValid)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QTime_minute)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->minute());
}


RING_FUNC(ring_QTime_msec)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->msec());
}


RING_FUNC(ring_QTime_msecsSinceStartOfDay)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->msecsSinceStartOfDay());
}


RING_FUNC(ring_QTime_msecsTo)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->msecsTo(* (QTime *) RING_API_GETCPOINTER(2,"QTime")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTime"));
}


RING_FUNC(ring_QTime_restart)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->restart());
}


RING_FUNC(ring_QTime_second)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->second());
}


RING_FUNC(ring_QTime_secsTo)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	RING_API_RETNUMBER(pObject->secsTo(* (QTime *) RING_API_GETCPOINTER(2,"QTime")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTime"));
}


RING_FUNC(ring_QTime_setHMS)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setHMS( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5)));
}


RING_FUNC(ring_QTime_start)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	pObject->start();
}


RING_FUNC(ring_QTime_toString)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->toString(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QTime_currentTime)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->currentTime();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTime",ring_QTime_freefunc);
	}
}


RING_FUNC(ring_QTime_fromMSecsSinceStartOfDay)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->fromMSecsSinceStartOfDay( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTime",ring_QTime_freefunc);
	}
}


RING_FUNC(ring_QTime_fromString)
{
	QTime *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTime *) RING_API_GETCPOINTER(1,"QTime");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->fromString(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTime",ring_QTime_freefunc);
	}
}


RING_FUNC(ring_QDate_addDays)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->addDays( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDate",ring_QDate_freefunc);
	}
}


RING_FUNC(ring_QDate_addMonths)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->addMonths( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDate",ring_QDate_freefunc);
	}
}


RING_FUNC(ring_QDate_addYears)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->addYears( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDate",ring_QDate_freefunc);
	}
}


RING_FUNC(ring_QDate_day)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->day());
}


RING_FUNC(ring_QDate_dayOfWeek)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->dayOfWeek());
}


RING_FUNC(ring_QDate_dayOfYear)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->dayOfYear());
}


RING_FUNC(ring_QDate_daysInMonth)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->daysInMonth());
}


RING_FUNC(ring_QDate_daysInYear)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->daysInYear());
}


RING_FUNC(ring_QDate_daysTo)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->daysTo(* (QDate *) RING_API_GETCPOINTER(2,"QDate")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDate"));
}


RING_FUNC(ring_QDate_getDate)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getDate(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
}


RING_FUNC(ring_QDate_isNull)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QDate_isValid)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QDate_month)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->month());
}


RING_FUNC(ring_QDate_setDate)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setDate( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QDate_toJulianDay)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->toJulianDay());
}


RING_FUNC(ring_QDate_toString)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->toString(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QDate_weekNumber)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->weekNumber(RING_API_GETINTPOINTER(2)));
	RING_API_ACCEPTINTVALUE(1) ;
}


RING_FUNC(ring_QDate_year)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	RING_API_RETNUMBER(pObject->year());
}


RING_FUNC(ring_QDate_currentDate)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->currentDate();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDate",ring_QDate_freefunc);
	}
}


RING_FUNC(ring_QDate_fromJulianDay)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->fromJulianDay( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDate",ring_QDate_freefunc);
	}
}


RING_FUNC(ring_QDate_fromString)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->fromString(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDate",ring_QDate_freefunc);
	}
}


RING_FUNC(ring_QDate_isLeapYear)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isLeapYear( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QDate_longDayName)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->longDayName( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QDate_longMonthName)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->longMonthName( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QDate_shortDayName)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->shortDayName( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QDate_shortMonthName)
{
	QDate *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDate *) RING_API_GETCPOINTER(1,"QDate");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->shortMonthName( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTextCodec_codecForName)
{
	RING_API_RETCPOINTER( QTextCodec::codecForName(RING_API_GETSTRING(1)) , "QTextCodec");
}

RING_FUNC(ring_QTextCodec_setCodecForLocale)
{
	 QTextCodec::setCodecForLocale( (QTextCodec *) RING_API_GETCPOINTER(1,"QTextCodec"));
}


RING_FUNC(ring_QVariant_canConvert)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->canConvert( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QVariant_clear)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	pObject->clear();
}


RING_FUNC(ring_QVariant_convert)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->convert( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QVariant_isNull)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QVariant_isValid)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QVariant_swap)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	pObject->swap(* (QVariant *) RING_API_GETCPOINTER(2,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QVariant"));
}


RING_FUNC(ring_QVariant_toBitArray)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QBitArray *pValue ; 
		pValue = (QBitArray *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QBitArray)) ;
		*pValue = pObject->toBitArray();
		RING_API_RETMANAGEDCPOINTER(pValue,"QBitArray",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toBool)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	RING_API_RETNUMBER(pObject->toBool());
}


RING_FUNC(ring_QVariant_toByteArray)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toByteArray();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QVariant_toChar)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->toChar();
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QVariant_toDate)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->toDate();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDate",ring_QDate_freefunc);
	}
}


RING_FUNC(ring_QVariant_toDateTime)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->toDateTime();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QVariant_toDouble)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toDouble((bool *) RING_API_GETCPOINTER(2,"bool")));
}


RING_FUNC(ring_QVariant_toEasingCurve)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QEasingCurve *pValue ; 
		pValue = (QEasingCurve *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QEasingCurve)) ;
		*pValue = pObject->toEasingCurve();
		RING_API_RETMANAGEDCPOINTER(pValue,"QEasingCurve",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toFloat)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toFloat((bool *) RING_API_GETCPOINTER(2,"bool")));
}


RING_FUNC(ring_QVariant_toInt)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toInt((bool *) RING_API_GETCPOINTER(2,"bool")));
}


RING_FUNC(ring_QVariant_toJsonArray)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QJsonArray *pValue ; 
		pValue = new QJsonArray() ;
		*pValue = pObject->toJsonArray();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonArray",ring_QJsonArray_freefunc);
	}
}


RING_FUNC(ring_QVariant_toJsonDocument)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QJsonDocument *pValue ; 
		pValue = new QJsonDocument() ;
		*pValue = pObject->toJsonDocument();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonDocument",ring_QJsonDocument_freefunc);
	}
}


RING_FUNC(ring_QVariant_toJsonObject)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QJsonObject *pValue ; 
		pValue = new QJsonObject() ;
		*pValue = pObject->toJsonObject();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonObject",ring_QJsonObject_freefunc);
	}
}


RING_FUNC(ring_QVariant_toJsonValue)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QJsonValue *pValue ; 
		pValue = new QJsonValue() ;
		*pValue = pObject->toJsonValue();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonValue",ring_QJsonValue_freefunc);
	}
}


RING_FUNC(ring_QVariant_toLine)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QLine *pValue ; 
		pValue = (QLine *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QLine)) ;
		*pValue = pObject->toLine();
		RING_API_RETMANAGEDCPOINTER(pValue,"QLine",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toLineF)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QLineF *pValue ; 
		pValue = (QLineF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QLineF)) ;
		*pValue = pObject->toLineF();
		RING_API_RETMANAGEDCPOINTER(pValue,"QLineF",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toLocale)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QLocale *pValue ; 
		pValue = (QLocale *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QLocale)) ;
		*pValue = pObject->toLocale();
		RING_API_RETMANAGEDCPOINTER(pValue,"QLocale",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toLongLong)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		qlonglong *pValue ; 
		pValue = (qlonglong *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(qlonglong)) ;
		*pValue = pObject->toLongLong((bool *) RING_API_GETCPOINTER(2,"bool"));
		RING_API_RETMANAGEDCPOINTER(pValue,"qlonglong",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toModelIndex)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->toModelIndex();
		RING_API_RETMANAGEDCPOINTER(pValue,"QModelIndex",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toPoint)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->toPoint();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QVariant_toPointF)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QPointF *pValue ; 
		pValue = new QPointF() ;
		*pValue = pObject->toPointF();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPointF",ring_QPointF_freefunc);
	}
}


RING_FUNC(ring_QVariant_toReal)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toReal((bool *) RING_API_GETCPOINTER(2,"bool")));
}


RING_FUNC(ring_QVariant_toRect)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->toRect();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QVariant_toRectF)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QRectF *pValue ; 
		pValue = (QRectF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRectF)) ;
		*pValue = pObject->toRectF();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRectF",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toRegExp)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QRegExp *pValue ; 
		pValue = (QRegExp *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRegExp)) ;
		*pValue = pObject->toRegExp();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegExp",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toRegularExpression)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QRegularExpression *pValue ; 
		pValue = new QRegularExpression() ;
		*pValue = pObject->toRegularExpression();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegularExpression",ring_QRegularExpression_freefunc);
	}
}


RING_FUNC(ring_QVariant_toSize)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->toSize();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QVariant_toSizeF)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QSizeF *pValue ; 
		pValue = (QSizeF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QSizeF)) ;
		*pValue = pObject->toSizeF();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSizeF",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toStringList)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->toStringList();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QVariant_toTime)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->toTime();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTime",ring_QTime_freefunc);
	}
}


RING_FUNC(ring_QVariant_toUInt)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->toUInt((bool *) RING_API_GETCPOINTER(2,"bool"));
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toULongLong)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		qulonglong *pValue ; 
		pValue = (qulonglong *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(qulonglong)) ;
		*pValue = pObject->toULongLong((bool *) RING_API_GETCPOINTER(2,"bool"));
		RING_API_RETMANAGEDCPOINTER(pValue,"qulonglong",ring_state_free);
	}
}


RING_FUNC(ring_QVariant_toUrl)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QUrl *pValue ; 
		pValue = new QUrl() ;
		*pValue = pObject->toUrl();
		RING_API_RETMANAGEDCPOINTER(pValue,"QUrl",ring_QUrl_freefunc);
	}
}


RING_FUNC(ring_QVariant_toUuid)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	{
		QUuid *pValue ; 
		pValue = new QUuid() ;
		*pValue = pObject->toUuid();
		RING_API_RETMANAGEDCPOINTER(pValue,"QUuid",ring_QUuid_freefunc);
	}
}


RING_FUNC(ring_QVariant_type)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	RING_API_RETNUMBER(pObject->type());
}


RING_FUNC(ring_QVariant_typeName)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	RING_API_RETSTRING(pObject->typeName());
}


RING_FUNC(ring_QVariant_userType)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	RING_API_RETNUMBER(pObject->userType());
}


RING_FUNC(ring_QVariant_toString)
{
	QVariant *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVariant *) RING_API_GETCPOINTER(1,"QVariant");
	RING_API_RETSTRING(pObject->toString().toStdString().c_str());
}


RING_FUNC(ring_QXmlStreamReader_addData)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	pObject->addData(* (QByteArray *) RING_API_GETCPOINTER(2,"QByteArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QXmlStreamReader_addData_2)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addData(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamReader_addData_3)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addData(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamReader_addExtraNamespaceDeclaration)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	pObject->addExtraNamespaceDeclaration(* (QXmlStreamNamespaceDeclaration *) RING_API_GETCPOINTER(2,"QXmlStreamNamespaceDeclaration"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QXmlStreamNamespaceDeclaration"));
}


RING_FUNC(ring_QXmlStreamReader_addExtraNamespaceDeclarations)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	pObject->addExtraNamespaceDeclarations(* (QXmlStreamNamespaceDeclarations *) RING_API_GETCPOINTER(2,"QXmlStreamNamespaceDeclarations"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QXmlStreamNamespaceDeclarations"));
}


RING_FUNC(ring_QXmlStreamReader_atEnd)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->atEnd());
}


RING_FUNC(ring_QXmlStreamReader_attributes)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QXmlStreamAttributes *pValue ; 
		pValue = new QXmlStreamAttributes() ;
		*pValue = pObject->attributes();
		RING_API_RETMANAGEDCPOINTER(pValue,"QXmlStreamAttributes",ring_QXmlStreamAttributes_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_characterOffset)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->characterOffset());
}


RING_FUNC(ring_QXmlStreamReader_clear)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	pObject->clear();
}


RING_FUNC(ring_QXmlStreamReader_columnNumber)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->columnNumber());
}


RING_FUNC(ring_QXmlStreamReader_device)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETCPOINTER(pObject->device(),"QIODevice");
}


RING_FUNC(ring_QXmlStreamReader_documentEncoding)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->documentEncoding();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_documentVersion)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->documentVersion();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_dtdName)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->dtdName();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_dtdPublicId)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->dtdPublicId();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_dtdSystemId)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->dtdSystemId();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_entityDeclarations)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QXmlStreamEntityDeclarations *pValue ; 
		pValue = (QXmlStreamEntityDeclarations *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QXmlStreamEntityDeclarations)) ;
		*pValue = pObject->entityDeclarations();
		RING_API_RETMANAGEDCPOINTER(pValue,"QXmlStreamEntityDeclarations",ring_state_free);
	}
}


RING_FUNC(ring_QXmlStreamReader_entityResolver)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETCPOINTER(pObject->entityResolver(),"QXmlStreamEntityResolver");
}


RING_FUNC(ring_QXmlStreamReader_error)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->error());
}


RING_FUNC(ring_QXmlStreamReader_errorString)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETSTRING(pObject->errorString().toStdString().c_str());
}


RING_FUNC(ring_QXmlStreamReader_hasError)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->hasError());
}


RING_FUNC(ring_QXmlStreamReader_isCDATA)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isCDATA());
}


RING_FUNC(ring_QXmlStreamReader_isCharacters)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isCharacters());
}


RING_FUNC(ring_QXmlStreamReader_isComment)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isComment());
}


RING_FUNC(ring_QXmlStreamReader_isDTD)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isDTD());
}


RING_FUNC(ring_QXmlStreamReader_isEndDocument)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isEndDocument());
}


RING_FUNC(ring_QXmlStreamReader_isEndElement)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isEndElement());
}


RING_FUNC(ring_QXmlStreamReader_isEntityReference)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isEntityReference());
}


RING_FUNC(ring_QXmlStreamReader_isProcessingInstruction)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isProcessingInstruction());
}


RING_FUNC(ring_QXmlStreamReader_isStandaloneDocument)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isStandaloneDocument());
}


RING_FUNC(ring_QXmlStreamReader_isStartDocument)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isStartDocument());
}


RING_FUNC(ring_QXmlStreamReader_isStartElement)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isStartElement());
}


RING_FUNC(ring_QXmlStreamReader_isWhitespace)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->isWhitespace());
}


RING_FUNC(ring_QXmlStreamReader_lineNumber)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->lineNumber());
}


RING_FUNC(ring_QXmlStreamReader_name)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->name();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_namespaceDeclarations)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QXmlStreamNamespaceDeclarations *pValue ; 
		pValue = (QXmlStreamNamespaceDeclarations *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QXmlStreamNamespaceDeclarations)) ;
		*pValue = pObject->namespaceDeclarations();
		RING_API_RETMANAGEDCPOINTER(pValue,"QXmlStreamNamespaceDeclarations",ring_state_free);
	}
}


RING_FUNC(ring_QXmlStreamReader_namespaceProcessing)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->namespaceProcessing());
}


RING_FUNC(ring_QXmlStreamReader_namespaceUri)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->namespaceUri();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_notationDeclarations)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QXmlStreamNotationDeclarations *pValue ; 
		pValue = (QXmlStreamNotationDeclarations *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QXmlStreamNotationDeclarations)) ;
		*pValue = pObject->notationDeclarations();
		RING_API_RETMANAGEDCPOINTER(pValue,"QXmlStreamNotationDeclarations",ring_state_free);
	}
}


RING_FUNC(ring_QXmlStreamReader_prefix)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->prefix();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_processingInstructionData)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->processingInstructionData();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_processingInstructionTarget)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->processingInstructionTarget();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_qualifiedName)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->qualifiedName();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_raiseError)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->raiseError(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamReader_readElementText)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->readElementText( (QXmlStreamReader::ReadElementTextBehaviour)  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QXmlStreamReader_readNext)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->readNext());
}


RING_FUNC(ring_QXmlStreamReader_readNextStartElement)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->readNextStartElement());
}


RING_FUNC(ring_QXmlStreamReader_setDevice)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDevice((QIODevice *) RING_API_GETCPOINTER(2,"QIODevice"));
}


RING_FUNC(ring_QXmlStreamReader_setEntityResolver)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEntityResolver((QXmlStreamEntityResolver *) RING_API_GETCPOINTER(2,"QXmlStreamEntityResolver"));
}


RING_FUNC(ring_QXmlStreamReader_setNamespaceProcessing)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNamespaceProcessing( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QXmlStreamReader_skipCurrentElement)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	pObject->skipCurrentElement();
}


RING_FUNC(ring_QXmlStreamReader_text)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->text();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamReader_tokenString)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETSTRING(pObject->tokenString().toStdString().c_str());
}


RING_FUNC(ring_QXmlStreamReader_tokenType)
{
	QXmlStreamReader *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamReader *) RING_API_GETCPOINTER(1,"QXmlStreamReader");
	RING_API_RETNUMBER(pObject->tokenType());
}


RING_FUNC(ring_QXmlStreamWriter_autoFormatting)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	RING_API_RETNUMBER(pObject->autoFormatting());
}


RING_FUNC(ring_QXmlStreamWriter_autoFormattingIndent)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	RING_API_RETNUMBER(pObject->autoFormattingIndent());
}


RING_FUNC(ring_QXmlStreamWriter_codec)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	RING_API_RETCPOINTER(pObject->codec(),"QTextCodec");
}


RING_FUNC(ring_QXmlStreamWriter_device)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	RING_API_RETCPOINTER(pObject->device(),"QIODevice");
}


RING_FUNC(ring_QXmlStreamWriter_hasError)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	RING_API_RETNUMBER(pObject->hasError());
}


RING_FUNC(ring_QXmlStreamWriter_setAutoFormatting)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoFormatting( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QXmlStreamWriter_setAutoFormattingIndent)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoFormattingIndent( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QXmlStreamWriter_setCodec)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCodec((QTextCodec *) RING_API_GETCPOINTER(2,"QTextCodec"));
}


RING_FUNC(ring_QXmlStreamWriter_setCodec_2)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCodec(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_setDevice)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDevice((QIODevice *) RING_API_GETCPOINTER(2,"QIODevice"));
}


RING_FUNC(ring_QXmlStreamWriter_writeAttribute)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeAttribute(RING_API_GETSTRING(2),RING_API_GETSTRING(3),RING_API_GETSTRING(4));
}


RING_FUNC(ring_QXmlStreamWriter_writeAttribute_2)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeAttribute(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QXmlStreamWriter_writeAttribute_3)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	pObject->writeAttribute(* (QXmlStreamAttribute *) RING_API_GETCPOINTER(2,"QXmlStreamAttribute"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QXmlStreamAttribute"));
}


RING_FUNC(ring_QXmlStreamWriter_writeAttributes)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	pObject->writeAttributes(* (QXmlStreamAttributes *) RING_API_GETCPOINTER(2,"QXmlStreamAttributes"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QXmlStreamAttributes"));
}


RING_FUNC(ring_QXmlStreamWriter_writeCDATA)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeCDATA(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_writeCharacters)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeCharacters(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_writeComment)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeComment(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_writeCurrentToken)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	pObject->writeCurrentToken(* (QXmlStreamReader  *) RING_API_GETCPOINTER(2,"QXmlStreamReader"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QXmlStreamReader"));
}


RING_FUNC(ring_QXmlStreamWriter_writeDTD)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeDTD(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_writeDefaultNamespace)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeDefaultNamespace(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_writeEmptyElement)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeEmptyElement(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QXmlStreamWriter_writeEmptyElement_2)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeEmptyElement(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_writeEndDocument)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	pObject->writeEndDocument();
}


RING_FUNC(ring_QXmlStreamWriter_writeEndElement)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	pObject->writeEndElement();
}


RING_FUNC(ring_QXmlStreamWriter_writeEntityReference)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeEntityReference(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_writeNamespace)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeNamespace(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QXmlStreamWriter_writeProcessingInstruction)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeProcessingInstruction(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QXmlStreamWriter_writeStartDocument)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeStartDocument(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_writeStartDocument_2)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeStartDocument(RING_API_GETSTRING(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QXmlStreamWriter_writeStartDocument_3)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	pObject->writeStartDocument();
}


RING_FUNC(ring_QXmlStreamWriter_writeStartElement)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeStartElement(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QXmlStreamWriter_writeStartElement_2)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeStartElement(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QXmlStreamWriter_writeTextElement)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeTextElement(RING_API_GETSTRING(2),RING_API_GETSTRING(3),RING_API_GETSTRING(4));
}


RING_FUNC(ring_QXmlStreamWriter_writeTextElement_2)
{
	QXmlStreamWriter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamWriter *) RING_API_GETCPOINTER(1,"QXmlStreamWriter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->writeTextElement(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QXmlStreamNotationDeclaration_name)
{
	QXmlStreamNotationDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamNotationDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamNotationDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->name();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamNotationDeclaration_publicId)
{
	QXmlStreamNotationDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamNotationDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamNotationDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->publicId();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamNotationDeclaration_systemId)
{
	QXmlStreamNotationDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamNotationDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamNotationDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->systemId();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamNamespaceDeclaration_namespaceUri)
{
	QXmlStreamNamespaceDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamNamespaceDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamNamespaceDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->namespaceUri();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamNamespaceDeclaration_prefix)
{
	QXmlStreamNamespaceDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamNamespaceDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamNamespaceDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->prefix();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamEntityDeclaration_name)
{
	QXmlStreamEntityDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamEntityDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamEntityDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->name();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamEntityDeclaration_notationName)
{
	QXmlStreamEntityDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamEntityDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamEntityDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->notationName();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamEntityDeclaration_publicId)
{
	QXmlStreamEntityDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamEntityDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamEntityDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->publicId();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamEntityDeclaration_systemId)
{
	QXmlStreamEntityDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamEntityDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamEntityDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->systemId();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamEntityDeclaration_value)
{
	QXmlStreamEntityDeclaration *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamEntityDeclaration *) RING_API_GETCPOINTER(1,"QXmlStreamEntityDeclaration");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->value();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttributes_append)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->append(RING_API_GETSTRING(2),RING_API_GETSTRING(3),RING_API_GETSTRING(4));
}


RING_FUNC(ring_QXmlStreamAttributes_append_2)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->append(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QXmlStreamAttributes_hasAttribute)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->hasAttribute(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QXmlStreamAttributes_hasAttribute_2)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	RING_API_RETNUMBER(pObject->hasAttribute(* (QLatin1String  *) RING_API_GETCPOINTER(2,"QLatin1String")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLatin1String"));
}


RING_FUNC(ring_QXmlStreamAttributes_hasAttribute_3)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->hasAttribute(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QXmlStreamAttributes_value)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->value(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttributes_value_2)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->value(RING_API_GETSTRING(2),* (QLatin1String  *) RING_API_GETCPOINTER(3,"QLatin1String"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QLatin1String"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttributes_value_3)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->value(* (QLatin1String  *) RING_API_GETCPOINTER(2,"QLatin1String"),* (QLatin1String  *) RING_API_GETCPOINTER(3,"QLatin1String"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLatin1String"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QLatin1String"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttributes_value_4)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->value(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttributes_value_5)
{
	QXmlStreamAttributes *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttributes *) RING_API_GETCPOINTER(1,"QXmlStreamAttributes");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->value(* (QLatin1String  *) RING_API_GETCPOINTER(2,"QLatin1String"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLatin1String"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttribute_isDefault)
{
	QXmlStreamAttribute *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttribute *) RING_API_GETCPOINTER(1,"QXmlStreamAttribute");
	RING_API_RETNUMBER(pObject->isDefault());
}


RING_FUNC(ring_QXmlStreamAttribute_name)
{
	QXmlStreamAttribute *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttribute *) RING_API_GETCPOINTER(1,"QXmlStreamAttribute");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->name();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttribute_namespaceUri)
{
	QXmlStreamAttribute *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttribute *) RING_API_GETCPOINTER(1,"QXmlStreamAttribute");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->namespaceUri();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttribute_prefix)
{
	QXmlStreamAttribute *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttribute *) RING_API_GETCPOINTER(1,"QXmlStreamAttribute");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->prefix();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttribute_qualifiedName)
{
	QXmlStreamAttribute *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttribute *) RING_API_GETCPOINTER(1,"QXmlStreamAttribute");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->qualifiedName();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QXmlStreamAttribute_value)
{
	QXmlStreamAttribute *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QXmlStreamAttribute *) RING_API_GETCPOINTER(1,"QXmlStreamAttribute");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->value();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QThread_eventDispatcher)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETCPOINTER(pObject->eventDispatcher(),"QAbstractEventDispatcher");
}


RING_FUNC(ring_QThread_exit)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->exit( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QThread_isFinished)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETNUMBER(pObject->isFinished());
}


RING_FUNC(ring_QThread_isInterruptionRequested)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETNUMBER(pObject->isInterruptionRequested());
}


RING_FUNC(ring_QThread_isRunning)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETNUMBER(pObject->isRunning());
}


RING_FUNC(ring_QThread_priority)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETNUMBER(pObject->priority());
}


RING_FUNC(ring_QThread_requestInterruption)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	pObject->requestInterruption();
}


RING_FUNC(ring_QThread_setEventDispatcher)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEventDispatcher((QAbstractEventDispatcher *) RING_API_GETCPOINTER(2,"QAbstractEventDispatcher"));
}


RING_FUNC(ring_QThread_setPriority)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPriority( (QThread::Priority )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QThread_setStackSize)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	pObject->setStackSize(* (uint  *) RING_API_GETCPOINTER(2,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QThread_stackSize)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->stackSize();
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QThread_wait)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETNUMBER(pObject->wait(* (unsigned long  *) RING_API_GETCPOINTER(2,"unsigned long")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"unsigned long"));
}


RING_FUNC(ring_QThread_quit)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	pObject->quit();
}


RING_FUNC(ring_QThread_start)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->start( (QThread::Priority )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QThread_terminate)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	pObject->terminate();
}


RING_FUNC(ring_QThread_currentThread)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETCPOINTER(pObject->currentThread(),"QThread");
}


RING_FUNC(ring_QThread_currentThreadId)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	{
		Qt::HANDLE *pValue ; 
		pValue = (Qt::HANDLE *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(Qt::HANDLE)) ;
		*pValue = pObject->currentThreadId();
		RING_API_RETMANAGEDCPOINTER(pValue,"Qt::HANDLE",ring_state_free);
	}
}


RING_FUNC(ring_QThread_idealThreadCount)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETNUMBER(pObject->idealThreadCount());
}


RING_FUNC(ring_QThread_msleep)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	pObject->msleep(* (unsigned long  *) RING_API_GETCPOINTER(2,"unsigned long"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"unsigned long"));
}


RING_FUNC(ring_QThread_sleep)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	pObject->sleep(* (unsigned long  *) RING_API_GETCPOINTER(2,"unsigned long"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"unsigned long"));
}


RING_FUNC(ring_QThread_usleep)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	pObject->usleep(* (unsigned long  *) RING_API_GETCPOINTER(2,"unsigned long"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"unsigned long"));
}


RING_FUNC(ring_QThread_yieldCurrentThread)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	pObject->yieldCurrentThread();
}


RING_FUNC(ring_QThread_setStartedEvent)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStartedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QThread_setFinishedEvent)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFinishedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QThread_getStartedEvent)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETSTRING(pObject->getStartedEvent());
}


RING_FUNC(ring_QThread_getFinishedEvent)
{
	GThread *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GThread *) RING_API_GETCPOINTER(1,"QThread");
	RING_API_RETSTRING(pObject->getFinishedEvent());
}


RING_FUNC(ring_QThreadPool_activeThreadCount)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	RING_API_RETNUMBER(pObject->activeThreadCount());
}


RING_FUNC(ring_QThreadPool_clear)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	pObject->clear();
}


RING_FUNC(ring_QThreadPool_expiryTimeout)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	RING_API_RETNUMBER(pObject->expiryTimeout());
}


RING_FUNC(ring_QThreadPool_maxThreadCount)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	RING_API_RETNUMBER(pObject->maxThreadCount());
}


RING_FUNC(ring_QThreadPool_releaseThread)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	pObject->releaseThread();
}


RING_FUNC(ring_QThreadPool_reserveThread)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	pObject->reserveThread();
}


RING_FUNC(ring_QThreadPool_setExpiryTimeout)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setExpiryTimeout( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QThreadPool_setMaxThreadCount)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaxThreadCount( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QThreadPool_start)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->start((QRunnable *) RING_API_GETCPOINTER(2,"QRunnable"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QThreadPool_tryStart)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->tryStart((QRunnable *) RING_API_GETCPOINTER(2,"QRunnable")));
}


RING_FUNC(ring_QThreadPool_waitForDone)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->waitForDone( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QThreadPool_globalInstance)
{
	QThreadPool *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QThreadPool *) RING_API_GETCPOINTER(1,"QThreadPool");
	RING_API_RETCPOINTER(pObject->globalInstance(),"QThreadPool");
}


RING_FUNC(ring_QRegularExpression_captureCount)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	RING_API_RETNUMBER(pObject->captureCount());
}


RING_FUNC(ring_QRegularExpression_errorString)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	RING_API_RETSTRING(pObject->errorString().toStdString().c_str());
}


RING_FUNC(ring_QRegularExpression_globalMatch)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRegularExpressionMatchIterator *pValue ; 
		pValue = new QRegularExpressionMatchIterator() ;
		*pValue = pObject->globalMatch(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3), (QRegularExpression::MatchType )  (int) RING_API_GETNUMBER(4), (QRegularExpression::MatchOptions )  (int) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegularExpressionMatchIterator",ring_QRegularExpressionMatchIterator_freefunc);
	}
}


RING_FUNC(ring_QRegularExpression_isValid)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QRegularExpression_match)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRegularExpressionMatch *pValue ; 
		pValue = new QRegularExpressionMatch() ;
		*pValue = pObject->match(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3), (QRegularExpression::MatchType )  (int) RING_API_GETNUMBER(4), (QRegularExpression::MatchOptions )  (int) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegularExpressionMatch",ring_QRegularExpressionMatch_freefunc);
	}
}


RING_FUNC(ring_QRegularExpression_namedCaptureGroups)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->namedCaptureGroups();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QRegularExpression_pattern)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	RING_API_RETSTRING(pObject->pattern().toStdString().c_str());
}


RING_FUNC(ring_QRegularExpression_patternErrorOffset)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	RING_API_RETNUMBER(pObject->patternErrorOffset());
}


RING_FUNC(ring_QRegularExpression_patternOptions)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	RING_API_RETNUMBER(pObject->patternOptions());
}


RING_FUNC(ring_QRegularExpression_setPattern)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPattern(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QRegularExpression_setPatternOptions)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPatternOptions( (QRegularExpression::PatternOptions )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QRegularExpression_swap)
{
	QRegularExpression *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpression *) RING_API_GETCPOINTER(1,"QRegularExpression");
	pObject->swap(* (QRegularExpression   *) RING_API_GETCPOINTER(2,"QRegularExpression"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRegularExpression"));
}


RING_FUNC(ring_QRegularExpressionMatch_captured)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->captured( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QRegularExpressionMatch_captured_2)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETSTRING(pObject->captured(* (const QString   *) RING_API_GETCPOINTER(2,"const QString")).toStdString().c_str());
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QString"));
}


RING_FUNC(ring_QRegularExpressionMatch_capturedEnd)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->capturedEnd( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QRegularExpressionMatch_capturedEnd_2)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETNUMBER(pObject->capturedEnd(* (const QString   *) RING_API_GETCPOINTER(2,"const QString")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QString"));
}


RING_FUNC(ring_QRegularExpressionMatch_capturedLength)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->capturedLength( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QRegularExpressionMatch_capturedLength_2)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETNUMBER(pObject->capturedLength(* (const QString   *) RING_API_GETCPOINTER(2,"const QString")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QString"));
}


RING_FUNC(ring_QRegularExpressionMatch_capturedRef)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->capturedRef( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QRegularExpressionMatch_capturedRef_2)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->capturedRef(* (const QString   *) RING_API_GETCPOINTER(2,"const QString"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QString"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QRegularExpressionMatch_capturedStart)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->capturedStart( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QRegularExpressionMatch_capturedStart_2)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETNUMBER(pObject->capturedStart(* (const QString   *) RING_API_GETCPOINTER(2,"const QString")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QString"));
}


RING_FUNC(ring_QRegularExpressionMatch_capturedTexts)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->capturedTexts();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QRegularExpressionMatch_hasMatch)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETNUMBER(pObject->hasMatch());
}


RING_FUNC(ring_QRegularExpressionMatch_hasPartialMatch)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETNUMBER(pObject->hasPartialMatch());
}


RING_FUNC(ring_QRegularExpressionMatch_isValid)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QRegularExpressionMatch_lastCapturedIndex)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETNUMBER(pObject->lastCapturedIndex());
}


RING_FUNC(ring_QRegularExpressionMatch_matchOptions)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETNUMBER(pObject->matchOptions());
}


RING_FUNC(ring_QRegularExpressionMatch_matchType)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	RING_API_RETNUMBER(pObject->matchType());
}


RING_FUNC(ring_QRegularExpressionMatch_regularExpression)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	{
		QRegularExpression *pValue ; 
		pValue = new QRegularExpression() ;
		*pValue = pObject->regularExpression();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegularExpression",ring_QRegularExpression_freefunc);
	}
}


RING_FUNC(ring_QRegularExpressionMatch_swap)
{
	QRegularExpressionMatch *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatch *) RING_API_GETCPOINTER(1,"QRegularExpressionMatch");
	pObject->swap(* (QRegularExpressionMatch   *) RING_API_GETCPOINTER(2,"QRegularExpressionMatch"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRegularExpressionMatch"));
}


RING_FUNC(ring_QRegularExpressionMatchIterator_hasNext)
{
	QRegularExpressionMatchIterator *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatchIterator *) RING_API_GETCPOINTER(1,"QRegularExpressionMatchIterator");
	RING_API_RETNUMBER(pObject->hasNext());
}


RING_FUNC(ring_QRegularExpressionMatchIterator_isValid)
{
	QRegularExpressionMatchIterator *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatchIterator *) RING_API_GETCPOINTER(1,"QRegularExpressionMatchIterator");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QRegularExpressionMatchIterator_matchOptions)
{
	QRegularExpressionMatchIterator *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatchIterator *) RING_API_GETCPOINTER(1,"QRegularExpressionMatchIterator");
	RING_API_RETNUMBER(pObject->matchOptions());
}


RING_FUNC(ring_QRegularExpressionMatchIterator_matchType)
{
	QRegularExpressionMatchIterator *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatchIterator *) RING_API_GETCPOINTER(1,"QRegularExpressionMatchIterator");
	RING_API_RETNUMBER(pObject->matchType());
}


RING_FUNC(ring_QRegularExpressionMatchIterator_next)
{
	QRegularExpressionMatchIterator *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatchIterator *) RING_API_GETCPOINTER(1,"QRegularExpressionMatchIterator");
	{
		QRegularExpressionMatch *pValue ; 
		pValue = new QRegularExpressionMatch() ;
		*pValue = pObject->next();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegularExpressionMatch",ring_QRegularExpressionMatch_freefunc);
	}
}


RING_FUNC(ring_QRegularExpressionMatchIterator_peekNext)
{
	QRegularExpressionMatchIterator *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatchIterator *) RING_API_GETCPOINTER(1,"QRegularExpressionMatchIterator");
	{
		QRegularExpressionMatch *pValue ; 
		pValue = new QRegularExpressionMatch() ;
		*pValue = pObject->peekNext();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegularExpressionMatch",ring_QRegularExpressionMatch_freefunc);
	}
}


RING_FUNC(ring_QRegularExpressionMatchIterator_regularExpression)
{
	QRegularExpressionMatchIterator *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatchIterator *) RING_API_GETCPOINTER(1,"QRegularExpressionMatchIterator");
	{
		QRegularExpression *pValue ; 
		pValue = new QRegularExpression() ;
		*pValue = pObject->regularExpression();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegularExpression",ring_QRegularExpression_freefunc);
	}
}


RING_FUNC(ring_QRegularExpressionMatchIterator_swap)
{
	QRegularExpressionMatchIterator *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QRegularExpressionMatchIterator *) RING_API_GETCPOINTER(1,"QRegularExpressionMatchIterator");
	pObject->swap(* (QRegularExpressionMatchIterator  *) RING_API_GETCPOINTER(2,"QRegularExpressionMatchIterator"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRegularExpressionMatchIterator"));
}


RING_FUNC(ring_QJsonArray_append)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	pObject->append(* (QJsonValue   *) RING_API_GETCPOINTER(2,"QJsonValue"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QJsonValue"));
}


RING_FUNC(ring_QJsonArray_at)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QJsonValue *pValue ; 
		pValue = new QJsonValue() ;
		*pValue = pObject->at( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonValue",ring_QJsonValue_freefunc);
	}
}


RING_FUNC(ring_QJsonArray_contains)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	RING_API_RETNUMBER(pObject->contains(* (QJsonValue   *) RING_API_GETCPOINTER(2,"QJsonValue")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QJsonValue"));
}


RING_FUNC(ring_QJsonArray_count)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	RING_API_RETNUMBER(pObject->count());
}


RING_FUNC(ring_QJsonArray_empty)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	RING_API_RETNUMBER(pObject->empty());
}


RING_FUNC(ring_QJsonArray_first)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	{
		QJsonValue *pValue ; 
		pValue = new QJsonValue() ;
		*pValue = pObject->first();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonValue",ring_QJsonValue_freefunc);
	}
}


RING_FUNC(ring_QJsonArray_insert)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insert( (int ) RING_API_GETNUMBER(2),* (QJsonValue   *) RING_API_GETCPOINTER(3,"QJsonValue"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QJsonValue"));
}


RING_FUNC(ring_QJsonArray_isEmpty)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QJsonArray_last)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	{
		QJsonValue *pValue ; 
		pValue = new QJsonValue() ;
		*pValue = pObject->last();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonValue",ring_QJsonValue_freefunc);
	}
}


RING_FUNC(ring_QJsonArray_pop_back)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	pObject->pop_back();
}


RING_FUNC(ring_QJsonArray_pop_front)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	pObject->pop_front();
}


RING_FUNC(ring_QJsonArray_prepend)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	pObject->prepend(* (QJsonValue   *) RING_API_GETCPOINTER(2,"QJsonValue"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QJsonValue"));
}


RING_FUNC(ring_QJsonArray_push_back)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	pObject->push_back(* (QJsonValue   *) RING_API_GETCPOINTER(2,"QJsonValue"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QJsonValue"));
}


RING_FUNC(ring_QJsonArray_push_front)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	pObject->push_front(* (QJsonValue   *) RING_API_GETCPOINTER(2,"QJsonValue"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QJsonValue"));
}


RING_FUNC(ring_QJsonArray_removeAt)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeAt( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QJsonArray_removeFirst)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	pObject->removeFirst();
}


RING_FUNC(ring_QJsonArray_removeLast)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	pObject->removeLast();
}


RING_FUNC(ring_QJsonArray_replace)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->replace( (int ) RING_API_GETNUMBER(2),* (QJsonValue   *) RING_API_GETCPOINTER(3,"QJsonValue"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QJsonValue"));
}


RING_FUNC(ring_QJsonArray_size)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	RING_API_RETNUMBER(pObject->size());
}


RING_FUNC(ring_QJsonArray_takeAt)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QJsonValue *pValue ; 
		pValue = new QJsonValue() ;
		*pValue = pObject->takeAt( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonValue",ring_QJsonValue_freefunc);
	}
}


RING_FUNC(ring_QJsonArray_toVariantList)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	{
		QVariantList *pValue ; 
		pValue = (QVariantList *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QVariantList)) ;
		*pValue = pObject->toVariantList();
		RING_API_RETMANAGEDCPOINTER(pValue,"QVariantList",ring_state_free);
	}
}


RING_FUNC(ring_QJsonArray_fromStringList)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	{
		QJsonArray *pValue ; 
		pValue = new QJsonArray() ;
		*pValue = pObject->fromStringList(* (QStringList   *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonArray",ring_QJsonArray_freefunc);
	}
}


RING_FUNC(ring_QJsonArray_fromVariantList)
{
	QJsonArray *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonArray *) RING_API_GETCPOINTER(1,"QJsonArray");
	{
		QJsonArray *pValue ; 
		pValue = new QJsonArray() ;
		*pValue = pObject->fromVariantList(* (QVariantList   *) RING_API_GETCPOINTER(2,"QVariantList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QVariantList"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonArray",ring_QJsonArray_freefunc);
	}
}


RING_FUNC(ring_QJsonDocument_array)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	{
		QJsonArray *pValue ; 
		pValue = new QJsonArray() ;
		*pValue = pObject->array();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonArray",ring_QJsonArray_freefunc);
	}
}


RING_FUNC(ring_QJsonDocument_isArray)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	RING_API_RETNUMBER(pObject->isArray());
}


RING_FUNC(ring_QJsonDocument_isEmpty)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QJsonDocument_isNull)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QJsonDocument_isObject)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	RING_API_RETNUMBER(pObject->isObject());
}


RING_FUNC(ring_QJsonDocument_object)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	{
		QJsonObject *pValue ; 
		pValue = new QJsonObject() ;
		*pValue = pObject->object();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonObject",ring_QJsonObject_freefunc);
	}
}


RING_FUNC(ring_QJsonDocument_rawData)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->rawData(RING_API_GETINTPOINTER(2)));
	RING_API_ACCEPTINTVALUE(1) ;
}


RING_FUNC(ring_QJsonDocument_setArray)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	pObject->setArray(* (QJsonArray   *) RING_API_GETCPOINTER(2,"QJsonArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QJsonArray"));
}


RING_FUNC(ring_QJsonDocument_setObject)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	pObject->setObject(* (QJsonObject   *) RING_API_GETCPOINTER(2,"QJsonObject"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QJsonObject"));
}


RING_FUNC(ring_QJsonDocument_toBinaryData)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toBinaryData();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QJsonDocument_toJson)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toJson( (QJsonDocument::JsonFormat )  (int) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QJsonDocument_toVariant)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->toVariant();
		RING_API_RETMANAGEDCPOINTER(pValue,"QVariant",ring_QVariant_freefunc);
	}
}


RING_FUNC(ring_QJsonDocument_fromBinaryData)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QJsonDocument *pValue ; 
		pValue = new QJsonDocument() ;
		*pValue = pObject->fromBinaryData(* (QByteArray   *) RING_API_GETCPOINTER(2,"QByteArray"), (QJsonDocument::DataValidation )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonDocument",ring_QJsonDocument_freefunc);
	}
}


RING_FUNC(ring_QJsonDocument_fromJson)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QJsonDocument *pValue ; 
		pValue = new QJsonDocument() ;
		*pValue = pObject->fromJson(* (QByteArray   *) RING_API_GETCPOINTER(2,"QByteArray"),(QJsonParseError *) RING_API_GETCPOINTER(3,"QJsonParseError"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonDocument",ring_QJsonDocument_freefunc);
	}
}


RING_FUNC(ring_QJsonDocument_fromRawData)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QJsonDocument *pValue ; 
		pValue = new QJsonDocument() ;
		*pValue = pObject->fromRawData(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3), (QJsonDocument::DataValidation )  (int) RING_API_GETNUMBER(4));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonDocument",ring_QJsonDocument_freefunc);
	}
}


RING_FUNC(ring_QJsonDocument_fromVariant)
{
	QJsonDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonDocument *) RING_API_GETCPOINTER(1,"QJsonDocument");
	{
		QJsonDocument *pValue ; 
		pValue = new QJsonDocument() ;
		*pValue = pObject->fromVariant(* (QVariant   *) RING_API_GETCPOINTER(2,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QVariant"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonDocument",ring_QJsonDocument_freefunc);
	}
}


RING_FUNC(ring_QJsonObject_contains)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->contains(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QJsonObject_count)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	RING_API_RETNUMBER(pObject->count());
}


RING_FUNC(ring_QJsonObject_empty)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	RING_API_RETNUMBER(pObject->empty());
}


RING_FUNC(ring_QJsonObject_isEmpty)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QJsonObject_keys)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->keys();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QJsonObject_length)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	RING_API_RETNUMBER(pObject->length());
}


RING_FUNC(ring_QJsonObject_remove)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->remove(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QJsonObject_size)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	RING_API_RETNUMBER(pObject->size());
}


RING_FUNC(ring_QJsonObject_take)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QJsonValue *pValue ; 
		pValue = new QJsonValue() ;
		*pValue = pObject->take(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonValue",ring_QJsonValue_freefunc);
	}
}


RING_FUNC(ring_QJsonObject_toVariantMap)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	{
		QVariantMap *pValue ; 
		pValue = (QVariantMap *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QVariantMap)) ;
		*pValue = pObject->toVariantMap();
		RING_API_RETMANAGEDCPOINTER(pValue,"QVariantMap",ring_state_free);
	}
}


RING_FUNC(ring_QJsonObject_value)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QJsonValue *pValue ; 
		pValue = new QJsonValue() ;
		*pValue = pObject->value(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonValue",ring_QJsonValue_freefunc);
	}
}


RING_FUNC(ring_QJsonObject_fromVariantMap)
{
	QJsonObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonObject *) RING_API_GETCPOINTER(1,"QJsonObject");
	{
		QJsonObject *pValue ; 
		pValue = new QJsonObject() ;
		*pValue = pObject->fromVariantMap(* (QVariantMap   *) RING_API_GETCPOINTER(2,"QVariantMap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QVariantMap"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonObject",ring_QJsonObject_freefunc);
	}
}


RING_FUNC(ring_QJsonParseError_errorString)
{
	QJsonParseError *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonParseError *) RING_API_GETCPOINTER(1,"QJsonParseError");
	RING_API_RETSTRING(pObject->errorString().toStdString().c_str());
}


RING_FUNC(ring_QJsonValue_isArray)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	RING_API_RETNUMBER(pObject->isArray());
}


RING_FUNC(ring_QJsonValue_isBool)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	RING_API_RETNUMBER(pObject->isBool());
}


RING_FUNC(ring_QJsonValue_isDouble)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	RING_API_RETNUMBER(pObject->isDouble());
}


RING_FUNC(ring_QJsonValue_isNull)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QJsonValue_isObject)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	RING_API_RETNUMBER(pObject->isObject());
}


RING_FUNC(ring_QJsonValue_isString)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	RING_API_RETNUMBER(pObject->isString());
}


RING_FUNC(ring_QJsonValue_isUndefined)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	RING_API_RETNUMBER(pObject->isUndefined());
}


RING_FUNC(ring_QJsonValue_toArray)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	{
		QJsonArray *pValue ; 
		pValue = new QJsonArray() ;
		*pValue = pObject->toArray(* (QJsonArray   *) RING_API_GETCPOINTER(2,"QJsonArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QJsonArray"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonArray",ring_QJsonArray_freefunc);
	}
}


RING_FUNC(ring_QJsonValue_toArray_2)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	{
		QJsonArray *pValue ; 
		pValue = new QJsonArray() ;
		*pValue = pObject->toArray();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonArray",ring_QJsonArray_freefunc);
	}
}


RING_FUNC(ring_QJsonValue_toBool)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toBool( (bool ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QJsonValue_toDouble)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toDouble( (double ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QJsonValue_toInt)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toInt( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QJsonValue_toObject)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	{
		QJsonObject *pValue ; 
		pValue = new QJsonObject() ;
		*pValue = pObject->toObject(* (QJsonObject   *) RING_API_GETCPOINTER(2,"QJsonObject"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QJsonObject"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonObject",ring_QJsonObject_freefunc);
	}
}


RING_FUNC(ring_QJsonValue_toObject_2)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	{
		QJsonObject *pValue ; 
		pValue = new QJsonObject() ;
		*pValue = pObject->toObject();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonObject",ring_QJsonObject_freefunc);
	}
}


RING_FUNC(ring_QJsonValue_toString)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->toString(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QJsonValue_toVariant)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->toVariant();
		RING_API_RETMANAGEDCPOINTER(pValue,"QVariant",ring_QVariant_freefunc);
	}
}


RING_FUNC(ring_QJsonValue_type)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	{
		QJsonValue::Type *pValue ; 
		pValue = (QJsonValue::Type *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QJsonValue::Type)) ;
		*pValue = pObject->type();
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonValue::Type",ring_state_free);
	}
}


RING_FUNC(ring_QJsonValue_fromVariant)
{
	QJsonValue *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QJsonValue *) RING_API_GETCPOINTER(1,"QJsonValue");
	{
		QJsonValue *pValue ; 
		pValue = new QJsonValue() ;
		*pValue = pObject->fromVariant(* (QVariant   *) RING_API_GETCPOINTER(2,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QVariant"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QJsonValue",ring_QJsonValue_freefunc);
	}
}


RING_FUNC(ring_QPointF_isNull)
{
	QPointF *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPointF *) RING_API_GETCPOINTER(1,"QPointF");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QPointF_manhattanLength)
{
	QPointF *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPointF *) RING_API_GETCPOINTER(1,"QPointF");
	RING_API_RETNUMBER(pObject->manhattanLength());
}


RING_FUNC(ring_QPointF_rx)
{
	QPointF *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPointF *) RING_API_GETCPOINTER(1,"QPointF");
	RING_API_RETNUMBER(pObject->rx());
}


RING_FUNC(ring_QPointF_ry)
{
	QPointF *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPointF *) RING_API_GETCPOINTER(1,"QPointF");
	RING_API_RETNUMBER(pObject->ry());
}


RING_FUNC(ring_QPointF_setX)
{
	QPointF *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPointF *) RING_API_GETCPOINTER(1,"QPointF");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setX( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPointF_setY)
{
	QPointF *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPointF *) RING_API_GETCPOINTER(1,"QPointF");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setY( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPointF_toPoint)
{
	QPointF *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPointF *) RING_API_GETCPOINTER(1,"QPointF");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->toPoint();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QPointF_x)
{
	QPointF *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPointF *) RING_API_GETCPOINTER(1,"QPointF");
	RING_API_RETNUMBER(pObject->x());
}


RING_FUNC(ring_QPointF_y)
{
	QPointF *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPointF *) RING_API_GETCPOINTER(1,"QPointF");
	RING_API_RETNUMBER(pObject->y());
}


RING_FUNC(ring_QPoint_isNull)
{
	QPoint *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPoint *) RING_API_GETCPOINTER(1,"QPoint");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QPoint_manhattanLength)
{
	QPoint *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPoint *) RING_API_GETCPOINTER(1,"QPoint");
	RING_API_RETNUMBER(pObject->manhattanLength());
}


RING_FUNC(ring_QPoint_rx)
{
	QPoint *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPoint *) RING_API_GETCPOINTER(1,"QPoint");
	RING_API_RETNUMBER(pObject->rx());
}


RING_FUNC(ring_QPoint_ry)
{
	QPoint *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPoint *) RING_API_GETCPOINTER(1,"QPoint");
	RING_API_RETNUMBER(pObject->ry());
}


RING_FUNC(ring_QPoint_setX)
{
	QPoint *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPoint *) RING_API_GETCPOINTER(1,"QPoint");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setX( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPoint_setY)
{
	QPoint *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPoint *) RING_API_GETCPOINTER(1,"QPoint");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setY( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPoint_x)
{
	QPoint *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPoint *) RING_API_GETCPOINTER(1,"QPoint");
	RING_API_RETNUMBER(pObject->x());
}


RING_FUNC(ring_QPoint_y)
{
	QPoint *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPoint *) RING_API_GETCPOINTER(1,"QPoint");
	RING_API_RETNUMBER(pObject->y());
}


RING_FUNC(ring_QString2_append)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->append(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QString2_toUtf8)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toUtf8();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QString2_toLatin1)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toLatin1();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QString2_toLocal8Bit)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toLocal8Bit();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QString2_split)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->split(RING_API_GETSTRING(2), (QString::SplitBehavior )  (int) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QString2_split_2)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->split(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"), (QString::SplitBehavior )  (int) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QString2_split_3)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->split(* (QRegExp   *) RING_API_GETCPOINTER(2,"QRegExp"), (QString::SplitBehavior )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRegExp"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QString2_split_4)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->split(* (QRegularExpression   *) RING_API_GETCPOINTER(2,"QRegularExpression"), (QString::SplitBehavior )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRegularExpression"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QString2_unicode)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	RING_API_RETCPOINTER(pObject->unicode(),"QChar");
}


RING_FUNC(ring_QString2_number)
{
	QString *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QString *) RING_API_GETCPOINTER(1,"QString2");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->number( (ulong ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)).toStdString().c_str());
}


RING_FUNC(ring_QProcess_arguments)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->arguments();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QProcess_closeReadChannel)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->closeReadChannel( (QProcess::ProcessChannel )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProcess_closeWriteChannel)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	pObject->closeWriteChannel();
}


RING_FUNC(ring_QProcess_error)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETNUMBER(pObject->error());
}


RING_FUNC(ring_QProcess_exitCode)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETNUMBER(pObject->exitCode());
}


RING_FUNC(ring_QProcess_exitStatus)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETNUMBER(pObject->exitStatus());
}


RING_FUNC(ring_QProcess_inputChannelMode)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETNUMBER(pObject->inputChannelMode());
}


RING_FUNC(ring_QProcess_processChannelMode)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETNUMBER(pObject->processChannelMode());
}


RING_FUNC(ring_QProcess_processEnvironment)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	{
		QProcessEnvironment *pValue ; 
		pValue = (QProcessEnvironment *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QProcessEnvironment)) ;
		*pValue = pObject->processEnvironment();
		RING_API_RETMANAGEDCPOINTER(pValue,"QProcessEnvironment",ring_state_free);
	}
}


RING_FUNC(ring_QProcess_program)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETSTRING(pObject->program().toStdString().c_str());
}


RING_FUNC(ring_QProcess_readAllStandardError)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->readAllStandardError();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QProcess_readAllStandardOutput)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->readAllStandardOutput();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QProcess_readChannel)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETNUMBER(pObject->readChannel());
}


RING_FUNC(ring_QProcess_setArguments)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	pObject->setArguments(* (QStringList   *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QProcess_setInputChannelMode)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setInputChannelMode( (QProcess::InputChannelMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProcess_setProcessChannelMode)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setProcessChannelMode( (QProcess::ProcessChannelMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProcess_setProcessEnvironment)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	pObject->setProcessEnvironment(* (QProcessEnvironment   *) RING_API_GETCPOINTER(2,"QProcessEnvironment"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QProcessEnvironment"));
}


RING_FUNC(ring_QProcess_setProgram)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setProgram(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QProcess_setReadChannel)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setReadChannel( (QProcess::ProcessChannel )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProcess_setStandardErrorFile)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStandardErrorFile(RING_API_GETSTRING(2), (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QProcess_setStandardInputFile)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStandardInputFile(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QProcess_setStandardOutputFile)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStandardOutputFile(RING_API_GETSTRING(2), (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QProcess_setStandardOutputProcess)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStandardOutputProcess((QProcess *) RING_API_GETCPOINTER(2,"QProcess"));
}


RING_FUNC(ring_QProcess_setWorkingDirectory)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWorkingDirectory(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QProcess_start)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->start(RING_API_GETSTRING(2),* (QStringList   *) RING_API_GETCPOINTER(3,"QStringList"), (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QStringList"));
}


RING_FUNC(ring_QProcess_start_2)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->start(RING_API_GETSTRING(2), (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QProcess_start_3)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->start( (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProcess_state)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETNUMBER(pObject->state());
}


RING_FUNC(ring_QProcess_waitForFinished)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->waitForFinished( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QProcess_waitForStarted)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->waitForStarted( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QProcess_workingDirectory)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETSTRING(pObject->workingDirectory().toStdString().c_str());
}


RING_FUNC(ring_QProcess_kill)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	pObject->kill();
}


RING_FUNC(ring_QProcess_terminate)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	pObject->terminate();
}


RING_FUNC(ring_QProcess_setreadyReadStandardErrorEvent)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setreadyReadStandardErrorEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QProcess_setreadyReadStandardOutputEvent)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setreadyReadStandardOutputEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QProcess_getreadyReadStandardErrorEvent)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETSTRING(pObject->getreadyReadStandardErrorEvent());
}


RING_FUNC(ring_QProcess_getreadyReadStandardOutputEvent)
{
	GProcess *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProcess *) RING_API_GETCPOINTER(1,"QProcess");
	RING_API_RETSTRING(pObject->getreadyReadStandardOutputEvent());
}


RING_FUNC(ring_QUuid_toString)
{
	QUuid *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUuid *) RING_API_GETCPOINTER(1,"QUuid");
	RING_API_RETSTRING(pObject->toString().toStdString().c_str());
}


RING_FUNC(ring_QStringRef_appendTo)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringRef *pValue ; 
		pValue = new QStringRef() ;
		*pValue = pObject->appendTo((QString *) RING_API_GETCPOINTER(2,"QString"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringRef",ring_QStringRef_freefunc);
	}
}


RING_FUNC(ring_QStringRef_at)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->at( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QStringRef_clear)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	pObject->clear();
}


RING_FUNC(ring_QStringRef_compare_2)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->compare(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_compare_3)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->compare(* (QLatin1String  *) RING_API_GETCPOINTER(2,"QLatin1String"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLatin1String"));
}


RING_FUNC(ring_QStringRef_constData)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETCPOINTER(pObject->constData(),"QChar");
}


RING_FUNC(ring_QStringRef_contains)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->contains(RING_API_GETSTRING(2), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QStringRef_contains_2)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->contains(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QStringRef_contains_3)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->contains(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_contains_4)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->contains(* (QLatin1String  *) RING_API_GETCPOINTER(2,"QLatin1String"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLatin1String"));
}


RING_FUNC(ring_QStringRef_count)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETNUMBER(pObject->count());
}


RING_FUNC(ring_QStringRef_count_2)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->count(RING_API_GETSTRING(2), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QStringRef_count_3)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->count(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QStringRef_count_4)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->count(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_data)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETCPOINTER(pObject->data(),"QChar");
}


RING_FUNC(ring_QStringRef_endsWith)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->endsWith(RING_API_GETSTRING(2), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QStringRef_endsWith_2)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->endsWith(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QStringRef_endsWith_3)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->endsWith(* (QLatin1String  *) RING_API_GETCPOINTER(2,"QLatin1String"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLatin1String"));
}


RING_FUNC(ring_QStringRef_endsWith_4)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->endsWith(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_indexOf)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->indexOf(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QStringRef_indexOf_2)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->indexOf(* (QLatin1String  *) RING_API_GETCPOINTER(2,"QLatin1String"), (int ) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLatin1String"));
}


RING_FUNC(ring_QStringRef_indexOf_3)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->indexOf(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"), (int ) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QStringRef_indexOf_4)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->indexOf(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"), (int ) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_isEmpty)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QStringRef_isNull)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QStringRef_lastIndexOf)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->lastIndexOf(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QStringRef_lastIndexOf_2)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->lastIndexOf(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"), (int ) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QStringRef_lastIndexOf_3)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->lastIndexOf(* (QLatin1String  *) RING_API_GETCPOINTER(2,"QLatin1String"), (int ) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLatin1String"));
}


RING_FUNC(ring_QStringRef_lastIndexOf_4)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->lastIndexOf(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"), (int ) RING_API_GETNUMBER(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_length)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETNUMBER(pObject->length());
}


RING_FUNC(ring_QStringRef_localeAwareCompare)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->localeAwareCompare(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QStringRef_localeAwareCompare_2)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETNUMBER(pObject->localeAwareCompare(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_position)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETNUMBER(pObject->position());
}


RING_FUNC(ring_QStringRef_size)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETNUMBER(pObject->size());
}


RING_FUNC(ring_QStringRef_startsWith)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->startsWith(RING_API_GETSTRING(2), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QStringRef_startsWith_2)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->startsWith(* (QLatin1String  *) RING_API_GETCPOINTER(2,"QLatin1String"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLatin1String"));
}


RING_FUNC(ring_QStringRef_startsWith_3)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->startsWith(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_startsWith_4)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->startsWith(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QStringRef_string)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETCPOINTER(pObject->string(),"QString");
}


RING_FUNC(ring_QStringRef_toLatin1)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toLatin1();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QStringRef_toLocal8Bit)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toLocal8Bit();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QStringRef_toString)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETSTRING(pObject->toString().toStdString().c_str());
}


RING_FUNC(ring_QStringRef_toUcs4)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	{
		QVector<uint> *pValue ; 
		pValue = (QVector<uint> *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QVector<uint>)) ;
		*pValue = pObject->toUcs4();
		RING_API_RETMANAGEDCPOINTER(pValue,"QVector<uint>",ring_state_free);
	}
}


RING_FUNC(ring_QStringRef_toUtf8)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->toUtf8();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QStringRef_unicode)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETCPOINTER(pObject->unicode(),"QChar");
}


RING_FUNC(ring_QStringRef_compare_4)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->compare(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"),RING_API_GETSTRING(3), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_compare_5)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->compare(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"),* (QStringRef  *) RING_API_GETCPOINTER(3,"QStringRef"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QStringRef"));
}


RING_FUNC(ring_QStringRef_compare_6)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->compare(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"),* (QLatin1String  *) RING_API_GETCPOINTER(3,"QLatin1String"), (Qt::CaseSensitivity )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QLatin1String"));
}


RING_FUNC(ring_QStringRef_localeAwareCompare_3)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->localeAwareCompare(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"),RING_API_GETSTRING(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
}


RING_FUNC(ring_QStringRef_localeAwareCompare_4)
{
	QStringRef *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStringRef *) RING_API_GETCPOINTER(1,"QStringRef");
	RING_API_RETNUMBER(pObject->localeAwareCompare(* (QStringRef  *) RING_API_GETCPOINTER(2,"QStringRef"),* (QStringRef  *) RING_API_GETCPOINTER(3,"QStringRef")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringRef"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QStringRef"));
}


RING_FUNC(ring_QMutex_isRecursive)
{
	QMutex *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMutex *) RING_API_GETCPOINTER(1,"QMutex");
	RING_API_RETNUMBER(pObject->isRecursive());
}


RING_FUNC(ring_QMutex_lock)
{
	QMutex *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMutex *) RING_API_GETCPOINTER(1,"QMutex");
	pObject->lock();
}


RING_FUNC(ring_QMutex_unlock)
{
	QMutex *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMutex *) RING_API_GETCPOINTER(1,"QMutex");
	pObject->unlock();
}


RING_FUNC(ring_QMutexLocker_mutex)
{
	QMutexLocker *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMutexLocker *) RING_API_GETCPOINTER(1,"QMutexLocker");
	RING_API_RETCPOINTER(pObject->mutex(),"QMutex");
}


RING_FUNC(ring_QMutexLocker_relock)
{
	QMutexLocker *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMutexLocker *) RING_API_GETCPOINTER(1,"QMutexLocker");
	pObject->relock();
}


RING_FUNC(ring_QMutexLocker_unlock)
{
	QMutexLocker *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMutexLocker *) RING_API_GETCPOINTER(1,"QMutexLocker");
	pObject->unlock();
}


RING_FUNC(ring_QBuffer_buffer)
{
	QBuffer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBuffer *) RING_API_GETCPOINTER(1,"QBuffer");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->buffer();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QBuffer_data)
{
	QBuffer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBuffer *) RING_API_GETCPOINTER(1,"QBuffer");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->data();
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QBuffer_setBuffer)
{
	QBuffer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBuffer *) RING_API_GETCPOINTER(1,"QBuffer");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBuffer((QByteArray *) RING_API_GETCPOINTER(2,"QByteArray"));
}


RING_FUNC(ring_QBuffer_setData)
{
	QBuffer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBuffer *) RING_API_GETCPOINTER(1,"QBuffer");
	pObject->setData(* (QByteArray  *) RING_API_GETCPOINTER(2,"QByteArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QBuffer_setData_2)
{
	QBuffer *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBuffer *) RING_API_GETCPOINTER(1,"QBuffer");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setData(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QDateTime_addDays)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->addDays( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_addMSecs)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->addMSecs( (qint64 ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_addMonths)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->addMonths( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_addSecs)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->addSecs( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_addYears)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->addYears( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_date)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->date();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDate",ring_QDate_freefunc);
	}
}


RING_FUNC(ring_QDateTime_daysTo)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	RING_API_RETNUMBER(pObject->daysTo(* (QDateTime  *) RING_API_GETCPOINTER(2,"QDateTime")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDateTime"));
}


RING_FUNC(ring_QDateTime_isNull)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QDateTime_isValid)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QDateTime_msecsTo)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	RING_API_RETNUMBER(pObject->msecsTo(* (QDateTime  *) RING_API_GETCPOINTER(2,"QDateTime")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDateTime"));
}


RING_FUNC(ring_QDateTime_secsTo)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	RING_API_RETNUMBER(pObject->secsTo(* (QDateTime  *) RING_API_GETCPOINTER(2,"QDateTime")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDateTime"));
}


RING_FUNC(ring_QDateTime_setDate)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	pObject->setDate(* (QDate  *) RING_API_GETCPOINTER(2,"QDate"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDate"));
}


RING_FUNC(ring_QDateTime_setMSecsSinceEpoch)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMSecsSinceEpoch( (qint64 ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDateTime_setTime)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	pObject->setTime(* (QTime  *) RING_API_GETCPOINTER(2,"QTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTime"));
}


RING_FUNC(ring_QDateTime_setTimeSpec)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTimeSpec( (Qt::TimeSpec )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDateTime_setTime_t)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	pObject->setTime_t(* (uint  *) RING_API_GETCPOINTER(2,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QDateTime_time)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->time();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTime",ring_QTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_timeSpec)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	RING_API_RETNUMBER(pObject->timeSpec());
}


RING_FUNC(ring_QDateTime_toLocalTime)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->toLocalTime();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_toMSecsSinceEpoch)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	RING_API_RETNUMBER(pObject->toMSecsSinceEpoch());
}


RING_FUNC(ring_QDateTime_toString)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->toString(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QDateTime_toString_2)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->toString( (Qt::DateFormat )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QDateTime_toTimeSpec)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->toTimeSpec( (Qt::TimeSpec )  (int) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_toTime_t)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->toTime_t();
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QDateTime_toUTC)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->toUTC();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_currentDateTime)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->currentDateTime();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_currentDateTimeUtc)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->currentDateTimeUtc();
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_currentMSecsSinceEpoch)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	RING_API_RETNUMBER(pObject->currentMSecsSinceEpoch());
}


RING_FUNC(ring_QDateTime_fromMSecsSinceEpoch)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->fromMSecsSinceEpoch( (qint64 ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_fromString)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->fromString(RING_API_GETSTRING(2), (Qt::DateFormat )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_fromString_2)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->fromString(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QDateTime_fromTime_t)
{
	QDateTime *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTime *) RING_API_GETCPOINTER(1,"QDateTime");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->fromTime_t(* (uint  *) RING_API_GETCPOINTER(2,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QDateTime",ring_QDateTime_freefunc);
	}
}


RING_FUNC(ring_QCoreApplication_installNativeEventFilter)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->installNativeEventFilter((QAbstractNativeEventFilter *) RING_API_GETCPOINTER(2,"QAbstractNativeEventFilter"));
}


RING_FUNC(ring_QCoreApplication_removeNativeEventFilter)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeNativeEventFilter((QAbstractNativeEventFilter *) RING_API_GETCPOINTER(2,"QAbstractNativeEventFilter"));
}


RING_FUNC(ring_QCoreApplication_quit)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	pObject->quit();
}


RING_FUNC(ring_QCoreApplication_addLibraryPath)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addLibraryPath(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCoreApplication_applicationDirPath)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETSTRING(pObject->applicationDirPath().toStdString().c_str());
}


RING_FUNC(ring_QCoreApplication_applicationFilePath)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETSTRING(pObject->applicationFilePath().toStdString().c_str());
}


RING_FUNC(ring_QCoreApplication_applicationName)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETSTRING(pObject->applicationName().toStdString().c_str());
}


RING_FUNC(ring_QCoreApplication_applicationPid)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETNUMBER(pObject->applicationPid());
}


RING_FUNC(ring_QCoreApplication_applicationVersion)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETSTRING(pObject->applicationVersion().toStdString().c_str());
}


RING_FUNC(ring_QCoreApplication_arguments)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->arguments();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QCoreApplication_closingDown)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETNUMBER(pObject->closingDown());
}


RING_FUNC(ring_QCoreApplication_eventDispatcher)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETCPOINTER(pObject->eventDispatcher(),"QAbstractEventDispatcher");
}


RING_FUNC(ring_QCoreApplication_exec)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETNUMBER(pObject->exec());
}


RING_FUNC(ring_QCoreApplication_exit)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->exit( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QCoreApplication_installTranslator)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->installTranslator((QTranslator *) RING_API_GETCPOINTER(2,"QTranslator")));
}


RING_FUNC(ring_QCoreApplication_instance)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETCPOINTER(pObject->instance(),"QCoreApplication");
}


RING_FUNC(ring_QCoreApplication_isQuitLockEnabled)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETNUMBER(pObject->isQuitLockEnabled());
}


RING_FUNC(ring_QCoreApplication_libraryPaths)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->libraryPaths();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QCoreApplication_organizationDomain)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETSTRING(pObject->organizationDomain().toStdString().c_str());
}


RING_FUNC(ring_QCoreApplication_organizationName)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETSTRING(pObject->organizationName().toStdString().c_str());
}


RING_FUNC(ring_QCoreApplication_postEvent)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->postEvent((QObject *) RING_API_GETCPOINTER(2,"QObject"),(QEvent *) RING_API_GETCPOINTER(3,"QEvent"), (int ) RING_API_GETNUMBER(4));
}


RING_FUNC(ring_QCoreApplication_processEvents)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->processEvents( (QEventLoop::ProcessEventsFlags )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QCoreApplication_processEvents_2)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->processEvents( (QEventLoop::ProcessEventsFlags )  (int) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QCoreApplication_removeLibraryPath)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeLibraryPath(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCoreApplication_removePostedEvents)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removePostedEvents((QObject *) RING_API_GETCPOINTER(2,"QObject"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QCoreApplication_removeTranslator)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->removeTranslator((QTranslator *) RING_API_GETCPOINTER(2,"QTranslator")));
}


RING_FUNC(ring_QCoreApplication_sendEvent)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->sendEvent((QObject *) RING_API_GETCPOINTER(2,"QObject"),(QEvent *) RING_API_GETCPOINTER(3,"QEvent")));
}


RING_FUNC(ring_QCoreApplication_sendPostedEvents)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sendPostedEvents((QObject *) RING_API_GETCPOINTER(2,"QObject"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QCoreApplication_setApplicationName)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setApplicationName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCoreApplication_setApplicationVersion)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setApplicationVersion(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCoreApplication_setAttribute)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAttribute( (Qt::ApplicationAttribute )  (int) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QCoreApplication_setEventDispatcher)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEventDispatcher((QAbstractEventDispatcher *) RING_API_GETCPOINTER(2,"QAbstractEventDispatcher"));
}


RING_FUNC(ring_QCoreApplication_setLibraryPaths)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	pObject->setLibraryPaths(* (QStringList  *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QCoreApplication_setOrganizationDomain)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOrganizationDomain(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCoreApplication_setOrganizationName)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOrganizationName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCoreApplication_setQuitLockEnabled)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setQuitLockEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QCoreApplication_startingUp)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	RING_API_RETNUMBER(pObject->startingUp());
}


RING_FUNC(ring_QCoreApplication_testAttribute)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->testAttribute( (Qt::ApplicationAttribute )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QCoreApplication_translate)
{
	QCoreApplication *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCoreApplication *) RING_API_GETCPOINTER(1,"QCoreApplication");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->translate(RING_API_GETSTRING(2),RING_API_GETSTRING(3),RING_API_GETSTRING(4), (int ) RING_API_GETNUMBER(5)).toStdString().c_str());
}


RING_FUNC(ring_QFile_copy)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->copy(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QFile_exists)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	RING_API_RETNUMBER(pObject->exists());
}


RING_FUNC(ring_QFile_link)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->link(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QFile_open)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->open((FILE *) RING_API_GETCPOINTER(2,"FILE"), (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(3), (QFile::FileHandleFlags )  (int) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QFile_open_2)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->open( (int ) RING_API_GETNUMBER(2), (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(3), (QFile::FileHandleFlags )  (int) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QFile_open_3)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->open( (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QFile_remove)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	RING_API_RETNUMBER(pObject->remove());
}


RING_FUNC(ring_QFile_rename)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->rename(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QFile_setFileName)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFileName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFile_symLinkTarget)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	RING_API_RETSTRING(pObject->symLinkTarget().toStdString().c_str());
}


RING_FUNC(ring_QFile_copy_2)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->copy(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QFile_decodeName)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	RING_API_RETSTRING(pObject->decodeName(* (QByteArray  *) RING_API_GETCPOINTER(2,"QByteArray")).toStdString().c_str());
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QFile_decodeName_2)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->decodeName(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QFile_encodeName)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->encodeName(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QFile_exists_2)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->exists(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QFile_link_2)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->link(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QFile_permissions)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->permissions(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QFile_remove_2)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->remove(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QFile_rename_2)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->rename(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QFile_resize)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->resize(RING_API_GETSTRING(2), (qint64 ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QFile_setPermissions)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setPermissions(RING_API_GETSTRING(2), (QFile::Permissions )  (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QFile_symLinkTarget_2)
{
	QFile *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFile *) RING_API_GETCPOINTER(1,"QFile");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->symLinkTarget(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QFileDevice_error)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	RING_API_RETNUMBER(pObject->error());
}


RING_FUNC(ring_QFileDevice_flush)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	RING_API_RETNUMBER(pObject->flush());
}


RING_FUNC(ring_QFileDevice_handle)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	RING_API_RETNUMBER(pObject->handle());
}


RING_FUNC(ring_QFileDevice_map)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->map( (qint64 ) RING_API_GETNUMBER(2), (qint64 ) RING_API_GETNUMBER(3), (QFileDevice::MemoryMapFlags )  (int) RING_API_GETNUMBER(4)),"uchar");
}


RING_FUNC(ring_QFileDevice_permissions)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	RING_API_RETNUMBER(pObject->permissions());
}


RING_FUNC(ring_QFileDevice_resize)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->resize( (qint64 ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QFileDevice_fileName)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	RING_API_RETSTRING(pObject->fileName().toStdString().c_str());
}


RING_FUNC(ring_QFileDevice_setPermissions)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setPermissions( (QFileDevice::Permissions )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QFileDevice_unmap)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->unmap((uchar *) RING_API_GETCPOINTER(2,"uchar")));
}


RING_FUNC(ring_QFileDevice_unsetError)
{
	QFileDevice *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDevice *) RING_API_GETCPOINTER(1,"QFileDevice");
	pObject->unsetError();
}


RING_FUNC(ring_QStandardPaths_displayName)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISNUMBER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(QStandardPaths::displayName( (QStandardPaths::StandardLocation )  (int) RING_API_GETNUMBER(1)).toStdString().c_str());
}


RING_FUNC(ring_QStandardPaths_findExecutable)
{
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISSTRING(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(QStandardPaths::findExecutable(RING_API_GETSTRING(1),* (QStringList  *) RING_API_GETCPOINTER(2,"QStringList")).toStdString().c_str());
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QStringList"));
}


RING_FUNC(ring_QStandardPaths_locate)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISNUMBER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(QStandardPaths::locate( (QStandardPaths::StandardLocation )  (int) RING_API_GETNUMBER(1),RING_API_GETSTRING(2), (QStandardPaths::LocateOptions )  (int) RING_API_GETNUMBER(3)).toStdString().c_str());
}


RING_FUNC(ring_QStandardPaths_locateAll)
{
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISNUMBER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = QStandardPaths::locateAll( (QStandardPaths::StandardLocation )  (int) RING_API_GETNUMBER(1),RING_API_GETSTRING(2), (QStandardPaths::LocateOptions )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QStandardPaths_setTestModeEnabled)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISNUMBER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	QStandardPaths::setTestModeEnabled( (bool ) RING_API_GETNUMBER(1));
}


RING_FUNC(ring_QStandardPaths_standardLocations)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISNUMBER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = QStandardPaths::standardLocations( (QStandardPaths::StandardLocation )  (int) RING_API_GETNUMBER(1));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QStandardPaths_writableLocation)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISNUMBER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(QStandardPaths::writableLocation( (QStandardPaths::StandardLocation )  (int) RING_API_GETNUMBER(1)).toStdString().c_str());
}


RING_FUNC(ring_QMimeData_clear)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	pObject->clear();
}


RING_FUNC(ring_QMimeData_colorData)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->colorData();
		RING_API_RETMANAGEDCPOINTER(pValue,"QVariant",ring_QVariant_freefunc);
	}
}


RING_FUNC(ring_QMimeData_data)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->data(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QByteArray",ring_QByteArray_freefunc);
	}
}


RING_FUNC(ring_QMimeData_formats)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->formats();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QMimeData_hasColor)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	RING_API_RETNUMBER(pObject->hasColor());
}


RING_FUNC(ring_QMimeData_hasFormat)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->hasFormat(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QMimeData_hasHtml)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	RING_API_RETNUMBER(pObject->hasHtml());
}


RING_FUNC(ring_QMimeData_hasImage)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	RING_API_RETNUMBER(pObject->hasImage());
}


RING_FUNC(ring_QMimeData_hasText)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	RING_API_RETNUMBER(pObject->hasText());
}


RING_FUNC(ring_QMimeData_hasUrls)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	RING_API_RETNUMBER(pObject->hasUrls());
}


RING_FUNC(ring_QMimeData_html)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	RING_API_RETSTRING(pObject->html().toStdString().c_str());
}


RING_FUNC(ring_QMimeData_imageData)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->imageData();
		RING_API_RETMANAGEDCPOINTER(pValue,"QVariant",ring_QVariant_freefunc);
	}
}


RING_FUNC(ring_QMimeData_removeFormat)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeFormat(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QMimeData_setColorData)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	pObject->setColorData(* (QVariant  *) RING_API_GETCPOINTER(2,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QVariant"));
}


RING_FUNC(ring_QMimeData_setData)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setData(RING_API_GETSTRING(2),* (QByteArray  *) RING_API_GETCPOINTER(3,"QByteArray"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QByteArray"));
}


RING_FUNC(ring_QMimeData_setHtml)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHtml(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QMimeData_setImageData)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	pObject->setImageData(* (QVariant  *) RING_API_GETCPOINTER(2,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QVariant"));
}


RING_FUNC(ring_QMimeData_setText)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QMimeData_setUrls)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	pObject->setUrls(* (QList<QUrl>  *) RING_API_GETCPOINTER(2,"QList<QUrl>"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QList<QUrl>"));
}


RING_FUNC(ring_QMimeData_text)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QMimeData_urls)
{
	QMimeData *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMimeData *) RING_API_GETCPOINTER(1,"QMimeData");
	{
		QList<QUrl> *pValue ; 
		pValue = (QList<QUrl> *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QList<QUrl>)) ;
		*pValue = pObject->urls();
		RING_API_RETMANAGEDCPOINTER(pValue,"QList<QUrl>",ring_state_free);
	}
}


RING_FUNC(ring_QChar_category)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->category());
}


RING_FUNC(ring_QChar_cell)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		uchar *pValue ; 
		pValue = (uchar *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uchar)) ;
		*pValue = pObject->cell();
		RING_API_RETMANAGEDCPOINTER(pValue,"uchar",ring_state_free);
	}
}


RING_FUNC(ring_QChar_combiningClass)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->combiningClass());
}


RING_FUNC(ring_QChar_decomposition)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETSTRING(pObject->decomposition().toStdString().c_str());
}


RING_FUNC(ring_QChar_decompositionTag)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->decompositionTag());
}


RING_FUNC(ring_QChar_digitValue)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->digitValue());
}


RING_FUNC(ring_QChar_direction)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->direction());
}


RING_FUNC(ring_QChar_hasMirrored)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->hasMirrored());
}


RING_FUNC(ring_QChar_isDigit)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isDigit());
}


RING_FUNC(ring_QChar_isHighSurrogate)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isHighSurrogate());
}


RING_FUNC(ring_QChar_isLetter)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isLetter());
}


RING_FUNC(ring_QChar_isLetterOrNumber)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isLetterOrNumber());
}


RING_FUNC(ring_QChar_isLowSurrogate)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isLowSurrogate());
}


RING_FUNC(ring_QChar_isLower)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isLower());
}


RING_FUNC(ring_QChar_isMark)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isMark());
}


RING_FUNC(ring_QChar_isNonCharacter)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isNonCharacter());
}


RING_FUNC(ring_QChar_isNull)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QChar_isNumber)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isNumber());
}


RING_FUNC(ring_QChar_isPrint)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isPrint());
}


RING_FUNC(ring_QChar_isPunct)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isPunct());
}


RING_FUNC(ring_QChar_isSpace)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isSpace());
}


RING_FUNC(ring_QChar_isSurrogate)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isSurrogate());
}


RING_FUNC(ring_QChar_isSymbol)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isSymbol());
}


RING_FUNC(ring_QChar_isTitleCase)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isTitleCase());
}


RING_FUNC(ring_QChar_isUpper)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isUpper());
}


RING_FUNC(ring_QChar_mirroredChar)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->mirroredChar();
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QChar_row)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		uchar *pValue ; 
		pValue = (uchar *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uchar)) ;
		*pValue = pObject->row();
		RING_API_RETMANAGEDCPOINTER(pValue,"uchar",ring_state_free);
	}
}


RING_FUNC(ring_QChar_script)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->script());
}


RING_FUNC(ring_QChar_toCaseFolded)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->toCaseFolded();
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QChar_toLatin1)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		char *pValue ; 
		pValue = (char *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(char)) ;
		*pValue = pObject->toLatin1();
		RING_API_RETMANAGEDCPOINTER(pValue,"char",ring_state_free);
	}
}


RING_FUNC(ring_QChar_toLower)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->toLower();
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QChar_toTitleCase)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->toTitleCase();
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QChar_toUpper)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->toUpper();
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QChar_unicode)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->unicode());
}


RING_FUNC(ring_QChar_unicode_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->unicode());
}


RING_FUNC(ring_QChar_unicodeVersion)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->unicodeVersion());
}


RING_FUNC(ring_QChar_category_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->category(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_combiningClass_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->combiningClass(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_currentUnicodeVersion)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->currentUnicodeVersion());
}


RING_FUNC(ring_QChar_decomposition_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETSTRING(pObject->decomposition(* (uint  *) RING_API_GETCPOINTER(2,"uint")).toStdString().c_str());
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_decompositionTag_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->decompositionTag(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_digitValue_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->digitValue(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_direction_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->direction(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_fromLatin1)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->fromLatin1(* (char  *) RING_API_GETCPOINTER(2,"char"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"char"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QChar_hasMirrored_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->hasMirrored(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_highSurrogate)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->highSurrogate(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isDigit_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isDigit(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isHighSurrogate_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isHighSurrogate(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isLetter_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isLetter(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isLetterOrNumber_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isLetterOrNumber(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isLowSurrogate_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isLowSurrogate(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isLower_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isLower(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isMark_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isMark(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isNonCharacter_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isNonCharacter(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isNumber_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isNumber(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isPrint_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isPrint(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isPunct_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isPunct(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isSpace_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isSpace(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isSurrogate_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isSurrogate(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isSymbol_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isSymbol(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isTitleCase_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isTitleCase(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_isUpper_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->isUpper(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_lowSurrogate)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->lowSurrogate(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_mirroredChar_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->mirroredChar(* (uint  *) RING_API_GETCPOINTER(2,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QChar_requiresSurrogates)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->requiresSurrogates(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_script_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->script(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChar_surrogateToUcs4)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->surrogateToUcs4( (ushort ) RING_API_GETNUMBER(2), (ushort ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QChar_surrogateToUcs4_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->surrogateToUcs4(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"),* (QChar  *) RING_API_GETCPOINTER(3,"QChar"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QChar"));
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QChar_toCaseFolded_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->toCaseFolded(* (uint  *) RING_API_GETCPOINTER(2,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QChar_toLower_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->toLower(* (uint  *) RING_API_GETCPOINTER(2,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QChar_toTitleCase_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->toTitleCase(* (uint  *) RING_API_GETCPOINTER(2,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QChar_toUpper_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	{
		uint *pValue ; 
		pValue = (uint *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(uint)) ;
		*pValue = pObject->toUpper(* (uint  *) RING_API_GETCPOINTER(2,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
		RING_API_RETMANAGEDCPOINTER(pValue,"uint",ring_state_free);
	}
}


RING_FUNC(ring_QChar_unicodeVersion_2)
{
	QChar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChar *) RING_API_GETCPOINTER(1,"QChar");
	RING_API_RETNUMBER(pObject->unicodeVersion(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QChildEvent_added)
{
	QChildEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChildEvent *) RING_API_GETCPOINTER(1,"QChildEvent");
	RING_API_RETNUMBER(pObject->added());
}


RING_FUNC(ring_QChildEvent_child)
{
	QChildEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChildEvent *) RING_API_GETCPOINTER(1,"QChildEvent");
	RING_API_RETCPOINTER(pObject->child(),"QObject");
}


RING_FUNC(ring_QChildEvent_polished)
{
	QChildEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChildEvent *) RING_API_GETCPOINTER(1,"QChildEvent");
	RING_API_RETNUMBER(pObject->polished());
}


RING_FUNC(ring_QChildEvent_removed)
{
	QChildEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QChildEvent *) RING_API_GETCPOINTER(1,"QChildEvent");
	RING_API_RETNUMBER(pObject->removed());
}


RING_FUNC(ring_QTextStream_atEnd)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->atEnd());
}


RING_FUNC(ring_QTextStream_autoDetectUnicode)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->autoDetectUnicode());
}


RING_FUNC(ring_QTextStream_codec)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETCPOINTER(pObject->codec(),"QTextCodec");
}


RING_FUNC(ring_QTextStream_device)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETCPOINTER(pObject->device(),"QIODevice");
}


RING_FUNC(ring_QTextStream_fieldAlignment)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->fieldAlignment());
}


RING_FUNC(ring_QTextStream_fieldWidth)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->fieldWidth());
}


RING_FUNC(ring_QTextStream_flush)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	pObject->flush();
}


RING_FUNC(ring_QTextStream_generateByteOrderMark)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->generateByteOrderMark());
}


RING_FUNC(ring_QTextStream_integerBase)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->integerBase());
}


RING_FUNC(ring_QTextStream_locale)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	{
		QLocale *pValue ; 
		pValue = (QLocale *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QLocale)) ;
		*pValue = pObject->locale();
		RING_API_RETMANAGEDCPOINTER(pValue,"QLocale",ring_state_free);
	}
}


RING_FUNC(ring_QTextStream_numberFlags)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->numberFlags());
}


RING_FUNC(ring_QTextStream_padChar)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->padChar();
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QTextStream_pos)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->pos());
}


RING_FUNC(ring_QTextStream_read)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->read( (qint64 ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTextStream_readAll)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETSTRING(pObject->readAll().toStdString().c_str());
}


RING_FUNC(ring_QTextStream_readLine)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->readLine( (qint64 ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTextStream_realNumberNotation)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->realNumberNotation());
}


RING_FUNC(ring_QTextStream_realNumberPrecision)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->realNumberPrecision());
}


RING_FUNC(ring_QTextStream_reset)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	pObject->reset();
}


RING_FUNC(ring_QTextStream_resetStatus)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	pObject->resetStatus();
}


RING_FUNC(ring_QTextStream_seek)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->seek( (qint64 ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTextStream_setAutoDetectUnicode)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoDetectUnicode( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextStream_setCodec)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCodec((QTextCodec *) RING_API_GETCPOINTER(2,"QTextCodec"));
}


RING_FUNC(ring_QTextStream_setCodec_2)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCodec(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextStream_setDevice)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDevice((QIODevice *) RING_API_GETCPOINTER(2,"QIODevice"));
}


RING_FUNC(ring_QTextStream_setFieldAlignment)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFieldAlignment( (QTextStream::FieldAlignment )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextStream_setFieldWidth)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFieldWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextStream_setGenerateByteOrderMark)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setGenerateByteOrderMark( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextStream_setIntegerBase)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIntegerBase( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextStream_setLocale)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	pObject->setLocale(* (QLocale  *) RING_API_GETCPOINTER(2,"QLocale"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLocale"));
}


RING_FUNC(ring_QTextStream_setNumberFlags)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNumberFlags( (QTextStream::NumberFlags )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextStream_setPadChar)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	pObject->setPadChar(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QTextStream_setRealNumberNotation)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRealNumberNotation( (QTextStream::RealNumberNotation )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextStream_setRealNumberPrecision)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRealNumberPrecision( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextStream_setStatus)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStatus( (QTextStream::Status )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextStream_setString)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setString((QString *) RING_API_GETCPOINTER(2,"QString"), (QIODevice::OpenMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTextStream_skipWhiteSpace)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	pObject->skipWhiteSpace();
}


RING_FUNC(ring_QTextStream_status)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETNUMBER(pObject->status());
}


RING_FUNC(ring_QTextStream_string)
{
	QTextStream *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextStream *) RING_API_GETCPOINTER(1,"QTextStream");
	RING_API_RETCPOINTER(pObject->string(),"QString");
}


RING_FUNC(ring_QDesktopServices_openUrl)
{
	RING_API_IGNORECPOINTERTYPE ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_RETNUMBER(QDesktopServices::openUrl(* (QUrl *) RING_API_GETCPOINTER(1,"QUrl"))) ;
}

RING_FUNC(ring_QDesktopServices_setUrlHandler)
{
	RING_API_IGNORECPOINTERTYPE ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	QDesktopServices::setUrlHandler(RING_API_GETSTRING(1),(QObject *) RING_API_GETCPOINTER(2,"QObject *"),RING_API_GETSTRING(3));
}

RING_FUNC(ring_QDesktopServices_unsetUrlHandler)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	QDesktopServices::unsetUrlHandler(RING_API_GETSTRING(1));
}


RING_FUNC(ring_QBitmap_clear)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	pObject->clear();
}


RING_FUNC(ring_QBitmap_swap)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	pObject->swap(* (QBitmap *) RING_API_GETCPOINTER(2,"QBitmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBitmap"));
}


RING_FUNC(ring_QBitmap_transformed)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->transformed(* (QTransform *) RING_API_GETCPOINTER(2,"QTransform"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QBitmap",ring_QBitmap_freefunc);
	}
}


RING_FUNC(ring_QBitmap_fromData)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->fromData(* (QSize *) RING_API_GETCPOINTER(2,"QSize"),(uchar *) RING_API_GETCPOINTER(3,"uchar"), (QImage::Format )  (int) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QBitmap",ring_QBitmap_freefunc);
	}
}


RING_FUNC(ring_QBitmap_fromImage)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->fromImage(* (QImage *) RING_API_GETCPOINTER(2,"QImage"), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QBitmap",ring_QBitmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_copy)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->copy( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_scaled)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->scaled( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (Qt::AspectRatioMode )  (int) RING_API_GETNUMBER(4), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_width)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->width());
}


RING_FUNC(ring_QPixmap_height)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->height());
}


RING_FUNC(ring_QPixmap_createMaskFromColor)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->createMaskFromColor(* (QColor *) RING_API_GETCPOINTER(2,"QColor"), (Qt::MaskMode)  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QBitmap",ring_QBitmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_mask)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->mask();
		RING_API_RETMANAGEDCPOINTER(pValue,"QBitmap",ring_QBitmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_setMask)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	pObject->setMask(* (QBitmap *) RING_API_GETCPOINTER(2,"QBitmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBitmap"));
}


RING_FUNC(ring_QPixmap_fill)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	pObject->fill(* (QColor *) RING_API_GETCPOINTER(2,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
}


RING_FUNC(ring_QPixmap_fromImage)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->fromImage(* (QImage *) RING_API_GETCPOINTER(2,"QImage"), (Qt::ImageConversionFlags)  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_load)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->load(RING_API_GETSTRING(2),RING_API_GETSTRING(3), (Qt::ImageConversionFlags)  (int) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QPixmap_cacheKey)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->cacheKey());
}


RING_FUNC(ring_QPixmap_convertFromImage)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->convertFromImage(* (QImage  *) RING_API_GETCPOINTER(2,"QImage"), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
}


RING_FUNC(ring_QPixmap_copy_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->copy(* (QRect  *) RING_API_GETCPOINTER(2,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_createHeuristicMask)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->createHeuristicMask( (bool ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QBitmap",ring_QBitmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_depth)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->depth());
}


RING_FUNC(ring_QPixmap_detach)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	pObject->detach();
}


RING_FUNC(ring_QPixmap_devicePixelRatio)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->devicePixelRatio());
}


RING_FUNC(ring_QPixmap_hasAlpha)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->hasAlpha());
}


RING_FUNC(ring_QPixmap_hasAlphaChannel)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->hasAlphaChannel());
}


RING_FUNC(ring_QPixmap_isNull)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QPixmap_isQBitmap)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->isQBitmap());
}


RING_FUNC(ring_QPixmap_loadFromData)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->loadFromData((uchar *) RING_API_GETCPOINTER(2,"uchar"),* (uint  *) RING_API_GETCPOINTER(3,"uint"),RING_API_GETSTRING(4), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(5)));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"uint"));
}


RING_FUNC(ring_QPixmap_loadFromData_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->loadFromData(* (QByteArray  *) RING_API_GETCPOINTER(2,"QByteArray"),RING_API_GETSTRING(3), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QPixmap_rect)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->rect();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QPixmap_save)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->save(RING_API_GETSTRING(2),RING_API_GETSTRING(3), (int ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QPixmap_save_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->save((QIODevice *) RING_API_GETCPOINTER(2,"QIODevice"),RING_API_GETSTRING(3), (int ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QPixmap_scaled_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->scaled(* (QSize  *) RING_API_GETCPOINTER(2,"QSize"), (Qt::AspectRatioMode )  (int) RING_API_GETNUMBER(3), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_scaledToHeight)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->scaledToHeight( (int ) RING_API_GETNUMBER(2), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_scaledToWidth)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->scaledToWidth( (int ) RING_API_GETNUMBER(2), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_scroll)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 8 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(8) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scroll( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6), (int ) RING_API_GETNUMBER(7),(QRegion *) RING_API_GETCPOINTER(8,"QRegion"));
}


RING_FUNC(ring_QPixmap_scroll_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scroll( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QRect  *) RING_API_GETCPOINTER(4,"QRect"),(QRegion *) RING_API_GETCPOINTER(5,"QRegion"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QRect"));
}


RING_FUNC(ring_QPixmap_setDevicePixelRatio)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDevicePixelRatio( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPixmap_size)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->size();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QPixmap_swap)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	pObject->swap(* (QPixmap  *) RING_API_GETCPOINTER(2,"QPixmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPixmap"));
}


RING_FUNC(ring_QPixmap_toImage)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->toImage();
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QPixmap_transformed)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->transformed(* (QTransform  *) RING_API_GETCPOINTER(2,"QTransform"), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_transformed_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->transformed(* (QMatrix  *) RING_API_GETCPOINTER(2,"QMatrix"), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QMatrix"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_defaultDepth)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->defaultDepth());
}


RING_FUNC(ring_QPixmap_fromImage_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->fromImage(* (QImage  *) RING_API_GETCPOINTER(2,"QImage"), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_fromImageReader)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->fromImageReader((QImageReader *) RING_API_GETCPOINTER(2,"QImageReader"), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QPixmap_trueMatrix)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTransform *pValue ; 
		pValue = (QTransform *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform)) ;
		*pValue = pObject->trueMatrix(* (QTransform  *) RING_API_GETCPOINTER(2,"QTransform"), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTransform",ring_state_free);
	}
}


RING_FUNC(ring_QPixmap_trueMatrix_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QMatrix *pValue ; 
		pValue = (QMatrix *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMatrix)) ;
		*pValue = pObject->trueMatrix(* (QMatrix  *) RING_API_GETCPOINTER(2,"QMatrix"), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QMatrix"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QMatrix",ring_state_free);
	}
}


RING_FUNC(ring_QPainter_background)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->background();
		RING_API_RETMANAGEDCPOINTER(pValue,"QBrush",ring_QBrush_freefunc);
	}
}


RING_FUNC(ring_QPainter_backgroundMode)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->backgroundMode());
}


RING_FUNC(ring_QPainter_begin)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->begin((QPaintDevice *) RING_API_GETCPOINTER(2,"QPaintDevice")));
}


RING_FUNC(ring_QPainter_beginNativePainting)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->beginNativePainting();
}


RING_FUNC(ring_QPainter_boundingRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->boundingRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6),RING_API_GETSTRING(7));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QPainter_brush)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->brush();
		RING_API_RETMANAGEDCPOINTER(pValue,"QBrush",ring_QBrush_freefunc);
	}
}


RING_FUNC(ring_QPainter_brushOrigin)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->brushOrigin();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QPainter_clipBoundingRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QRectF *pValue ; 
		pValue = (QRectF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRectF)) ;
		*pValue = pObject->clipBoundingRect();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRectF",ring_state_free);
	}
}


RING_FUNC(ring_QPainter_clipPath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QPainterPath *pValue ; 
		pValue = new QPainterPath() ;
		*pValue = pObject->clipPath();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPainterPath",ring_QPainterPath_freefunc);
	}
}


RING_FUNC(ring_QPainter_clipRegion)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QRegion *pValue ; 
		pValue = new QRegion() ;
		*pValue = pObject->clipRegion();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegion",ring_QRegion_freefunc);
	}
}


RING_FUNC(ring_QPainter_combinedTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QTransform *pValue ; 
		pValue = (QTransform *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform)) ;
		*pValue = pObject->combinedTransform();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTransform",ring_state_free);
	}
}


RING_FUNC(ring_QPainter_compositionMode)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->compositionMode());
}


RING_FUNC(ring_QPainter_device)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETCPOINTER(pObject->device(),"QPaintDevice");
}


RING_FUNC(ring_QPainter_deviceTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QTransform *pValue ; 
		pValue = (QTransform *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform)) ;
		*pValue = pObject->deviceTransform();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTransform",ring_state_free);
	}
}


RING_FUNC(ring_QPainter_drawArc)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawArc( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6), (int ) RING_API_GETNUMBER(7));
}


RING_FUNC(ring_QPainter_drawChord)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawChord( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6), (int ) RING_API_GETNUMBER(7));
}


RING_FUNC(ring_QPainter_drawEllipse)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawEllipse( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_drawGlyphRun)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->drawGlyphRun(* (QPointF   *) RING_API_GETCPOINTER(2,"QPointF"),* (QGlyphRun   *) RING_API_GETCPOINTER(3,"QGlyphRun"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPointF"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QGlyphRun"));
}


RING_FUNC(ring_QPainter_drawImage)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawImage( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QImage  *) RING_API_GETCPOINTER(4,"QImage"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QImage"));
}


RING_FUNC(ring_QPainter_drawLine)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawLine( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_drawLines)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawLines((QLine *) RING_API_GETCPOINTER(2,"QLine"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_drawPath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->drawPath(* (QPainterPath  *) RING_API_GETCPOINTER(2,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
}


RING_FUNC(ring_QPainter_drawPicture)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPicture( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QPicture   *) RING_API_GETCPOINTER(4,"QPicture"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QPicture"));
}


RING_FUNC(ring_QPainter_drawPie)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPie( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6), (int ) RING_API_GETNUMBER(7));
}


RING_FUNC(ring_QPainter_drawPixmap)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPixmap( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QPixmap *) RING_API_GETCPOINTER(4,"QPixmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QPixmap"));
}


RING_FUNC(ring_QPainter_drawPoint)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPoint( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_drawRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_drawRects)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawRects((QRectF *) RING_API_GETCPOINTER(2,"QRectF"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_drawRoundedRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 8 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(8) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawRoundedRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (qreal ) RING_API_GETNUMBER(6), (qreal ) RING_API_GETNUMBER(7), (Qt::SizeMode )  (int) RING_API_GETNUMBER(8));
}


RING_FUNC(ring_QPainter_drawStaticText)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawStaticText( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QStaticText   *) RING_API_GETCPOINTER(4,"QStaticText"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QStaticText"));
}


RING_FUNC(ring_QPainter_drawText)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawText( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),RING_API_GETSTRING(4));
}


RING_FUNC(ring_QPainter_drawTiledPixmap)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 8 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(8) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawTiledPixmap( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5),* (QPixmap   *) RING_API_GETCPOINTER(6,"QPixmap"), (int ) RING_API_GETNUMBER(7), (int ) RING_API_GETNUMBER(8));
	if (RING_API_ISCPOINTERNOTASSIGNED(5))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(5,"QPixmap"));
}


RING_FUNC(ring_QPainter_end)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->end());
}


RING_FUNC(ring_QPainter_endNativePainting)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->endNativePainting();
}


RING_FUNC(ring_QPainter_eraseRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->eraseRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_fillPath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->fillPath(* (QPainterPath   *) RING_API_GETCPOINTER(2,"QPainterPath"),* (QBrush   *) RING_API_GETCPOINTER(3,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QBrush"));
}


RING_FUNC(ring_QPainter_fillRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->fillRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5),* (QBrush *) RING_API_GETCPOINTER(6,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(5))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(5,"QBrush"));
}


RING_FUNC(ring_QPainter_font)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->font();
		RING_API_RETMANAGEDCPOINTER(pValue,"QFont",ring_QFont_freefunc);
	}
}


RING_FUNC(ring_QPainter_fontInfo)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QFontInfo *pValue ; 
		pValue = (QFontInfo *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QFontInfo)) ;
		*pValue = pObject->fontInfo();
		RING_API_RETMANAGEDCPOINTER(pValue,"QFontInfo",ring_state_free);
	}
}


RING_FUNC(ring_QPainter_hasClipping)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->hasClipping());
}


RING_FUNC(ring_QPainter_initFrom)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->initFrom((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QPainter_isActive)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->isActive());
}


RING_FUNC(ring_QPainter_layoutDirection)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->layoutDirection());
}


RING_FUNC(ring_QPainter_opacity)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->opacity());
}


RING_FUNC(ring_QPainter_paintEngine)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETCPOINTER(pObject->paintEngine(),"QPaintEngine");
}


RING_FUNC(ring_QPainter_pen)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QPen *pValue ; 
		pValue = new QPen() ;
		*pValue = pObject->pen();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPen",ring_QPen_freefunc);
	}
}


RING_FUNC(ring_QPainter_renderHints)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->renderHints());
}


RING_FUNC(ring_QPainter_resetTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->resetTransform();
}


RING_FUNC(ring_QPainter_restore)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->restore();
}


RING_FUNC(ring_QPainter_rotate)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->rotate( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_save)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->save();
}


RING_FUNC(ring_QPainter_scale)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scale( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_setBackground)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->setBackground(* (QBrush   *) RING_API_GETCPOINTER(2,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBrush"));
}


RING_FUNC(ring_QPainter_setBackgroundMode)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBackgroundMode( (Qt::BGMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setBrush)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->setBrush(* (QBrush  *) RING_API_GETCPOINTER(2,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBrush"));
}


RING_FUNC(ring_QPainter_setBrushOrigin)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBrushOrigin( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_setClipPath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClipPath(* (QPainterPath   *) RING_API_GETCPOINTER(2,"QPainterPath"), (Qt::ClipOperation )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
}


RING_FUNC(ring_QPainter_setClipRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClipRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (Qt::ClipOperation )  (int) RING_API_GETNUMBER(6));
}


RING_FUNC(ring_QPainter_setClipRegion)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClipRegion(* (QRegion   *) RING_API_GETCPOINTER(2,"QRegion"), (Qt::ClipOperation )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRegion"));
}


RING_FUNC(ring_QPainter_setClipping)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClipping( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setCompositionMode)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCompositionMode( (QPainter::CompositionMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setFont)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->setFont(* (QFont  *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QPainter_setLayoutDirection)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLayoutDirection( (Qt::LayoutDirection )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setOpacity)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOpacity( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setPen)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->setPen(* (QPen  *) RING_API_GETCPOINTER(2,"QPen"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPen"));
}


RING_FUNC(ring_QPainter_setRenderHint)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRenderHint( (QPainter::RenderHint )  (int) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_setTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTransform(* (QTransform   *) RING_API_GETCPOINTER(2,"QTransform"), (bool ) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
}


RING_FUNC(ring_QPainter_setViewTransformEnabled)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setViewTransformEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setViewport)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setViewport( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_setWindow)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindow( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_setWorldMatrixEnabled)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWorldMatrixEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setWorldTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWorldTransform(* (QTransform   *) RING_API_GETCPOINTER(2,"QTransform"), (bool ) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
}


RING_FUNC(ring_QPainter_shear)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->shear( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_strokePath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->strokePath(* (QPainterPath   *) RING_API_GETCPOINTER(2,"QPainterPath"),* (QPen   *) RING_API_GETCPOINTER(3,"QPen"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QPen"));
}


RING_FUNC(ring_QPainter_testRenderHint)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->testRenderHint( (QPainter::RenderHint )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QPainter_transform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QTransform *pValue ; 
		pValue = (QTransform *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform)) ;
		*pValue = pObject->transform();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTransform",ring_state_free);
	}
}


RING_FUNC(ring_QPainter_translate)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->translate( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_viewTransformEnabled)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->viewTransformEnabled());
}


RING_FUNC(ring_QPainter_viewport)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->viewport();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QPainter_window)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->window();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QPainter_worldMatrixEnabled)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->worldMatrixEnabled());
}


RING_FUNC(ring_QPainter_worldTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QTransform  *pValue ; 
		pValue = (QTransform  *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform )) ;
		*pValue = pObject->worldTransform();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTransform",ring_state_free);
	}
}

RING_FUNC(ring_QPainter_drawPolygon)
{
	QPainter *pObject;
	List *pList,*pList2;
	int x,nSize;
	RING_API_IGNORECPOINTERTYPE ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pList = (List *) RING_API_GETLIST(2);
	nSize = ring_list_getsize(pList);
	QPointF *points = new QPointF[nSize];
	for (x=0 ; x < nSize ; x++) {
		pList2 = ring_list_getlist(pList,x+1);
		points[x].setX((float) ring_list_getdouble(pList2,1));
		points[x].setY((float) ring_list_getdouble(pList2,2));
	}
	pObject->drawPolygon(points, nSize, (Qt::FillRule )  (int) RING_API_GETNUMBER(3));	
	delete [] points;
}

RING_FUNC(ring_QPainter_drawConvexPolygon)
{
	QPainter *pObject ;
	List *pList,*pList2;
	int x,nSize;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pList = (List *) RING_API_GETLIST(2);
	nSize = ring_list_getsize(pList);
	QPoint *points = new QPoint[nSize];
	for (x=0 ; x < nSize ; x++) {
		pList2 = ring_list_getlist(pList,x+1);
		points[x].setX((float) ring_list_getdouble(pList2,1));
		points[x].setY((float) ring_list_getdouble(pList2,2));
	}
	pObject->drawConvexPolygon(points, nSize);
	delete [] points;
}

RING_FUNC(ring_QPainter_drawPoints)
{
	QPainter *pObject ;
	List *pList,*pList2;
	int x,nSize;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pList = (List *) RING_API_GETLIST(2);
	nSize = ring_list_getsize(pList);
	QPointF *points = new QPointF[nSize];
	for (x=0 ; x < nSize ; x++) {
		pList2 = ring_list_getlist(pList,x+1);
		points[x].setX((float) ring_list_getdouble(pList2,1));
		points[x].setY((float) ring_list_getdouble(pList2,2));
	}
	pObject->drawPoints(points, nSize);
	delete [] points;
}

RING_FUNC(ring_QPainter_drawPolyline)
{
	QPainter *pObject ;
	List *pList,*pList2;
	int x,nSize;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pList = (List *) RING_API_GETLIST(2);
	nSize = ring_list_getsize(pList);
	QPointF *points = new QPointF[nSize];
	for (x=0 ; x < nSize ; x++) {
		pList2 = ring_list_getlist(pList,x+1);
		points[x].setX((float) ring_list_getdouble(pList2,1));
		points[x].setY((float) ring_list_getdouble(pList2,2));
	}
	pObject->drawPolyline(points, nSize);
	delete [] points;
}


RING_FUNC(ring_QPicture_boundingRect)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->boundingRect();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QPicture_data)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	RING_API_RETSTRING(pObject->data());
}


RING_FUNC(ring_QPicture_isNull)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QPicture_load)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->load(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QPicture_play)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->play((QPainter *) RING_API_GETCPOINTER(2,"QPainter")));
}


RING_FUNC(ring_QPicture_save)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->save(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QPicture_setBoundingRect)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	pObject->setBoundingRect(* (QRect *) RING_API_GETCPOINTER(2,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
}


RING_FUNC(ring_QPicture_size)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	RING_API_RETNUMBER(pObject->size());
}


RING_FUNC(ring_QPicture_swap)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	pObject->swap(* (QPicture *) RING_API_GETCPOINTER(2,"QPicture"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPicture"));
}


RING_FUNC(ring_QPen_brush)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->brush();
		RING_API_RETMANAGEDCPOINTER(pValue,"QBrush",ring_QBrush_freefunc);
	}
}


RING_FUNC(ring_QPen_capStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->capStyle());
}


RING_FUNC(ring_QPen_color)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->color();
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QPen_dashOffset)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->dashOffset());
}


RING_FUNC(ring_QPen_isCosmetic)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->isCosmetic());
}


RING_FUNC(ring_QPen_isSolid)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->isSolid());
}


RING_FUNC(ring_QPen_joinStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->joinStyle());
}


RING_FUNC(ring_QPen_miterLimit)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->miterLimit());
}


RING_FUNC(ring_QPen_setBrush)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	pObject->setBrush(* (QBrush *) RING_API_GETCPOINTER(2,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBrush"));
}


RING_FUNC(ring_QPen_setCapStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCapStyle( (Qt::PenCapStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setColor)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	pObject->setColor(* (QColor *) RING_API_GETCPOINTER(2,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
}


RING_FUNC(ring_QPen_setCosmetic)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCosmetic( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setDashOffset)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDashOffset( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setJoinStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setJoinStyle( (Qt::PenJoinStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setMiterLimit)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMiterLimit( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyle( (Qt::PenStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setWidth)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setWidthF)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWidthF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_style)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->style());
}


RING_FUNC(ring_QPen_swap)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	pObject->swap(* (QPen *) RING_API_GETCPOINTER(2,"QPen"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPen"));
}


RING_FUNC(ring_QPen_width)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->width());
}


RING_FUNC(ring_QPen_widthF)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->widthF());
}


RING_FUNC(ring_QColor_alpha)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->alpha());
}


RING_FUNC(ring_QColor_alphaF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->alphaF());
}


RING_FUNC(ring_QColor_black)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->black());
}


RING_FUNC(ring_QColor_blackF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->blackF());
}


RING_FUNC(ring_QColor_blue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->blue());
}


RING_FUNC(ring_QColor_blueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->blueF());
}


RING_FUNC(ring_QColor_convertTo)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->convertTo( (QColor::Spec )  (int) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_cyan)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->cyan());
}


RING_FUNC(ring_QColor_cyanF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->cyanF());
}


RING_FUNC(ring_QColor_darker)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->darker( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_getCmyk)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getCmyk(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5),RING_API_GETINTPOINTER(6));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
	RING_API_ACCEPTINTVALUE(5) ;
}


RING_FUNC(ring_QColor_getCmykF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getCmykF((qreal *) RING_API_GETCPOINTER(2,"qreal"),(qreal *) RING_API_GETCPOINTER(3,"qreal"),(qreal *) RING_API_GETCPOINTER(4,"qreal"),(qreal *) RING_API_GETCPOINTER(5,"qreal"),(qreal *) RING_API_GETCPOINTER(6,"qreal"));
}


RING_FUNC(ring_QColor_getHsl)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getHsl(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QColor_getHslF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getHslF((qreal *) RING_API_GETCPOINTER(2,"qreal"),(qreal *) RING_API_GETCPOINTER(3,"qreal"),(qreal *) RING_API_GETCPOINTER(4,"qreal"),(qreal *) RING_API_GETCPOINTER(5,"qreal"));
}


RING_FUNC(ring_QColor_getHsv)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getHsv(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QColor_getHsvF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getHsvF((qreal *) RING_API_GETCPOINTER(2,"qreal"),(qreal *) RING_API_GETCPOINTER(3,"qreal"),(qreal *) RING_API_GETCPOINTER(4,"qreal"),(qreal *) RING_API_GETCPOINTER(5,"qreal"));
}


RING_FUNC(ring_QColor_getRgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getRgb(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QColor_getRgbF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getRgbF((qreal *) RING_API_GETCPOINTER(2,"qreal"),(qreal *) RING_API_GETCPOINTER(3,"qreal"),(qreal *) RING_API_GETCPOINTER(4,"qreal"),(qreal *) RING_API_GETCPOINTER(5,"qreal"));
}


RING_FUNC(ring_QColor_green)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->green());
}


RING_FUNC(ring_QColor_greenF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->greenF());
}


RING_FUNC(ring_QColor_hslHue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hslHue());
}


RING_FUNC(ring_QColor_hslHueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hslHueF());
}


RING_FUNC(ring_QColor_hslSaturation)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hslSaturation());
}


RING_FUNC(ring_QColor_hslSaturationF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hslSaturationF());
}


RING_FUNC(ring_QColor_hsvHue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hsvHue());
}


RING_FUNC(ring_QColor_hsvHueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hsvHueF());
}


RING_FUNC(ring_QColor_hsvSaturation)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hsvSaturation());
}


RING_FUNC(ring_QColor_hsvSaturationF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hsvSaturationF());
}


RING_FUNC(ring_QColor_hue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hue());
}


RING_FUNC(ring_QColor_hueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hueF());
}


RING_FUNC(ring_QColor_isValid)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QColor_lighter)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->lighter( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_lightness)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->lightness());
}


RING_FUNC(ring_QColor_lightnessF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->lightnessF());
}


RING_FUNC(ring_QColor_magenta)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->magenta());
}


RING_FUNC(ring_QColor_magentaF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->magentaF());
}


RING_FUNC(ring_QColor_name)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETSTRING(pObject->name().toStdString().c_str());
}


RING_FUNC(ring_QColor_red)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->red());
}


RING_FUNC(ring_QColor_redF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->redF());
}


RING_FUNC(ring_QColor_rgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QRgb *pValue ; 
		pValue = (QRgb *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRgb)) ;
		*pValue = pObject->rgb();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRgb",ring_state_free);
	}
}


RING_FUNC(ring_QColor_rgba)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QRgb *pValue ; 
		pValue = (QRgb *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRgb)) ;
		*pValue = pObject->rgba();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRgb",ring_state_free);
	}
}


RING_FUNC(ring_QColor_saturation)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->saturation());
}


RING_FUNC(ring_QColor_saturationF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->saturationF());
}


RING_FUNC(ring_QColor_setAlpha)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlpha( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setAlphaF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlphaF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setBlue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBlue( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setBlueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBlueF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setCmyk)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCmyk( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6));
}


RING_FUNC(ring_QColor_setCmykF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCmykF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5), (double ) RING_API_GETNUMBER(6));
}


RING_FUNC(ring_QColor_setGreen)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setGreen( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setGreenF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setGreenF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setHsl)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHsl( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setHslF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHslF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setHsv)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHsv( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setHsvF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHsvF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setNamedColor)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNamedColor(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QColor_setRed)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRed( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setRedF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRedF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setRgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRgb( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setRgbF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRgbF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setRgba)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	pObject->setRgba(* (QRgb  *) RING_API_GETCPOINTER(2,"QRgb"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRgb"));
}


RING_FUNC(ring_QColor_spec)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->spec());
}


RING_FUNC(ring_QColor_toCmyk)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->toCmyk();
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_toHsl)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->toHsl();
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_toHsv)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->toHsv();
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_toRgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->toRgb();
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_value)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->value());
}


RING_FUNC(ring_QColor_valueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->valueF());
}


RING_FUNC(ring_QColor_yellow)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->yellow());
}


RING_FUNC(ring_QColor_yellowF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->yellowF());
}


RING_FUNC(ring_QColor_colorNames)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->colorNames();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QColor_fromCmyk)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromCmyk( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_fromCmykF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromCmykF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5), (double ) RING_API_GETNUMBER(6));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_fromHsl)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromHsl( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_fromHslF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromHslF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_fromHsv)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromHsv( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_fromHsvF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromHsvF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_fromRgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromRgb( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_fromRgbF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromRgbF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_fromRgba)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromRgba(* (QRgb  *) RING_API_GETCPOINTER(2,"QRgb"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRgb"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QColor_isValidColor)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isValidColor(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QFont_bold)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->bold());
}


RING_FUNC(ring_QFont_capitalization)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->capitalization());
}


RING_FUNC(ring_QFont_defaultFamily)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->defaultFamily().toStdString().c_str());
}


RING_FUNC(ring_QFont_exactMatch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->exactMatch());
}


RING_FUNC(ring_QFont_family)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->family().toStdString().c_str());
}


RING_FUNC(ring_QFont_fixedPitch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->fixedPitch());
}


RING_FUNC(ring_QFont_fromString)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->fromString(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QFont_hintingPreference)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->hintingPreference());
}


RING_FUNC(ring_QFont_isCopyOf)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->isCopyOf(* (QFont *) RING_API_GETCPOINTER(2,"QFont")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QFont_italic)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->italic());
}


RING_FUNC(ring_QFont_kerning)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->kerning());
}


RING_FUNC(ring_QFont_key)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->key().toStdString().c_str());
}


RING_FUNC(ring_QFont_lastResortFamily)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->lastResortFamily().toStdString().c_str());
}


RING_FUNC(ring_QFont_lastResortFont)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->lastResortFont().toStdString().c_str());
}


RING_FUNC(ring_QFont_letterSpacing)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->letterSpacing());
}


RING_FUNC(ring_QFont_letterSpacingType)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->letterSpacingType());
}


RING_FUNC(ring_QFont_overline)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->overline());
}


RING_FUNC(ring_QFont_pixelSize)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->pixelSize());
}


RING_FUNC(ring_QFont_pointSize)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->pointSize());
}


RING_FUNC(ring_QFont_pointSizeF)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->pointSizeF());
}


RING_FUNC(ring_QFont_rawMode)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->rawMode());
}


RING_FUNC(ring_QFont_rawName)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->rawName().toStdString().c_str());
}


RING_FUNC(ring_QFont_resolve)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->resolve(* (QFont *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QFont",ring_QFont_freefunc);
	}
}


RING_FUNC(ring_QFont_setBold)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBold( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setCapitalization)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCapitalization( (QFont::Capitalization )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setFamily)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFamily(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFont_setFixedPitch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFixedPitch( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setHintingPreference)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHintingPreference( (QFont::HintingPreference )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setItalic)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItalic( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setKerning)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setKerning( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setLetterSpacing)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLetterSpacing( (QFont::SpacingType )  (int) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QFont_setOverline)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOverline( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setPixelSize)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPixelSize( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setPointSize)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPointSize( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setPointSizeF)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPointSizeF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setRawMode)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRawMode( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setRawName)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRawName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFont_setStretch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStretch( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setStrikeOut)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStrikeOut( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setStyle)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyle( (QFont::Style )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setStyleHint)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyleHint( (QFont::StyleHint )  (int) RING_API_GETNUMBER(2), (QFont::StyleStrategy )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QFont_setStyleName)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyleName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFont_setStyleStrategy)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyleStrategy( (QFont::StyleStrategy )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setUnderline)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUnderline( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setWeight)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setWordSpacing)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWordSpacing( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_stretch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->stretch());
}


RING_FUNC(ring_QFont_strikeOut)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->strikeOut());
}


RING_FUNC(ring_QFont_style)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->style());
}


RING_FUNC(ring_QFont_styleHint)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->styleHint());
}


RING_FUNC(ring_QFont_styleName)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->styleName().toStdString().c_str());
}


RING_FUNC(ring_QFont_styleStrategy)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->styleStrategy());
}


RING_FUNC(ring_QFont_toString)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->toString().toStdString().c_str());
}


RING_FUNC(ring_QFont_underline)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->underline());
}


RING_FUNC(ring_QFont_weight)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->weight());
}


RING_FUNC(ring_QFont_wordSpacing)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->wordSpacing());
}


RING_FUNC(ring_QFont_insertSubstitution)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertSubstitution(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QFont_insertSubstitutions)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertSubstitutions(RING_API_GETSTRING(2),* (QStringList *) RING_API_GETCPOINTER(3,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QStringList"));
}


RING_FUNC(ring_QFont_substitute)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->substitute(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QFont_substitutes)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->substitutes(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QFont_substitutions)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->substitutions();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QBrush_color)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->color();
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QBrush_gradient)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	RING_API_RETCPOINTER(pObject->gradient(),"QGradient");
}


RING_FUNC(ring_QBrush_isOpaque)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	RING_API_RETNUMBER(pObject->isOpaque());
}


RING_FUNC(ring_QBrush_matrix)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	{
		QMatrix *pValue ; 
		pValue = (QMatrix *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMatrix)) ;
		*pValue = pObject->matrix();
		RING_API_RETMANAGEDCPOINTER(pValue,"QMatrix",ring_state_free);
	}
}


RING_FUNC(ring_QBrush_setColor)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	pObject->setColor(* (QColor *) RING_API_GETCPOINTER(2,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
}


RING_FUNC(ring_QBrush_setMatrix)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	pObject->setMatrix(* (QMatrix *) RING_API_GETCPOINTER(2,"QMatrix"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QMatrix"));
}


RING_FUNC(ring_QBrush_setStyle)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyle( (Qt::BrushStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QBrush_setTexture)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	pObject->setTexture(* (QPixmap *) RING_API_GETCPOINTER(2,"QPixmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPixmap"));
}


RING_FUNC(ring_QBrush_setTextureImage)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	pObject->setTextureImage(* (QImage *) RING_API_GETCPOINTER(2,"QImage"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
}


RING_FUNC(ring_QBrush_setTransform)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	pObject->setTransform(* (QTransform *) RING_API_GETCPOINTER(2,"QTransform"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
}


RING_FUNC(ring_QBrush_style)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	RING_API_RETNUMBER(pObject->style());
}


RING_FUNC(ring_QBrush_swap)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	pObject->swap(* (QBrush *) RING_API_GETCPOINTER(2,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBrush"));
}


RING_FUNC(ring_QBrush_texture)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->texture();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QBrush_textureImage)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->textureImage();
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QBrush_transform)
{
	QBrush *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBrush *) RING_API_GETCPOINTER(1,"QBrush");
	{
		QTransform *pValue ; 
		pValue = (QTransform *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform)) ;
		*pValue = pObject->transform();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTransform",ring_state_free);
	}
}


RING_FUNC(ring_QTextCursor_anchor)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->anchor());
}


RING_FUNC(ring_QTextCursor_atBlockEnd)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->atBlockEnd());
}


RING_FUNC(ring_QTextCursor_atBlockStart)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->atBlockStart());
}


RING_FUNC(ring_QTextCursor_atEnd)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->atEnd());
}


RING_FUNC(ring_QTextCursor_atStart)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->atStart());
}


RING_FUNC(ring_QTextCursor_beginEditBlock)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->beginEditBlock();
}


RING_FUNC(ring_QTextCursor_block)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->block();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextCursor_blockCharFormat)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	{
		QTextCharFormat *pValue ; 
		pValue = new QTextCharFormat() ;
		*pValue = pObject->blockCharFormat();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextCharFormat",ring_QTextCharFormat_freefunc);
	}
}


RING_FUNC(ring_QTextCursor_blockFormat)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	{
		QTextBlockFormat *pValue ; 
		pValue = (QTextBlockFormat *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTextBlockFormat)) ;
		*pValue = pObject->blockFormat();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlockFormat",ring_state_free);
	}
}


RING_FUNC(ring_QTextCursor_blockNumber)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->blockNumber());
}


RING_FUNC(ring_QTextCursor_charFormat)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	{
		QTextCharFormat *pValue ; 
		pValue = new QTextCharFormat() ;
		*pValue = pObject->charFormat();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextCharFormat",ring_QTextCharFormat_freefunc);
	}
}


RING_FUNC(ring_QTextCursor_clearSelection)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->clearSelection();
}


RING_FUNC(ring_QTextCursor_columnNumber)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->columnNumber());
}


RING_FUNC(ring_QTextCursor_createList)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETCPOINTER(pObject->createList(* (QTextListFormat *) RING_API_GETCPOINTER(2,"QTextListFormat")),"QTextList");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextListFormat"));
}


RING_FUNC(ring_QTextCursor_currentFrame)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETCPOINTER(pObject->currentFrame(),"QTextFrame");
}


RING_FUNC(ring_QTextCursor_currentList)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETCPOINTER(pObject->currentList(),"QTextList");
}


RING_FUNC(ring_QTextCursor_currentTable)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETCPOINTER(pObject->currentTable(),"QTextTable");
}


RING_FUNC(ring_QTextCursor_deleteChar)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->deleteChar();
}


RING_FUNC(ring_QTextCursor_deletePreviousChar)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->deletePreviousChar();
}


RING_FUNC(ring_QTextCursor_document)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETCPOINTER(pObject->document(),"QTextDocument");
}


RING_FUNC(ring_QTextCursor_endEditBlock)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->endEditBlock();
}


RING_FUNC(ring_QTextCursor_hasComplexSelection)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->hasComplexSelection());
}


RING_FUNC(ring_QTextCursor_hasSelection)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->hasSelection());
}


RING_FUNC(ring_QTextCursor_insertBlock)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->insertBlock();
}


RING_FUNC(ring_QTextCursor_insertFragment)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->insertFragment(* (QTextDocumentFragment *) RING_API_GETCPOINTER(2,"QTextDocumentFragment"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextDocumentFragment"));
}


RING_FUNC(ring_QTextCursor_insertFrame)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETCPOINTER(pObject->insertFrame(* (QTextFrameFormat *) RING_API_GETCPOINTER(2,"QTextFrameFormat")),"QTextFrame");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextFrameFormat"));
}


RING_FUNC(ring_QTextCursor_insertHtml)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertHtml(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextCursor_insertImage)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->insertImage(* (QTextImageFormat *) RING_API_GETCPOINTER(2,"QTextImageFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextImageFormat"));
}


RING_FUNC(ring_QTextCursor_insertList)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETCPOINTER(pObject->insertList(* (QTextListFormat *) RING_API_GETCPOINTER(2,"QTextListFormat")),"QTextList");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextListFormat"));
}


RING_FUNC(ring_QTextCursor_insertTable)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->insertTable( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QTextTableFormat *) RING_API_GETCPOINTER(4,"QTextTableFormat")),"QTextTable");
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QTextTableFormat"));
}


RING_FUNC(ring_QTextCursor_insertText)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextCursor_insertText_2)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertText(RING_API_GETSTRING(2),* (QTextCharFormat *) RING_API_GETCPOINTER(3,"QTextCharFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QTextCharFormat"));
}


RING_FUNC(ring_QTextCursor_isCopyOf)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->isCopyOf(* (QTextCursor *) RING_API_GETCPOINTER(2,"QTextCursor")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextCursor"));
}


RING_FUNC(ring_QTextCursor_isNull)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QTextCursor_joinPreviousEditBlock)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->joinPreviousEditBlock();
}


RING_FUNC(ring_QTextCursor_keepPositionOnInsert)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->keepPositionOnInsert());
}


RING_FUNC(ring_QTextCursor_mergeBlockCharFormat)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->mergeBlockCharFormat(* (QTextCharFormat *) RING_API_GETCPOINTER(2,"QTextCharFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextCharFormat"));
}


RING_FUNC(ring_QTextCursor_mergeBlockFormat)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->mergeBlockFormat(* (QTextBlockFormat *) RING_API_GETCPOINTER(2,"QTextBlockFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextBlockFormat"));
}


RING_FUNC(ring_QTextCursor_mergeCharFormat)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->mergeCharFormat(* (QTextCharFormat *) RING_API_GETCPOINTER(2,"QTextCharFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextCharFormat"));
}


RING_FUNC(ring_QTextCursor_movePosition)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->movePosition( (QTextCursor::MoveOperation )  (int) RING_API_GETNUMBER(2), (QTextCursor::MoveMode )  (int) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QTextCursor_position)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->position());
}


RING_FUNC(ring_QTextCursor_positionInBlock)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->positionInBlock());
}


RING_FUNC(ring_QTextCursor_removeSelectedText)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->removeSelectedText();
}


RING_FUNC(ring_QTextCursor_select)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->select( (QTextCursor::SelectionType )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCursor_selectedTableCells)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->selectedTableCells(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QTextCursor_selectedText)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETSTRING(pObject->selectedText().toStdString().c_str());
}


RING_FUNC(ring_QTextCursor_selection)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	{
		QTextDocumentFragment *pValue ; 
		pValue = (QTextDocumentFragment *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTextDocumentFragment)) ;
		*pValue = pObject->selection();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextDocumentFragment",ring_state_free);
	}
}


RING_FUNC(ring_QTextCursor_selectionEnd)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->selectionEnd());
}


RING_FUNC(ring_QTextCursor_selectionStart)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->selectionStart());
}


RING_FUNC(ring_QTextCursor_setBlockCharFormat)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->setBlockCharFormat(* (QTextCharFormat *) RING_API_GETCPOINTER(2,"QTextCharFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextCharFormat"));
}


RING_FUNC(ring_QTextCursor_setBlockFormat)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->setBlockFormat(* (QTextBlockFormat *) RING_API_GETCPOINTER(2,"QTextBlockFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextBlockFormat"));
}


RING_FUNC(ring_QTextCursor_setCharFormat)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	pObject->setCharFormat(* (QTextCharFormat *) RING_API_GETCPOINTER(2,"QTextCharFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextCharFormat"));
}


RING_FUNC(ring_QTextCursor_setKeepPositionOnInsert)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setKeepPositionOnInsert( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCursor_setPosition)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPosition( (int ) RING_API_GETNUMBER(2), (QTextCursor::MoveMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTextCursor_setVerticalMovementX)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVerticalMovementX( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCursor_setVisualNavigation)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVisualNavigation( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCursor_verticalMovementX)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->verticalMovementX());
}


RING_FUNC(ring_QTextCursor_visualNavigation)
{
	QTextCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCursor *) RING_API_GETCPOINTER(1,"QTextCursor");
	RING_API_RETNUMBER(pObject->visualNavigation());
}


RING_FUNC(ring_QTextDocument_addResource)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addResource( (int ) RING_API_GETNUMBER(2),* (QUrl  *) RING_API_GETCPOINTER(3,"QUrl"),* (QVariant  *) RING_API_GETCPOINTER(4,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QVariant"));
}


RING_FUNC(ring_QTextDocument_adjustSize)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	pObject->adjustSize();
}


RING_FUNC(ring_QTextDocument_allFormats)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	{
		QVector<QTextFormat> *pValue ; 
		pValue = (QVector<QTextFormat> *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QVector<QTextFormat>)) ;
		*pValue = pObject->allFormats();
		RING_API_RETMANAGEDCPOINTER(pValue,"QVector<QTextFormat>",ring_state_free);
	}
}


RING_FUNC(ring_QTextDocument_availableRedoSteps)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->availableRedoSteps());
}


RING_FUNC(ring_QTextDocument_availableUndoSteps)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->availableUndoSteps());
}


RING_FUNC(ring_QTextDocument_begin)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->begin();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_blockCount)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->blockCount());
}


RING_FUNC(ring_QTextDocument_characterAt)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QChar *pValue ; 
		pValue = new QChar() ;
		*pValue = pObject->characterAt( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QChar",ring_QChar_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_characterCount)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->characterCount());
}


RING_FUNC(ring_QTextDocument_clearUndoRedoStacks)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->clearUndoRedoStacks( (QTextDocument::Stacks )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextDocument_clone)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->clone((QObject *) RING_API_GETCPOINTER(2,"QObject")),"QTextDocument");
}


RING_FUNC(ring_QTextDocument_defaultCursorMoveStyle)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->defaultCursorMoveStyle());
}


RING_FUNC(ring_QTextDocument_defaultFont)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->defaultFont();
		RING_API_RETMANAGEDCPOINTER(pValue,"QFont",ring_QFont_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_defaultStyleSheet)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETSTRING(pObject->defaultStyleSheet().toStdString().c_str());
}


RING_FUNC(ring_QTextDocument_defaultTextOption)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	{
		QTextOption *pValue ; 
		pValue = (QTextOption *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTextOption)) ;
		*pValue = pObject->defaultTextOption();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextOption",ring_state_free);
	}
}


RING_FUNC(ring_QTextDocument_documentLayout)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETCPOINTER(pObject->documentLayout(),"QAbstractTextDocumentLayout");
}


RING_FUNC(ring_QTextDocument_documentMargin)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->documentMargin());
}


RING_FUNC(ring_QTextDocument_drawContents)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawContents((QPainter *) RING_API_GETCPOINTER(2,"QPainter"),* (QRectF  *) RING_API_GETCPOINTER(3,"QRectF"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QRectF"));
}


RING_FUNC(ring_QTextDocument_end)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->end();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_find)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTextCursor *pValue ; 
		pValue = new QTextCursor() ;
		*pValue = pObject->find(RING_API_GETSTRING(2),* (QTextCursor  *) RING_API_GETCPOINTER(3,"QTextCursor"), (QTextDocument::FindFlag )  (int) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QTextCursor"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextCursor",ring_QTextCursor_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_findBlock)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->findBlock( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_findBlockByLineNumber)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->findBlockByLineNumber( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_findBlockByNumber)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->findBlockByNumber( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_firstBlock)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->firstBlock();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_idealWidth)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->idealWidth());
}


RING_FUNC(ring_QTextDocument_indentWidth)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->indentWidth());
}


RING_FUNC(ring_QTextDocument_isEmpty)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QTextDocument_isModified)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->isModified());
}


RING_FUNC(ring_QTextDocument_isRedoAvailable)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->isRedoAvailable());
}


RING_FUNC(ring_QTextDocument_isUndoAvailable)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->isUndoAvailable());
}


RING_FUNC(ring_QTextDocument_isUndoRedoEnabled)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->isUndoRedoEnabled());
}


RING_FUNC(ring_QTextDocument_lastBlock)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->lastBlock();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_lineCount)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->lineCount());
}


RING_FUNC(ring_QTextDocument_markContentsDirty)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->markContentsDirty( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTextDocument_maximumBlockCount)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->maximumBlockCount());
}


RING_FUNC(ring_QTextDocument_metaInformation)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->metaInformation( (QTextDocument::MetaInformation )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTextDocument_object)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->object( (int ) RING_API_GETNUMBER(2)),"QTextObject");
}


RING_FUNC(ring_QTextDocument_objectForFormat)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETCPOINTER(pObject->objectForFormat(* (QTextFormat  *) RING_API_GETCPOINTER(2,"QTextFormat")),"QTextObject");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextFormat"));
}


RING_FUNC(ring_QTextDocument_pageCount)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->pageCount());
}


RING_FUNC(ring_QTextDocument_pageSize)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	{
		QSizeF *pValue ; 
		pValue = (QSizeF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QSizeF)) ;
		*pValue = pObject->pageSize();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSizeF",ring_state_free);
	}
}


RING_FUNC(ring_QTextDocument_print)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->print((QPrinter *) RING_API_GETCPOINTER(2,"QPrinter"));
}


RING_FUNC(ring_QTextDocument_redo)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->redo((QTextCursor *) RING_API_GETCPOINTER(2,"QTextCursor"));
}


RING_FUNC(ring_QTextDocument_resource)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->resource( (int ) RING_API_GETNUMBER(2),* (QUrl  *) RING_API_GETCPOINTER(3,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QUrl"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QVariant",ring_QVariant_freefunc);
	}
}


RING_FUNC(ring_QTextDocument_revision)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->revision());
}


RING_FUNC(ring_QTextDocument_rootFrame)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETCPOINTER(pObject->rootFrame(),"QTextFrame");
}


RING_FUNC(ring_QTextDocument_setDefaultCursorMoveStyle)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDefaultCursorMoveStyle( (Qt::CursorMoveStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextDocument_setDefaultFont)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	pObject->setDefaultFont(* (QFont  *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QTextDocument_setDefaultStyleSheet)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDefaultStyleSheet(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextDocument_setDefaultTextOption)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	pObject->setDefaultTextOption(* (QTextOption  *) RING_API_GETCPOINTER(2,"QTextOption"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextOption"));
}


RING_FUNC(ring_QTextDocument_setDocumentLayout)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDocumentLayout((QAbstractTextDocumentLayout *) RING_API_GETCPOINTER(2,"QAbstractTextDocumentLayout"));
}


RING_FUNC(ring_QTextDocument_setDocumentMargin)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDocumentMargin( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextDocument_setHtml)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHtml(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextDocument_setIndentWidth)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIndentWidth( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextDocument_setMaximumBlockCount)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaximumBlockCount( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextDocument_setMetaInformation)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMetaInformation( (QTextDocument::MetaInformation )  (int) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QTextDocument_setPageSize)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	pObject->setPageSize(* (QSizeF  *) RING_API_GETCPOINTER(2,"QSizeF"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSizeF"));
}


RING_FUNC(ring_QTextDocument_setPlainText)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPlainText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextDocument_setTextWidth)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextWidth( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextDocument_setUndoRedoEnabled)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUndoRedoEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextDocument_setUseDesignMetrics)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUseDesignMetrics( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextDocument_size)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	{
		QSizeF *pValue ; 
		pValue = (QSizeF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QSizeF)) ;
		*pValue = pObject->size();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSizeF",ring_state_free);
	}
}


RING_FUNC(ring_QTextDocument_textWidth)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->textWidth());
}


RING_FUNC(ring_QTextDocument_toHtml)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETSTRING(pObject->toHtml(* (QByteArray  *) RING_API_GETCPOINTER(2,"QByteArray")).toStdString().c_str());
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QTextDocument_toPlainText)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETSTRING(pObject->toPlainText().toStdString().c_str());
}


RING_FUNC(ring_QTextDocument_undo)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->undo((QTextCursor *) RING_API_GETCPOINTER(2,"QTextCursor"));
}


RING_FUNC(ring_QTextDocument_useDesignMetrics)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	RING_API_RETNUMBER(pObject->useDesignMetrics());
}


RING_FUNC(ring_QTextDocument_setModified)
{
	QTextDocument *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextDocument *) RING_API_GETCPOINTER(1,"QTextDocument");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setModified( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextBlock_blockFormat)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	{
		QTextBlockFormat *pValue ; 
		pValue = (QTextBlockFormat *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTextBlockFormat)) ;
		*pValue = pObject->blockFormat();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlockFormat",ring_state_free);
	}
}


RING_FUNC(ring_QTextBlock_blockFormatIndex)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->blockFormatIndex());
}


RING_FUNC(ring_QTextBlock_blockNumber)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->blockNumber());
}


RING_FUNC(ring_QTextBlock_charFormat)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	{
		QTextCharFormat *pValue ; 
		pValue = new QTextCharFormat() ;
		*pValue = pObject->charFormat();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextCharFormat",ring_QTextCharFormat_freefunc);
	}
}


RING_FUNC(ring_QTextBlock_charFormatIndex)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->charFormatIndex());
}


RING_FUNC(ring_QTextBlock_clearLayout)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	pObject->clearLayout();
}


RING_FUNC(ring_QTextBlock_contains)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->contains( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTextBlock_document)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETCPOINTER(pObject->document(),"QTextDocument");
}


RING_FUNC(ring_QTextBlock_firstLineNumber)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->firstLineNumber());
}


RING_FUNC(ring_QTextBlock_isValid)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QTextBlock_isVisible)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->isVisible());
}


RING_FUNC(ring_QTextBlock_layout)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETCPOINTER(pObject->layout(),"QTextLayout");
}


RING_FUNC(ring_QTextBlock_length)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->length());
}


RING_FUNC(ring_QTextBlock_lineCount)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->lineCount());
}


RING_FUNC(ring_QTextBlock_next)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->next();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextBlock_position)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->position());
}


RING_FUNC(ring_QTextBlock_previous)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	{
		QTextBlock *pValue ; 
		pValue = new QTextBlock() ;
		*pValue = pObject->previous();
		RING_API_RETMANAGEDCPOINTER(pValue,"QTextBlock",ring_QTextBlock_freefunc);
	}
}


RING_FUNC(ring_QTextBlock_revision)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->revision());
}


RING_FUNC(ring_QTextBlock_setLineCount)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLineCount( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextBlock_setRevision)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRevision( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextBlock_setUserData)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUserData((QTextBlockUserData *) RING_API_GETCPOINTER(2,"QTextBlockUserData"));
}


RING_FUNC(ring_QTextBlock_setUserState)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUserState( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextBlock_setVisible)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVisible( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextBlock_text)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QTextBlock_textDirection)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->textDirection());
}


RING_FUNC(ring_QTextBlock_textList)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETCPOINTER(pObject->textList(),"QTextList");
}


RING_FUNC(ring_QTextBlock_userData)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETCPOINTER(pObject->userData(),"QTextBlockUserData");
}


RING_FUNC(ring_QTextBlock_userState)
{
	QTextBlock *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextBlock *) RING_API_GETCPOINTER(1,"QTextBlock");
	RING_API_RETNUMBER(pObject->userState());
}


RING_FUNC(ring_QPainterPath_addEllipse)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addEllipse( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3), (qreal ) RING_API_GETNUMBER(4), (qreal ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainterPath_addPath)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	pObject->addPath(* (QPainterPath *) RING_API_GETCPOINTER(2,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
}


RING_FUNC(ring_QPainterPath_addPolygon)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	pObject->addPolygon(* (QPolygonF *) RING_API_GETCPOINTER(2,"QPolygonF"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPolygonF"));
}


RING_FUNC(ring_QPainterPath_addRect)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addRect( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3), (qreal ) RING_API_GETNUMBER(4), (qreal ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainterPath_addRegion)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	pObject->addRegion(* (QRegion *) RING_API_GETCPOINTER(2,"QRegion"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRegion"));
}


RING_FUNC(ring_QPainterPath_addRoundedRect)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 8 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(8) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addRoundedRect( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3), (qreal ) RING_API_GETNUMBER(4), (qreal ) RING_API_GETNUMBER(5), (qreal ) RING_API_GETNUMBER(6), (qreal ) RING_API_GETNUMBER(7), (Qt::SizeMode )  (int) RING_API_GETNUMBER(8));
}


RING_FUNC(ring_QPainterPath_addText)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addText( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3),* (QFont *) RING_API_GETCPOINTER(4,"QFont"),RING_API_GETSTRING(5));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QFont"));
}


RING_FUNC(ring_QPainterPath_angleAtPercent)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->angleAtPercent( (qreal ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QPainterPath_arcMoveTo)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->arcMoveTo( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3), (qreal ) RING_API_GETNUMBER(4), (qreal ) RING_API_GETNUMBER(5), (qreal ) RING_API_GETNUMBER(6));
}


RING_FUNC(ring_QPainterPath_arcTo)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->arcTo( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3), (qreal ) RING_API_GETNUMBER(4), (qreal ) RING_API_GETNUMBER(5), (qreal ) RING_API_GETNUMBER(6), (qreal ) RING_API_GETNUMBER(7));
}


RING_FUNC(ring_QPainterPath_boundingRect)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	{
		QRectF *pValue ; 
		pValue = (QRectF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRectF)) ;
		*pValue = pObject->boundingRect();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRectF",ring_state_free);
	}
}


RING_FUNC(ring_QPainterPath_closeSubpath)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	pObject->closeSubpath();
}


RING_FUNC(ring_QPainterPath_connectPath)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	pObject->connectPath(* (QPainterPath *) RING_API_GETCPOINTER(2,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
}


RING_FUNC(ring_QPainterPath_contains)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	RING_API_RETNUMBER(pObject->contains(* (QPointF *) RING_API_GETCPOINTER(2,"QPointF")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPointF"));
}


RING_FUNC(ring_QPainterPath_controlPointRect)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	{
		QRectF *pValue ; 
		pValue = (QRectF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRectF)) ;
		*pValue = pObject->controlPointRect();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRectF",ring_state_free);
	}
}


RING_FUNC(ring_QPainterPath_cubicTo)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->cubicTo( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3), (qreal ) RING_API_GETNUMBER(4), (qreal ) RING_API_GETNUMBER(5), (qreal ) RING_API_GETNUMBER(6), (qreal ) RING_API_GETNUMBER(7));
}


RING_FUNC(ring_QPainterPath_currentPosition)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	{
		QPointF *pValue ; 
		pValue = new QPointF() ;
		*pValue = pObject->currentPosition();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPointF",ring_QPointF_freefunc);
	}
}


RING_FUNC(ring_QPainterPath_elementAt)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPainterPath::Element *pValue ; 
		pValue = (QPainterPath::Element *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QPainterPath::Element)) ;
		*pValue = pObject->elementAt( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPainterPath::Element",ring_state_free);
	}
}


RING_FUNC(ring_QPainterPath_elementCount)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	RING_API_RETNUMBER(pObject->elementCount());
}


RING_FUNC(ring_QPainterPath_fillRule)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	RING_API_RETNUMBER(pObject->fillRule());
}


RING_FUNC(ring_QPainterPath_intersected)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	{
		QPainterPath *pValue ; 
		pValue = new QPainterPath() ;
		*pValue = pObject->intersected(* (QPainterPath *) RING_API_GETCPOINTER(2,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPainterPath",ring_QPainterPath_freefunc);
	}
}


RING_FUNC(ring_QPainterPath_intersects)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	RING_API_RETNUMBER(pObject->intersects(* (QRectF *) RING_API_GETCPOINTER(2,"QRectF")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRectF"));
}


RING_FUNC(ring_QPainterPath_isEmpty)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QPainterPath_length)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	RING_API_RETNUMBER(pObject->length());
}


RING_FUNC(ring_QPainterPath_lineTo)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->lineTo( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainterPath_moveTo)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->moveTo( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainterPath_percentAtLength)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->percentAtLength( (qreal ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QPainterPath_pointAtPercent)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPointF *pValue ; 
		pValue = new QPointF() ;
		*pValue = pObject->pointAtPercent( (qreal ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPointF",ring_QPointF_freefunc);
	}
}


RING_FUNC(ring_QPainterPath_quadTo)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->quadTo( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3), (qreal ) RING_API_GETNUMBER(4), (qreal ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainterPath_setElementPositionAt)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setElementPositionAt( (int ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3), (qreal ) RING_API_GETNUMBER(4));
}


RING_FUNC(ring_QPainterPath_setFillRule)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFillRule( (Qt::FillRule )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainterPath_simplified)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	{
		QPainterPath *pValue ; 
		pValue = new QPainterPath() ;
		*pValue = pObject->simplified();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPainterPath",ring_QPainterPath_freefunc);
	}
}


RING_FUNC(ring_QPainterPath_slopeAtPercent)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->slopeAtPercent( (qreal ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QPainterPath_subtracted)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	{
		QPainterPath *pValue ; 
		pValue = new QPainterPath() ;
		*pValue = pObject->subtracted(* (QPainterPath *) RING_API_GETCPOINTER(2,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPainterPath",ring_QPainterPath_freefunc);
	}
}


RING_FUNC(ring_QPainterPath_swap)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	pObject->swap(* (QPainterPath *) RING_API_GETCPOINTER(2,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
}


RING_FUNC(ring_QPainterPath_toFillPolygon)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	{
		QPolygonF *pValue ; 
		pValue = (QPolygonF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QPolygonF)) ;
		*pValue = pObject->toFillPolygon(* (QTransform *) RING_API_GETCPOINTER(2,"QTransform"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPolygonF",ring_state_free);
	}
}


RING_FUNC(ring_QPainterPath_toReversed)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	{
		QPainterPath *pValue ; 
		pValue = new QPainterPath() ;
		*pValue = pObject->toReversed();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPainterPath",ring_QPainterPath_freefunc);
	}
}


RING_FUNC(ring_QPainterPath_translate)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->translate( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainterPath_translated)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPainterPath *pValue ; 
		pValue = new QPainterPath() ;
		*pValue = pObject->translated( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPainterPath",ring_QPainterPath_freefunc);
	}
}


RING_FUNC(ring_QPainterPath_united)
{
	QPainterPath *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainterPath *) RING_API_GETCPOINTER(1,"QPainterPath");
	{
		QPainterPath *pValue ; 
		pValue = new QPainterPath() ;
		*pValue = pObject->united(* (QPainterPath *) RING_API_GETCPOINTER(2,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPainterPath",ring_QPainterPath_freefunc);
	}
}


RING_FUNC(ring_QImage_allGray)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->allGray());
}


RING_FUNC(ring_QImage_bitPlaneCount)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->bitPlaneCount());
}


RING_FUNC(ring_QImage_bits)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETCPOINTER(pObject->bits(),"uchar");
}


RING_FUNC(ring_QImage_byteCount)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->byteCount());
}


RING_FUNC(ring_QImage_bytesPerLine)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->bytesPerLine());
}


RING_FUNC(ring_QImage_cacheKey)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->cacheKey());
}


RING_FUNC(ring_QImage_color)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRgb *pValue ; 
		pValue = (QRgb *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRgb)) ;
		*pValue = pObject->color( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRgb",ring_state_free);
	}
}


RING_FUNC(ring_QImage_colorCount)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->colorCount());
}


RING_FUNC(ring_QImage_constBits)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETCPOINTER(pObject->constBits(),"uchar");
}


RING_FUNC(ring_QImage_constScanLine)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->constScanLine( (int ) RING_API_GETNUMBER(2)),"uchar");
}


RING_FUNC(ring_QImage_convertToFormat)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->convertToFormat( (QImage::Format )  (int) RING_API_GETNUMBER(2), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_copy)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->copy( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_createAlphaMask)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->createAlphaMask( (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_createHeuristicMask)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->createHeuristicMask( (bool ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_createMaskFromColor)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->createMaskFromColor(* (QRgb  *) RING_API_GETCPOINTER(2,"QRgb"), (Qt::MaskMode )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRgb"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_depth)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->depth());
}


RING_FUNC(ring_QImage_dotsPerMeterX)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->dotsPerMeterX());
}


RING_FUNC(ring_QImage_dotsPerMeterY)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->dotsPerMeterY());
}


RING_FUNC(ring_QImage_fill)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	pObject->fill(* (QColor *) RING_API_GETCPOINTER(2,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
}


RING_FUNC(ring_QImage_format)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->format());
}


RING_FUNC(ring_QImage_hasAlphaChannel)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->hasAlphaChannel());
}


RING_FUNC(ring_QImage_height)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->height());
}


RING_FUNC(ring_QImage_invertPixels)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->invertPixels( (QImage::InvertMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QImage_isGrayscale)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->isGrayscale());
}


RING_FUNC(ring_QImage_isNull)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QImage_load)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->load(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QImage_loadFromData)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->loadFromData(* (QByteArray *) RING_API_GETCPOINTER(2,"QByteArray"),RING_API_GETSTRING(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QImage_mirrored)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->mirrored( (bool ) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_offset)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->offset();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QImage_pixel)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRgb *pValue ; 
		pValue = (QRgb *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRgb)) ;
		*pValue = pObject->pixel( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRgb",ring_state_free);
	}
}


RING_FUNC(ring_QImage_pixelIndex)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->pixelIndex( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QImage_rect)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->rect();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QImage_rgbSwapped)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->rgbSwapped();
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_save)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->save(RING_API_GETSTRING(2),RING_API_GETSTRING(3), (int ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QImage_scaled)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->scaled( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (Qt::AspectRatioMode )  (int) RING_API_GETNUMBER(4), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_scaledToHeight)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->scaledToHeight( (int ) RING_API_GETNUMBER(2), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_scaledToWidth)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->scaledToWidth( (int ) RING_API_GETNUMBER(2), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_scanLine)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->scanLine( (int ) RING_API_GETNUMBER(2)),"uchar");
}


RING_FUNC(ring_QImage_setColor)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColor( (int ) RING_API_GETNUMBER(2),* (QRgb  *) RING_API_GETCPOINTER(3,"QRgb"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QRgb"));
}


RING_FUNC(ring_QImage_setColorCount)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColorCount( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QImage_setDotsPerMeterX)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDotsPerMeterX( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QImage_setDotsPerMeterY)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDotsPerMeterY( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QImage_setOffset)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	pObject->setOffset(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QImage_setPixel)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPixel( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (uint  *) RING_API_GETCPOINTER(4,"uint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"uint"));
}


RING_FUNC(ring_QImage_setText)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QImage_size)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->size();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QImage_swap)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	pObject->swap(* (QImage *) RING_API_GETCPOINTER(2,"QImage"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
}


RING_FUNC(ring_QImage_text)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->text(RING_API_GETSTRING(2)).toStdString().c_str());
}


RING_FUNC(ring_QImage_textKeys)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->textKeys();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QImage_transformed)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->transformed(* (QMatrix *) RING_API_GETCPOINTER(2,"QMatrix"), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QMatrix"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QImage",ring_QImage_freefunc);
	}
}


RING_FUNC(ring_QImage_valid)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->valid( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QImage_width)
{
	QImage *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QImage *) RING_API_GETCPOINTER(1,"QImage");
	RING_API_RETNUMBER(pObject->width());
}


RING_FUNC(ring_QTextCharFormat_anchorHref)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETSTRING(pObject->anchorHref().toStdString().c_str());
}


RING_FUNC(ring_QTextCharFormat_anchorNames)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->anchorNames();
		RING_API_RETMANAGEDCPOINTER(pValue,"QStringList",ring_QStringList_freefunc);
	}
}


RING_FUNC(ring_QTextCharFormat_font)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->font();
		RING_API_RETMANAGEDCPOINTER(pValue,"QFont",ring_QFont_freefunc);
	}
}


RING_FUNC(ring_QTextCharFormat_fontCapitalization)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontCapitalization());
}


RING_FUNC(ring_QTextCharFormat_fontFamily)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETSTRING(pObject->fontFamily().toStdString().c_str());
}


RING_FUNC(ring_QTextCharFormat_fontFixedPitch)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontFixedPitch());
}


RING_FUNC(ring_QTextCharFormat_fontHintingPreference)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontHintingPreference());
}


RING_FUNC(ring_QTextCharFormat_fontItalic)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontItalic());
}


RING_FUNC(ring_QTextCharFormat_fontKerning)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontKerning());
}


RING_FUNC(ring_QTextCharFormat_fontLetterSpacing)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontLetterSpacing());
}


RING_FUNC(ring_QTextCharFormat_fontLetterSpacingType)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontLetterSpacingType());
}


RING_FUNC(ring_QTextCharFormat_fontOverline)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontOverline());
}


RING_FUNC(ring_QTextCharFormat_fontPointSize)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontPointSize());
}


RING_FUNC(ring_QTextCharFormat_fontStretch)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontStretch());
}


RING_FUNC(ring_QTextCharFormat_fontStrikeOut)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontStrikeOut());
}


RING_FUNC(ring_QTextCharFormat_fontStyleHint)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontStyleHint());
}


RING_FUNC(ring_QTextCharFormat_fontStyleStrategy)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontStyleStrategy());
}


RING_FUNC(ring_QTextCharFormat_fontUnderline)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontUnderline());
}


RING_FUNC(ring_QTextCharFormat_fontWeight)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontWeight());
}


RING_FUNC(ring_QTextCharFormat_fontWordSpacing)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->fontWordSpacing());
}


RING_FUNC(ring_QTextCharFormat_isAnchor)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->isAnchor());
}


RING_FUNC(ring_QTextCharFormat_isValid)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QTextCharFormat_setAnchor)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAnchor( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setAnchorHref)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAnchorHref(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextCharFormat_setAnchorNames)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	pObject->setAnchorNames(* (QStringList    *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QTextCharFormat_setFont_2)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	pObject->setFont(* (QFont    *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QTextCharFormat_setFontCapitalization)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontCapitalization( (QFont::Capitalization )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontFamily)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontFamily(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextCharFormat_setFontFixedPitch)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontFixedPitch( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontHintingPreference)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontHintingPreference( (QFont::HintingPreference )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontItalic)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontItalic( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontKerning)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontKerning( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontLetterSpacing)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontLetterSpacing( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontLetterSpacingType)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontLetterSpacingType( (QFont::SpacingType )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontOverline)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontOverline( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontPointSize)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontPointSize( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontStretch)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontStretch( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontStrikeOut)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontStrikeOut( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontStyleHint)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontStyleHint( (QFont::StyleHint )  (int) RING_API_GETNUMBER(2), (QFont::StyleStrategy )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTextCharFormat_setFontStyleStrategy)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontStyleStrategy( (QFont::StyleStrategy )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontUnderline)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontUnderline( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontWeight)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontWeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setFontWordSpacing)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontWordSpacing( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setTextOutline)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	pObject->setTextOutline(* (QPen    *) RING_API_GETCPOINTER(2,"QPen"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPen"));
}


RING_FUNC(ring_QTextCharFormat_setToolTip)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setToolTip(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextCharFormat_setUnderlineColor)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	pObject->setUnderlineColor(* (QColor    *) RING_API_GETCPOINTER(2,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
}


RING_FUNC(ring_QTextCharFormat_setUnderlineStyle)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUnderlineStyle( (QTextCharFormat::UnderlineStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_setVerticalAlignment)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVerticalAlignment( (QTextCharFormat::VerticalAlignment )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextCharFormat_textOutline)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	{
		QPen *pValue ; 
		pValue = new QPen() ;
		*pValue = pObject->textOutline();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPen",ring_QPen_freefunc);
	}
}


RING_FUNC(ring_QTextCharFormat_toolTip)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETSTRING(pObject->toolTip().toStdString().c_str());
}


RING_FUNC(ring_QTextCharFormat_underlineColor)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->underlineColor();
		RING_API_RETMANAGEDCPOINTER(pValue,"QColor",ring_QColor_freefunc);
	}
}


RING_FUNC(ring_QTextCharFormat_underlineStyle)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->underlineStyle());
}


RING_FUNC(ring_QTextCharFormat_verticalAlignment)
{
	QTextCharFormat *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTextCharFormat *) RING_API_GETCPOINTER(1,"QTextCharFormat");
	RING_API_RETNUMBER(pObject->verticalAlignment());
}


RING_FUNC(ring_QFontMetrics_ascent)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->ascent());
}


RING_FUNC(ring_QFontMetrics_averageCharWidth)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->averageCharWidth());
}


RING_FUNC(ring_QFontMetrics_boundingRect)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->boundingRect(* (QChar  *) RING_API_GETCPOINTER(2,"QChar"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QFontMetrics_boundingRect_2)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->boundingRect(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QFontMetrics_boundingRect_3)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 9 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(8) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(9) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->boundingRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6),RING_API_GETSTRING(7), (int ) RING_API_GETNUMBER(8),RING_API_GETINTPOINTER(9));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
	RING_API_ACCEPTINTVALUE(8) ;
}


RING_FUNC(ring_QFontMetrics_boundingRect_4)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->boundingRect(* (QRect    *) RING_API_GETCPOINTER(2,"QRect"), (int ) RING_API_GETNUMBER(3),RING_API_GETSTRING(4), (int ) RING_API_GETNUMBER(5),RING_API_GETINTPOINTER(6));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
	RING_API_ACCEPTINTVALUE(5) ;
}


RING_FUNC(ring_QFontMetrics_descent)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->descent());
}


RING_FUNC(ring_QFontMetrics_elidedText)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->elidedText(RING_API_GETSTRING(2), (Qt::TextElideMode )  (int) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5)).toStdString().c_str());
}


RING_FUNC(ring_QFontMetrics_height)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->height());
}


RING_FUNC(ring_QFontMetrics_inFont)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->inFont(* (QChar  *) RING_API_GETCPOINTER(2,"QChar")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QFontMetrics_inFontUcs4)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->inFontUcs4(* (uint  *) RING_API_GETCPOINTER(2,"uint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"uint"));
}


RING_FUNC(ring_QFontMetrics_leading)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->leading());
}


RING_FUNC(ring_QFontMetrics_leftBearing)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->leftBearing(* (QChar  *) RING_API_GETCPOINTER(2,"QChar")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QFontMetrics_lineSpacing)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->lineSpacing());
}


RING_FUNC(ring_QFontMetrics_lineWidth)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->lineWidth());
}


RING_FUNC(ring_QFontMetrics_maxWidth)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->maxWidth());
}


RING_FUNC(ring_QFontMetrics_minLeftBearing)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->minLeftBearing());
}


RING_FUNC(ring_QFontMetrics_minRightBearing)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->minRightBearing());
}


RING_FUNC(ring_QFontMetrics_overlinePos)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->overlinePos());
}


RING_FUNC(ring_QFontMetrics_rightBearing)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->rightBearing(* (QChar  *) RING_API_GETCPOINTER(2,"QChar")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QFontMetrics_size)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->size( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3), (int ) RING_API_GETNUMBER(4),RING_API_GETINTPOINTER(5));
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QFontMetrics_strikeOutPos)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->strikeOutPos());
}


RING_FUNC(ring_QFontMetrics_tightBoundingRect)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->tightBoundingRect(RING_API_GETSTRING(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QFontMetrics_underlinePos)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->underlinePos());
}


RING_FUNC(ring_QFontMetrics_width)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->width(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QFontMetrics_width_2)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->width(* (QChar  *) RING_API_GETCPOINTER(2,"QChar")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QChar"));
}


RING_FUNC(ring_QFontMetrics_xHeight)
{
	QFontMetrics *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFontMetrics *) RING_API_GETCPOINTER(1,"QFontMetrics");
	RING_API_RETNUMBER(pObject->xHeight());
}


RING_FUNC(ring_QLinearGradient_finalStop)
{
	QLinearGradient *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLinearGradient *) RING_API_GETCPOINTER(1,"QLinearGradient");
	{
		QPointF *pValue ; 
		pValue = new QPointF() ;
		*pValue = pObject->finalStop();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPointF",ring_QPointF_freefunc);
	}
}


RING_FUNC(ring_QLinearGradient_setFinalStop)
{
	QLinearGradient *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLinearGradient *) RING_API_GETCPOINTER(1,"QLinearGradient");
	pObject->setFinalStop(* (QPointF  *) RING_API_GETCPOINTER(2,"QPointF"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPointF"));
}


RING_FUNC(ring_QLinearGradient_setFinalStop_2)
{
	QLinearGradient *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLinearGradient *) RING_API_GETCPOINTER(1,"QLinearGradient");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFinalStop( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QLinearGradient_setStart)
{
	QLinearGradient *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLinearGradient *) RING_API_GETCPOINTER(1,"QLinearGradient");
	pObject->setStart(* (QPointF  *) RING_API_GETCPOINTER(2,"QPointF"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPointF"));
}


RING_FUNC(ring_QLinearGradient_setStart_2)
{
	QLinearGradient *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLinearGradient *) RING_API_GETCPOINTER(1,"QLinearGradient");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStart( (qreal ) RING_API_GETNUMBER(2), (qreal ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QLinearGradient_start)
{
	QLinearGradient *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLinearGradient *) RING_API_GETCPOINTER(1,"QLinearGradient");
	{
		QPointF *pValue ; 
		pValue = new QPointF() ;
		*pValue = pObject->start();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPointF",ring_QPointF_freefunc);
	}
}


RING_FUNC(ring_QGradient_coordinateMode)
{
	QGradient *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QGradient *) RING_API_GETCPOINTER(1,"QGradient");
	RING_API_RETNUMBER(pObject->coordinateMode());
}


RING_FUNC(ring_QGradient_setColorAt)
{
	QGradient *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QGradient *) RING_API_GETCPOINTER(1,"QGradient");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColorAt( (qreal ) RING_API_GETNUMBER(2),* (QColor    *) RING_API_GETCPOINTER(3,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QColor"));
}


RING_FUNC(ring_QGradient_setCoordinateMode)
{
	QGradient *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QGradient *) RING_API_GETCPOINTER(1,"QGradient");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCoordinateMode( (QGradient::CoordinateMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QGradient_setSpread)
{
	QGradient *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QGradient *) RING_API_GETCPOINTER(1,"QGradient");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSpread( (QGradient::Spread )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QGradient_setStops)
{
	QGradient *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QGradient *) RING_API_GETCPOINTER(1,"QGradient");
	pObject->setStops(* (QGradientStops  *) RING_API_GETCPOINTER(2,"QGradientStops"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QGradientStops"));
}


RING_FUNC(ring_QGradient_spread)
{
	QGradient *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QGradient *) RING_API_GETCPOINTER(1,"QGradient");
	RING_API_RETNUMBER(pObject->spread());
}


RING_FUNC(ring_QGradient_stops)
{
	QGradient *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QGradient *) RING_API_GETCPOINTER(1,"QGradient");
	{
		QGradientStops *pValue ; 
		pValue = (QGradientStops *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QGradientStops)) ;
		*pValue = pObject->stops();
		RING_API_RETMANAGEDCPOINTER(pValue,"QGradientStops",ring_state_free);
	}
}


RING_FUNC(ring_QGradient_type)
{
	QGradient *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QGradient *) RING_API_GETCPOINTER(1,"QGradient");
	RING_API_RETNUMBER(pObject->type());
}


RING_FUNC(ring_QCursor_bitmap)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	RING_API_RETCPOINTER(pObject->bitmap(),"QBitmap");
}


RING_FUNC(ring_QCursor_hotSpot)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->hotSpot();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QCursor_mask)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	RING_API_RETCPOINTER(pObject->mask(),"QBitmap");
}


RING_FUNC(ring_QCursor_pixmap)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->pixmap();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QCursor_setShape)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setShape( (Qt::CursorShape )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QCursor_shape)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	RING_API_RETNUMBER(pObject->shape());
}


RING_FUNC(ring_QCursor_pos)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->pos();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QCursor_pos_2)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->pos((QScreen *) RING_API_GETCPOINTER(2,"QScreen"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QCursor_setPos)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPos( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QCursor_setPos_2)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPos((QScreen *) RING_API_GETCPOINTER(2,"QScreen"), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4));
}


RING_FUNC(ring_QCursor_setPos_3)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	pObject->setPos(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QCursor_setPos_4)
{
	QCursor *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QCursor *) RING_API_GETCPOINTER(1,"QCursor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPos((QScreen *) RING_API_GETCPOINTER(2,"QScreen"),* (QPoint *) RING_API_GETCPOINTER(3,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QPoint"));
}


RING_FUNC(ring_QScreen_angleBetween)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->angleBetween(* (Qt::ScreenOrientation  *) RING_API_GETCPOINTER(2,"Qt::ScreenOrientation"),* (Qt::ScreenOrientation  *) RING_API_GETCPOINTER(3,"Qt::ScreenOrientation")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"Qt::ScreenOrientation"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"Qt::ScreenOrientation"));
}


RING_FUNC(ring_QScreen_availableGeometry)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->availableGeometry();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QScreen_availableSize)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->availableSize();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QScreen_availableVirtualGeometry)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->availableVirtualGeometry();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QScreen_availableVirtualSize)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->availableVirtualSize();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QScreen_depth)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->depth());
}


RING_FUNC(ring_QScreen_devicePixelRatio)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->devicePixelRatio());
}


RING_FUNC(ring_QScreen_geometry)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->geometry();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QScreen_grabWindow)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->grabWindow( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QScreen_grabWindow_2)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->grabWindow( (int ) RING_API_GETNUMBER(2));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPixmap",ring_QPixmap_freefunc);
	}
}


RING_FUNC(ring_QScreen_handle)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETCPOINTER(pObject->handle(),"QPlatformScreen");
}


RING_FUNC(ring_QScreen_isLandscape)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->isLandscape(* (Qt::ScreenOrientation  *) RING_API_GETCPOINTER(2,"Qt::ScreenOrientation")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"Qt::ScreenOrientation"));
}


RING_FUNC(ring_QScreen_isPortrait)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->isPortrait(* (Qt::ScreenOrientation  *) RING_API_GETCPOINTER(2,"Qt::ScreenOrientation")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"Qt::ScreenOrientation"));
}


RING_FUNC(ring_QScreen_logicalDotsPerInch)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->logicalDotsPerInch());
}


RING_FUNC(ring_QScreen_logicalDotsPerInchX)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->logicalDotsPerInchX());
}


RING_FUNC(ring_QScreen_logicalDotsPerInchY)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->logicalDotsPerInchY());
}


RING_FUNC(ring_QScreen_mapBetween)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->mapBetween(* (Qt::ScreenOrientation  *) RING_API_GETCPOINTER(2,"Qt::ScreenOrientation"),* (Qt::ScreenOrientation  *) RING_API_GETCPOINTER(3,"Qt::ScreenOrientation"),* (QRect  *) RING_API_GETCPOINTER(4,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"Qt::ScreenOrientation"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"Qt::ScreenOrientation"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QRect"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QScreen_name)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETSTRING(pObject->name().toStdString().c_str());
}


RING_FUNC(ring_QScreen_nativeOrientation)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		Qt::ScreenOrientation *pValue ; 
		pValue = (Qt::ScreenOrientation *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(Qt::ScreenOrientation)) ;
		*pValue = pObject->nativeOrientation();
		RING_API_RETMANAGEDCPOINTER(pValue,"Qt::ScreenOrientation",ring_state_free);
	}
}


RING_FUNC(ring_QScreen_orientation)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		Qt::ScreenOrientation *pValue ; 
		pValue = (Qt::ScreenOrientation *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(Qt::ScreenOrientation)) ;
		*pValue = pObject->orientation();
		RING_API_RETMANAGEDCPOINTER(pValue,"Qt::ScreenOrientation",ring_state_free);
	}
}


RING_FUNC(ring_QScreen_orientationUpdateMask)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		Qt::ScreenOrientations *pValue ; 
		pValue = (Qt::ScreenOrientations *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(Qt::ScreenOrientations)) ;
		*pValue = pObject->orientationUpdateMask();
		RING_API_RETMANAGEDCPOINTER(pValue,"Qt::ScreenOrientations",ring_state_free);
	}
}


RING_FUNC(ring_QScreen_physicalDotsPerInch)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->physicalDotsPerInch());
}


RING_FUNC(ring_QScreen_physicalDotsPerInchX)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->physicalDotsPerInchX());
}


RING_FUNC(ring_QScreen_physicalDotsPerInchY)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->physicalDotsPerInchY());
}


RING_FUNC(ring_QScreen_physicalSize)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		QSizeF *pValue ; 
		pValue = (QSizeF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QSizeF)) ;
		*pValue = pObject->physicalSize();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSizeF",ring_state_free);
	}
}


RING_FUNC(ring_QScreen_primaryOrientation)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		Qt::ScreenOrientation *pValue ; 
		pValue = (Qt::ScreenOrientation *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(Qt::ScreenOrientation)) ;
		*pValue = pObject->primaryOrientation();
		RING_API_RETMANAGEDCPOINTER(pValue,"Qt::ScreenOrientation",ring_state_free);
	}
}


RING_FUNC(ring_QScreen_refreshRate)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	RING_API_RETNUMBER(pObject->refreshRate());
}


RING_FUNC(ring_QScreen_setOrientationUpdateMask)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	pObject->setOrientationUpdateMask(* (Qt::ScreenOrientations  *) RING_API_GETCPOINTER(2,"Qt::ScreenOrientations"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"Qt::ScreenOrientations"));
}


RING_FUNC(ring_QScreen_size)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->size();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QScreen_transformBetween)
{
	QScreen *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QScreen *) RING_API_GETCPOINTER(1,"QScreen");
	{
		QTransform *pValue ; 
		pValue = (QTransform *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform)) ;
		*pValue = pObject->transformBetween(* (Qt::ScreenOrientation  *) RING_API_GETCPOINTER(2,"Qt::ScreenOrientation"),* (Qt::ScreenOrientation  *) RING_API_GETCPOINTER(3,"Qt::ScreenOrientation"),* (QRect  *) RING_API_GETCPOINTER(4,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"Qt::ScreenOrientation"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"Qt::ScreenOrientation"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QRect"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QTransform",ring_state_free);
	}
}


RING_FUNC(ring_QWindow_baseSize)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->baseSize();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QWindow_contentOrientation)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		Qt::ScreenOrientation *pValue ; 
		pValue = (Qt::ScreenOrientation *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(Qt::ScreenOrientation)) ;
		*pValue = pObject->contentOrientation();
		RING_API_RETMANAGEDCPOINTER(pValue,"Qt::ScreenOrientation",ring_state_free);
	}
}


RING_FUNC(ring_QWindow_create)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->create();
}


RING_FUNC(ring_QWindow_cursor)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QCursor *pValue ; 
		pValue = new QCursor() ;
		*pValue = pObject->cursor();
		RING_API_RETMANAGEDCPOINTER(pValue,"QCursor",ring_QCursor_freefunc);
	}
}


RING_FUNC(ring_QWindow_destroy)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->destroy();
}


RING_FUNC(ring_QWindow_devicePixelRatio)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->devicePixelRatio());
}


RING_FUNC(ring_QWindow_filePath)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->filePath().toStdString().c_str());
}


RING_FUNC(ring_QWindow_flags)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->flags());
}


RING_FUNC(ring_QWindow_focusObject)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETCPOINTER(pObject->focusObject(),"QObject");
}


RING_FUNC(ring_QWindow_frameGeometry)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->frameGeometry();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QWindow_frameMargins)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QMargins *pValue ; 
		pValue = (QMargins *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMargins)) ;
		*pValue = pObject->frameMargins();
		RING_API_RETMANAGEDCPOINTER(pValue,"QMargins",ring_state_free);
	}
}


RING_FUNC(ring_QWindow_framePosition)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->framePosition();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QWindow_geometry)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->geometry();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRect",ring_QRect_freefunc);
	}
}


RING_FUNC(ring_QWindow_height)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->height());
}


RING_FUNC(ring_QWindow_icon)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->icon();
		RING_API_RETMANAGEDCPOINTER(pValue,"QIcon",ring_QIcon_freefunc);
	}
}


RING_FUNC(ring_QWindow_isActive)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->isActive());
}


RING_FUNC(ring_QWindow_isAncestorOf)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isAncestorOf((QWindow *) RING_API_GETCPOINTER(2,"QWindow"), (QWindow::AncestorMode )  (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QWindow_isExposed)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->isExposed());
}


RING_FUNC(ring_QWindow_isModal)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->isModal());
}


RING_FUNC(ring_QWindow_isTopLevel)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->isTopLevel());
}


RING_FUNC(ring_QWindow_isVisible)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->isVisible());
}


RING_FUNC(ring_QWindow_mapFromGlobal)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->mapFromGlobal(* (QPoint  *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QWindow_mapToGlobal)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->mapToGlobal(* (QPoint  *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QWindow_mask)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QRegion *pValue ; 
		pValue = new QRegion() ;
		*pValue = pObject->mask();
		RING_API_RETMANAGEDCPOINTER(pValue,"QRegion",ring_QRegion_freefunc);
	}
}


RING_FUNC(ring_QWindow_maximumHeight)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->maximumHeight());
}


RING_FUNC(ring_QWindow_maximumSize)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->maximumSize();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QWindow_maximumWidth)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->maximumWidth());
}


RING_FUNC(ring_QWindow_minimumHeight)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->minimumHeight());
}


RING_FUNC(ring_QWindow_minimumSize)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->minimumSize();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QWindow_minimumWidth)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->minimumWidth());
}


RING_FUNC(ring_QWindow_modality)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->modality());
}


RING_FUNC(ring_QWindow_opacity)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->opacity());
}


RING_FUNC(ring_QWindow_position)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->position();
		RING_API_RETMANAGEDCPOINTER(pValue,"QPoint",ring_QPoint_freefunc);
	}
}


RING_FUNC(ring_QWindow_reportContentOrientationChange)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->reportContentOrientationChange(* (Qt::ScreenOrientation  *) RING_API_GETCPOINTER(2,"Qt::ScreenOrientation"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"Qt::ScreenOrientation"));
}


RING_FUNC(ring_QWindow_requestedFormat)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QSurfaceFormat *pValue ; 
		pValue = (QSurfaceFormat *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QSurfaceFormat)) ;
		*pValue = pObject->requestedFormat();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSurfaceFormat",ring_state_free);
	}
}


RING_FUNC(ring_QWindow_resize)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->resize(* (QSize  *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QWindow_resize_2)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->resize( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWindow_screen)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETCPOINTER(pObject->screen(),"QScreen");
}


RING_FUNC(ring_QWindow_setBaseSize)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setBaseSize(* (QSize  *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QWindow_setCursor)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setCursor(* (QCursor  *) RING_API_GETCPOINTER(2,"QCursor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QCursor"));
}


RING_FUNC(ring_QWindow_setFilePath)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFilePath(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setFlags)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFlags( (Qt::WindowFlags )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setFormat)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setFormat(* (QSurfaceFormat  *) RING_API_GETCPOINTER(2,"QSurfaceFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSurfaceFormat"));
}


RING_FUNC(ring_QWindow_setFramePosition)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setFramePosition(* (QPoint  *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QWindow_setGeometry)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setGeometry( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QWindow_setGeometry_2)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setGeometry(* (QRect  *) RING_API_GETCPOINTER(2,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
}


RING_FUNC(ring_QWindow_setIcon)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setIcon(* (QIcon  *) RING_API_GETCPOINTER(2,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QIcon"));
}


RING_FUNC(ring_QWindow_setKeyboardGrabEnabled)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setKeyboardGrabEnabled( (bool ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QWindow_setMask)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setMask(* (QRegion  *) RING_API_GETCPOINTER(2,"QRegion"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRegion"));
}


RING_FUNC(ring_QWindow_setMaximumSize)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setMaximumSize(* (QSize  *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QWindow_setMinimumSize)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setMinimumSize(* (QSize  *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QWindow_setModality)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setModality( (Qt::WindowModality )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setMouseGrabEnabled)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setMouseGrabEnabled( (bool ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QWindow_setOpacity)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOpacity( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setParent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setParent((QWindow *) RING_API_GETCPOINTER(2,"QWindow"));
}


RING_FUNC(ring_QWindow_setPosition)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setPosition(* (QPoint  *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QWindow_setPosition_2)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPosition( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWindow_setScreen)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setScreen((QScreen *) RING_API_GETCPOINTER(2,"QScreen"));
}


RING_FUNC(ring_QWindow_setSizeIncrement)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->setSizeIncrement(* (QSize  *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QWindow_setTransientParent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTransientParent((QWindow *) RING_API_GETCPOINTER(2,"QWindow"));
}


RING_FUNC(ring_QWindow_setVisibility)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVisibility( (QWindow::Visibility )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setWindowState)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowState( (Qt::WindowState )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_sizeIncrement)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeIncrement();
		RING_API_RETMANAGEDCPOINTER(pValue,"QSize",ring_QSize_freefunc);
	}
}


RING_FUNC(ring_QWindow_title)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->title().toStdString().c_str());
}


RING_FUNC(ring_QWindow_transientParent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETCPOINTER(pObject->transientParent(),"QWindow");
}


RING_FUNC(ring_QWindow_type)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->type());
}


RING_FUNC(ring_QWindow_unsetCursor)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->unsetCursor();
}


RING_FUNC(ring_QWindow_visibility)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->visibility());
}


RING_FUNC(ring_QWindow_width)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->width());
}


RING_FUNC(ring_QWindow_winId)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	{
		WId *pValue ; 
		pValue = (WId *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(WId)) ;
		*pValue = pObject->winId();
		RING_API_RETMANAGEDCPOINTER(pValue,"WId",ring_state_free);
	}
}


RING_FUNC(ring_QWindow_windowState)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->windowState());
}


RING_FUNC(ring_QWindow_x)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->x());
}


RING_FUNC(ring_QWindow_y)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->y());
}


RING_FUNC(ring_QWindow_alert)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->alert( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_close)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETNUMBER(pObject->close());
}


RING_FUNC(ring_QWindow_hide)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->hide();
}


RING_FUNC(ring_QWindow_lower)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->lower();
}


RING_FUNC(ring_QWindow_raise)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->raise();
}


RING_FUNC(ring_QWindow_requestActivate)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->requestActivate();
}


RING_FUNC(ring_QWindow_setHeight)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setMaximumHeight)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaximumHeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setMaximumWidth)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaximumWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setMinimumHeight)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMinimumHeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setMinimumWidth)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMinimumWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setTitle)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTitle(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setVisible)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVisible( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setWidth)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setX)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setX( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_setY)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setY( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWindow_show)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->show();
}


RING_FUNC(ring_QWindow_showFullScreen)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->showFullScreen();
}


RING_FUNC(ring_QWindow_showMaximized)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->showMaximized();
}


RING_FUNC(ring_QWindow_showMinimized)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->showMinimized();
}


RING_FUNC(ring_QWindow_showNormal)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	pObject->showNormal();
}


RING_FUNC(ring_QWindow_fromWinId)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETCPOINTER(pObject->fromWinId(* (WId  *) RING_API_GETCPOINTER(2,"WId")),"QWindow");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"WId"));
}


RING_FUNC(ring_QWindow_setactiveChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setactiveChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setcontentOrientationChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcontentOrientationChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setfocusObjectChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setfocusObjectChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setheightChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setheightChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setmaximumHeightChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setmaximumHeightChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setmaximumWidthChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setmaximumWidthChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setminimumHeightChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setminimumHeightChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setminimumWidthChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setminimumWidthChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setmodalityChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setmodalityChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setopacityChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setopacityChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setscreenChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setscreenChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setvisibilityChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setvisibilityChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setvisibleChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setvisibleChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setwidthChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setwidthChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setwindowStateChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setwindowStateChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setwindowTitleChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setwindowTitleChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setxChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setxChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_setyChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setyChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWindow_getactiveChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getactiveChangedEvent());
}


RING_FUNC(ring_QWindow_getcontentOrientationChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getcontentOrientationChangedEvent());
}


RING_FUNC(ring_QWindow_getfocusObjectChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getfocusObjectChangedEvent());
}


RING_FUNC(ring_QWindow_getheightChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getheightChangedEvent());
}


RING_FUNC(ring_QWindow_getmaximumHeightChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getmaximumHeightChangedEvent());
}


RING_FUNC(ring_QWindow_getmaximumWidthChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getmaximumWidthChangedEvent());
}


RING_FUNC(ring_QWindow_getminimumHeightChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getminimumHeightChangedEvent());
}


RING_FUNC(ring_QWindow_getminimumWidthChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getminimumWidthChangedEvent());
}


RING_FUNC(ring_QWindow_getmodalityChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getmodalityChangedEvent());
}


RING_FUNC(ring_QWindow_getopacityChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getopacityChangedEvent());
}


RING_FUNC(ring_QWindow_getscreenChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getscreenChangedEvent());
}


RING_FUNC(ring_QWindow_getvisibilityChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getvisibilityChangedEvent());
}


RING_FUNC(ring_QWindow_getvisibleChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getvisibleChangedEvent());
}


RING_FUNC(ring_QWindow_getwidthChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getwidthChangedEvent());
}


RING_FUNC(ring_QWindow_getwindowStateChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getwindowStateChangedEvent());
}


RING_FUNC(ring_QWindow_getwindowTitleChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getwindowTitleChangedEvent());
}


RING_FUNC(ring_QWindow_getxChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getxChangedEvent());
}


RING_FUNC(ring_QWindow_getyChangedEvent)
{
	GWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GWindow *) RING_API_GETCPOINTER(1,"QWindow");
	RING_API_RETSTRING(pObject->getyChangedEvent());
}


RING_FUNC(ring_QGuiApplication_devicePixelRatio)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	RING_API_RETNUMBER(pObject->devicePixelRatio());
}


RING_FUNC(ring_QGuiApplication_isSavingSession)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	RING_API_RETNUMBER(pObject->isSavingSession());
}


RING_FUNC(ring_QGuiApplication_isSessionRestored)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	RING_API_RETNUMBER(pObject->isSessionRestored());
}


RING_FUNC(ring_QGuiApplication_sessionId)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	RING_API_RETSTRING(pObject->sessionId().toStdString().c_str());
}


RING_FUNC(ring_QGuiApplication_sessionKey)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	RING_API_RETSTRING(pObject->sessionKey().toStdString().c_str());
}


RING_FUNC(ring_QGuiApplication_allWindows)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	{
		QWindowList *pValue ; 
		pValue = (QWindowList *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QWindowList)) ;
		*pValue = pObject->allWindows();
		RING_API_RETMANAGEDCPOINTER(pValue,"QWindowList",ring_state_free);
	}
}


RING_FUNC(ring_QGuiApplication_applicationDisplayName)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	RING_API_RETSTRING(pObject->applicationDisplayName().toStdString().c_str());
}


RING_FUNC(ring_QGuiApplication_applicationState)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	{
		Qt::ApplicationState *pValue ; 
		pValue = (Qt::ApplicationState *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(Qt::ApplicationState)) ;
		*pValue = pObject->applicationState();
		RING_API_RETMANAGEDCPOINTER(pValue,"Qt::ApplicationState",ring_state_free);
	}
}


RING_FUNC(ring_QGuiApplication_changeOverrideCursor)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	pObject->changeOverrideCursor(* (QCursor  *) RING_API_GETCPOINTER(2,"QCursor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QCursor"));
}


RING_FUNC(ring_QGuiApplication_clipboard)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	RING_API_RETCPOINTER(pObject->clipboard(),"QClipboard");
}


RING_FUNC(ring_QGuiApplication_desktopSettingsAware)
{
	GGuiApplication *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GGuiApplication *) RING_API_GETCPOINTER(1,"QGuiApplication");
	