/**
 * @(#)SWFPlaceObject2Tag.java
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/9/19
 */
package	jp.co.iti.swf;

import	java.io.*;

/**
 * SWF PlaceObject2 TAG(ID=26)\B
 */
public class SWFPlaceObject2Tag extends SWFTag implements hasSWFActionRecord{
	private	int					myFlags;
	private	int					myDepth;
	private	int					myClipDepth;
	private	int					myCharacterId;
	private	SWFMatrix			myMatrix;
	private	SWFCxform			myCxform;
	private	int					myRatio;
	private	String				myName;
	private	SWFActionRecords	myActionRecords;
	
	private	static final int HasClipActions	= 0x80;
	private	static final int HasClipDepth	= 0x40;
	private	static final int HasName		= 0x20;
	private	static final int HasRatio		= 0x10;
	private	static final int HasCXFORM		= 0x08;
	private	static final int HasMATRIX		= 0x04;
	private	static final int HasCharacter	= 0x02;
	
	private static final int CLIP_ACTION_ON_LOAD     = 0x01;
	private static final int CLIP_ACTION_ENTER_FRAME = 0x02;
	private static final int CLIP_ACTION_UNLOAD      = 0x04;
	private static final int CLIP_ACTION_MOUSE_MOVE  = 0x08;
	private static final int CLIP_ACTION_MOUSE_DOWN  = 0x10;
	private static final int CLIP_ACTION_MOUSE_UP    = 0x20;
	private static final int CLIP_ACTION_KEY_DOWN    = 0x40;
	private static final int CLIP_ACTION_KEY_UP      = 0x80;
	private static final int CLIP_ACTION_DATA        = 0x100;
	
	public	SWFPlaceObject2Tag(int id ,byte[] data, int ver)
	throws SWFPlaceObject2TagException ,SWFActionRecordException ,SWFActionRecordsException{
		super(id ,data);
		
		myActionRecords = new SWFActionRecords();
		SWFInputStream swfstream = new SWFInputStream(new ByteArrayInputStream(data));
		try{
			try{
				myFlags			= swfstream.readUI8();		// Place Flags
				myDepth			= swfstream.readUI16();		// Depth
				if(0!=(HasCharacter	& myFlags))	myCharacterId	= swfstream.readUI16();		// Character Id
				if(0!=(HasMATRIX	& myFlags))	myMatrix		= swfstream.readMatrix();
				if(0!=(HasCXFORM	& myFlags))	myCxform		= swfstream.readCxform(false);
				if(0!=(HasRatio		& myFlags))	myRatio			= swfstream.readUI16();		// Ratio
				if(0!=(HasName		& myFlags))	myName			= swfstream.readString();	// Name
				if(0!=(HasClipDepth	& myFlags))	myClipDepth		= swfstream.readUI16();		// Clip Depth
				
				if(0!=(HasClipActions & myFlags)){
					swfstream.readUI16();	// gp
					if(5 < ver)	swfstream.readUI32();	// ClipActionstO
					else		swfstream.readUI16();	// ClipActionstO
					
					while(true){
						long flag = (5 < ver) ? swfstream.readUI32() : swfstream.readUI16();
						if(0==flag)	break;

						long length = swfstream.readUI32();
						myActionRecords.readRecords(swfstream);
					}
				}
			}finally{ swfstream.close(); }
		}catch(IOException e){ throw new SWFPlaceObject2TagException(); }
	}
	
	public	SWFActionRecord[]	getActionRecords(){ return myActionRecords.getActionRecords(); }
}
