/**
 * @(#)SWFButtonRecord.java
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/4
 */
package	jp.co.iti.swf;

import	java.io.*;

/**
 * SWF BUTTON TAG(ID=7)ButtonRecord\B
 */
public class SWFButtonRecord{
	public	static	final	int	END		=	0x00;
	
	public	static	final	int	HITTEST	=	0x08;
	public	static	final	int	DOWN	=	0x04;
	public	static	final	int	OVER	=	0x02;
	public	static	final	int	UP		=	0x01;
	
	private	int			myFlags;
	private	int			myCharacter;
	private	int			myLayer;
	private	SWFMatrix	myMatrix;
	private	SWFCxform	myCxform;
	
	public	SWFButtonRecord(int flags ,int character ,int layer ,SWFMatrix matrix ,SWFCxform cxform){
		myFlags		=	flags;
		myCharacter	=	character;
		myLayer		=	layer;
		myMatrix	=	(SWFMatrix)matrix.clone();
		myCxform	=	(SWFCxform)cxform.clone();
	}
	
	public	int			getFlags(){		return myFlags; }
	public	int			getCharacter(){	return myCharacter; }
	public	int			getLayer(){		return myLayer; }
	public	SWFMatrix	getMatrix(){	return (SWFMatrix)myMatrix.clone(); }
	public	SWFCxform	getCxform(){	return (SWFCxform)myCxform.clone(); }
}
