/**
 * @(#)elementBooster.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : element booster
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2001/03/25
 * @see 
 */

package	jp.co.nri.rid.xml;

// java
import	java.util.*;

// W3C DOM
import	org.w3c.dom.*;

/**
 * org.w3c.dom.Elementg₷邽߂̃bp[
 */

public class elementBooster{
	
	/**
	 * @param	document	hLg
	 * @param	element		Gg
	 * @since	1.00
	 */
	public	elementBooster(documentBooster document ,Element element){
		myDocument	=	document;
		myElement	=	element;
	}
	
	/**
	 * @param	document	hLg
	 * @param	name		Gg
	 * @since	1.00
	 */
	public	elementBooster(documentBooster document ,String name){
		myDocument	=	document;
		myElement	=	myDocument.document().createElement(name);
	}
	
	/**
	 * @param	element		Gg
	 * @since	1.00
	 */
	public	elementBooster(Element element){
		myDocument	=	new documentBooster(element.getOwnerDocument());
		myElement	=	element;
	}
	
	/**
	 * Rs[RXgN^
	 * @param	element		Rs[elementBoosterIuWFNg
	 * @since	1.00
	 */
	public	elementBooster(elementBooster element){
		myDocument	=	element.document();
		myElement	=	element.element();
	}
	
	/**
	 * hLg擾B
	 * @return	̃Gg̓ĂhLg
	 * @since	1.00
	 */
	public	documentBooster	document(){	return myDocument;	}
	
	/**
	 * ElementIuWFNg擾B
	 * @return	ElementIuWFNg
	 * @since	1.00
	 */
	public	Element			element(){	return myElement;	}
	
	/**
	 * ̃IuWFNgnullǂ𔻒肷B
	 * @return	nullȂtrue
	 * @since	1.00
	 */
	public	boolean isNull(){
		if(null==myElement)	return true;
		return false;
	}
	
	/**
	 * ̃Gg̃^O擾B
	 * @return	̃Gg̃^OB
	 * @since	1.00
	 */
	public	String	tagname(){ return myElement.getTagName(); }
	
	/**
	 * ̃Gg̃eLXgݒ肷B
	 * @param	text	eLXglB
	 * @since	1.00
	 */
	public	void	text(String text){
		removeText();
		myElement.appendChild(myElement.getOwnerDocument().createTextNode(text));
	}
	
	/**
	 * ̃Gg̃eLXg폜B
	 * @since	1.00
	 */
	protected	void	removeText(){
		NodeList	nl = myElement.getChildNodes();
		
		int mx = nl.getLength();
		for(int i = 0;i < mx;i++){
			Node n = nl.item(i);
			if(Node.TEXT_NODE == n.getNodeType()) myElement.removeChild(n);
		}
	}
	
	/**
	 * ̃Gg̃eLXg擾B
	 * @return	̃Gg̃eLXgB
	 * @since	1.00
	 */
	public	String	text(){
		NodeList	nl = myElement.getChildNodes();
		
		int mx = nl.getLength();
		for(int i = 0;i < mx;i++){
			Node n = nl.item(i);
			if(Node.TEXT_NODE == n.getNodeType()){
				String s;
//				try{ s = n.getNodeValue().trim(); }
				try{ s = n.getNodeValue(); }
				catch(NullPointerException e){ return null; }
				if(s.length() > 0)	return s;
				return null;
			}
		}
		
		return null;
	}
	
	/**
	 * ̃Gg̑ݒ肷B
	 * @param	name	B
	 * @param	value	lB
	 * @since	1.00
	 */
	public	void	attribute(String name ,String value){
		if(null==name)	return;
		if(null==value)				myElement.removeAttribute(name);
		else if(0>=value.length())	myElement.removeAttribute(name);
		else						myElement.setAttribute(name ,value);
	}
	
	
	/**
	 * ̃Gg̑l擾B
	 * @param	name	B
	 * @return	lB
	 * @since	1.00
	 */
	public	String	attribute(String name){
		String attribute = myElement.getAttribute(name);
		if(null==attribute)	return null;
//		if(0<attribute.trim().length())	return attribute;
		if(0<attribute.length())	return attribute;
		return null;
	}
	
	/**
	 * ̃Gg̑l擾B(int)
	 * @param	name	B
	 * @return	lB
	 * @since	1.00
	 */
	public	int	attributeInt(String name){
		return numeric(attribute(name));
	}
	
	/**
	 * ̃Gg̑Xg擾B
	 * @return	XgB
	 * @since	1.00
	 */
	public	Attributes	attributes(){
		NamedNodeMap	nnm = myElement.getAttributes();
		
		Attributes attributes = new Attributes();
		
		int mx = nnm.getLength();
		for(int i = 0;i < mx;i++){
			Node n = nnm.item(i);
//			String value = n.getNodeValue().trim();
			String value = n.getNodeValue();
			if(0 >= value.length())	continue;
			attributes.add(n.getNodeName() ,value);
		}
		
		if(0 < attributes.count())	return attributes;
		return null;
	}
	
	/**
	 * ̃Gg̑ݒ肷BꊇŐݒłB
	 * @param	attributes	XgB
	 * @since	1.00
	 */
	public void attributes(Attributes attributes){
		if(null==attributes)	return;
		
		Attribute[] a = attributes.attributes();
		if(null==a)	return;
		
		int mx = a.length;
		for(int i = 0;i < mx;i++) attribute(a[i].name ,a[i].value);
	}
	
	/**
	 * ̃Gg̍ŏ̎qGg̑Xg擾B
	 * @param	name	^OB
	 * @since	1.00
	 */
	public	Attributes	childAttributes(String name){
		elementBooster child = child(name);
		if(null == child)	return null;
		
		return child.attributes();
	}
	
	/**
	 * VGg쐬B(qGgɂ͒ǉȂ)
	 * @param	name	^OB
	 * @return	V쐬GgB
	 * @since	1.00
	 */
	public	elementBooster	newElement(String name){
		if(null==name)	return null;
		Element	e = myElement.getOwnerDocument().createElement(name);
		if(null==e)		return null;
		return new elementBooster(myDocument ,e);
	}
	
	/**
	 * qGgǉB
	 * @param	element	GgB
	 * @since	1.00
	 */
	public	void	add(elementBooster element){
		if(null!=element)	myElement.appendChild(element.element());
	}
	
	/**
	 * qGgǉB
	 * @param	name	GgB
	 * @return	qGgƂĒǉGgB
	 * @since	1.00
	 */
	public	elementBooster	add(String name){
		elementBooster element = newElement(name);
		if(null==element)	return null;
		
		add(element);
		return element;
	}
	
	/**
	 * w肵ĎqGgǉB
	 * @param	name		GgB
	 * @param	attributes	B
	 * @return	qGgƂĒǉGgB
	 * @since	1.00
	 */
	public	elementBooster	add(String name ,Attributes attributes){
		elementBooster element = add(name);
		if(null == element)	return null;
		
		if(null != attributes)	element.attributes(attributes);
		
		return element;
	}
	
	/**
	 * w肵^O̍ŏ̎qGg擾B
	 * @param	name	^OB
	 * @return	GgB
	 * @since	1.00
	 */
	public	elementBooster	child(String name){
		if(null==name)	return null;
		NodeList nl = myElement.getChildNodes();
		if(null==nl)	return null;
		
		int mx = nl.getLength();
		if(0>=mx)	return null;
		for(int i=0;i<mx;i++){
			Node n = nl.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			if(!name.equals(n.getNodeName()))			continue;
			
			return new elementBooster(myDocument ,(Element)n);
		}
		
		return null;
	}
	
	/**
	 * w肵^O̎qGgׂĎ擾B
	 * @param	name	^OB
	 * @return	GgzB
	 * @since	1.00
	 */
	public	elementBooster[]	children(String name){
		if(null==name)	return null;
		NodeList nl = myElement.getChildNodes();
		if(null==nl)	return null;
		
		Vector vec = new Vector();
		int mx = nl.getLength();
		if(0>=mx)	return null;
		for(int i=0;i<mx;i++){
			Node n = nl.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			if(!name.equals(n.getNodeName()))			continue;
			vec.add(new elementBooster(myDocument ,(Element)n));
		}
		if(0>=vec.size())	return null;
		
		return (elementBooster[])vec.toArray(new elementBooster[0]);
	}
	
	/**
	 * w肵^O̎qGgׂĎ擾B
	 * @param	name	^OB
	 * @return	GgzB
	 * @since	1.00
	 */
	public	elementBooster[]	offspring(String name){
		if(null==name)	name = "*";
		NodeList list = myElement.getElementsByTagName(name);
		if(null==list)	return null;
		int mx = list.getLength();
		if(0==mx)		return null;
		elementBooster[] elements = new elementBooster[mx];
		for(int i=0;i<mx;i++){
			elements[i] = new elementBooster(myDocument ,(Element)list.item(i));
		}
		return elements;
	}
	
	/**
	 * qGgׂĎ擾B
	 * @return	GgzB
	 * @since	1.00
	 */
	public	elementBooster[]	offspring(){ return offspring(null); }
	
	/**
	 * qGgׂč폜B
	 * @since	1.00
	 */
	public	void	removeChild(){
		NodeList	nl = myElement.getChildNodes();
		if(null==nl)	return;
		
		int mx = nl.getLength();
		for(int i = mx-1;0 <= i;i--){
			Node n = nl.item(i);
			if(null!=n) myElement.removeChild(n);
		}
	}
	
	/**
	 * ^Ow肵ĎqGg폜B
	 * @since	1.00
	 */
	public	void	removeChildren(String name){
		if(null==name)	return;
		NodeList nl = myElement.getChildNodes();
		if(null==nl)	return;
		
		for(int i=nl.getLength()-1;0<=i;i--){
			Node n = nl.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			if(!name.equals(n.getNodeName()))			continue;
			myElement.removeChild(n);
		}
	}
	
	/**
	 * ̃Gg폜B
	 * @since	1.00
	 */
	public	void	remove(){
		myElement.getParentNode().removeChild(myElement);
	}
	
	/**
	 * qGgׂĎ擾B
	 * @return	GgzB
	 * @since	1.00
	 */
	public	elementBooster[]	children(){
		NodeList	nl = myElement.getChildNodes();
		if(null==nl)	return null;
		
		Vector vec = new Vector();
		int mx = nl.getLength();
		if(0>=mx)	return null;
		for(int i=0;i<mx;i++){
			Node	n	=	nl.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			vec.add(new elementBooster(myDocument ,(Element)n));
		}
		if(0>=vec.size())	return null;
		
		return (elementBooster[])vec.toArray(new elementBooster[0]);
	}
	
	/**
	 * eGg擾B
	 * @return	eGgB
	 * @since	1.00
	 */
	public	elementBooster	parent(){
		try{
			Node	n	=	myElement.getParentNode();
			if(Node.ELEMENT_NODE != n.getNodeType())	return null;
			return new elementBooster(myDocument ,(Element)n);
		}catch(NullPointerException e){ return null; }
	}
	
	protected int numeric(String s){
		if(null==s)	return 0;
		if(0>=s.trim().length())	return 0;
		
		StringBuffer sb = new StringBuffer(s);
		for(int i=sb.length()-1;0<=i;i--){
			char c = sb.charAt(i);
			if(('0' <= c) && ('9' >= c))	continue;
			if(('-' == c) || ('.' == c))	continue;
			
			sb.deleteCharAt(i);
		}
		
		return Integer.parseInt(sb.toString());
	}
	
	protected	documentBooster	myDocument;
	protected	Element			myElement;
}