/**
 * @(#)SiteXmlAnalizer.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : Site.xml Analizer
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2001/03/25
 * @see 
 */
package	jp.co.nri.rid.xml;

/* JAVA */
import	java.util.*;

/* W3C */
import	org.w3c.dom.Document;

/* rid */
import	jp.co.nri.rid.xml.*;

/**
 * Site.xml̖ړĨjbgׂĂ܂Ƃ߂ď邽߂̃NX
 */

public class SiteXmlAnalizer{
	private static final String ZONEUNIT		= "ZoneUnit";
	private static final String LINKUNIT		= "LinkUnit";
	private static final String FILE			= "File";
	private static final String EXIST			= "Exist";
	private static final String FALSE			= "false";
	private static final String LINKTYPE		= "LinkType";
	private static final String SERVER			= "server";
	private documentBooster	myDocument;
	
	/**
	 * @param	document	Site.xmlDocumentIuWFNg
	 * @since	1.00
	 */
	public SiteXmlAnalizer(Document document){
		myDocument = new documentBooster(document);
	}
	
	/**
	 * @param	document	Site.xmldocumentBoosterIuWFNg
	 * @since	1.00
	 */
	public SiteXmlAnalizer(documentBooster document){
		myDocument = document;
	}
	
	/**
	 * w肵^OUnitW
	 * @param	tagname	^O
	 * @return	W߂Unit̔z
	 * @since	1.00
	 */
	public UnitData[] collecting(String tagname){
		elementBooster[] elements = myDocument.root().offspring(tagname);
		if(null==elements)	return null;
		int mx = elements.length;
		UnitData[] unitdatas = new UnitData[mx];
		for(int i=0;i<mx;i++){
			elementBooster offspring = elements[i];
			unitdatas[i] = new UnitData(offspring.attribute(FILE) ,offspring);
		}
		
		return unitdatas;
	}
	
/*		
	private UnitData[] collecting(String tagname ,elementBooster element){
		elementBooster[] children = element.children();
		if(null==children)	return;
		int mx = children.length;
		for(int i=0;i<mx;i++){
			elementBooster child = children[i];
			String childtagname = child.tagname();
			if(childtagname.equals(tagname)) 	unitdatas.add(new UnitData(child.attribute(FILE) ,child));
			if(childtagname.equals(ZONEUNIT))	collecting(tagname ,child ,unitdatas);
		}
	}
*/
	
	/**
	 * SĂLinkUnitExist"false"ɃZbg
	 * @since	1.00
	 */
	public void resetLinkExist(){
		elementBooster[] elements = myDocument.root().offspring(LINKUNIT);
		if(null==elements)	return;
		int mx = elements.length;
		for(int i=0;i<mx;i++){
			elementBooster	element	= elements[i];
			if(!SERVER.equals(element.attribute(LINKTYPE)))	element.attribute(EXIST ,FALSE);
		}
	}
	
	public class UnitData{
		public String			file;
		public elementBooster	element;
		
		public UnitData(String File ,elementBooster Element){
			file	= new String(File);
			element	= Element;
		}
	}
}
