/**
 * @(#)WebFileRobo.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RIDUAL : Web File Robo
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/08/23
 */
package jp.co.nri.rid.web;

import	java.net.*;
import	java.io.*;
import	java.util.*;

/**
 * t@C1_E[hXbh
 */
public class WebDownloadRobo extends Thread{
	private Vector				myDownloadQueue;
	private	WebDownloadQueueMap	myQueueMap;
	private	Hashtable			myDownloadLog;
	private	WebFile				myWebFile;
	private	WebRoboState		myState;
	private WebMessages			myMessages;
	
	public	long				SleepTime	= 4000;	// 4sec
	
	/**
	 * RXgN^
	 * @since	1.00
	 */
	public WebDownloadRobo(WebRoboState state ,Vector downloadQueue ,WebDownloadQueueMap map ,Hashtable downloadLog ,String host ,String dir ,WebMessages messages){
		myDownloadQueue	= downloadQueue;
		myQueueMap		= map;
		myDownloadLog	= downloadLog;
		myMessages		= messages;
		myWebFile		= new WebFile(host.toLowerCase());
		
		myState = state;
	}
	
	public void setSaveDir(File dir ,File outside){
		myWebFile.setSaveDir(dir);
		
		// outside͂ǂH
	}
	
	public void setRootPath(String path){	myWebFile.setRootPath(path); }
	
	/**
	 * WebDownloadQueueMapɃL[ЂƂo^Ă炸AdefaultQueueo^ĂȂꍇANullPointerExceptionX[B
	 * @since	1.00
	 */
	public void run(){
		Vector	defaultQueue= myQueueMap.getDefaultQueue();
		boolean	isEmptyMap	= (0<myQueueMap.size()) ? false : true;
		
		while(!myState.stopping){
			if(0 >= myDownloadQueue.size()){
				try{ sleep(SleepTime); }catch(InterruptedException e){}
				continue;
			}
			
			myState.alive++;
			
			try{
				Object obj = myDownloadQueue.remove(0);
				DownloadProperty property = null;				
				try{
					if(obj instanceof DownloadProperty){
						property = (DownloadProperty)obj;
						if(!myWebFile.setURL(property.parent ,property.url)) continue;
					}
					else{
						if(obj instanceof String){
							if(!myWebFile.setURL((String)obj)) continue;
						} else continue;
					}
					
				}catch(MalformedURLException e){	// URL쐬G[
					myMessages.add(myMessages.BadURLDR ,obj.toString());
					continue;
				}
				URL url = myWebFile.getURL();
				
				if(null==url){	// t@CȗĂ邪At@CȂB
					myMessages.add(myMessages.DefaultFileNotFoundDR ,obj.toString());
					continue;
				}
				
//				if(!url.getHost().toLowerCase().equals(myHost))	continue;	// _E[hȂzXg
				
				File file = myWebFile.fusionPath();
				if(null==file)	continue;									// _E[hȂfBNg
				
				// L[擾
				Vector queue = isEmptyMap ? defaultQueue : myQueueMap.get(getExtension(file).toLowerCase());	// Z[uȂ[hǂH gq	++++
				if(null==queue)	continue;	// _E[hȂgq
				
				// O	_E[hς݃`FbNɂg
				synchronized(myDownloadLog){
					if(myDownloadLog.containsKey(url))	continue;
					myDownloadLog.put(url ,url);
				}
				
				// _E[h
				try{
					int httpstat = myWebFile.save();
					if(HttpURLConnection.HTTP_OK == httpstat){
						/* t3-nishimura@nri modification start */
						if (getExtension(file).equalsIgnoreCase("swf")
							&& property != null) {
							/* swf ̏ꍇ͎Qƌy[WN̋N_Ƃ */
							queue.add(new ScanProperty(property.parent,
													   myWebFile.getURL(),
													   file));
						} else {
							queue.add(new ScanProperty(myWebFile.getURL() ,file));	// L[ɒǉ	// Z[uȂ[hǂH	++++
						}
						/* t3-nishimura@nri modification end */
					}
					else{
						myDownloadLog.remove(url);
						myMessages.add(myMessages.SaveFileNotFoundDR ,"HTTP-STATUS="+httpstat+" "+url.toString());
					}
				}
				catch(FileNotFoundException e){
					myDownloadLog.remove(url);
					myMessages.add(myMessages.SaveFileNotFoundDR ,url.toString());
				}
				catch(IOException e){
					myDownloadLog.remove(url);
					myMessages.add(myMessages.SaveIOErrorDR ,url.toString());
				}
			}
			catch(ArrayIndexOutOfBoundsException e){} // ɑ̃XbhɎꂽB
			finally{ myState.alive--; }
		}
	}
	
	private String getExtension(File file){ return getExtension(file.getName()); }
	private String getExtension(String name){
		int ix = name.lastIndexOf('.');
		if(0 > ix)					return ".";
		if(name.length()-1 <= ix)	return ".";
		return name.substring(ix+1);
	}
}
