/**
 * @(#)BoolCEC.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : Boolean Cell Editor Component
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2002/03/26
 * @see iCellEditorComponent
 */
package	jp.co.nri.rid.table.editor;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * ON/OFFłZGfB^/_R|[lg(`FbN{bNX)
 */
public class BoolCEC extends JCheckBox implements iCellEditorComponent{
    /** RCS ID */
    private static final String RCSID =
        "$Id: BoolCEC.java,v 1.2 2003/01/31 06:42:08 nsmr Exp $";

	protected Color myFore;
	protected Color myBack;
	
	/*
	 * @param	editable	ҏWہB
	 * @param	listener	ANVXi[B
	 * @since	1.00
	 */
	public BoolCEC(boolean editable ,ActionListener listener){
		myFore = getForeground();
		myBack = getBackground();
		setHorizontalAlignment(SwingConstants.CENTER);
		setBorderPaintedFlat(true);
		setBorder(null);
//		setSelected(true);
		setSelected(false);
		editable(editable);
		addActionListener(listener);
		if(listener instanceof CECAdapter)	((CECAdapter)listener).editor(this);
	}
	
	/*
	 * Zl(String)擾B
	 * @return	ZlB
	 * @since	1.00
	 */
	public String	text(){
//		if(isSelected())	return "true";
//		return "false";
		return isSelected() ? "true" : "false";
	}
	
	/*
	 * Zlݒ肷B
	 * @param	text	ZlB
	 * @since	1.00
	 */
	public void	text(String text){
//		if("false".equals(text))	setSelected(false);
//		else						setSelected(true);
		setSelected("true".equals(text) ? true : false);

	}
	
	/*
	 * GfB^R|[lg擾B
	 * @return	GfB^R|[lgB
	 * @since	1.00
	 */
	public JComponent	component(){		return this;		}
	
	/*
	 * ̓spublicƂȂĂ邪AgpȂƁB
	 * @since	1.00
	 */
	public void			focus(boolean hasFocus ,JTable table){
		if(hasFocus){
			setForeground(table.getSelectionForeground());
			setBackground(table.getSelectionBackground());
		}
		else{
//			setForeground(table.getForeground());
//			setBackground(table.getBackground());
			setForeground(myFore);
			setBackground(myBack);
		}
	}
	
	/*
	 * ҏWۂݒ肷B
	 * @param	editable	true:ҏW false:ҏWsB
	 * @since	1.00
	 */
    public void editable(boolean editable){
		setEnabled(editable);
	}
}
