/*
 * @(#)LineItemComparator.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2002/03/26
 * @see LineItem
 */
package jp.co.nri.rid.table.comparator;

/* JAVA */
import	java.util.Comparator;
/* rid */
import	jp.co.nri.rid.table.*;

/**
 * LineItemIuWFNgmrBTableł̃\[gɎgpB
 */
public class LineItemComparator implements Comparator{
	protected String	myName;
	protected int		myMode;
	
	/**
	 * @param	name	nameB
	 * @param	mode	modeB
	 * @since	1.00
	 */
	public LineItemComparator(String name ,int mode){
		myName = new String(name);
		myMode = mode;
	}
	
	/**
	 * ComparatorB
	 * @since	1.00
	 */
	public	int	compare(Object a ,Object b){
		String aValue = ((LineItem)a).cellstring(myName);
		String bValue = ((LineItem)b).cellstring(myName);
		if(null==aValue && null==bValue)	return(0);
		if(null==aValue)	return(-myMode);
		if(null==bValue)	return(myMode);
		
		return(aValue.compareTo(bValue)*myMode);
	}
}