/**
 * @(#)ClmDefs.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : Colum Defines
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2002/01/08
 */
package	jp.co.nri.rid.table;

import	java.util.*;

/**
 * ClmDefCX^XǗ邽߂̃NX
 */
public class ClmDefs{
	private	HashMap		myTagEdge;
	private	HashMap		myNameEdge;
	private	Vector		myClmDefs;
	
//--------[[ constructor ]]----------------------------------------------------
	public ClmDefs(){
		myTagEdge	= new HashMap();
		myNameEdge	= new HashMap();
		myClmDefs	= new Vector();
	}
	
//--------[[ open method ]]----------------------------------------------------
	/**
	 * J`ǉB
	 * @param	clmdef	ǉJ`B
	 * @see		ClmDef
	 * @since	1.00
	 */
	public void add(ClmDef clmdef){
		myNameEdge.put(clmdef.name ,clmdef);
		myClmDefs.add(clmdef);
	}
	
	/**
	 * J`ǉB
	 * @param	tagname	^O
	 * @param	names	Jz
	 * @since	1.00
	 */
	public void add(String tagname ,String[] names){
		Vector defs = (Vector)myTagEdge.get(tagname);
		if(null==defs){
			defs = new Vector();
			myTagEdge.put(tagname ,defs);
		}
		
		int mx = names.length;
		for(int i=0;i<mx;i++){
			ClmDef def = (ClmDef)myNameEdge.get(names[i]);
			if(null!=def)	defs.add(def);
		}
	}
	
	/**
	 * Y^OɊ֌WJ`̔z擾B
	 * @param	name	^OB
	 * @return	J`zB
	 * @see		ClmDef
	 * @since	1.00
	 */
	public ClmDef[] tagEdge(String name){	return get(myTagEdge ,name); }
	
	/**
	 * SẴJ`擾B
	 * @return	J`zB
	 * @see		ClmDefs
	 * @since	1.00
	 */
	public ClmDef[] ClmDefs(){	return (ClmDef[])myClmDefs.toArray(new ClmDef[0]); }
	
	/**
	 * SẴ^O擾B
	 * @return	^Oz
	 * @since	1.00
	 */
	public String[] tagnames(){	return keys(myTagEdge); }
	
	/**
	 * Y^OɊ֌WJ^Cg̔z擾B
	 * @param	tagname	^OB
	 * @return	J^CgzB
	 * @since	1.00
	 */
	public String[] titles(String tagname){
		Vector vec = (Vector)myTagEdge.get(tagname);
		if(null==vec)	return null;
		
		ClmDef[] defs	= (ClmDef[])vec.toArray(new ClmDef[0]);
		int mx = defs.length;
		if(0>=mx)	return null;
		String[] titles	= new String[mx];
		for(int i=0;i<mx;i++)	titles[i] = new String(defs[i].title);
		
		return titles;
	}
	
//--------[[ close method ]]----------------------------------------------------
	private ClmDef[] get(HashMap map ,String name){
		Vector clmdefs = (Vector)map.get(name);
		if(null==clmdefs)	return null;
		return (ClmDef[])clmdefs.toArray(new ClmDef[0]);
	}

	private String[] keys(HashMap map){
		Set keyset = map.keySet();
		if(null==keyset)	return null;
		return (String[])keyset.toArray(new String[0]);
	}
}
