/**
 * @(#)AttributeMap.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : Attribute Map
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/01/09
 */
package	jp.co.nri.rid.table;

/* java */
import	java.util.*;

/**
 * ̃jbgQƂƂɎg`̃nbV
 * 
 */
public class AttributeMap extends HashMap{
//--------[[ open method ]]----------------------------------------------------
	/**
	 * Qƃjbg`ǉ
	 * @param	myname	g̃jbg
	 * @param	myattr	g̑
	 * @param	rname	Qƃjbg
	 * @param	rattr	Qƃjbg̑
	 * @since	1.00
	 */
	public void add(String myname ,String myattr ,String rname ,String rattr){
		Attributes attributes = (Attributes)get(myname);
		if(null==attributes){
			attributes = new Attributes();
			put(myname ,attributes);
		}
		attributes.add(myattr ,rname ,rattr);
	}
	
	/**
	 * QƂ郆jbg擾
	 * @param	unit	g̃jbg
	 * @param	attr	g̑
	 * @return	jbg
	 * @since	1.00
	 */
	public String unit(String unit ,String attr){
		try{ return ((Attributes)get(unit)).unit(attr); }
		catch(NullPointerException e){ return null; }
	}
	
	/**
	 * QƂ鑮擾
	 * @param	unit	g̃jbg
	 * @param	attr	g̑
	 * @return	
	 * @since	1.00
	 */
	public String attr(String unit ,String attr){
		try{ return ((Attributes)get(unit)).attr(attr); }
		catch(NullPointerException e){ return null; }
	}

//--------[[ close inner class ]]----------------------------------------------
	private class Attributes extends HashMap{
	//--------[[ open method ]]------------------------------------------------
		/**
		 * QƑ`ǉ
		 * @param	name	g̑
		 * @param	rname	Qƃjbg
		 * @param	rattr	Qƃjbg̑
		 * @since	1.00
		 */
		public void add(String name ,String rname ,String rattr){
			put(name ,new Unit(rname ,rattr));
		}
		
		/**
		 * QƂ郆jbg擾
		 * @param	name	g̑
		 * @return	jbg
		 * @since	1.00
		 */
		public String unit(String name){
			try{ return ((Unit)get(name)).unit; }
			catch(NullPointerException e){ return null; }
		}
		
		/**
		 * QƂ鑮擾
		 * @param	name	g̑
		 * @return	
		 * @since	1.00
		 */
		public String attr(String name){
			try{ return ((Unit)get(name)).attr; }
			catch(NullPointerException e){ return null; }
		}
	}
	
	private class Unit{
		public String unit;
		public String attr;
		public Unit(String u ,String a){
			unit	= u;
			attr	= a;
		}
	}
}
