package jp.co.nri.rid.search;

/* Layouts */
import java.awt.BorderLayout;
import javax.swing.BoxLayout;

/* Listeners */
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;

/* Events */
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;

/* Swing Components */
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;

/* interfaces & models */
import javax.swing.table.TableModel;

/* misc */
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;

/* Rid */
import jp.co.nri.Rid;
import jp.co.nri.rid.RMenu;
import jp.co.nri.rid.doc.RidElementPage;
import jp.co.nri.rid.export.ExportCsvDialog;
import jp.co.nri.rid.generator.GenerateCSV2;
import jp.co.nri.rid.table.LineNoRowHeader;
import jp.co.nri.rid.xml.elementBooster;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZFileFilter;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;


/**
 * pl:
 * instance ʂ̃Rei (JFrame Ȃ)  add ĎgB
 * class ̂܂܎sƁAV JFrame 𐶐āA
 * ̒ɕ\B
 *
 * @author t3-nishimura@nri.co.jp
 */
public class SearchPanel extends JPanel {
    /** SCCS ID */
    private static final String SCCSID = "@(#)SearchPanel.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SearchPanel.java,v 1.56 2003-07-17 18:26:56+09 nsmr Exp $";

    /** debug flag */
    static final boolean DEBUG = false;

    /** e{^̕ (sNZ) */
    static final int BUTTON_WIDTH = 150;

    /** e{^̍ (sNZ) */
    static final int BUTTON_HEIGHT = 30;

    /** 󔒃x̍ (sNZ) */
    static final int SPACER_HEIGHT = 20;

    /** e[ůeZ̍ (sNZ) */
    static final int TABLE_ROW_HEIGHT = 24;

    /** e[uŜ̕ (sNZ) */
    static final int TABLE_WIDTH = 300;

    /** [̓eLXgtB[h*/
    JTextField depthField;

    /** [̓pl*/
    SPFieldHolderPanel depthPanel;

    /** ACRhFύX`FbN{bNX */
    JCheckBox changeIconColorCheckBox;

    /** hFI{^ */
    JButton selectColorButton;

    /** ACRhFύXpl */
    JPanel changeIconColorPanel;

    /** CSV ۑ{^ */
    JButton saveCSVButton;

    /** CSV ۑpl */
    JPanel saveCSVPanel;

    /** ʕ\e[u */
    private JTable resultTable;

    /** ʕ\pl */
    JScrollPane resultScrollPanel;

    /** Ώە\px */
    JLabel targetLabel;

    /** ԕ\px */
    JLabel statusLabel;

    /** Ώۂɕt鎯ʖ */
    static final int[] SEARCH_TARGETS = {
        SPTableModel.ISOLATED, 
        SPTableModel.LARGE,
        SPTableModel.UNUSED,
        SPTableModel.FORM,
        SPTableModel.META,
        SPTableModel.SCRIPT,
        SPTableModel.STYLESHEET,
        SPTableModel.STATISTICS
    };

    /**
     * RXgN^
     * 
     * eR|[lg̏B
     */
    public SearchPanel() {
	/* JnbVe[u */
	SPColumnNames.init();

	/* 񃊃\[X */
	SPResourceHash.init();

	/* [̓pl̏*/
        initDepthPanel();

	/* ACRhFύXpl̏ */
        initChangeIconColorPanel();

	/* ʕ\pl̏ */
        initResultScrollPanel();

	/* ΏۑI{^̃Xg*/
	JPanel[] searchButtonPanels = createSearchButtonPanels();

	/* CSV ۑ{^ */
        initSaveCSVPanel();

	/* ep[cplɔzu */

        /** ΏۑIpl */
        JPanel searchButtonsContainer = new JPanel();

	//searchButtonsContainer.setLayout(new GridLayout(0,1));
	//searchButtonsContainer.setLayout(new FlowLayout());
	searchButtonsContainer.setLayout(new BoxLayout(searchButtonsContainer,
						       BoxLayout.Y_AXIS));

	/* pl̒ǉ */
	SPSpacerLabel spacerLabel;
	for (int i = 0; i < searchButtonPanels.length; i++) {
	    spacerLabel = new SPSpacerLabel(1, SPACER_HEIGHT);
	    searchButtonsContainer.add(searchButtonPanels[i]);
            // searchButtonsContainer.add(spacerLabel);
	}

        // javax.swing.ImageIcon icon = new javax.swing.ImageIcon(SearchPanel.class.getResource("button.gif"));
        // JButton but = new JButton(icon);
        // searchButtonsContainer.add(but);
        // but.setAlignmentX(RIGHT_ALIGNMENT);
        // but.setMargin(new java.awt.Insets(0, 0, 0, 0));

	// spacerLabel = new SPSpacerLabel(1, BUTTON_HEIGHT);
        // searchButtonsContainer.add(spacerLabel);
        // searchButtonsContainer.add(saveCSVPanel);

        /* Ώە\x̐ */
        targetLabel = createStatusLabel();

	/* ԕ\x̐ */
	statusLabel = createStatusLabel();

	/* ftHg FlowLayout */
	setLayout(new BorderLayout());

	JPanel panel;

	/* ftHg FlowLayout */
	panel = new JPanel(new BorderLayout());
	/* plɌΏۑIplǉ */
	panel.add(searchButtonsContainer, BorderLayout.NORTH);
	/* pl CSV ۑ{^ǉ */
        // panel.add(saveCSVPanel, BorderLayout.SOUTH);

	/* plǉ */
        add(panel, BorderLayout.WEST);

	/* EplɌʕ\plƏԕ\xǉ */
	panel = new JPanel(new BorderLayout());
        panel.add(targetLabel, BorderLayout.NORTH);
	panel.add(resultScrollPanel, BorderLayout.CENTER);
	panel.add(statusLabel, BorderLayout.SOUTH);

	/* Eplǉ */
	add(panel, BorderLayout.CENTER);
	
	init();
    } /* SearchPanel (RXgN^) */


    /**
     * main \bh
     * 
     * JFrame 𐶐A̒Ɍpl\B
     * Ridual ł͂̃\bh͎gpȂB
     */
    public static void main(String[] args) {
	JFrame frame = new JFrame();

	/* Window ꂽ́AvOI */
	frame.addWindowListener(new SPWindowAdapter());
 
	frame.getContentPane().add(new SearchPanel(), BorderLayout.CENTER);
	frame.pack();
	frame.setVisible(true);
    } /* main */


    /**
     * @param errStr fobObZ[W
     * fobObZ[Wo͂
     */
    public void debugOut(String errStr) {
	if (DEBUG) {
	    System.err.println(errStr);
	}
    }


    /**
     * ΏۂI{^𐶐
     * @return ΏۂI{^܂ރpl̃Xg
     */
    private JPanel[] createSearchButtonPanels() {
	JPanel[] panels = new JPanel[0];

	/* SEARCH_TARGETS ݒ肳ĂȂꍇ */
	if (SEARCH_TARGETS == null) {
	    return panels;
	}
	if (SEARCH_TARGETS.length == 0) {
	    return panels;
	}

	ActionListener myListener = new ButtonLsnr();

	panels = new JPanel[SEARCH_TARGETS.length];
	for (int i = 0; i < SEARCH_TARGETS.length; i++) {
	    JButton button;

	    panels[i] = new JPanel(new BorderLayout());
	    // panels[i].setLayout(new BoxLayout(panels[i], BoxLayout.Y_AXIS));

            int target = SEARCH_TARGETS[i];
	    button = new JButton(SPTableModel.toString(target));

	    /* action command ̓o^ */
	    button.setActionCommand(Integer.toString(target));

	    /* Xi̓o^ */
	    button.addActionListener(myListener);

	    /* TCY̐ݒ */
            // button.setPreferredSize(new
            //     Dimension(BUTTON_WIDTH, BUTTON_HEIGHT));
            
	    /* BoxLayout  JPanel ɔzuꍇ */
	    //button.setAlignmentX(CENTER_ALIGNMENT);

            /* {^̃eLXg */
            button.setHorizontalAlignment(JButton.LEFT);

	    /* plɒǉ */
	    panels[i].add(button, BorderLayout.CENTER);

	    /* ACRhFύXpl̒ǉ */
	    if (target == SPTableModel.ISOLATED &&
                (changeIconColorPanel != null)) {
		panels[i].add(changeIconColorPanel, BorderLayout.SOUTH);
	    }

	    /* [̓pl̒ǉ */
	    if (target == SPTableModel.DEEPPAGE && (depthPanel != null)) {
		panels[i].add(depthPanel, BorderLayout.SOUTH);
	    }
	}
	return panels;
    } /* createSearchButtonPanels */


    /**
     * [̓eLXgtB[hƃpl𐶐
     */
    private void initDepthPanel() {
        depthField = new JTextField("5", 5);
        depthField.setHorizontalAlignment(JTextField.RIGHT);

        depthPanel = new SPFieldHolderPanel();
        depthPanel.addField("depth", depthField);
    } /* initDepthField */


    /**
     * ACRhFύX{^ƃpl𐶐
     */
    private void initChangeIconColorPanel() {
	changeIconColorCheckBox =
            new JCheckBox(SPResourceHash.getString("changeColor"));

        selectColorButton = new JButton(" ... ");
        selectColorButton.addActionListener(new SPColorListener());

	changeIconColorPanel = new JPanel();
	changeIconColorPanel.add(changeIconColorCheckBox);
	changeIconColorPanel.add(selectColorButton);
    } /* initChangeIconColorPanel */


    /**
     * CSV ۑ{^ƃpl𐶐
     */
    private void initSaveCSVPanel() {
        saveCSVButton = new JButton(SPResourceHash.getString("saveCSV"));
        saveCSVButton.addActionListener(new CsvButtonLsnr());

        // saveCSVButton.setPreferredSize(new
        //     Dimension(BUTTON_WIDTH, BUTTON_HEIGHT));

        /* pl̈ʒu𒆉 */
        // saveCSVButton.setAlignmentX(CENTER_ALIGNMENT);

        /* {^̃eLXg */
        // saveCSVButton.setHorizontalAlignment(JButton.LEFT);

	saveCSVPanel = new JPanel(new BorderLayout());
	saveCSVPanel.add(saveCSVButton);
    } /* initSaveCSVPanel */


    /**
     * ʕ\pl̐
     */
    private void initResultScrollPanel() {
	resultTable = new JTable();

        /** ENbNŃReLXgj[\邽߂̃Xi */
	resultTable.addMouseListener(new TableListener());

        resultTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        resultTable.setRowHeight(TABLE_ROW_HEIGHT);
        resultTable.setPreferredScrollableViewportSize(new
            Dimension(TABLE_WIDTH, TABLE_ROW_HEIGHT));

        // resultTable.setCellSelectionEnabled(true);

        /* J\wb_ (ŏs) ̍XV */
        JTableHeader columnHeader = resultTable.getTableHeader();
        columnHeader.addMouseListener(new SPHeaderListener());

        resultScrollPanel = new JScrollPane(resultTable);
    } /* initResultScrollPanel */


    /**
     * ԕ\x𐶐
     * 
     * @return "a"Ƃ\̂ɏ\ȍx
     */
    public JLabel createStatusLabel() {
	JLabel label = new JLabel("a");
        label.setBorder(new javax.swing.border.EmptyBorder(1, 2, 1, 1));
	Dimension d = label.getPreferredSize();
	label.setText("");
	label.setPreferredSize(d);
	return label;
    } /* createStatusLabel */


    /**
     * Aʕ\e[ȕ
     */
    public int init() {
	/* ʕ\e[ȕ */
	resultTable.setModel(new SPTableModel());

	/* CSV ۑ{^𗘗psɂ */
	saveCSVButton.setEnabled(false);

	/* ACRhF𖢑IԂɂ */
        changeIconColorCheckBox.setSelected(false);
	selectColorButton.setBackground(Color.gray);

	/** ԕ\NA */
	statusLabel.setText("");

	return 1;
    } /* init */


    /** ʕ\e[uԂ */
    public JComponent getTable() {
        return (JComponent)resultTable;
    }


    /**
     * {^̃ANVĎNXB
     * Aʂ\B
     */
    class ButtonLsnr implements ActionListener {
	public void actionPerformed(ActionEvent e){
            SPTableModel spTableModel;

	    /* action command (Cxg̔) ̎擾 */
	    String targetString = e.getActionCommand();
            int target;

            try {
                target = Integer.parseInt(targetString);
            } catch (NumberFormatException ex) {
                target = -1;
            }

            if (target == SPTableModel.ISOLATED) {
                spTableModel = new
                    SPTableModelIsolated(changeIconColorCheckBox.isSelected(),
                                         selectColorButton.getBackground());
            } else if (target == SPTableModel.LARGE) {
                spTableModel = new SPTableModelLarge();
            } else if (target == SPTableModel.UNUSED) {
                spTableModel = new SPTableModelUnused();
            } else if (target == SPTableModel.STATISTICS) {
                spTableModel = new SPTableModelStatistics();
            } else if (target == SPTableModel.FORM) {
                spTableModel = new SPTableModelDetailInfo(target);
            } else if (target == SPTableModel.META) {
                spTableModel = new SPTableModelDetailInfo(target);
            } else if (target == SPTableModel.SCRIPT) {
                spTableModel = new SPTableModelDetailInfo(target);
            } else if (target == SPTableModel.STYLESHEET) {
                spTableModel = new SPTableModelDetailInfo(target);
            } else {
                spTableModel = new SPTableModel(target);
            }

            /* Ώە\x̍XV */
            targetLabel.setText(SPTableModel.toString(target));

            /* ԕ\x̍XV */
            statusLabel.setText(spTableModel.getStatusString());

            /* e[uf̍XV */
	    resultTable.setModel(spTableModel);

            /* Jf̍XV */
	    resultTable.setColumnModel(new SPTableColumnModel(target));

            /* sԍ\wb_ (ō) ̍XV */
            JTable rowHeader = new LineNoRowHeader(resultTable);
            resultScrollPanel.setRowHeaderView(rowHeader);
            resultScrollPanel.getRowHeader().setPreferredSize(rowHeader.getPreferredSize());
            resultScrollPanel.getVerticalScrollBar().setValue(0);
            resultScrollPanel.getHorizontalScrollBar().setValue(0);

            /* CSV ۑ{^̍XV */
            if (spTableModel.isImplemented()) {
                saveCSVButton.setEnabled(true);
            } else {
                saveCSVButton.setEnabled(false);
            }
	}
    } /* class ButtonLsnr */


    /**
     * CSV ۑ{^̃ANVĎNXB
     * ʂ CSV t@CɕۑB
     */
    class CsvButtonLsnr implements ActionListener {
	public void actionPerformed(ActionEvent e) {
            TableModel tableModel = resultTable.getModel();
            SPTableModel spTableModel;

            if (tableModel instanceof SPTableModel) {
                spTableModel = (SPTableModel)tableModel;
            } else {
                return;
            }

	    if (!spTableModel.isImplemented()) {
		return;
	    }

	    /* ȉ jp.co.nri.rid.action.RidListAction Rs[ */
	    String szFile = openFileDialog("csv", "CSV File", "rid.csv.dir");
	    if ( szFile == null ) {
		return;
	    }

	    try {
		// csvo͌Ăяo
		GenerateCSV2 csv2 = new GenerateCSV2();
		csv2.generateCSV(resultTable, szFile);
	    } catch (Exception evt) {
		debugOut("Write csv failed:"+evt.toString());
		evt.printStackTrace();
	    }

            // o̓fBNg̊mF
            String szDocsDir = null;
            String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
            if (szPjDir != null) {
		ZResource res = ZApp.getTheApp().getResource();
                szDocsDir = szPjDir + File.separator + res.getString("rid.docs.dir");
                String szCompare = szFile.substring(0,Math.min(szFile.length(),szDocsDir.length()));
                if ( szCompare.equalsIgnoreCase(szDocsDir) ) {
                    // Rg
                    ExportCsvDialog csvd = new ExportCsvDialog();
                    csvd.show(szFile);
                }
	    }
	} /* actionPerformed */


	/* jp.co.nri.rid.action.RidGobAction Rs[ */
	/**
	 * t@CI_CAO
	 * @param szExt
	 * @param szExtName
	 * @param szOutDir
	 */
	public String openFileDialog(String szExt, String szExtName, String szOutDir) {
	    IZApp izapp;
	    ZResource res;

	    izapp = ZApp.getTheApp();
	    if (izapp == null) {
		debugOut("Not running within Ridual application.");
		return null;
	    } else {
		res = ZApp.getTheApp().getResource();
	    }

	    JFileChooser dlg = new JFileChooser();
	    // t@CtB^̐ݒ
	    dlg.setFileFilter(new ZFileFilter( new String(szExt), szExtName));

	    // JgfBNg̐ݒ
	    String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
	    String szDir = res.getString("app.install.path");
	    if ( szPjDir != null ) {
		szDir = szPjDir + File.separator + res.getString(szOutDir);
	    }
	    dlg.setCurrentDirectory(new File(szDir)) ;

	    // _CAOJ
	    int nRet = dlg.showSaveDialog(ZApp.getTheApp().getFrame());
	    String szFile = null ;
	    if ( nRet == JFileChooser.APPROVE_OPTION) {
		// t@C擾
		File fFile = dlg.getSelectedFile();
		try {
		    szFile = fFile.getCanonicalPath();
		} catch ( java.io.IOException evt) {
		    szFile = fFile.getAbsolutePath();
		}

		if( szFile != null ){
		    if ( !szFile.endsWith("."+szExt) ) {
			szFile += "."+szExt;
		    }
		}
	    }

	    // t@C̍XV
	    // ͍XVȂAdlg.setCurrentDirectorysăfBNg
	    // ύXɂȂƃj[\ŃG[ł邽߁AŃt@CXV
	    ZApp.getTheApp().updateRecent( null );

	    return szFile;
	} /* openFileDialog */
    } /* class CsvButtonLsnr */


    /** ENbNŃReLXgj[\邽߂̃Xi */
    class TableListener implements MouseListener {
	public void mouseClicked(MouseEvent e){
	}
	public void mouseEntered(MouseEvent e){
	}
	public void mouseExited(MouseEvent e){
	}
	public void mousePressed(MouseEvent e){
	}

	public void mouseReleased(MouseEvent e){
	    JTable table;

            Object eventSource = e.getSource();
            if (eventSource instanceof JTable) {
                table = (JTable)eventSource;
            } else {
                return;
            }

	    int row = table.rowAtPoint(e.getPoint());
	    int col = table.columnAtPoint(e.getPoint());

            /** ZAENbNȂ */
	    if ((row >= 0) && (col >= 0) && e.isPopupTrigger()) {
                SPTableModel tableModel = (SPTableModel)table.getModel();
		elementBooster eb = tableModel.getElementAt(row, col);

                /** XML GgɑΉZł */
		if (eb != null) {
                    if (eb.element() instanceof RidElementPage) {
                        RMenu.createContextMenu(e, (RidElementPage)(eb.element()));
                    }
		}
	    }
	}
    } /* class TableListener */
} /* class SearchPanel */
