package jp.co.nri.rid.search;

/* misc */
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/* Rid */
import jp.co.nri.Rid;
import jp.co.nri.rid.RUpdateManager;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElementPage;
import jp.co.nri.rid.xml.elementBooster;
import jp.co.iti.fagot.util.ZInstance;

/**
 * Ǘy[Wʕ\e[ũf[^f
 */
class SPTableModelIsolated extends SPTableModel{
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPTableModelIsolated.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPTableModelIsolated.java,v 1.16 2003-07-22 20:23:03+09 nsmr Exp $";

    boolean changeIconColorCheckBoxIsSelected;
    Color selectColorButtonBackground;

    /** LinkUnit Nɂĕނ Vector QA
     *  NL[ɂănbVe[u 
     */
    Hashtable linkUnitsHash;

    /**
     * RXgN^:
     */
    SPTableModelIsolated(boolean changeIconColorCheckBoxIsSelected,
                         Color selectColorButtonBackground) {
        target = SPTableModel.ISOLATED;

        this.changeIconColorCheckBoxIsSelected =
            changeIconColorCheckBoxIsSelected;
        this.selectColorButtonBackground = selectColorButtonBackground;

        count = searchIsolatedPages();
    } /* SPTableModelIsolated */


    /**
     * gbvy[ẂANǂĂǂ蒅Ȃy[WT
     * @return y[W
     */
    private int searchIsolatedPages(){
        resultVector = new Vector();

        /* DOCUMENT_SITE ̎擾 */
        RidDocumentSite siteDoc =
            (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);
        if (siteDoc == null) {
            debugOut("DOCUMENT_SITE ܂");
            return 0;
        }

        /* gbvy[W̎擾 */
        RidElementPage topPageElem = siteDoc.getTopPage(Rid.PANEL_SEARCH);
        if (topPageElem == null) {
            return 0;
        }

        /* gbvy[W̃t@C擾 */
        String topPageName = topPageElem.getAttribute("File");
        if (topPageName == null) {
            debugOut("gbvy[W File Agr[g܂");
            return 0;
        }
        debugOut("top page: " + topPageName);

        /* DOCUMENT_SITE  PaegUnit ׂĎ擾 */
        elementBooster[] pageUnits =
            getElementsFromDocument("PageUnit", Rid.DOCUMENT_SITE);
        /* nbṼL[́At@Cɕϊ */
        SPElementStatusHash pageUnitHash =
            new SPElementStatusHash(pageUnits, true);

        /* DOCUMENT_SITE  LinkUnit ׂĎ擾 */
        elementBooster[] linkUnits =
            getElementsFromDocument("LinkUnit", Rid.DOCUMENT_SITE);
        /* nbṼL[́AÑt@Cɕϊ */
        linkUnitsHash = getElementVectorHash(linkUnits);

        /* N̒T */
        analyzePageLink(topPageName, pageUnitHash);

        /*
         * `FbNς݃tO̗ĂȂ PageUnit (= Ǘy[W) ̕\
         */
        int found = 0;
        siteDoc.beginTransaction();
        for (Enumeration e = pageUnitHash.keys(); e.hasMoreElements();) {
            String pageName = (String)e.nextElement();
            SPElementStatus es = pageUnitHash.get(pageName);
            int status = es.getStatus();
            if (status == SPElementStatus.UNCHECKED) {
                resultVector.add(new SPElementAndStrings(es.getElement()));
                changeIconColor(es.getElement());
                found++;
            }
        }
        siteDoc.commit();

        /* FILE JڂL[Ƀ\[g */
        sort(SPColumnNames.getColumnIndex(target, SPColumnNames.FILE), false);
        return found;
    } /* searchIsolatedPages */


    /**
     * PageUnit ̃ACRhFύX
     @ param element hFύX PageUnit
    */
    private void changeIconColor(elementBooster element){
        if (element == null) {
            return;
        }

        /**
         * ACRhFύX`FbN{bNXIĂȂ
         * Ȃ
         */
        if (!changeIconColorCheckBoxIsSelected) {
            return;
        }

        String paintColor = null;
        if (selectColorButtonBackground != null) {
            int rgb = selectColorButtonBackground.getRGB() & 0xffffff;
            String rgbString = Integer.toHexString(rgb);;

            String zero = "000000";
            String pad = "";
            int padLength = zero.length() - rgbString.length();
            if (padLength > 0) {
                pad = zero.substring(0, padLength);
            }
            paintColor = "#" + pad + rgbString;
        }
        /* "PaintColor" Agr[gAIꂽFɕύX
         * paintColor  null ̏ꍇ "PaintColor" Agr[g폜
         */
        element.attribute("PaintColor", paintColor);

        if (paintColor == null) {
            return;
        }

        String newvalue = element.attribute("PaintColor");
        if (newvalue == null) {
            return;
        }
        if (newvalue.equalsIgnoreCase(paintColor)){
            RUpdateManager.update(RUpdateManager.PROPERTY_CHANGED);
            return;
        }
    } /* changeIconColor */


    /** LinkUnit ̔ẑANv̂ꂼ 1  Vector
     *  ɂAe Vector NL[ɂănbVe[u
     *  @param elements LinkUnit  z
     *  @return Vector  Hashtable
     */
    private Hashtable getElementVectorHash(elementBooster[] elements) {
        Hashtable elementVectorHash = new Hashtable();
        Vector elementVector;

        if (elements == null) {
            return elementVectorHash;
        }
        if (elements.length == 0) {
            return elementVectorHash;
        }

        for (int i = 0; i < elements.length; i++) {
            /* ݂Gĝݒo */
            String exist = elements[i].attribute("Exist");
            if (exist == null) {
                continue; 
            }
            if (!exist.equals("true")) {
                continue;
            }

            /* N̎擾 */
            elementBooster connect0 = elements[i].child("Connect0");
            String linkSource = connect0.attribute("Key");
            if (linkSource == null) {
                continue;
            }
            linkSource = linkSource.toLowerCase();

            Object o = elementVectorHash.get(linkSource);
            if (o == null) {
                elementVector = new Vector();
            } else if (o instanceof Vector) {
                elementVector = (Vector)o;
            } else {
                elementVector = new Vector();
            }

            elementVector.add(elements[i]);
            elementVectorHash.put(linkSource, elementVector);
        }
        return elementVectorHash;
    } /* getElementStatusVector */


    /**
     * y[WԃN[DőSTABy[WɂāA
     * pageHash ̊YtO𗧂Ă
     * @param sourceNode T̋N_ƂȂ PageUnit ̖O
     * @param pageHash SPElementStatusHash ̃CX^X
     *                 (PageUnit  Hashtable)
     */
    private void analyzePageLink(String sourceNode,
                                 SPElementStatusHash pageHash) {
        if (pageHash.size() <= 0) { 
            debugOut("݂y[W܂");
            return;
        }
        SPElementStatus es = pageHash.get(sourceNode, true);
        if (es == null) {
            debugOut(sourceNode + " ܂");
            return;
        }
        es.setStatus(SPElementStatus.CHECKING);

        /* sourceNode ̃N擾 */
        Object o = linkUnitsHash.get(sourceNode.toLowerCase());
        if (o == null) {
            return;
        }
        if (!(o instanceof Vector)) {
            return;
        }

        Vector linkUnitVector = (Vector)o;

        /* sourceNode ̃Nׂă`FbN */
        for (int i = 0; i < linkUnitVector.size(); i++) {
            Object elem = linkUnitVector.elementAt(i);
            if (!(elem instanceof elementBooster)) {
                continue;
            }
            elementBooster linkElement = (elementBooster)elem;

            /*
             * NAN̒oB
             * NGgȊÕN͖
             */
            elementBooster connect0 = linkElement.child("Connect0");
            elementBooster connect1 = linkElement.child("Connect1");
            if (connect0 == null || connect1 == null) {
                continue;
            }
            String source      = connect0.attribute("Key");
            String destination = connect1.attribute("Key");
            if (source == null || destination == null) {
                continue;
            }

            debugOut("link: " + source + " -> " +  destination);

            SPElementStatus destElement = pageHash.get(destination, true);
            /*
             * destination  Exist  "false" Ƃ́A
             * null ݒ肳Ă
             */
            if (destElement == null) {
                debugOut("page: " + destination + " not exist");
            } else if (destElement.getStatus() == SPElementStatus.UNCHECKED) {
                /* ċAďo*/
                analyzePageLink(destination, pageHash);
            } else {
                /* N悪`FbNAłɃ`FbNς */
                debugOut("page: " + destination + ": " +
                         destElement.getStatus());
            }
        } /* for (int i = 0; i < linkUnitVector.size(); i++) */

        es.setStatus(SPElementStatus.DONE);
        debugOut("analyzePageLink: " + sourceNode + " done");
    } /* analyzePageLink */
} /* class SPTableModelIsolated */
