package jp.co.nri.rid.search;

/* interfaces & models */
import javax.swing.table.AbstractTableModel;

/* misc */
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

/* Rid */
import jp.co.nri.rid.doc.RidDocument;
import jp.co.nri.rid.doc.RidElementPage;
import jp.co.nri.rid.xml.documentBooster;
import jp.co.nri.rid.xml.elementBooster;
import jp.co.iti.fagot.util.ZInstance;

/**
 * ʕ\e[ũf[^f
 */
class SPTableModel extends AbstractTableModel{
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPTableModel.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPTableModel.java,v 1.35 2003-06-26 17:14:01+09 nsmr Exp $";

    /** Ώۂ ID */
    static final int ISOLATED   = 0;
    static final int LARGE      = 1;
    static final int UNUSED     = 2;
    static final int FORM       = 3;
    static final int META       = 4;
    static final int SCRIPT     = 5;
    static final int STYLESHEET = 6;
    static final int DEEPPAGE   = 7;
    static final int STATISTICS = 8;

    static final int NUMTARGETS = 9;

    /** {^ɕ\镶 */
    static final Object TARGET_ID_STRING[][] = {
        {new Integer(ISOLATED),   "isolated pages"},
        {new Integer(LARGE),      "calculated page size"},
        {new Integer(UNUSED),     "unused resources"},
        {new Integer(FORM),       "form detail"},
        {new Integer(META),       "meta information"},
        {new Integer(STYLESHEET), "stylesheet"},
        {new Integer(DEEPPAGE),   "deep page"},
        {new Integer(SCRIPT),     "script"},
        {new Integer(STATISTICS), "site report"}
    };

    /** Xe[^X\ۂ̒P */
    static final Object TARGET_ID_UNIT[][] = {
        {new Integer(ISOLATED),   "file"},
        {new Integer(LARGE),      "page"},
        {new Integer(UNUSED),     "file"},
        {new Integer(FORM),       "item"},
        {new Integer(META),       "item"},
        {new Integer(STYLESHEET), "item"},
        {new Integer(DEEPPAGE),   "item"},
        {new Integer(SCRIPT),     "item"},
        {new Integer(STATISTICS), ""}
    };

    /** ʂi[ Vector */
    Vector resultVector = null;

    protected boolean implemented = true;

    /** Ώ ID */
    int target;

    /** ʂ̌ */
    int count = -1;

    /** debug flag */
    static final boolean DEBUG = false;

    /** Boolean objects */
    static final Boolean BTRUE = new Boolean(true);
    static final Boolean BFALSE = new Boolean(false);

    /** \[gς݂̃J̃f̃CfNX */
    protected int modelIndexOfSortedColumn = -1;

    protected int sortOrder = -1;

    /** \[gς݂̃JŃ\[gĂ邱ƂtO */
    public static final int ASCENDING = 1;

    /** \[gς݂̃J~Ń\[gĂ邱ƂtO */
    public static final int DESCENDING = -1;


    /**
     * RXgN^:
     * 
     * \Ȃe[uf
     */
    SPTableModel() {
        target = -1;
    }


    /**
     * RXgN^:
     */
    SPTableModel(int target) {
        this.target = target;
        implemented = false;
    } /* SPTableModel */


    /**
     * @param errStr fobObZ[W
     * fobObZ[Wo͂
     */
    public void debugOut(String errStr) {
	if (DEBUG) {
	    System.err.println(errStr);
	}
    }


    /**
     * statusLabel ɕ\邽߂̕Ԃ
     */
    String getStatusString() {
        if (!implemented) {
            return "not implemented.";
        }

        String unit = getItemUnit(target);
        if (unit == "") {
            return "";
        }

        if (count == 1) {
            return count + " " + unit + " found.";
        }
        if (count == 0 || 2 <= count) {
            return count + " " + unit + "s found.";
        }

        return "";
    } /* getStatusString */


    /**
     * hLgAw肳ꂽjbgvfׂĎ擾
     * @param unitName 擾vf̃jbg
     * @param docName jbg擾hLg
     @ @return vf elementBooster zB
     @ hLg݂Ȃ new elementBooster[0] ԂB
     @ vf݂Ȃ new elementBooster[0] ԂB
    */
    elementBooster[] getElementsFromDocument(String unitName,
                                             String docName){
        elementBooster[] elements = new elementBooster[0];

        if (docName == null) {
            return elements;
        }

        /* hLg̎擾 */
        Object o = ZInstance.map().get(docName);
        if (o == null) {
            return elements;
        }
        if (!(o instanceof RidDocument)) {
            return elements;
        }
        RidDocument doc = (RidDocument)o;

        /* hLg root element 擾 */
        elementBooster rootElem = (new documentBooster(doc)).root();
        if (rootElem.isNull()) {
            return elements;
        } 

        /* hLg̃jbgׂĎ擾 */
        elementBooster[] resultElements = rootElem.offspring(unitName);
        if (resultElements == null) {
            return elements;
        }
        return resultElements;
    } /* getElementsFromDocument */


    public int getColumnCount() {
        if (!implemented) {
            return 0;
        }
        if (target == -1) {
            return 0;
        }
        int[] columnIDArray = SPColumnNames.get(target);
        if (columnIDArray == null) {
            return 0;
        }
        return columnIDArray.length;
    } /* getColumnCount */


    public String getColumnName(int column) {
        int columnID = SPColumnNames.getColumnID(target, column);
        if (columnID < 0) {
            return "";
        }
        return SPColumnNames.toString(columnID);
    } /* getColumnName */


    public int getRowCount() {
        if (!implemented) {
            return 0;
        }
        if (resultVector == null) {
            return 0;
        }
        return resultVector.size();
    } /* getRowCount */


    public Object getValueAt(int row, int col) {
        String columnName = getColumnName(col);

        if (!implemented) {
            return "";
        }

        /* l擾łȂ "" \ */
        if (row < 0) {
            return "";
        }
        if (resultVector == null) {
            return "";
        }
        if (resultVector.size() <= row) {
            return "";
        }
        Object rowObject = resultVector.elementAt(row);
        if (rowObject == null) {
            return "";
        }
        if (!(rowObject instanceof SPElementAndStrings)) {
            return "";
        }

        SPElementAndStrings rowData = (SPElementAndStrings)rowObject;

        /* strings l擾ł΂\ */
        String[] rowStrings = rowData.strings;
        if (rowStrings != null) {
            if (0 <= col && col < rowStrings.length) {
                String cell = rowStrings[col];
                if (cell != null) {
                    return cell;
                }
            }
        }

        /* element l擾ł΂\ */
        elementBooster rowElement = rowData.element;
        if (rowElement != null) {
            if (columnName != null) {
                String cell = rowElement.attribute(columnName);
                if (cell != null) {
                    return cell;
                }
            }
        }

        /* l擾łȂ "" \ */
        return "";
    } /* getValueAt */


    public elementBooster getElementAt(int row, int col) {
        if (!implemented) {
            return null;
        }

        if (resultVector == null) {
            return null;
        }
        if (resultVector.size() <= row) {
            return null;
        }

        Object selectedRow = resultVector.elementAt(row);
        if (selectedRow == null) {
            return null;
        }

        if (selectedRow instanceof SPElementAndStrings) {
            return ((SPElementAndStrings)selectedRow).element;
        }

        return null;
    } /* getElementAt */


    public Class getColumnClass(int column) {
        int columnID = SPColumnNames.getColumnID(target, column);
        if (columnID < 0) {
            return Object.class;
        }

        if (SPTableColumnModel.isIntegerColumn(columnID)) {
            return Integer.class;
        }

        return Object.class;
    }


    public boolean isImplemented() {
        return implemented;
    }


    /** \[gς݂̃J́Af̃CfNXԂ */
    public int getModelIndexOfSortedColumn() {
        return modelIndexOfSortedColumn;
    }


    public void sort(int columnIndex, boolean updateModelIndexOfSortedColumn) {
        sort(columnIndex, updateModelIndexOfSortedColumn, 0);
    }


    /**
     * @param order ASCENDING: , DESCENDING: ~, ȊO: OƔ]
     *              (O񂪈ႤJꍇ͏)
     */
    public void sort(int columnIndex, boolean updateModelIndexOfSortedColumn,
                     int order) {
        /* ʕ\JL[Ƀ\[g\łȂΖ */
        if (!isSortableTarget(target)) {
            return;
        }

        /* ݂Ɠ columnIndex Ȃ΁A\[g̏𔽓] */
        if (order == DESCENDING) {
            sortOrder = DESCENDING;
        } else if (order == ASCENDING) {
            sortOrder = ASCENDING;
        } else if (modelIndexOfSortedColumn == columnIndex) {
            sortOrder *= -1;
        } else {
            sortOrder = ASCENDING;
        }

        if (updateModelIndexOfSortedColumn) {
            modelIndexOfSortedColumn = columnIndex;
        } else {
            modelIndexOfSortedColumn = -1;
        }

        Comparator comparator;

        int columnID = SPColumnNames.getColumnID(target, columnIndex);
        if (SPColumnNames.isElementColumn(target, columnID)) {
            String attribute = getColumnName(columnIndex);
            boolean isInt = SPTableColumnModel.isIntegerColumn(columnID);
            comparator = new SPElementComparator(attribute, sortOrder, isInt);
        } else {
            boolean isInt = SPTableColumnModel.isIntegerColumn(columnID);
            comparator =
                new SPElementComparator(columnIndex, sortOrder, isInt);
        }

        Object[] elements = resultVector.toArray();
        Arrays.sort(elements, comparator);
        resultVector = new Vector(Arrays.asList(elements));
    } /* sort */


    /**
     * @param Ώ ID
     * @return w肳ꂽΏۂ̌ʕ\A
     *         JL[Ƀ\[g\ǂ
     */
    boolean isSortableTarget(int target) {
        if (target == ISOLATED) {
            return true;
        }
        if (target == LARGE) {
            return true;
        }
        if (target == UNUSED) {
            return true;
        }
        return false;
    } /* isSortableTarget */


    /**
     * Ώ ID J̕\ɕϊ
     */
    static String toString(int targetID) {
        Integer targetIDInteger = new Integer(targetID);
        for (int i = 0; i < TARGET_ID_STRING.length; i++) {
            if (TARGET_ID_STRING[i] == null) {
                continue;
            }
            if (TARGET_ID_STRING[i].length < 1) {
                continue;
            }
            if (TARGET_ID_STRING[i][0].equals(targetIDInteger)) {
                if (TARGET_ID_STRING[i].length < 2) {
                    return "";
                }
                return (String)TARGET_ID_STRING[i][1];
            }
        }
        return null;
    } /* toString */


    /**
     * Ώۂ𐔂PʂԂ
     */
    static String getItemUnit(int targetID) {
        Integer targetIDInteger = new Integer(targetID);
        for (int i = 0; i < TARGET_ID_UNIT.length; i++) {
            if (TARGET_ID_UNIT[i] == null) {
                continue;
            }
            if (TARGET_ID_UNIT[i].length < 1) {
                continue;
            }
            if (TARGET_ID_UNIT[i][0].equals(targetIDInteger)) {
                if (TARGET_ID_UNIT[i].length < 2) {
                    return "";
                }
                return (String)TARGET_ID_UNIT[i][1];
            }
        }
        return null;
    } /* getItemUnit */


    String[] addStringToRowStrings(String[] rowStrings, int target,
                                   int columnID, String value) {
        int columnIndex = SPColumnNames.getColumnIndex(target, columnID);
        if (columnIndex < 0 || rowStrings.length <= columnIndex) {
            return rowStrings;
        }
        rowStrings[columnIndex] = value;
        return rowStrings;
    } /* addStringToRowStrings */
} /* class SPTableModel */
