package jp.co.nri.rid.search;

/** $B%+%i%`L>G[Ns$rJ];}$9$k%/%i%9(B */
public class SPColumnNames {
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPColumnNames.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPColumnNames.java,v 1.11 2003-08-06 18:29:58+09 nsmr Exp $";

    /** $B%+%i%`L>$N(B ID */
    static final int ACTION     = 0;
    static final int CHARSET    = 1;
    static final int CHECKED    = 2;
    static final int CONTENT    = 3;
    static final int FILE       = 4;
    static final int FORM_NAME  = 5;
    static final int HASH       = 6;
    static final int HEIGHT     = 7;
    static final int HTML_ONLY  = 8;
    static final int HTTP_EQUIV = 9;
    static final int INPUT_NAME = 10;
    static final int INPUT_TYPE = 11;
    static final int LANGUAGE   = 12;
    static final int LINK       = 13;
    static final int META_NAME  = 14;
    static final int METHOD     = 15;
    static final int COUNT      = 16;
    static final int PAGE_TYPE  = 17;
    static final int RESOURCES  = 18;
    static final int SIZE       = 19;
    static final int SOURCE     = 20;
    static final int STYLE      = 21;
    static final int TITLE      = 22;
    static final int TOTAL      = 23;
    static final int TYPE       = 24;
    static final int UNIT       = 25;
    static final int VALUE      = 26;
    static final int WIDTH      = 27;

    static final int NUMCOLUMNS = 28;

    static final String COLUMN_ID_STRING[][] = {
        {Integer.toString(ACTION),     "Action"},
        {Integer.toString(CHARSET),    "Charset"},
        {Integer.toString(CHECKED),    "Checked"},
        {Integer.toString(CONTENT),    "Content"},
        {Integer.toString(FILE),       "File"},
        {Integer.toString(FORM_NAME),  "Form Name"},
        {Integer.toString(HASH),       "#"},
        {Integer.toString(HEIGHT),     "Height"},
        {Integer.toString(HTML_ONLY),  "HTML only"},
        {Integer.toString(HTTP_EQUIV), "Http-equiv"},
        {Integer.toString(INPUT_NAME), "Input Name"},
        {Integer.toString(INPUT_TYPE), "Input Type"},
        {Integer.toString(LANGUAGE),   "Language"},
        {Integer.toString(LINK),       "Link"},
        {Integer.toString(META_NAME),  "Meta Name"},
        {Integer.toString(METHOD),     "Method"},
        {Integer.toString(COUNT),      "Count"},
        {Integer.toString(PAGE_TYPE),  "PageType"},
        {Integer.toString(RESOURCES),  "Resources"},
        {Integer.toString(SIZE),       "Size"},
        {Integer.toString(SOURCE),     "Source"},
        {Integer.toString(STYLE),      "Style"},
        {Integer.toString(TITLE),      "Title"},
        {Integer.toString(TOTAL),      "Total [Byte]"},
        {Integer.toString(TYPE),       "Type"},
        {Integer.toString(UNIT),       "Unit"},
        {Integer.toString(VALUE),      "Value"},
        {Integer.toString(WIDTH),      "Width"}
    };

    /**
     * $B8!:w7k2LI=<(%F!<%V%k$N%+%i%`L>(B<BR>
     * {$B8!:wBP>]$N(B ID, $B%+%i%`L>$N(B ID [, $B%+%i%`L>(B...]}
     */
    static final int[][] COLUMN_NAMES = {
        {SPTableModel.ISOLATED, FILE, TITLE, PAGE_TYPE, SIZE},
        {SPTableModel.LARGE, FILE, TITLE, TOTAL, HTML_ONLY, RESOURCES},
        {SPTableModel.UNUSED, FILE, WIDTH, HEIGHT, SIZE},
        {SPTableModel.FORM, FILE, FORM_NAME, ACTION, METHOD, INPUT_NAME,
         INPUT_TYPE, VALUE, CHECKED, SOURCE},
        {SPTableModel.META, FILE, META_NAME, HTTP_EQUIV, CONTENT},
        {SPTableModel.SCRIPT, FILE, LANGUAGE, TYPE, CHARSET, SOURCE},
        {SPTableModel.STYLESHEET, FILE, TYPE, LINK},
        {SPTableModel.STATISTICS, UNIT, COUNT, TOTAL}
    };

    /**
     * $B8!:w7k2LI=<(%F!<%V%k$N%+%i%`$N$&$A(B XML $B$N%"%H%j%S%e!<%H$rI=<($9$kNs(B<BR>
     * {$B8!:wBP>]$N(B ID, $B%+%i%`L>$N(B ID [, $B%+%i%`L>(B...]}
     */
    static final int[][] ELEMENT_COLUMNS = {
        {SPTableModel.ISOLATED, FILE, TITLE, PAGE_TYPE, SIZE},
        {SPTableModel.LARGE, FILE, TITLE},
        {SPTableModel.UNUSED, FILE, WIDTH, HEIGHT, SIZE},
    };

    /** $B8!:w7k2LI=<(%F!<%V%k$N%+%i%`L>$N%O%C%7%e%F!<%V%k(B */
    static private int[][] columnNamesArray;


    /** columnNamesArray $B$N=i4|2=(B */
    static void init() {
        columnNamesArray = new int[SPTableModel.NUMTARGETS][];

	if (COLUMN_NAMES == null) {
	    return;
	}

	for (int i = 0; i < COLUMN_NAMES.length; i++) {
	    if (COLUMN_NAMES[i] == null) {
		continue;
	    }
            int targetID = COLUMN_NAMES[i][0];
            if (targetID < 0 || SPTableModel.NUMTARGETS <= targetID) {
                continue;
            }
            columnNamesArray[targetID] = new int[COLUMN_NAMES[i].length - 1];

	    for (int j = 1; j < COLUMN_NAMES[i].length; j++) {
                columnNamesArray[targetID][j-1] = COLUMN_NAMES[i][j];
	    }
	}
    } /* init */


    static int[] get(int targetID) {
        if (targetID < 0 || columnNamesArray.length <= targetID) {
            return null;
        }
	return columnNamesArray[targetID];
    } /* get */


    static int getColumnIndex(int targetID, int columnID) {
        if (targetID < 0 || columnNamesArray.length <= targetID) {
            return -1;
        }

        for (int i = 0; i < columnNamesArray[targetID].length; i++) {
            if (columnNamesArray[targetID][i] == columnID) {
                return i;
            }
        }
        return -1;
    } /* getColumnIndex */


    static int getColumnID(int targetID, int columnIndex) {
        if (targetID < 0 || columnNamesArray.length <= targetID) {
            return -1;
        }

        if (columnIndex < 0 ||
            columnNamesArray[targetID].length <= columnIndex) {
            return -1;
        }

        return columnNamesArray[targetID][columnIndex];
    } /* getColumnID */


    /**
     * $B%+%i%`L>(B ID $B$r%+%i%`L>$NJ8;zNsI=8=$KJQ49$9$k(B
     */
    static String toString(int columnID) {
        String columnIDString = Integer.toString(columnID);
        for (int i = 0; i < COLUMN_ID_STRING.length; i++) {
            if (COLUMN_ID_STRING[i] == null) {
                continue;
            }
            if (COLUMN_ID_STRING[i].length < 1) {
                continue;
            }
            if (COLUMN_ID_STRING[i][0].equals(columnIDString)) {
                if (COLUMN_ID_STRING[i].length < 2) {
                    return "";
                }
                return COLUMN_ID_STRING[i][1];
            }
        }
        return null;
    } /* toString */

    /** 
     * @return $B;XDj$5$l$?%+%i%`$,!"(BXML $B%(%l%a%s%H$N%"%H%j%S%e!<%H$rI=<($9$kNs$G(B
     * $B$"$k$+$I$&$+(B
     */
    static boolean isElementColumn(int targetID, int columnID) {
        for (int i = 0; i < ELEMENT_COLUMNS.length; i++) {
            if ((ELEMENT_COLUMNS[i][0] != targetID)) {
                continue;
            }
            for (int j = 1; j < ELEMENT_COLUMNS[i].length; j++) {
                if (ELEMENT_COLUMNS[i][j] != columnID) {
                    continue;
                }
                return true;
            }
        }
        return false;
    } /* isElementColumn */
} /* class SPColumnNames */
