/*
 * @(#)XmlUtil.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X :  XPath Utility
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/18
 */
package jp.co.nri.rid.mapper;


import java.io.*;
import org.w3c.dom.*;

import org.apache.xpath.XPathAPI;
import org.apache.xml.serialize.*;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import	jp.co.iti.fagot.util.*;

/**
  * XPath Utility
  **/
public class XmlUtil {

/**
  * RXgN^
  *
  */
    public XmlUtil() {}

/**
  * Gg̃eLXg擾
  *
  * @param  Node        elem            eGg
  * @param  String      rel_xpath       Gg
  *
  * @return String      eLXg
  */
    public String getTextValue(Node elem, String rel_xpath) throws Exception {
        Node rel_elem = XPathAPI.selectSingleNode( elem, rel_xpath );
        if (rel_elem == null) {
            ZDebug.err("Fail to get text Value: \"" + rel_xpath + "\" in " + elem.getNodeName() + ".");
            throw new Exception();
        }
        return getTextValue( rel_elem );
    }



/**
  * Gg̃eLXg擾
  *
  * @param  Node        elem            Gg
  *
  * @return String      eLXg
  */
    public String getTextValue(Node elem) throws Exception {
        Node text_node = XPathAPI.selectSingleNode( elem, "text()" );
        if (text_node == null) {
            return "";
        }
        return text_node.getNodeValue();
    }



/**
  * GgɃeLXg𐶐^擾
  *
  * @param  Node        elem            Gg
  *
  * @return String      eLXg
  */
    public String createOrGetTextValue(Node elem) throws Exception {
        Node text = XPathAPI.selectSingleNode( elem, "text()" );
        if (text == null) {
            Document doc = elem.getOwnerDocument();
            text = doc.createTextNode("");
            elem.appendChild(text);
        }
        return text.getNodeValue();
    }



/**
  * GgɃeLXg擾^݂Ȃꍇ͐
  *
  * @param  Node        elem            Gg
  * @param  String      rel_xpath       Gg
  *
  * @return String      eLXg
  */
    public String createOrGetTextValue(Node elem, String rel_xpath) throws Exception {
        Element text_elem = createOrGetSubElement( elem, rel_xpath );
        return createOrGetTextValue(text_elem);
    }



/**
  * GgɃeLXgw肷
  *
  * @param  Node        elem            eGg
  * @param  String      rel_xpath       Gg
  * @param  String      value           l
  *
  * @return void
  */
    public void setTextValue( Node elem, String rel_xpath, String value ) throws Exception {
        Node rel_elem = XPathAPI.selectSingleNode( elem, rel_xpath );
        if ( rel_elem == null ) {
            ZDebug.err("Fail to set text Value.");
            throw new Exception();
        }
        setTextValue( rel_elem, value );
    }



/**
  * GgɃeLXgw肷
  *
  * @param  Element     elem            Gg
  * @param  String      value           l
  *
  * @return void
  */
    public void setTextValue( Node elem, String value ) throws Exception {
        Node text_node = XPathAPI.selectSingleNode( elem, "text()" );
        text_node.setNodeValue(value);
    }



/**
  * GgɃeLXgw肷
  *
  * @param  Element     elem            Gg
  * @param  String      value           l
  *
  * @return void
  */
    public void createOrSetTextValue( Node elem, String value ) throws Exception {
        Node text_node = XPathAPI.selectSingleNode( elem, "text()" );
        if ( text_node == null ) {
            Document doc = elem.getOwnerDocument();
            Node text = doc.createTextNode(value);
            elem.appendChild(text);
        } else{
            text_node.setNodeValue(value);
		}
    }



/**
  * TuGg(/擾)AeLXgw肷
  *
  * @param  Element     parentElem      eGg
  * @param  String      subElemName     Gg
  * @param  String      value           l
  *
  * @return void
  */
    public void createOrSetTextValue( Element elem, String subElemName, String value ) throws Exception {
        Element subelem = createOrGetSubElement( elem, subElemName );
        createOrSetTextValue( subelem, value );
    }



/**
  * TuGg̐@́@擾
  *
  * @param  Element     parentElem      eGg
  * @param  String      subElemName     Gg
  *
  * @return Element     Gg
  */
    public Element createOrGetSubElement( Node parentElem, String subElemName ) throws Exception {

        Element elem = (Element)XPathAPI.selectSingleNode( parentElem, subElemName );
        if ( elem == null ) {
            Document doc = parentElem.getOwnerDocument();
            elem = doc.createElement(subElemName);
            parentElem.appendChild(elem);
        }
        return elem;
    }



/**
  * TuGg̐
  *
  * @param  Element     parentElem      eGg
  * @param  String      subElemName     Gg
  *
  * @return Element     Gg
  */
    public Element createSubElement( Node parentElem, String subElemName ) throws Exception {
        Document doc = parentElem.getOwnerDocument();
        Element elem = doc.createElement(subElemName);
        parentElem.appendChild(elem);
        return elem;
    }



/**
  * GgɃAgr[g@́@擾
  *
  * @param  Element     parentElem      Gg
  * @param  String      attrName        Agr[g
  *
  * @return Attr        Agr[g
  */
/*
    public Attr createOrGetAttribute( Element parentElem, String attrName ) throws Exception {
        Attr attr = (Attr)XPathAPI.selectSingleNode( parentElem, "@" + attrName );
        if ( attr == null ) {
            Document doc = parentElem.getOwnerDocument();
            attr = doc.createAttribute(attrName);
            attr.setNodeValue("");
            parentElem.setAttributeNode(attr);
        }
        return attr;
    }
*/


/**
  * GgɃTuGg݂邩̔f
  *
  * @param  Element     parent          Gg
  * @param  String      childName       TuGgi^Oj
  *
  * @return boolean     true(݂) / false (݂Ȃ)
  */
    public boolean hasChild(Element parent, String childName) throws Exception{
        NodeList list = XPathAPI.selectNodeList(parent, childName);
        return (list.getLength() > 0);
    }



/**
  * XML̃t@Co
  *
  * @param  String      file            o̓t@C
  * @param  Document    document        hLg
  *
  * @return boolean     true(݂) / false (݂Ȃ)
  */
  public boolean writeDocment2XMLFile(String file, Document document) throws Exception  {
      // o
      OutputFormat fm = new OutputFormat(document,"Shift_JIS", true);
      FileOutputStream out = new FileOutputStream(file);
      DOMSerializer ser = new XMLSerializer(out,fm).asDOMSerializer();
      ser.serialize(document);
      return true;
  }

}