/*
 * @(#)MapperType1.java
 *
 * RID-X : Mapper
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/15
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */

package jp.co.nri.rid.mapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.w3c.dom.*;
import org.apache.xpath.XPathAPI;

import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.*;


import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;


/**
 * Mapper(Type2)
 */
public class MapperType2 extends MapperBase {

    /** G[bZ[W **/
    private static String pr_errorString;

    /*@ROOT@ELEMENT̒`FRID@*/
    /** RidProject̒` **/
    private static final String ROOT_ELEMENT  = "RidProject";
    /** MapAttr̒` **/
    private static final String MAP_ATTR      = "MapAttr";
    /** MapAttrData̒` **/
    private static final String MAP_ATTR_DATA = "MapAttrData";
    /** Rid_Tmp̒` **/
    private static final String RID_TMP       = "Rid_Tmp";
    /** MapData̒` **/
    private static final String MAPDATA       = "MapData";

    /*@̒`@*/
    /** srcTag̒` **/
    private static final String SRC_TAG       = "srcTag";
    /** srcKey̒` **/
    private static final String SRC_KEY       = "srcKey";
    /** dataTag̒` **/
    private static final String DATA_TAG      = "dataTag";
    /** dataKey̒` **/
    private static final String DATA_KEY      = "dataKey";
    /** inTag̒` **/
    private static final String IN_TAG        = "inTag";
    /** outAttr̒` **/
    private static final String OUT_ATTR      = "outAttr";
    /** name̒` **/
    private static final String NAME          = "name";


/**
  * RXgN^
  *
  */
    public MapperType2() {
        //NA
        pr_errorString = "";
    }


/**
  * (Mapper_Type2)
  *
  * ev[gt@CiHTML)<Rid_Tmp>^O
@* DATAhLg̒lɒuāAw肳ꂽt@Cɏo͂
  *
  * @param  String      in_file         INPUTt@C   (HTML`)
  * @param  Document@  data_doc        DATAhLg(XML `)
  * @param  String      out_file        OUTPUTt@C  (HTML`)
  *
  * @return boolean     true() / false (s)
  */
    public boolean Type2(String in_file, Document data_doc, String out_file)  throws RidException {

        boolean ret = false;
        Vector  data_lst = new Vector();
        RidMessage ridMsg = new RidMessage();

        try {
            //t@CL
            if (checkFile(in_file)) {
                //DATAhLg̉
                ret = type2DataDocParser(data_doc, data_lst);
                if (ret) {
                    //
                    ret = type2Generate(in_file, data_lst, out_file);
                }
            }
            //C[Wt@CRs[
            if (ret){
              MapperResource  mr = new MapperResource();
              mr.imageFileCopy(in_file, out_file);
            }
        }
        catch(Exception e){
            String err_msg = ridMsg.Error("E4002"," (Mapper) " + e.getMessage());
            if (err_msg.indexOf("Filename too long") != -1) {
                err_msg =  ridMsg.Error("E4003"," (Mapper) " + e.getMessage());
            }
            throw new RidException(err_msg);
        }
        return ret;
   }

/**
  * (Mapper_Type2)
  *
  * ev[gt@CiHTML)<Rid_Tmp>^O
@* DATAhLg̒lɒuāAw肳ꂽt@Cɏo͂
  *
  * @param  String      in_file         INPUTt@C   (HTML`)
  * @param  Document@  data_doc        DATAhLg(XML `)
  * @param  String      out_file        OUTPUTt@C  (HTML`)
  *
  * @return boolean     true() / false (s)
  */
    public boolean TypeScript(String in_file, Document data_doc, String out_file)  throws RidException {

        boolean ret = false;
        Vector  data_lst = new Vector();
        RidMessage ridMsg = new RidMessage();

        try {
            //t@CL
            if (checkFile(in_file)) {
                //DATAhLg̉
                ret = type2DataDocParser(data_doc, data_lst);
                if (ret) {
                    //
                    ret = type2Generate(in_file, data_lst, out_file);
                }
            }
        }
        catch(Exception e){
            String err_msg = ridMsg.Error("E4002"," (Mapper) " + e.getMessage());
            if (err_msg.indexOf("Filename too long") != -1) {
                err_msg =  ridMsg.Error("E4003"," (Mapper) " + e.getMessage());
            }
            throw new RidException(err_msg);
        }
        return ret;
   }



/**
  * (Mapper_Type2)
  * f[^t@C̉
  *
  * @param  String      data_file       f[^t@C
  * @param  Vector      data_lst        DataItemNX̔z
  *
  * @return boolean     true() / false(s)
  */
    public boolean type2DataDocParser(Document data_doc, Vector data_lst) throws Exception {


        XmlUtil xu = new XmlUtil();
        boolean ret = false;

        // f[^XMLt@C̃[gGg擾
        Element root_elem = root_elem = data_doc.getDocumentElement();
        if (!checkRootElement(root_elem, ROOT_ELEMENT)) {
            String msg = "Root element name is different.";
            setErrorString(msg);
            root_elem = null;
        }

        if(root_elem != null) {
            NodeList data_elem_lst = XPathAPI.selectNodeList(root_elem, "*");
            for (int i =0; i < data_elem_lst.getLength(); i++) {
                Element data_elem = (Element)data_elem_lst.item(i);

                // ADD Data List
                DataItem data = new DataItem();
                data.tagName  = RID_TMP;
                data.keyName  = data_elem.getNodeName();
                data.inData   = xu.getTextValue(data_elem);
                data.outAttr  = "";
                data_lst.add(data);
            }
            ret = true;
        }
        return ret;
    }



/**
  * (Mapper_Type2)
  * TYPE2̐
  *
  * @param  String      in_file         ̓t@C
  * @param  Vector      data_lst        DataItemNX̔z
  * @param  String      out_file        o͓̓t@C
  *
  * @return boolean     true() / false(s)
  */
    public boolean type2Generate(String in_file, Vector data_lst, String out_file) throws Exception{

        boolean ret = false;

        char str[] = new char[256];

        // ̓t@C<RID_TMP>^Ȍ𔲏o
        Vector inTag_lst = new Vector();
        templateFileParser(in_file, inTag_lst);

        // INPUTt@C̃I[v
        InputStreamReader InData=new InputStreamReader(new FileInputStream(in_file));

        // OUTOUTt@C̃I[v
        OutputStreamWriter outWriter = new OutputStreamWriter(new FileOutputStream(out_file));

        int pos = 0;
        for ( int n = 0; n < inTag_lst.size(); n ++ ) {
            TagItem inTag = (TagItem)inTag_lst.elementAt(n);

            // <Rid_Tmp>^O̍ŏ̈ʒu܂ŏo͂
            while ((InData.read(str, 0, 1)) != -1) {
                if (pos < inTag.sPos) {
                    outWriter.write(str, 0, 1);
                } else {
                    pos++;
                    break;
                }
                pos++;
            }

            // Rid_Tmp̂NAMEƓ
            for ( int m = 0; m < data_lst.size(); m ++ ) {
                DataItem data = (DataItem)data_lst.elementAt(m);
                if (inTag.keyName.compareToIgnoreCase(data.keyName) == 0)
                    outWriter.write(data.inData, 0, data.inData.length());
            }

            // </Rid_Tmp>^Oǔ΂
            while ((InData.read(str, 0, 1)) != -1) {
                if (pos < inTag.ePos) {
                    //ǂݔ΂;
                } else {
                    pos++;
                    break;
                }
                pos++;
            }
        }

        // Ō܂œǍ
        while ((InData.read(str, 0, 1)) != -1) {
            outWriter.write(str, 0, 1);
        }

        // t@CN[Y
        InData.close();
        outWriter.close();
        
        return true;
   }


/**
  * (Mapper_Type2)
  * Templatet@C<RID_TMP>̏𔲏o
  *
  * @param  String      in_file         ̓t@C
  * @param  Vector      data_lst        DataItemNX̔z
  *
  * @return void
  */
    private void templateFileParser(String in_file, Vector inTag_lst) throws Exception {

        //in_file@Parser
        Vector tag_lst = new Vector();
        htmlParser(in_file, tag_lst);

        // HTML^O̔z񂩂AMapItemsrcTag^O𔲏o
        for (int n = 0; n < tag_lst.size(); n ++ ) {
            // HTML^O̎擾
            TagItem htmlTag = (TagItem)tag_lst.elementAt(n);

            //啶ɕϊ
            String tagStringUp  = htmlTag.tagString.toUpperCase();
            String srcTagUp     = "<" + RID_TMP.toUpperCase();

            //srcTag^O̔f
            if (tagStringUp.indexOf(srcTagUp) != -1) {

                //srcKey̎擾
                String srcKey = getAttrValue(htmlTag.tagString, NAME);

                //
                if (srcKey != ""){
                  TagItem srcTag = new TagItem();
                  srcTag.tagName     = RID_TMP;
                  srcTag.keyName     = srcKey;
                  srcTag.tagString   = htmlTag.tagString;
                  srcTag.sPos        = htmlTag.sPos;
                  srcTag.ePos        = htmlTag.ePos;
                  inTag_lst.add(srcTag);
                }
            }
        }
  }

/**
  * t@C݂邩ǂAǂݍ݉\ǂmF
  *
  * @param  String      in_file         Lt@C
  *
  * @return boolean     true(݂) / false (݂Ȃ)
  */
    public boolean checkFile(String in_file) {

        boolean ret = true;

        if (!isFile(in_file)) {
            String msg = "no such source file: \"" + in_file + "\"";
            setErrorString(msg);
            ret =  false;
        }
        return ret;
    }


/**
  * G[bZ[W̐ݒ
  *
  * @param  String      errorString     G[bZ[W
  * @return void
  */
    private void setErrorString(String errorString) {
        pr_errorString = errorString;
    }

/**
  * G[bZ[W̎擾
  *
  * @return String      G[bZ[W
  */
    public String getErrorString() {
        return pr_errorString;
    }

/****************************************************************************************************************/




}