/*
 * @(#)MapperResource.java
 *
 * RID-X : Mapper
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/15
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */

package jp.co.nri.rid.mapper;

import org.w3c.dom.*;
import java.io.File;
import java.util.Vector;

import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

import jp.co.nri.rid.snapshot.xcopy;



/**
 * Mapper Resource<br>
 * \[Xt@CRs[
 */
public class MapperResource extends MapperBase {

    /** G[bZ[W **/
    private static String pr_errorString;

/**
  * RXgN^
  *
  */
    public MapperResource() {
        //NA
        pr_errorString = "";
    }

/*******************************************************************************/

/**
  * C[Wt@CRs[
  *
  * @param  String      in_file         ̓t@C
  * @param  String      out_file        o̓t@C
  * @return void
  */
    public void imageFileCopy(String in_file, String out_file) throws Exception {

        // \[Xt@C̊gqꗗ擾
        ZProperties prop  = DocManager.loadProperty( DocManager.ELEMENT );
        String[] extensions = ZString.tokenize(prop.getProperty("import.resource.extensions"));

        // ޖƑ
        String[] TagName  = { "IMG", "INPUT", "EMBED", "BODY", "TABEL", "TR", "TD"};
        String[] AttrName = { "SRC", "BACKGROUND"};

        //HTML FILE Parser
        Vector img_lst = new Vector();
        Vector tag_lst = new Vector();
        htmlParser(in_file, tag_lst);

        // HTML^O̔z񂩂AMapItemsrcTag^O𔲏o
        for (int n = 0; n < tag_lst.size(); n ++ ) {
            // HTML^O̎擾
            TagItem htmlTag = (TagItem)tag_lst.elementAt(n);

            //Sđ啶Ŕf@啶ɕϊ
            String tagStringUp  = htmlTag.tagString.toUpperCase();

            // ޖ LOOP
            for ( int i = 0 ; i < TagName.length ; i++ ) {
                // ޖ
                String srcTagUp = "<" + TagName[i];

                // ޖ̔f
                if (tagStringUp.indexOf(srcTagUp) != -1) {
                    // ޖvꍇ 鑮 LOOP
                    for ( int m = 0 ; m < AttrName.length ; m++ ) {
                        //srcKey̎擾
                        String imgSrc = "";
                        imgSrc = getAttrValue(htmlTag.tagString, AttrName[m]);

                        // imgSrcݒ肳ĂΓo^
                        if (imgSrc != "" && IsExtensions(extensions, imgSrc)){
                            htmlTag.tagName = "Resource";
                            htmlTag.keyName = imgSrc;
                            // o^ĂȂꍇo^
                            if (-1 == img_lst.indexOf(htmlTag))
                                img_lst.add((htmlTag));
                        }
                    }
                }
            }
        }

        // Rs[̃fBNg擾
        String buff;
        buff = replaceWebSeparator(in_file);
        String source_dir = buff.substring(0, buff.lastIndexOf("/"));

        // Rs[̃fBNg擾
        buff = replaceWebSeparator(out_file);
        String dest_dir   = buff.substring(0, buff.lastIndexOf("/"));

        // \[Xt@C̃Rs[ ***
        resourceFileCopy(source_dir, dest_dir, img_lst);
    }


/**
  * w肳ꂽgqf
  *
  * @param  String[]    ext_lst         gq̃Xg
  * @param  String      filename        t@C
  * @return boolean     true / false
  */
    private boolean IsExtensions(String[] ext_lst, String filename) throws Exception {

        boolean ret = false;

        // \[Xt@Cgqɂ
        String buff = replaceWebSeparator(filename);
        String extensions = buff.substring(Math.min(buff.lastIndexOf(".")+1, buff.length()));

        // gqXgɈv邩f
        for (int n = 0 ; n < ext_lst.length ; n++) {
            if (extensions.equalsIgnoreCase(ext_lst[n])){
                ret = true;
                break;
            }
        }
        return ret;
    }


/**
  * \[Xt@CRs[
  *
  * @param  String      source_dir      Rs[fBNg
  * @param  String      dest_dir        Rs[fBNg
  * @param  Vector      img_lst         \[Xt@CXg
  * @return void
  */
    private void resourceFileCopy(String source_dir, String dest_dir, Vector img_lst) throws Exception {

        xcopy xc = new xcopy();
        
        for (int n = 0; n < img_lst.size(); n ++ ) {
            // HTML^O̎擾
            TagItem imgTag = (TagItem)img_lst.elementAt(n);

            // fBNg݂Ȃ΍쐬
            String dir_buff = replaceWebSeparator(imgTag.keyName);
            String dir  = dir_buff.substring(0, dir_buff.lastIndexOf("/"));
            xc.makeDir(replaceWebSeparator(dest_dir +  File.separator + dir));

            // copy source --> dest
            String source_name = replaceWebSeparator(source_dir + File.separator + imgTag.keyName);
            String dest_name = replaceWebSeparator(dest_dir + File.separator + imgTag.keyName);
            xc.file(source_name, dest_name);
        }
    }


/**
  * G[bZ[W̐ݒ
  *
  * @param  String      errorString     G[bZ[W
  * @return void
  */
    private void setErrorString(String errorString) {
        pr_errorString = errorString;
    }

/**
  * G[bZ[W̎擾
  *
  * @return String      G[bZ[W
  */
    public String getErrorString() {
        return pr_errorString;
    }

/****************************************************************************************************************/




}