/*
 * @(#)MapperAccessLog.java
 *
 * RID-X : MapperAccessLog
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/04/05
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */

package jp.co.nri.rid.mapper;

import org.w3c.dom.*;
import java.io.File;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

import jp.co.nri.rid.error.RidException;


/**
 * Mapper AccessLog
 */
public class MapperAccessLog {

    /** ev[gfBNg **/
    static final String RID_TEMPLATE_DIR = "rid.template.dir";
    /**map.xml **/
    static final String puMapXml    = "accesslog_map.xml";
    /** RidProject^O̒` **/
    static final String puRootTag   = "RidProject";
    /** Page^O̒` **/
    static final String puPageTag   = "Page";
    /** File^O̒` **/
    static final String puFileTag   = "File";
    /** accesscount^O **/
    static final String puAccessTag = "accesscount";

/**
  * RXgN^
  *
  */
    public MapperAccessLog() {
    }


/**
  *
  * ANZXOiCSV`)SITE.XML<PageUnit>AccessCountƂĂǉ
  *
  * @param  String      project_dir     vWFNgfBNg
  * @param  Document    doc             SITE.XML̃hLg
  * @param  String      csvfile         ANZXOt@CiCSV`)
  *
  * @return boolean     true() / false(s)
  */
  public boolean accesslog(String project_dir, Document doc, String csvfile)  throws RidException, Exception {

      boolean ret = true;

      // CSV`̃ANZXOMapper(Type1)̃f[^`iDOM`jɕϊ
      Document date_doc = makeDOM(csvfile);

      // ev[gfBNg
      ZResource res = ZApp.getTheApp().getResource();
      String template_dir = res.getString(RID_TEMPLATE_DIR);
      String mapfile = project_dir + File.separator + template_dir + File.separator + puMapXml;

      //Mapper <PageUnit> AccessCountǉ
      MapperType1 mt1 = new MapperType1();
      ret  = mt1.Type1Xml(doc.getDocumentElement(), mapfile, date_doc.getDocumentElement());

      return ret;
  }

/**
  *
  * CSVt@CDOM`ɕϊ
  *
  * <RidProject>
  *   <Page File="url">
  *     <accesscount>accesscount</accesscount>
  *   </Page>
  *                     ....<Page>^ǑJԂ
  * </RidProject>
  *
  * @param  String      csvfile         CSVt@C
  *
  * @return boolean     Document
  */
  public Document makeDOM(String csvfile)  throws RidException, Exception {

      XmlUtil xu = new XmlUtil();
      Element page_elem;
//      Attr attr;
      String line = null;

      // CSVt@CI[v
      BufferedReader bufreader = new BufferedReader(new FileReader(csvfile));

      // hg
      Document doc = new org.apache.xerces.dom.DocumentImpl();
      Element topElem = doc.createElement(puRootTag);
      doc.appendChild(topElem);

      /* CSVf[^DOMc[쐬 */
      while((line =bufreader.readLine()) != null){
            StringTokenizer tokens= new StringTokenizer(line,",");

            //g[No񐔂̎擾
            int count = tokens.countTokens(); 

            if (count != 0) {
                //1ڂ̃y[W擾
                String url = tokens.nextToken();

                //ANZXJEg擾 (URL+PRs[)
                String ac_buff = line.substring(Math.max(0,url.length()+1));

                //ANZXJEg["]͎菜
                StringTokenizer tokens2 = new StringTokenizer(ac_buff,"\"");
                String accesscount = "";
                while (tokens2.hasMoreTokens()) {
                    accesscount = accesscount + tokens2.nextToken();
                }

                // lNULLl̏ꍇ ""ɂ
                if (isNullString(url))  url = "";
                if (isNullString(accesscount)) accesscount = "";

                // url̐擪[ / ]폜
                if (url.length() > 0 )  url = url.substring(1);

                //DOM Write
                page_elem = xu.createSubElement(topElem, puPageTag);
				page_elem.setAttribute(puFileTag, url);
//                attr = xu.createOrGetAttribute(page_elem, puFileTag);
//                xu.createOrSetTextValue((Node)attr, url);
                xu.createOrSetTextValue(page_elem, puAccessTag, accesscount);
            }
      }
      return doc;
    }

/**
  * String^mtkkf
  *
  * @param  String      str           t@C
  * @return boolean     true (null)/false(not null)
  */
    public boolean isNullString(String str) throws Exception {

        boolean ret;
        if ((str == null) || (str == ""))
            ret = true;
        else
            ret = false;
        return ret;
    }

}