/*
 * @(#)GeneratePresent.java
 *
 * RID-X    : Generator ŋ
 *
 * @author    Intelligent Technology Inc.
 * @version   1.01 2001/12/21
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */
package jp.co.nri.rid.generator;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import java.util.Random;
import org.w3c.dom.*;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;


import jp.co.nri.Ridual;
import jp.co.nri.rid.mapper.*;
import jp.co.nri.rid.snapshot.*;
import jp.co.nri.rid.error.*;


/**
 * Rid ŋ
 */
public class GeneratePresent extends GenerateParser {

    /** rid.template.dirvpeB  **/
    final static public String RID_TEMPLATE_DIR = "rid.template.dir";
    /** rid.parts.dirvpeB  **/
    final static public String RID_PARTS_DIR    = "rid.parts.dir";
    /** rid.public.dirvpeB  **/
    final static public String RID_PUBLIC_DIR   = "rid.public.dir";
    /** rid.html.dirvpeB  **/
//    final static public String RID_HTML_DIR     = "rid.html.dir";

    /** TOP@URL  **/
    private static String pr_url;
    /** ev[gfBNg  **/
    private static String pr_templateDir;
    /** ev[gfBNg  **/
    private static String pr_partsDir;
    /** o̓fBNg  **/
    private static String pr_outDir;
    /** TOP@URL  **/
    private static String pr_htmlDir;

/**
  * ftHgRXgN^
  */
    public GeneratePresent() {
        pr_url = "";                        // TOP URL
        pr_templateDir = "";                // ev[gfBNg
        pr_partsDir    = "";                // ev[gfBNg
        pr_outDir      = "";                // o̓fBNg
        pr_htmlDir     = "";                // htmlfBNg
    }


/**
  * ŋ
  *
  * @param  Document    doc             hLg
  * @param  String      project_dir     vWFNgfBNg
  * @return boolean     trueij/ falseisj
  */
    public boolean generate(Document doc, String project_dir) throws Exception {

        boolean ret = false;
        RidMessage ridMsg = new RidMessage();

        getDir(project_dir);

        //ŋ̃fBNg̓e폜
        erase del = new erase();
        ret = del.directory(pr_outDir);
        if(!ret)  ZDebug.trace(ridMsg.Warning("W4003", pr_outDir));

        // document̉
        ProjectInfo  project_info = new ProjectInfo();
        project_info = documentParser(doc, "", parentPath(pr_outDir, pr_htmlDir));

        // ŋ̐
        ret = generatePresent(project_info);

        return true;
    }


/**
  * TOP URL̎擾
  *
  * @return String      TOP@URL
  */
    public String getUrl() throws Exception {
        return pr_url;
    }


/**
  * TOP URL̐ݒ
  *
  * @param  String      url             TOP URL
  * @return void
  */
    private void setUrl(String url) throws Exception {
        pr_url = url;
    }


/**
  * ŋ̐
  *
  * @param  ProjectInfo project         vWFNg
  * @return boolean     trueij/ falseisj
  */
    private boolean generatePresent(ProjectInfo project) throws Exception {

        boolean ret = false;
        String refresh = "";

        //Top Zone
        ZoneInfo zone_info = project.zone;
        ret = presentZoneInfo(zone_info, null);

        if (ret) {
            if (zone_info.page_lst.size() != 0) {
                //TOP URL
                PageInfo page_info = (PageInfo)zone_info.page_lst.elementAt(0);
                setUrl(page_info.url);
                refresh = page_info.name;
            } else {
                setUrl(pr_outDir + File.separator + puBlank + puOutFrame);
                refresh = puBlank;
            }

            //ŋ̃tbV쐬 
            GenerateRefresh   gr = new GenerateRefresh();
            gr.generateRefresh(pr_templateDir, pr_outDir, refresh);
        }
        return ret;
    }

/**
  * ŋ̐(ZONE)
  *
  * @param  ZoneInfo    zone            Zone
  * @param  ZoneInfo    parent          eZone
  * @return void
  */
    private boolean presentZoneInfo(ZoneInfo zone, ZoneInfo parent) throws Exception {

        boolean ret = false;

        //fBNg̍쐬 ZonẽgbvȊO
        if ( !zone.top ) {
            xcopy xc = new xcopy();
            xc.makeDir(pr_outDir + File.separator + zone.file); 
        }

        //Page
        if (zone.page_lst.size() > 0) {
            //ZoneɃy[W݂
            for ( int i = 0; i < zone.page_lst.size(); i++ ) {
                PageInfo page_info = (PageInfo)zone.page_lst.elementAt(i);
                ret = presentPageInfo(zone, page_info);
                if (!ret) return false;
            }
        } else {
            //y[W݂Ȃꍇ́ABlankt[쐬
            presentFrame(zone, null);
        }

        //Zone
        for ( int n = 0; n < zone.zone_lst.size(); n++ ) {
            ZoneInfo zone_info = (ZoneInfo)zone.zone_lst.elementAt(n);
            ret = presentZoneInfo(zone_info, zone);
            if (!ret) return false;
        }

        // ir
        GenerateNavibar gn = new GenerateNavibar();
        ret = gn.generate(GenerateNavibar.PRESENT, pr_templateDir, pr_outDir, zone, parent);

        return ret;
    }



/**
  * ŋ̐(PAGE)
  *
  * @param  String      zone_name       ZoneifBNgj
  * @param  PageInfo    page            y[W
  * @return boolean     trueij/ falseisj
  */
    private boolean presentPageInfo(ZoneInfo zone, PageInfo page) throws Exception {

        boolean ret = false;

        // t[̍쐬
        ret = presentFrame(zone,  page);
        //ł̓y[WȂ@2002/08/13
        //if (ret) {
        //    // y[W̐
        //    GeneratePage gp = new GeneratePage();
        //    ret = gp.generate(pr_htmlDir, pr_templateDir, pr_partsDir, zone, page);
        //}
        return ret;
    }

/**
  * t[̐
  *
  * @param  String      zone_name       Zone
  * @param  PageInfo    page            y[W
  * @return boolean     trueij/ falseisj
  */
    private boolean presentFrame(ZoneInfo zone, PageInfo page) throws Exception {

        boolean ret = false;
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        // _framePresent.htmlL
        String template = pr_templateDir + File.separator + puTemplPreFrame;
        if ( !xc.fileExists(template) ){
            throw new RidException(ridMsg.Error("E4001", template));
        }

        // _frame_map.xmlL
        String map = pr_templateDir + File.separator + puMapFrame;
        if ( !xc.fileExists(map) ) {
            throw new RidException(ridMsg.Error("E4001", map));
        }

        // o̓t@C
        String out;
        if (page != null) {
            out = pr_outDir + File.separator + page.file + puOutFrame;
            page.url = out;
        } else {
            if (zone.top){
                out = pr_outDir + File.separator + puBlank + puOutFrame;
            } else {
                out = pr_outDir + File.separator + zone.file + File.separator + puBlank + puOutFrame;
            }
        }

        //Map Data̐
        Document map_data = presentFrameMapData(zone.name, page);

        //t[HTML@(Mapper=Template + Map + MapData)
        Mapper mapper = new Mapper();
        if( !mapper.Type1(template, map, map_data, out)) {
            throw new RidException(ridMsg.Error("E4002",mapper.getErrorString()));
        }

        return true;
    }



/**
  * t[̃f[^
  *
  * @param  String      navi_name       NAVI HTMLt@C
  * @param  String      html_name       HTMLt@C
  * @return Document    t[̃hg
  */
    private Document presentFrameMapData(String zone_name, PageInfo page) throws Exception {

        XmlUtil xu = new XmlUtil();
        Element page_elem;
//        Attr attr;

        // hg
        Document doc = new org.apache.xerces.dom.DocumentImpl();
        Element topElem = doc.createElement(puRootTag);
        doc.appendChild(topElem);

        // ir
        String navi = zone_name + puTemplNavi;
        page_elem = xu.createSubElement(topElem, puMapFrameData);
		page_elem.setAttribute(puMapFrameDataKey, "navi");
//        attr = xu.createOrGetAttribute(page_elem, puMapFrameDataKey);
//        xu.createOrSetTextValue((Node)attr, "navi");
        xu.createOrSetTextValue(page_elem, puMapFrameInTag, navi);

        if (page != null) {
            // C
            String html_file  = replaceWebFileSeparator(page.path + File.separator + page.file);
            page_elem = xu.createSubElement(topElem, puMapFrameData);
			page_elem.setAttribute(puMapFrameDataKey, "main");
//            attr = xu.createOrGetAttribute(page_elem, puMapFrameDataKey);
//            xu.createOrSetTextValue((Node)attr, "main");
            xu.createOrSetTextValue(page_elem, puMapFrameInTag, html_file);
        }
        return doc;
    }

/**
  * fBNg̎擾
  *
  * @param  String      project_dir   vWFNgfBNg
  * @return void
  */
    private void getDir(String project_dir) throws Exception {

        ZResource res = ZApp.getTheApp().getResource();

        String template_dir = res.getString(RID_TEMPLATE_DIR);          // ev[gfBNg
        String parts_dir    = res.getString(RID_PARTS_DIR);             // ev[gfBNgip[cj
        String out_dir      = res.getString(RID_PUBLIC_DIR);            // o̓fBNg
//        String html_dir     = res.getString(RID_HTML_DIR);              // htmlfBNg

        pr_templateDir = project_dir + File.separator + template_dir;   // ev[gfBNg
        pr_outDir      = project_dir + File.separator + out_dir;        // o̓fBNg
//        pr_htmlDir     = project_dir + File.separator + html_dir;       // htmlfBNg
        pr_htmlDir     = Ridual.getHtmlDir();       // htmlfBNg
        pr_partsDir    = project_dir + File.separator + parts_dir;      // ev[gfBNg
    }

}
