/**
 * Exportelement.java
 */

package jp.co.nri.rid.export;

import  java.util.*;
import org.w3c.dom.*;
import jp.co.nri.rid.xml.*;
import jp.co.iti.fagot.util.*;

/**
 * CSV,SVGGLX|[gpGg`
 */
public class Exportelement{

    /**
     *@RXgN^
     */
    public  Exportelement(Element element){
        myElement   =   element;
    }

    public  Element element(){
        return myElement;
    }

    /**
     * Element쐬
     * @param String name Gg
     * @return element
     */
    public Exportelement add(String name){
        Element ele = myElement.getOwnerDocument().createElement(name);
        Exportelement element = new Exportelement(ele);
        if(null==element)   return null;
        
        myElement.appendChild(element.element());
        return element;
    }
    
    /**
     * Element쐬
     * @param String     name      Gg
     * @param Attributes attribute 
     * @return element
     */
    public Exportelement add(String name ,Attributes attributes){

        Exportelement element = add(name);
        if(null == element) return null;
        
        if(null != attributes)  element.attributes(attributes);
        
        return element;
    }

    /**
     * Zbg 
     * @param String name  
     * @param String value l
     */
    public void attribute(String name ,String value){

        if(null==name)  return;
        if(null==value)             myElement.removeAttribute(name);
        else if(0>=value.length())  myElement.removeAttribute(name);
        else                        myElement.setAttribute(name ,value);
    }

    /** 
     * ̒lo
     * @param String name 
     * @return l 
     */
    public String attribute(String name){

        String attribute = myElement.getAttribute(name);

        if(0<attribute.trim().length()){
            return attribute;
        }
        return null;
    }

    /**
     * ݒ
     * @param Attributes attributes@ 
     * @return attribute(name, value)
     */
    public void attributes(Attributes attributes){

        if(null==attributes)    return;
        
        Attribute[] a = attributes.attributes();
        if(null==a) return;
        
        for(int i = 0;i < a.length;i++){
            attribute(a[i].name ,a[i].value);
        }
    }

    public Element[] lister(String name) {

        NodeList list = myElement.getElementsByTagName(name);
        if (list==null) return null;
        int size = list.getLength();
        Element[] result = new Element[size];
        for(int i = 0; i < size; i++) {
            result[i] = (Element)list.item(i);
        }
        return (result);
    }

    /**
     * Unitɑ΂q̌
     * @param name Unit
     */
    public Exportelement child(String name){

        NodeList list = myElement.getChildNodes();

        for(int i = 0; i < list.getLength(); i++){
            Node node = list.item(i);
            if(Node.ELEMENT_NODE != node.getNodeType())    continue;
            if(!name.equals(node.getNodeName()))           continue;
            
            return new Exportelement((Element)node);
        }
        return null;
    }

    /**
     * qm[h̃`FbN
     * @param name  Gg
     * @return Exportelement
     */
    public Exportelement[] children(String name){

        NodeList list = myElement.getChildNodes();
        
        Vector vec = new Vector();

        for(int i = 0; i < list.getLength(); i++){
            Node node = list.item(i);
            if(Node.ELEMENT_NODE != node.getNodeType())    continue;
            if(!name.equals(node.getNodeName()))           continue;
            vec.add(new Exportelement((Element)node));
        }
        if(0>=vec.size())   return null;

        //ŏ̎qreturn
        return (Exportelement[])vec.toArray(new Exportelement[0]);
    }    
    
    protected   Exportdocument   myDocument;
    protected   Element         myElement;
}