/*
 * @(#)MessageDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * bZ[W_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/02/21
 */
package jp.co.nri.rid.environment;

import java.io.*;
import java.util.*;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextArea;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZInstance;


/**
 * bZ[W_CAO
 */

public class MessageDialog {

    /**
      * ftHgRXgN^
      */
      public MessageDialog() {}

    /**
      * bZ[W_CAO
      *   \郁bZ[WPOsȏ̏ꍇ̓XN[o[tŕ\
      * 
      * @param  String      message         \bZ[W
      * @param  String      content         e
      * @param  int         type            bZ[W^Cv<br>
      *                                       FJOptionPane.INFORMATION_MESSAGE<br>
      *                                     G[FJOptionPane.ERROR_MESSAGE<br>
      *                                     x@FJOptionPane.WARNING_MESSAGE<br>
      * @return void
      */
    public  static void showMessage(String message, String content, int type) {

        //bZ[WObjectɐݒ
        Object[]  obj = new Object[2];

        //\bZ[W
        obj[0] = message;

		// *** fuku(STA) *** 20020927
		// bZ[W\tO̐ݒ
		// vpeBplA\ɂăbZ[W\ɍēxbZ[W\Ȃ悤
		// \tOݒ肷
		ZInstance.prop().putBoolean("messagedialog.isShowing",true);
		// *** fuku(END) *** 20020927


        //\bZ[W̓e
        //s߂ [\n]s10ȏ̏ꍇ10ŒƂ
        StringTokenizer st = new StringTokenizer(content, "\n");
        if (st.countTokens() > 10) {
          // eLXgGA̐
          JTextArea ta = new JTextArea(content);
          ta.setEditable(false); //ҏWs
          ta.setRows(10);
          obj[1] = new JScrollPane(ta);
        } else {
          obj[1] =content;
        }

        //bZ[W̕\
        JOptionPane.showMessageDialog(ZApp.getTheApp().getFrame(), obj, "Ridual", type);

		// *** fuku(STA) *** 20020927
		ZInstance.prop().putBoolean("messagedialog.isShowing",false);
		// *** fuku(END) *** 20020927

    }

    /**
      * 񃁃bZ[W_CAO
      *
      * @param  String      message         \bZ[W
      * @param  String      content         e
      * @return void
      */
    public  static void showInfo(String message, String content) {
        showMessage(message, content, JOptionPane.INFORMATION_MESSAGE);
    }

    /**
      * 񃁃bZ[W_CAO
      *
      * @param  String      message         \bZ[W
      * @return void
      */
    public  static void showInfo(String message) {
        showMessage(message, "", JOptionPane.INFORMATION_MESSAGE);
    }

    /**
      * G[bZ[W_CAO
      *
      * @param  String      message         \bZ[W
      * @param  String      content         e
      * @return void
      */
    public  static void showError(String message, String content) {
        showMessage(message, content, JOptionPane.ERROR_MESSAGE);
    }

    /**
      * G[bZ[W_CAO
      *
      * @param  String      message         \bZ[W
      * @return void
      */
    public  static void showError(String message) {
        showMessage(message, "", JOptionPane.ERROR_MESSAGE);
    }

    /**
      * xbZ[W_CAO
      *
      * @param  String      message         \bZ[W
      * @param  String      content         e
      * @return void
      */
    public  static void showWarning(String message, String content) {
        showMessage(message, content, JOptionPane.WARNING_MESSAGE);
    }
    /**
      * xbZ[W_CAO
      *
      * @param  String      message         \bZ[W
      * @return void
      */
    public  static void showWarning(String message ) {
        showMessage(message, "", JOptionPane.WARNING_MESSAGE);
    }


    /**
      * O_CAO
      *
      * @param  String      message         \bZ[W
      * @param  Throwable   status          ONX
      * @return void
      */
    public static void showException(String message, Throwable status) {

        ZResource res = ZApp.getTheApp().getResource();

        //ThrowableNXNULL̏ꍇ͐
        if ( status == null) {
            showInfo(message,res.getString("msg.completed"));
        } else {
            String msg = "";

            if ((message == null) || (message == "")) {
                // \bZ[Wnull̏ꍇ́AÕbZ[Wݒ
                message = status.getMessage();
            } else {
                if ( (status.getMessage() == null) || (status.getMessage() == "")) {
                    // LZ{^̏ꍇ
                    String cStr = status.toString();
                    if (cStr.indexOf("ThreadDeath") != -1) {
                        //uLZ܂vݒ
                        msg = res.getString("msg.cancel");
                    } else {
                        msg = status.toString();
                    }
                } else {
                    msg = status.getMessage();
                }
            }
            ZDebug.trace("showException >> " + message+res.getString("msg.mistake") + msg);
            showError(message+res.getString("msg.mistake"), msg);
        }
    }
}
