/*
 * @(#)ImportDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X FC|[g_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/02/06
 */
package jp.co.nri.rid.environment;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import jp.co.nri.Ridual;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;


/**
 * C|[g_CAO<br>
 * <br>
 * EIgnoreL[ij<br>
 * EC|[giy[W^\[X^hLgj<br>
 * EC|[gDirifileChooser{^tj<br>
 *@@@C|[gfBNg݂̃vWFNgƈႤꍇ""ɂ<br>
 *@@@{^F""̏ꍇ̓Jg̃fBNgɂ
 * ERg<br>
 */

public class ImportDialog {

    /** rid.ignore.prefixvpeB̒`   **/
    final static public String IGNORE_PREFIX        = "rid.ignore.prefix";
    /** import.pagevpeB̒`         **/
    final static public String IMPORT_PAGE          = "import.page";
    /** import.resourcevpeB̒`     **/
    final static public String IMPORT_RESOURCE      = "import.resource";
    /** import.documentvpeB̒`     **/
    final static public String IMPORT_DOCUMENT      = "import.document";
    /** import.dirvpeB̒`          **/
    final static public String IMPORT_DIR           = "import.dir";
    /** import.commentvpeB̒`      **/
    final static public String IMPORT_COMMENT       = "import.comment";
    /** rid.html.dirvpeB̒`        **/
//    final static public String RID_HTML_DIR         = "rid.html.dir";
    /** msg.import.titlevpeB̒`    **/
    final static public String MSG_IMPORT_TITLE     = "msg.import.title";
    /** msg.import.pagevpeB̒`     **/
    final static public String MSG_IMPORT_PAGE      = "msg.import.page";
    /** msg.import.resourcevpeB̒` **/
    final static public String MSG_IMPORT_RESOURCE  = "msg.import.resource";
    /**msg.import.documentvpeB̒`  **/
    final static public String MSG_IMPORT_DOCUMENT  = "msg.import.document";
    /** msg.import.importvpeB̒`   **/
    final static public String MSG_IMPORT_IMPORT    = "msg.import.import";
    /** "msg.import.commentvpeB̒` **/
    final static public String MSG_IMPORT_COMMENT   = "msg.import.comment";
    /** msg.import.dirvpeB̒`      **/
    final static public String MSG_IMPORT_DIR       = "msg.import.dir";
    /** msg.import.ignore"vpeB̒`  **/
    final static public String MSG_IMPORT_IGNORE   	= "msg.import.ignore";
    final static public String MSG_IMPORT_REF   	= "msg.import.ref";

    /** Cpl                  **/
    protected JPanel      mPanel            = null;
    /** IgnorePrefix                  **/
    protected JTextField  mIgnorePrefix     = null;
    /** y[W`FbN{bNX        **/
    protected JCheckBox   mImportPage       = null;
    /** \[X`FbN{bNX      **/
    protected JCheckBox   mImportResource   = null;
    /** hLg`FbN{bNX  **/
    protected JCheckBox   mImportDocument   = null;
    /** fBNg                  **/
    protected JTextField  mImportDir        = null;
    /** fBNg̃pX            **/
    protected String      mImportPath       = null;
    /** fBNg̃{^          **/
    protected JButton     mImportDirButton  = null;
    /** Rg                      **/
    protected JTextField  mImportComment    = null;
    /** vWFNgDIR               **/
    protected String      mProjectDir       = null;


    /**
      * ftHgRXgN^
      */
      public ImportDialog() {}

    /**
      * C|[g_CAO
      *
      * @param  String            vWFNgfBNg
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public boolean show(String pro_dir) {

        ZResource res = ZApp.getTheApp().getResource();

        //vWFNgDIR
        mProjectDir = pro_dir;

        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog gdlg = new EnvDialog(frame, res.getString(MSG_IMPORT_TITLE));

        //CR|[lg
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill       = GridBagConstraints.BOTH;
        gbc.insets     = new Insets(10,10,10,10) ;

        //x
        gbc.gridy      = 0;
        gbc.gridx      = 0;
        JLabel label;
        label = new JLabel(res.getString(MSG_IMPORT_IGNORE));
        mLayout.setConstraints(label, gbc);
        mPanel.add( label );

        //IgnorePrefix
        gbc.gridy      = 0;
        gbc.gridx      = 1;
        gbc.gridwidth  = 3;
        mIgnorePrefix = createIgnorePrefix();
        mLayout.setConstraints(mIgnorePrefix, gbc);
        mPanel.add( mIgnorePrefix );


        //x
        gbc.gridy      = 1;
        gbc.gridx      = 0;
        gbc.gridwidth  = 1;
        gbc.gridheight = 1;
        label = new JLabel(res.getString(MSG_IMPORT_IMPORT));
        mLayout.setConstraints(label, gbc);
        mPanel.add( label );

        //y[W`FbN{bNX
        gbc.gridy      = 1;
        gbc.gridx      = 1;
        mImportPage = createImporCheckBox(res.getString(MSG_IMPORT_PAGE),IMPORT_PAGE);
        mLayout.setConstraints(mImportPage, gbc);
        mPanel.add( mImportPage );

        //\[X`FbN{bNX
        gbc.gridy      = 1;
        gbc.gridx      = 2;
        mImportResource = createImporCheckBox(res.getString(MSG_IMPORT_RESOURCE), IMPORT_RESOURCE);
        mLayout.setConstraints(mImportResource, gbc);
        mPanel.add( mImportResource );

        //hLg`FbN{bNX
        gbc.gridy      = 1;
        gbc.gridx      = 3;
        mImportDocument = createImporCheckBox(res.getString(MSG_IMPORT_DOCUMENT), IMPORT_DOCUMENT);
        mLayout.setConstraints(mImportDocument, gbc);
        mPanel.add( mImportDocument );

        //fBNg
        gbc.gridy      = 2;
        gbc.gridx      = 0;
        gbc.gridwidth  = 1;
        gbc.gridheight = 1;
        label = new JLabel(res.getString(MSG_IMPORT_DIR));
        mLayout.setConstraints(label, gbc);
        mPanel.add( label );

        //ImportfBNg
        gbc.gridy      = 2;
        gbc.gridx      = 1;
        gbc.gridwidth  = 3;
        gbc.gridheight = 1;
        JPanel      pane= createImportDir();
        mLayout.setConstraints(pane, gbc);
        mPanel.add( pane );

        //Rg
        gbc.gridy      = 3;
        gbc.gridx      = 0;
        gbc.gridwidth  = 1;
        gbc.gridheight = 1;
        label = new JLabel(res.getString(MSG_IMPORT_COMMENT));
        mLayout.setConstraints(label, gbc);
        mPanel.add( label );

        //IgnorePrefix
        gbc.gridy      = 3;
        gbc.gridx      = 1;
        gbc.gridwidth  = 3;
        mImportComment = createImportComment();
        mLayout.setConstraints(mImportComment, gbc);
        mPanel.add( mImportComment );

        // [CR|[lg][OK][CENCEL]
        gdlg.setControlPanel(mPanel);

        //_CAO\i[_j
        gdlg.doModal();

        // []{^ꂽꍇɕύX
        boolean ret = gdlg.isOK();
        if (ret){
            setImportResource();
        }   
        return ret;
    }


    /**
      * IgnoreL[JTextField𐶐
      *
      * @return JTextField
      */
    private JTextField createIgnorePrefix() {
        ZResource res = ZApp.getTheApp().getResource();
        String  ignore_prefix = res.getString(IGNORE_PREFIX);
        JTextField text = new JTextField(ignore_prefix);
        return text;
    }

    /**
      * IgnoreL[̕擾
      *
      * @return String  gnoreL[̕
      */
    private String getIgnorePrefix(){
        String szTmp = mIgnorePrefix.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }


    /**
      * C|[g̃`FbN{bNX쐬
      *
      * @param  String      label           x
      * @param  String      resource        vpeB
      * @return JCheckBox
      */
    private JCheckBox createImporCheckBox(String label, String resource) {
        ZResource res = ZApp.getTheApp().getResource();
        boolean selected = res.getBoolean(resource);
        JCheckBox chk = new JCheckBox(label);
        chk.setSelected(selected);
        return chk;
    }


    /**
      * C|[gpXJPanel𐶐
      *
      * @return JPanel
      */
    public JPanel createImportDir() {

        int ret;
        ZResource res = ZApp.getTheApp().getResource();
        mImportPath = res.getString(IMPORT_DIR);
        if (mImportPath == null) mImportPath ="";

        //C|[gfBNg݂̃vWFNgƈႤꍇ""ɂ
        String compare = mImportPath.substring(0, Math.min(mProjectDir.length(),mImportPath.length()));
        if (!compare.equalsIgnoreCase(mProjectDir)) {
            mImportPath ="";
        }

        // pl̐
        JPanel panel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        panel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();

        // TextField̐
        mImportDir = new JTextField(mImportPath);
        panel.add(mImportDir);

        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.gridx   = 0;
        mLayout.setConstraints(mImportDir, gbc);

        mImportDirButton = new JButton(res.getString(MSG_IMPORT_REF));
        mImportDirButton.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { fileChooser(); }
            }
        );
        gbc.fill    = GridBagConstraints.NONE;
        gbc.weightx = 0.0;
        gbc.gridx   = 1;
        mLayout.setConstraints(mImportDirButton, gbc);
        panel.add(mImportDirButton);
        return panel;
    }

    /**
      * C|[gpX̃{^Xi[
      *
      * @return void
      */
    public void fileChooser() {

        //C|[gfBNg""̏ꍇ̓Jg̃fBNgɂ
        mImportPath = getImportPath();
        if (mImportPath == null) {
            ZResource res = ZApp.getTheApp().getResource();
//            mImportPath = mProjectDir + File.separator + res.getString(RID_HTML_DIR); 
            mImportPath = Ridual.getHtmlDir(); 
        }

        // FileChooser
        EnvFileChooser fileChooser = new EnvFileChooser();
        String szFile = fileChooser.show(mPanel, mImportPath, JFileChooser.DIRECTORIES_ONLY);
        if (szFile != null) {
            // [OK]{^̏ꍇAeLXgtB[hɃfBNgݒAfBNgpXύX     
            mImportDir.setText(szFile);
            mImportPath = szFile;
        }

    }


    /**
      * C|[gpX̕擾
      *
      * @return String  C|[gpX̕
      */
    private String getImportPath(){
        String szTmp = mImportDir.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }


    /**
      * RgJTextField𐶐
      *
      * @return JTextField
      */
    private JTextField createImportComment() {

        ZResource res = ZApp.getTheApp().getResource();
        String  comment = res.getString(IMPORT_COMMENT);
        JTextField text = new JTextField(comment);
        return text;
    }


    /**
      * Rg̎擾
      *
      * @return String  Rg
      */
    private String getImportComment(){
        String szTmp = mImportComment.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }

    /**
      * vpeBݒ肷
      *
      * @return void
      */
    private void setImportResource() {

        ZResource res = ZApp.getTheApp().getResource();

        /* [gnore.prefix]ݒ */
        res.putString(IGNORE_PREFIX, getIgnorePrefix());

        /* [import.page]ݒ */
        res.putBoolean(IMPORT_PAGE, mImportPage.isSelected());

        /* [import.resource]ݒ */
        res.putBoolean(IMPORT_RESOURCE, mImportResource.isSelected());

        /* [import.document]ݒ */
        res.putBoolean(IMPORT_DOCUMENT, mImportDocument.isSelected());

        /* [import.dir]ݒ */
        String sss = getImportPath();
        res.putString(IMPORT_DIR, getImportPath());

        /* [import.comment]ݒ */
        res.putString(IMPORT_COMMENT, getImportComment() );
    }
}
