/*
 * @(#)EnvironmentDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : ݒ_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/05/15
 */
package jp.co.nri.rid.environment;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.File;
import java.lang.Integer;
import java.lang.Character;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

import jp.co.nri.rid.RUpdateManager;

/**
 * Rid ݒ_CAO
 */

public class EnvironmentDialog {
    /** pl**/
    protected JPanel        mPanel = null;
    /** CAEg  **/
    protected GridBagLayout mLayout = null;
    /** Ridual fBNg   **/
    EnvTextField    mRidualDir;
    /** Obh              **/
    EnvCheckBoxText mGrid;
    /** SVG o͐          **/
    EnvTextField    mSvg;
    /** Look & Feel           **/
    EnvRadioButton  mLookFeel;
    /** uEU              **/
    EnvRadioText    mBrowser;
    /** gslkGfB^      **/
    EnvRadioText    mHtmlEdit;
    /** eLXgGfB^      **/
    EnvTextField    mTextEdit;
    /** \FiZonej        **/
    EnvColorEditor  mColorZone;
    /** \FiPagej        **/
    EnvColorEditor  mColorPage;
    /** \FiLink:Virtualj**/
    EnvColorEditor  mColorLink;
    /** \FiLink:Realj   **/
    EnvColorEditor  mColorReal;
    /** \FiUrlj         **/
    EnvColorEditor  mColorUrl;
    /** \FiMapHierj     **/
    EnvColorEditor  mColorMapHier;
    /** \FiMapSitej     **/
    EnvColorEditor  mColorMapSite;
    /** \FiMapCirclej   **/
    EnvColorEditor  mColorMapCircle;
    /** \FiNotExistj    **/
    EnvColorEditor  mColorNotExist;
    /** \FiScenarioItemj**/
    EnvColorEditor  mColorScenarioItem;
    /** \IvV ZonePaneliZonej
    EnvRadioButton  mDispZone;
    **/
    /** \IvV          iPagej
    EnvRadioButton  mDispPage;
    **/
    /** \IvV          iUrlj 
    EnvRadioButton  mDispUrl;
    **/
    /** グIvV       (HTML-Editor)  **/
    EnvRadioButton  mStartHtml;
    /** EnvDocumentList **/
    EnvDocumentList mDocList;

    /** ݒ̋N  **/
    boolean         mEnvFirst;

    //
    /** [msg.environment.title]vpeB  **/
    static String MSG_ENVIRONMENT_TITLE     = "msg.environment.title";
    /** [app.install.path]vpeB  **/
    static String APP_INSTALL_PATH          = "app.install.path";
    /** [edit.grid]vpeB  **/
    static String EDIT_GRID                 = "edit.grid";
    /** [edit.gridsize]vpeB  **/
    static String EDIT_GRIDSIZE             = "edit.gridsize";
    /** [app.lookandfeel]vpeB  **/
    static String APP_LOOKANDFEEL           = "app.lookandfeel";
    /** [generate.browser_command]vpeB  **/
    static String GEN_BROWSER_CMD           = "generate.browser_command";
    /** [generate.browser_command.1]vpeB  **/
    static String GEN_BROWSER_CMD_1         = "generate.browser_command.1";
    /** [generate.browser_command.2]vpeB  **/
    static String GEN_BROWSER_CMD_2         = "generate.browser_command.2";
    /** [command.html.editor]vpeB  **/
    static String CMD_HTML_EDITOR           = "command.html.editor";
    /** [command.html.editor.1]vpeB  **/
    static String CMD_HTML_EDITOR_1         = "command.html.editor.1";
    /** [command.html.editor.2]vpeB  **/
    static String CMD_HTML_EDITOR_2         = "command.html.editor.2";
    /** [command.text.editor]vpeB  **/
    static String CMD_TEXT_EDITOR           = "command.text.editor";
    /** [unit.color.ZoneUnit]vpeB  **/
    static String UNIT_CLR_ZONEUNIT         = "unit.color.ZoneUnit";
    /** [unit.color.PageUnit]vpeB  **/
    static String UNIT_CLR_PAGEUNIT         = "unit.color.PageUnit";
    /** [unit.color.LinkUnit]vpeB  **/
    static String UNIT_CLR_LINKUNIT         = "unit.color.LinkUnit";
    /** [unit.color.StrongLink]vpeB  **/
    static String UNIT_CLR_STRONG           = "unit.color.StrongLink";
    /** [unit.color.UrlUnit]vpeB  **/
    static String UNIT_CLR_URLUNIT          = "unit.color.UrlUnit";
    /** [unit.color.AccessCount]vpeB  **/
    static String UNIT_CLR_ACCESSCOUNT      = "unit.color.AccessCount";
    /** [panel.color.page]vpeB  **/
    static String UNIT_CLR_PANEL_PAGE       = "panel.color.page";
    /** [panel.color.Map.Hier]vpeB  **/
    static String UNIT_CLR_MAP_HIER         = "panel.color.Map.Hier";
    /** [panel.color.Map.Site]vpeB  **/
    static String UNIT_CLR_MAP_SITE         = "panel.color.Map.Site";
    /** [panel.color.Map.Circle]vpeB  **/
    static String UNIT_CLR_MAP_CIRCLE       = "panel.color.Map.Circle";
    /** [unit.color.NotExist]vpeB  **/
    static String UNIT_CLR_NOT_EXIST        = "unit.color.NotExist";
    /** [unit.color.ScenarioItem]vpeB  **/
    static String UNIT_CLR_SCENARIO_ITEM    = "unit.color.ScenarioItem";
    /** [viewtext.Zone.ZoneUnit]vpeB  **/
    static String VIEWTEXT_ZONE_ZONEUNIT    = "viewtext.Zone.ZoneUnit";
    /** [viewtext.Zone.PageUnit]vpeB  **/
    static String VIEWTEXT_ZONE_PAGEUNIT    = "viewtext.Zone.PageUnit";
    /** [viewtext.Zone.UrlUnit]vpeB  **/
    static String VIEWTEXT_ZONE_URLUNIT     = "viewtext.Zone.UrlUnit";
    /** [viewtext.Map.PageUnit]vpeB  **/
    static String VIEWTEXT_MAP_PAGEUNIT     = "viewtext.Map.PageUnit";
    /** [newproject.edit.html]vpeB  **/
    static String NEWPROJECT_EDIT_HTML      = "newproject.edit.html";
    /** [env.first]vpeB  **/
    static String ENV_FIRST                 = "env.first";
    /** [svg.line.width]vpeB  **/
    static String SVG_LINEWIDTH             = "svg.line.width";

    /** LookAndFeel̃Xgi폜j 
    private String[] mLookAndFeel           = {"javax.swing.plaf.metal.MetalLookAndFeel" ,
                                               "com.sun.java.swing.plaf.motif.MotifLookAndFeel" ,
                                               "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"};
    **/
    /** LookAndFeel\̃Xgi폜j

    private String[] mRadioLookAndFeel      = { "Metal" ,"Motif" ,"Windows"};
    **/
    /** pl\@Page̕\Xg  (폜)
    private static String[] mRadioPage      = { "Name", "Title", "Comment", "File(Path)"};
    **/
    /** pl\@Zone̕\Xg  (폜)
    private static String[] mRadioZone      = { "Name", "Comment", "File(Path)"};
    **/
    /** pl\@Url̕\Xg (폜)
    private static String[] mRadioUrl       = { "Name", "Comment"};
    **/
    /** Start-UP\̃Xg  (폜)**/
    private static String[] mRadioHtml      = { "On", "Off"};


    /**
      * ݒ̃_CAO
      *
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public boolean EnvDialog() throws Exception {

        //OSLook&Feel̒lύXiftHgWindowsj
        init();

        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog gdlg = new EnvDialog(frame, getResString(MSG_ENVIRONMENT_TITLE));

        //CR|[lg
        mPanel = new JPanel();

        //pl̃CAEguGridBagLayoutvɂ
        mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        setPanelControl();

        // [CR|[lg][Kp][]
        gdlg.setControlPanel(mPanel);

        // Ԃ̎̓LZ{^Ȃ
        if (mEnvFirst){
          JButton  CancelButton = gdlg.getCancelButton();
          CancelButton.setVisible(false);
        }

        //_CAOɓKp{^zu
        JButton mApply = new JButton("Apply");
        mApply.addActionListener(
          new ActionListener() {
              public void actionPerformed(ActionEvent e) { onApply(); }
          }
        );
        gdlg.getButtonPanel().add( mApply );

        //_CAO\i[_j
        gdlg.doModal();

        // []{^ꂽꍇɕύX
        boolean ret = gdlg.isOK();
        if (ret){
            setEnvironment();
        }   
        return ret;
    }

    /**
      * ݒ
      *
      * @return void
      */
    private void init() {

        /* Look&dFeel Ɓ@Display̓c[o[ɂ̂ŃRg
        // OSA[LeN`
        String arch = System.getProperty("os.arch");

        //Mac OS X̏ꍇ
        if (arch.equals("ppc")) {
            mLookAndFeel[2] = "com.apple.mrj.swing.MacLookAndFeel";
            mRadioLookAndFeel[2] = "Mac";
        }
        */

        // ݒʂ̋N
        mEnvFirst = getResBoolean(ENV_FIRST);

    }


/******************************************************************************
 *@plzu
 ******************************************************************************/
    /**
      * pl̃Rg[zu
      *
      * @return void
      */
    private void setPanelControl() throws Exception  {

        //@Look&dFeel Ɓ@Display̓c[o[ɂ̂ŃRg
        //setPanelLookAndFeel(3);   // Look & Feel
        //setPanelDisplay(15);      // Display  (+4)

        setPanelLabel(0,"@");    // DUMMY
        if (mEnvFirst){
            setPanelRidualDir(1);     // Ridual Dir
            setPanelSeparator(2);     // Separator
        }
        setPanelGrid(3);          // Grid
        setPanelSeparator(4);     // Separator
        setPanelBrowser(5);       // Browser
        setPanelSeparator(6) ;    // Separator
        setPanelHtmlEdit(7);      // Html/Text Editor
        setPanelSeparator(9);     // Separator
        setPanelTextEdit(10);     // Html/Text Editor
        setPanelDocumentList(11); // Document List
        setPanelSeparator(12);    // Separator
        setPanelDefaultColor(13); // Default Color (+2)
        setPanelSeparator(15);    // Separator
        setPanelStartUp(16);      // Start Up (+2)
        setPanelSeparator(18);    // Separator
        setPanelSVGLineWidth(19);
        //setPanelSeparator(20);    // Separator
        //setPanelLabel(23,"@");   // Dummy
    }
    /**
      * pl[Ridual Dir]zu
      *
      * @param  int                 line    s
      * @return void
      */
    private void setPanelRidualDir(int line) throws Exception  {
        // uapp.install.pathvNull̏ꍇ̓JgfBNg̐ẽpXɂ
        String inst =getResString(APP_INSTALL_PATH);
        if ( isNullString(inst) ) {
            String current = getCurrentPath();
            File dir = new File(current);
            inst = dir.getParent();
        }
        mRidualDir = setPanelLabelText(line, "Ridual Dir", inst, JFileChooser.DIRECTORIES_ONLY);
    }
    /**
      * pl[Look & Feel]zu
      *
      * @param  int                 line    s
      * @return void
      */
/*(폜)
    private void setPanelLookAndFeel(int line) throws Exception  {
        mLookFeel = setPanelRadioButton(line, "Look&Feel", mRadioLookAndFeel, getLookAndFeel());
    }
*/
    /**
      * [Look & Feel]擾
      *
      * @param  
      * @return String Look & Feel
      */
/*(폜)
    private String getLookAndFeel() throws Exception {
        int n = 0;
        String  lookandfeel = getResString(APP_LOOKANDFEEL);
        for ( n = 0 ; n < mLookAndFeel.length; n++ ) {
            if (mLookAndFeel[n].compareTo(lookandfeel) == 0)  break;
        }
        return mRadioLookAndFeel[n];
    }
*/
    /**
      * pl[Grid]zu
      *
      * @param  int                 line    s
      * @return void
      */
    private void setPanelGrid(int line) throws Exception  {
        mGrid = setPanelCheckBoxText(line, "Grid", getResBoolean(EDIT_GRID), getResString(EDIT_GRIDSIZE));
    }
    /**
      * pl[Browser]zu
      *
      * @param  int                 line    s
      * @return void
      */
    private void setPanelBrowser(int line) throws Exception  {

        int sel = 0;

        // Browser擾ANull̏ꍇ ""
        String browser  = getResString(GEN_BROWSER_CMD);
        String browser1 = getResString(GEN_BROWSER_CMD_1);
        String browser2 = getResString(GEN_BROWSER_CMD_2);
        // ftHg͂ǂ炩H
        if ( browser.equals(browser1) ) {
            sel = 0;
        } else if ( browser.equals(browser2) ) {
            sel = 1;
        }
        mBrowser = setPanelRadioText(line, 
                                    "Browser", 
                                    getResString(GEN_BROWSER_CMD_1),
                                    getResString(GEN_BROWSER_CMD_2), 
                                    sel);

    }
    /**
      * pl[Editor(HTML/TEXT)]zu
      *
      * @param  int                 line    s
      * @return void
      */
    private void setPanelHtmlEdit(int line) throws Exception  {

        int sel = 0;
        
        // Html/Text Editor
        String  html  = getResString(CMD_HTML_EDITOR);
        String  html1 = getResString(CMD_HTML_EDITOR_1);
        String  html2 = getResString(CMD_HTML_EDITOR_2);
        // ftHg͂ǂ炩H
        if ( html.equals(html1) ) {
            sel = 0;
        } else if ( html.equals(html2) ) {
            sel = 1;
        }
        mHtmlEdit =  setPanelRadioText(line, 
                                      "HTML Editor", 
                                      getResString(CMD_HTML_EDITOR_1),
                                      getResString(CMD_HTML_EDITOR_2), 
                                      sel);
  }
    /**
      * pl[Editor(HTML/TEXT)]zu
      *
      * @param  int                 line    s
      * @return void
      */
    private void setPanelTextEdit(int line) throws Exception  {
        mTextEdit =  setPanelLabelText(line,"TEXT Editor", getResString(CMD_TEXT_EDITOR), JFileChooser.FILES_AND_DIRECTORIES);
    }
    /**
      * pl[Document List]zu
      *
      * @param  int                 line    s
      * @return void
      */
    private void setPanelDocumentList(int line) throws Exception  {
        mDocList = setPanelDocList(line, "Document List");
    }
    /**
      * pl[Default Color"]zu
      *
      * @param  int                 line    s
      * @return void
      */
    private void setPanelDefaultColor(int line)  throws Exception {

        // xs
        setPanelLabel(line,"Default Color");

        // pl̐
        JPanel p = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout l = new GridBagLayout();
        p.setLayout(l);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill   = GridBagConstraints.BOTH;

        // Panelɔzu
        mColorZone          = setColorEditor(p, l, gbc, 0, 0, " Zone",          getResString(UNIT_CLR_ZONEUNIT));
        mColorPage          = setColorEditor(p, l, gbc, 0, 1, " Page",          getResString(UNIT_CLR_PAGEUNIT));
        mColorLink          = setColorEditor(p, l, gbc, 0, 2, " Link(Virtual)", getResString(UNIT_CLR_STRONG));
        mColorReal          = setColorEditor(p, l, gbc, 0, 3, " Link(Real)",    getResString(UNIT_CLR_LINKUNIT));
        mColorUrl           = setColorEditor(p, l, gbc, 0, 4, " Url",           getResString(UNIT_CLR_URLUNIT));

        mColorNotExist      = setColorEditor(p, l, gbc, 2, 0, " NotExist",      getResString(UNIT_CLR_NOT_EXIST));
        mColorMapHier       = setColorEditor(p, l, gbc, 2, 1, " MapHier",       getResString(UNIT_CLR_MAP_HIER));
        mColorMapSite       = setColorEditor(p, l, gbc, 2, 2, " MapSite",       getResString(UNIT_CLR_MAP_SITE));
        mColorMapCircle     = setColorEditor(p, l, gbc, 2, 3, " MapCircle",     getResString(UNIT_CLR_MAP_CIRCLE));
        mColorScenarioItem  = setColorEditor(p, l, gbc, 2, 4, " ScenarioItem",  getResString(UNIT_CLR_SCENARIO_ITEM));

        //mColorAccessCount   = setColorEditor(p, l, gbc, 2, 4, " AccessCount",   getResString(UNIT_CLR_ACCESSCOUNT));
        //mColorPanelPage     = setColorEditor(p, l, gbc, 2, 0, " PanelPage",     getResString(UNIT_CLR_PANEL_PAGE));

        // R|[lgpCAEg̍쐬
        GridBagConstraints  cgbc= createComponentConstraints();
        cgbc.gridy = line+1;
        cgbc.gridx = 0;
        cgbc.gridwidth = 2;
        mLayout.setConstraints(p, cgbc);
        mPanel.add(p);
    }
    /**
      * eLXgtB[hƃJ[_CAORg[zu
      * 
      * @param  JPanel              p       pl
      * @param  GridBagLayout       l       CAEg
      * @param  GridBagConstraints  gbc     Layout̍쐬
      * @param  int                 x       
      * @param  int                 y       s
      * @param  String              label   x
      * @param  String              color   J[R[h
      * @return EnvColorEditor
      */
    private EnvColorEditor setColorEditor(JPanel p, GridBagLayout l, GridBagConstraints gbc, int x, int y, String label, String color) {

        // xzu
        gbc.weightx  = 0.0 ;
        gbc.insets   = new Insets(0,10,0,10) ;
        JLabel lb    = new JLabel(label);
        gbc.gridx    = x;
        gbc.gridy    = y;
        l.setConstraints(lb, gbc);
        p.add(lb);

        // EnvColorEditorzu
        EnvColorEditor env_color  = new EnvColorEditor(color);
        gbc.insets    = new Insets(0,0,0,0) ;
        gbc.weightx   = 1.0 ;
        gbc.gridx     = x+1;
        gbc.gridy     = y;
        l.setConstraints(env_color.getPanel(), gbc);
        p.add(env_color.getPanel());
        
        return env_color;
    }
    /**
      * pl[Display"]zu
      *
      * @param  int                 line    s
      * @return void
      */
/*(폜)
    private void setPanelDisplay(int line) {
        setPanelLabel(line,"Display");
        mDispZone = setPanelRadioButton(line+1, "  Zone", mRadioZone, getDialayItem(VIEWTEXT_ZONE_ZONEUNIT));
        mDispPage = setPanelRadioButton(line+2, "  Page", mRadioPage, getDialayItem(VIEWTEXT_ZONE_PAGEUNIT));
        mDispUrl  = setPanelRadioButton(line+3, "  Url",  mRadioUrl,  getDialayItem(VIEWTEXT_ZONE_URLUNIT));
    }
*/
    /**
      * Display擾
      *@Filȅꍇ̂݁A"(Path)"t
      * @param  String      resource      \[X
      * @return string
      */
/*(폜)
    private String getDialayItem(String resource) {
          ZResource res = ZApp.getTheApp().getResource();
          String  dialay = res.getString(resource);
          if (dialay.compareTo("File") == 0) dialay = dialay + "(Path)";
          return dialay;
    }
*/
    /**
      * pl[StartUp]zu
      *
      * @param  int                 line    s
      * @return void
      */
    private void setPanelStartUp(int line) {
        setPanelLabel(line,"Start-Up");
        mStartHtml = setPanelRadioButton(line+1, "  HTML-Editor", mRadioHtml, getStartUp(NEWPROJECT_EDIT_HTML));
    }
    /**
      * Start-Up̎擾
      *
      * @param  String      resource      \[X
      * @return String      On/Off̕
      */
    private String getStartUp(String resource) {
          boolean  startup = getResBoolean(resource);
          if (startup) return "On"; else  return "Off";
    }

    /**
      * pl[SVG Line Width]zu
      *
      * @param  int                 line    s
      * @return void
      */
    private void setPanelSVGLineWidth(int line) throws Exception  {
        mSvg = setPanelLabelTextLabel(line, "SVG Line Width ",getResString(SVG_LINEWIDTH), "@%@");
    }

    /**
      * xpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.weightx = 0.0 ;
        gbc.insets  = new Insets(0,10,0,10) ;
        return gbc;
    }
    /**
      * R|[lgpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0 ;
        gbc.insets    = new Insets(0,0,0,10) ;
        return gbc;
    }
    /**
      * x̃Rg[zu
      *
      * @param  int         line            s
      * @param  String      label           x
      * @return void
      */
    private void  setPanelLabel(int line, String label) {
        setPanelLayoutLabel(line,label);
    }
    /**
      * eLXgtB[h̃Rg[zu(JFileChooserL)
      * 
      * @param  int         line            s
      * @param  String      label           x
      * @param  String      value           eLXg
      * @param  int         mode            t@CZNg[h
      * @return EnvTextField
      */
    private EnvTextField setPanelLabelText(int line, String label, String value, int mode) {
        // eLXgtB[h
        EnvTextField itf = new EnvTextField(value, mode);
        // xzu
        setPanelLayoutLabel(line,label);
        // R|[lgzuieLXgtB[hj
        setPanelLayoutComponent(line, itf.getPanel());
        return itf;
    }

    /**
      * eLXgtB[h̃Rg[zu
      * 
      * @param  int         line            s
      * @param  String      label1          x
      * @param  String      value           eLXg
      * @param  String      label2          x
      * @return EnvTextField
      */
    private EnvTextField setPanelLabelTextLabel(int line, String label1, String value, String label2) {

        // eLXgtB[h
        EnvTextField itf = new EnvTextField(value, label2);
        // xzu
        setPanelLayoutLabel(line,label1);
        // R|[lgzuieLXgtB[hj
        setPanelLayoutComponent(line, itf.getPanel());
        return itf;
    }
    /**
      * `FbN{bNXteLXgtB[h̃Rg[zu
      * 
      * @param  int         line            s
      * @param  String      label           x
      * @param  boolean     selected        `FbN{bNX̏
      * @param  String      value           eLXg
      * @return EnvCheckBoxText
      */
    private EnvCheckBoxText setPanelCheckBoxText(int line, String label, boolean selected, String value) {
        // `FbN{bNXteLXgtB[h̐
        EnvCheckBoxText ice = new EnvCheckBoxText(selected, value);
        // xzu
        setPanelLayoutLabel(line,label);
        // R|[lgzui`FbN{bNXteLXgtB[hj
        setPanelLayoutComponent(line, ice.getPanel());
        return ice;
  }
    /**
      * WI{^Rg[zu
      * 
      * @param  int         line            s
      * @param  String      label           x
      * @param  String[]    radioButton     WI{^̃x
      * @param  String      checked         I
      * @return EnvRadioButton
      */
    private EnvRadioButton setPanelRadioButton(int line, String label, String[] radioButton, String checked) {
        // WI{^Rg[̐
        EnvRadioButton irb =  new EnvRadioButton();
        for ( int n=0 ; n<radioButton.length ; n++ ) {
            irb.addItem(radioButton[n]);
        }
        // lݒ
        irb.setString(checked);
        // xzu
        setPanelLayoutLabel(line,label);
        // R|[lgzuiWI{^j
        setPanelLayoutComponent(line, irb.getPanel());
        return irb;
    }
    /**
      * `FbN{bNXteLXgtB[h̃Rg[zu
      * 
      * @param  int         line            s
      * @param  String      label           x
      * @param  boolean     selected        `FbN{bNX̏
      * @param  String      value           eLXg
      * @return EnvCheckBoxText
      */
    private EnvRadioText setPanelRadioText(int line, String label, String value1, String value2, int selected ) {
        // `FbN{bNXteLXgtB[h̐
        EnvRadioText ice = new EnvRadioText(value1, value2);
        ice.setSelected(selected);
        // xzu
        setPanelLayoutLabel(line,label);
        // R|[lgzui`FbN{bNXteLXgtB[hj
        setPanelLayoutComponent(line, ice.getPanel());
        return ice;
  }
    /**
      * Zp[^̔zu
      *
      * @return EnvRadioButton
      */
    private void setPanelSeparator(int line) {
        EnvSeparator ISeparator = new EnvSeparator();
        // CAEg̍쐬
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill       = GridBagConstraints.BOTH;
        gbc.weightx    = 1.0 ;
        gbc.insets     = new Insets(0,0,0,10) ;
        gbc.gridy      = line;
        gbc.gridx      = 0;
        gbc.gridwidth  = 2;
        gbc.gridheight = 1;
        mLayout.setConstraints(ISeparator, gbc);
        mPanel.add(ISeparator);
    }
    /**
      * hLgXg̃Rg[zu
      * 
      * @param  int         line            s
      * @param  String      label           x
      * @return EnvDocumentList
      */
    private EnvDocumentList setPanelDocList(int line, String label) throws Exception  {
        // eLXgtB[h
        EnvDocumentList itf = new EnvDocumentList();
        // xzu
        setPanelLayoutLabel(line,label);
        // R|[lgzu
        setPanelLayoutComponent(line, itf.getPanel());
        return itf;
    }
    /**
      * xzu
      * @param  int         line            s
      * @param  String      label           x
      * @return void
      */
    private void setPanelLayoutLabel(int line, String value) {
        // xpCAEg̍쐬
        GridBagConstraints gbc = createLabelConstraints();
        JLabel label = new JLabel(value);
        gbc.gridy = line;
        gbc.gridx = 0;
        mLayout.setConstraints(label, gbc);
        mPanel.add(label);
    }
    /**
      * R|[lgzu
      * @param  int         line            s
      * @param  JComponent  component       R|[lg
      */
    private void setPanelLayoutComponent(int line, JComponent component) {
        // R|[lgpCAEg̍쐬
        GridBagConstraints gbc = createComponentConstraints();
        gbc.gridy = line;
        gbc.gridx = 1;
        mLayout.setConstraints(component, gbc);
        mPanel.add(component);
    }


/******************************************************************************
 *@ϐݒ
 ******************************************************************************/
    /**
      * ϐݒ
      * @return void
      */
    private void setEnvironment()  throws Exception {

        // ݒ
        if (mEnvFirst){
            setRidualDir();         // Ridial Dir    
        }
        setGrid();                  // Grid
        setBrowser();               // Browser
        setHtmlEditor();            // Html Edit
        setTextEditor();            // Text Edit
        mDocList.setDocList();      // Documet List
        setDefaultColor();          // Default Color
        setStartUp();               // Start Up
        setSvgLineWidth();          // Svg Line Width

        //c[o[XV
        ((jp.co.nri.Ridual)ZApp.getTheApp()).resetGroupToolBar();
        RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);
    }

    /**
      * uKpv{^
      *
      * @return void
      */
    public void onApply() {
        try {
            setEnvironment();
            //GridSVG LineWidth͍Đݒ
            mGrid.setString(getResString(EDIT_GRIDSIZE));
            mSvg.setString(getResString(SVG_LINEWIDTH));
        } catch ( Throwable e) {
        }
    }

    /**
      * Ridual Dirݒ
      * @ݒlNULL̏ꍇ́AOw肵lƂ
      * 
      * @return void
      */
    private void setRidualDir() throws Exception {
        String ridual = mRidualDir.getString();
        if (isNullString(ridual)) ridual = getResString(APP_INSTALL_PATH);
        setResString(APP_INSTALL_PATH, ridual);

        //x@Ridual Dir͂͂łȂ
        setResBoolean(ENV_FIRST, false);
    }
    /**
      * Look&Feelݒ
      * @param  
      * @return void
      */
/*(폜)
    private void setLookAndFeel() throws Exception {
        int n;
        String value = mLookFeel.getString();
        for (n = 0 ; n < mRadioLookAndFeel.length; n++ ) {
            if (mRadioLookAndFeel[n].compareTo(value) == 0) break;
        }
        setResString(APP_LOOKANDFEEL, mLookAndFeel[n]);
    }
*/
    /**
      * Gridݒ
      *     1 <= Obgl <= 100܂ŁAȊO̓ftHglƂ
      * 
      * @return void
      */
    private void setGrid() throws Exception {
        setResBoolean(EDIT_GRID, mGrid.getSelected());

        //擾
        String str=mGrid.getString();
        if ( str != null ) {
            String gridValue = null;
            //񂪐li0-9)f
            if ( isDigitString(str) ) {
                int Suu = Integer.parseInt(str);
                if ( (1 <= Suu) && (Suu <= 100)) gridValue = str;
            }
            setResString(EDIT_GRIDSIZE, gridValue);
        } else {
            setResString(EDIT_GRIDSIZE, null);
        }
    }
    /**
      * uEUݒ
      * @w肳ꂽuEUftHgƂ
      *
      * @return void
      */
    private void setBrowser() {
        String browser;
        if (mBrowser.getSelected() == 0) {
            browser = mBrowser.getString1();
        } else {
            browser = mBrowser.getString2();
        }
        setResString(GEN_BROWSER_CMD,   browser);
        setResString(GEN_BROWSER_CMD_1, mBrowser.getString1());
        setResString(GEN_BROWSER_CMD_2, mBrowser.getString2());
    }
    /**
      * HTMLGfB^ݒ
      * @w肳ꂽHTMLGfB^ftHgƂ
      * 
      * @return void
      */
    private void setHtmlEditor() {
        String htmlEdit;
        if (mHtmlEdit.getSelected() == 0) {
            htmlEdit = mHtmlEdit.getString1();
        } else {
            htmlEdit = mHtmlEdit.getString2();
        }
        setResString(CMD_HTML_EDITOR,   htmlEdit);
        setResString(CMD_HTML_EDITOR_1, mHtmlEdit.getString1());
        setResString(CMD_HTML_EDITOR_2, mHtmlEdit.getString2());
    }
    /**
      * TEXTGfB^ݒ
      * 
      * @return void
      */
    private void setTextEditor() {
        setResString(CMD_TEXT_EDITOR, mTextEdit.getString());
    }
    /**
      * ftHgJ[ݒ
      * 
      * @return void
      */
    private void setDefaultColor() {
        setResString(UNIT_CLR_ZONEUNIT,      mColorZone.getString());            // Zone
        setResString(UNIT_CLR_PAGEUNIT,      mColorPage.getString());            // Panel
        setResString(UNIT_CLR_STRONG,        mColorLink.getString());            // Link:Virtual
        setResString(UNIT_CLR_LINKUNIT,      mColorReal.getString());            // Link:Real
        setResString(UNIT_CLR_URLUNIT ,      mColorUrl.getString());             // Url
        setResString(UNIT_CLR_MAP_HIER,      mColorMapHier.getString());         // MapHier
        setResString(UNIT_CLR_MAP_SITE,      mColorMapSite.getString());         // MapSite
        setResString(UNIT_CLR_MAP_CIRCLE,    mColorMapCircle.getString());       // MapCircle
        setResString(UNIT_CLR_NOT_EXIST,     mColorNotExist.getString());        // NotExist
        setResString(UNIT_CLR_SCENARIO_ITEM, mColorScenarioItem.getString());    // ScenarioItem
        //setResString(UNIT_CLR_ACCESSCOUNT,   mColorAccessCount.getString());     // AccessCount
        //setResString(UNIT_CLR_PANEL_PAGE,    mColorPanelPage.getString());       // PanelPage

    }
    /**
      * Diaplayݒ
      * 
      * @return void
      */
/*(폜)
    private void setDiaplay() {
        setDialayItem(VIEWTEXT_ZONE_ZONEUNIT, mDispZone.getString());
        setDialayItem(VIEWTEXT_ZONE_PAGEUNIT, mDispPage.getString());
        setDialayItem(VIEWTEXT_ZONE_URLUNIT,  mDispUrl.getString());
    }
*/
    /**
      * Diaplayݒ肷
      *@File(Path)̏ꍇ́AFileɕύX
      * @param  String      resource      \[X
      * @param  String      value         
      * @return void
      */
    private void setDialayItem(String resource, String value) {
          // [File(Path)]̏ꍇ́AuFilevɂ
          if (value.indexOf("(Path)") != -1) value = "File";
          setResString(resource, value);
    }
    /**
      * Start-Upݒ
      * 
      * @return void
      */
    private void setStartUp() {
          boolean startup = false;
          String value = mStartHtml.getString();
          if (value.compareTo("On") == 0)  startup = true;
          setResBoolean(NEWPROJECT_EDIT_HTML, startup);
    }
    /**
      * Svg Line Widthݒ
      * 
      * @return void
      */
    private void setSvgLineWidth() throws Exception {
        //擾
        String str=mSvg.getString();
        if ( str != null ) {
            String lineWidth = null;
            //񂪐li0-9)f
            if ( isDigitString(str) ) {
                int Suu = Integer.parseInt(str);
                if ( (1 <= Suu) && (Suu <= 100)) lineWidth = str;
            }
            setResString(SVG_LINEWIDTH, lineWidth);
        } else {
            setResString(SVG_LINEWIDTH, null);
        }
    }

/******************************************************************************
 *@
 ******************************************************************************/
    /**
      * String^mtkkf
      *
      * @param  String      str           t@C
      * @return boolean     true (null)/false(not null)
      */
    private boolean isNullString(String str) throws Exception {
        boolean ret;
        if ( (str == null) || (str.equals("")) ) {
            ret = true;
        } else {
            ret = false;
        } 
        return ret;
    }
    /**
      * \[Xt@C֐ݒ(String)
      *
      * @param  String      resource      \[X
      * @param  String      value         
      * @return void
      */
    private void setResString(String resource, String value) {
        ZResource res = ZApp.getTheApp().getResource();
        res.putString(resource, value);
    }
    /**
      * \[Xt@C֐ݒ(boolean)
      *
      * @param  String      resource      \[X
      * @param  boolean     value         true/false
      * @return void
      */
    private void setResBoolean(String resource, boolean value) {
        ZResource res = ZApp.getTheApp().getResource();
        res.putBoolean(resource, value);
    }
    /**
      * \[Xt@C̎擾(String)
      *
      * @param  String      resource      \[X
      * @return String      
      */
    private String getResString(String resource) throws Exception {
        ZResource res = ZApp.getTheApp().getResource();
        String val = res.getString(resource);
        if (isNullString(val)) val = "";  
        return val;
    }
    /**
      * \[Xt@C̎擾(boolean)
      *
      * @param  String      resource      \[X
      * @return boolean     true/false
      */
    private boolean getResBoolean(String resource) {
        ZResource res = ZApp.getTheApp().getResource();
        return (res.getBoolean(resource));
    }

    /**
      * JgfBNg̐΃pX擾
      *
      * @return String  JgfBNg̃pX
    */
    private String getCurrentPath() throws Exception {
        File fileParentDir = new File(".").getAbsoluteFile().getParentFile();
        return (fileParentDir.getAbsolutePath());
    }

    /**
      * 񂪐li0-9)f
      *
      * @return boolean  true(l)/false(lȊO)
    */
    private boolean isDigitString(String str) throws Exception {
        for (int i=0; i<str.length() ; i++ ){
            if (!Character.isDigit(str.charAt(i))) return false;
        }
        return true;
    }
}
