/*
 * @(#)InputTextField.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : xt̓GA쐬
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/11/07
 */
package jp.co.nri.rid.environment;

import jp.co.iti.fagot.ZApp;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

import java.io.File;

/**
 * xt̓GA쐬
 **/
public class EnvTextField {

    /** pl **/
    protected JPanel      mPanel  = null;
    /** ̓GA**/
    protected JTextField  mText   = null ;
    /** {^ **/
    protected JButton     mBCmd   = null;
    /** x **/
    protected JLabel      mLabel  = null;
    /** [h **/
    protected int         mMode;

    /**
      *  TEXT̈̍쐬 (fileChoosert)
      * @param  String      value           eLXg
      * @param  int         mode            t@CZNg[h
      */
    public EnvTextField(String value, int mode) {

        // t@CZNg[h
        mMode = mode;

        // pl̐
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();

        //TEXT̈̍쐬
        if (value == null) value = "";
        mText = new JTextField(value);
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.gridx   = 0;
        gbc.gridy   = 0;
        mPanel.add(mText);
        mLayout.setConstraints(mText, gbc);

        //Command fileChooser
        gbc.weightx = 0.0 ;
        gbc.gridx   = 2;
        gbc.gridy   = 0;
        mBCmd = new JButton("...");
        mLayout.setConstraints(mBCmd, gbc);
        mPanel.add( mBCmd );
        mBCmd.addActionListener(
        new ActionListener() {
          public void actionPerformed(ActionEvent e) { fileChooser(); }
          }
        );
    }


    /**
      *  TEXT̈̍쐬(̓GǍɃxLj
      * @param  String      value           eLXg
      * @param  String      label           x
      */
    public EnvTextField(String value, String label) {

        // pl̐
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();

        //TEXT̈̍쐬
        if (value == null) value = "";
        mText = new JTextField(value);
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.gridx   = 0;
        gbc.gridy   = 0;
        mPanel.add(mText);
        mLayout.setConstraints(mText, gbc);

        if (!label.equals("")){
            //x
            gbc.weightx = 0.0 ;
            gbc.gridx   = 2;
            gbc.gridy   = 0;
            mLabel = new JLabel(label);
            mLayout.setConstraints(mLabel, gbc);
            mPanel.add( mLabel );
        }
    }

    /**
      * eLXgtB[h̎擾
      *
      * @return JTextField
      */
    public JTextField getTextField() {
        return mText;
    }

    /**
      * ̓GAɒlݒ
      *
      * @param  String      szValue ݒ蕶
      * @return void
      */
    public void setString( String szValue ){
        mText.setText( szValue );
    }

    /**
      * ̓GA̒l擾
      *
      * @return String  
      */
    public String getString(){
        String szTmp = mText.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }

    /**
      * pl̎擾
      *
      * @return JPanel
      */
    public JPanel getPanel(){
        return mPanel;
    }

    /**
      * fileChooser̐
      * 
      * @return void
      */
    public void fileChooser() {
        EnvFileChooser fileChooser = new EnvFileChooser();
        String szFile = fileChooser.show(ZApp.getTheApp().getFrame(), getString(), mMode);
        if (szFile != null) setString (szFile);
    }
}
