/*
 * @(#)AnalyzerDialog
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : AiCU_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/02/04
 * 			1.10 2003/05/19 Detail Info@\ǉɔύX
 */
package jp.co.nri.rid.environment;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.File;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;


/**
 * AiCU_CAO
 */

public class AnalyzerDialog {

    /** msg.analyzer.titlevpeB  **/
    final static public String MSG_ANALYZER_TITLE       = "msg.analyzer.title";
    /** msg.analyzer.ignorevpeB  **/
    final static public String MSG_ANALYZER_IGNORE      = "msg.analyzer.ignore";
    /** msg.analyzer.o3w.importvpeB  **/
    final static public String MSG_ANALYZER_O3W_IMPORT  = "msg.analyzer.o3w.import";
    /** rid.ignore.prefixevpeB  **/
    final static public String IGNORE_PREFIX            = "rid.ignore.prefix";
    /** analyze.o3w.importvpeB  **/
    final static public String ANALYZE_O3W_IMPORT       = "analyze.o3w.import";
    
// 2003/05/19
	/** detailinfovpeB  **/
	final static public String MSG_ANALYZER_DETAILINFO	= "msg.analyzer.detailinfo";
    final static public String ANALYZER_DETAILINFO		= "analyzer.detailinfo";

    /** pl      **/
    protected JPanel      mPanel        = null;
    /** IgnoreL[  **/
    protected JTextField  mIgnorePrefix = null;
    /** O3W Import  **/
    protected JCheckBox   mO3WImport    = null;
    
// 2003/05/19
    /** DetailInfo  **/
    protected JCheckBox[] mDetailInfo   = null;
	
    /**
      * ftHgRXgN^
      */
      public AnalyzerDialog() {  }

    /**
      * AiCU_CAO
      *
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public boolean show() {

        ZResource res = ZApp.getTheApp().getResource();

        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog gdlg = new EnvDialog(frame, res.getString(MSG_ANALYZER_TITLE));

        //CR|[lg
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints label_gbc = createLabelConstraints();
        GridBagConstraints compo_gbc = createComponentConstraints();

        //x
        label_gbc.gridy      = 0;
        label_gbc.gridx      = 0;
        JLabel label = new JLabel(res.getString(MSG_ANALYZER_IGNORE));
        mLayout.setConstraints(label, label_gbc);
        mPanel.add( label );

        //IgnorePrefix
        compo_gbc.gridy      = 0;
        compo_gbc.gridx      = 1;
        mIgnorePrefix = createIgnorePrefix();
        mLayout.setConstraints(mIgnorePrefix, compo_gbc);
        mPanel.add( mIgnorePrefix );

        //x
        label_gbc.gridy      = 1;
        label_gbc.gridx      = 0;
        JLabel label2 = new JLabel(res.getString(MSG_ANALYZER_O3W_IMPORT));
        mLayout.setConstraints(label2, label_gbc);
        mPanel.add( label2 );

        //y[W`FbN{bNX
        compo_gbc.gridy      = 1;
        compo_gbc.gridx      = 1;
        mO3WImport = new JCheckBox("");
        mO3WImport.setSelected(res.getBoolean(ANALYZE_O3W_IMPORT));
        mLayout.setConstraints(mO3WImport, compo_gbc);
        mPanel.add( mO3WImport );
		
// 2003/5/19 ǉ
		mDetailInfo = createDetailInfo();
		try{
			JPanel panel = new JPanel();
			int count = mDetailInfo.length;
			for(int i = 0; i < count; i++)	panel.add(mDetailInfo[i]);
	        
			//x
	        label_gbc.gridy      = 2;
	        label_gbc.gridx      = 0;
	        JLabel label3 = new JLabel(res.getString(MSG_ANALYZER_DETAILINFO));
	        mLayout.setConstraints(label3, label_gbc);
	        mPanel.add( label3 );
			
	        //R|[lg
	        compo_gbc.gridy      = 2;
	        compo_gbc.gridx      = 1;
	        mLayout.setConstraints(panel, compo_gbc);
	        mPanel.add( panel );
			
		} catch(NullPointerException e){}
		
        // [CR|[lg][OK][CENCEL]
        gdlg.setControlPanel(mPanel);

        //_CAO\i[_j
        gdlg.doModal();

        // []{^ꂽꍇɕύX
        boolean ret = gdlg.isOK();
        if (ret){
            setIgnorePrefix();
            setAnalyzO3WImport();
            setDetailInfo();
        }   
        return ret;
    }


    /**
      * ignoreL[JTextField𐶐
      *
      * @return JTextField
      */
    private JTextField createIgnorePrefix() {
        ZResource res = ZApp.getTheApp().getResource();
        String  ignore_prefix = res.getString(IGNORE_PREFIX);
        JTextField text = new JTextField(ignore_prefix,30);
        return text;
    }

    /**
      * DetailInfoJCheckBox𐶐 2003/05/19
      *
      * @return JCheckBox[]
      */
    private JCheckBox[] createDetailInfo() {
		Vector result = new Vector();
		ZResource res = ZApp.getTheApp().getResource();
		try{
			StringTokenizer st = new StringTokenizer(res.getString(ANALYZER_DETAILINFO) ," ");
			while(st.hasMoreTokens()){
				String label = st.nextToken();
				result.add( new JCheckBox(label, res.getBoolean(ANALYZER_DETAILINFO+"."+label)) );
			}
		}catch(NullPointerException e){}
		
		return (JCheckBox[])result.toArray(new JCheckBox[0]);
    }


    /**
      * ignoreL[̕擾
      *
      * @return void
      */
    private String getIgnorePrefix(){
        String szTmp = mIgnorePrefix.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }


    /**
      * ignoreL[[ignore.prefix]vpeBɐݒ
      *
      * @return void
      */
    private void setIgnorePrefix() {
        ZResource res = ZApp.getTheApp().getResource();
        /* [gnore.prefix]ݒ */
        res.putString(IGNORE_PREFIX, getIgnorePrefix() );
    }

    /**
      * O3W̃AiCYIԂ[analyz.o3w.import]ɐݒ
      *
      * @return void
      */
    private void setAnalyzO3WImport() {
        ZResource res = ZApp.getTheApp().getResource();
        /* [analyz.o3w.import]ݒ */
        res.putBoolean(ANALYZE_O3W_IMPORT, mO3WImport.isSelected());
    }

    /**
      * DetailInfõAiCYIԂݒ
      *
      * @return void
      */
    private void setDetailInfo() {
        ZResource res = ZApp.getTheApp().getResource();
		
		try{
			for(int i = mDetailInfo.length - 1; 0 <= i; i--){
				JCheckBox comp = mDetailInfo[i];
		        res.putBoolean(ANALYZER_DETAILINFO+"."+comp.getText() , comp.isSelected());
			}
		} catch(NullPointerException e){}
    }
    /**
      * xpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.weightx = 0.0 ;
        gbc.insets  = new Insets(10,10,0,10) ;
        return gbc;
    }


    /**
      * R|[lgpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0 ;
        gbc.insets    = new Insets(10,10,0,10) ;
        return gbc;
    }
}
