/*
 * @(#)RidMapAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : MAP Action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/08/09
 */
package jp.co.nri.rid.doc;

import java.awt.event.ActionEvent;

import java.util.Enumeration;
import java.util.Vector;

import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocElement;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidElement;
import jp.co.nri.rid.doc.RidElementPage;
import jp.co.nri.rid.doc.RidDocumentSite;
/**
 * Rid MAP Action
 */
public class RidMapAction extends RidAction {
	/**
	 * ANVs
	 */
	public void doAction(ActionEvent evt) {
	String szAction = getActionName();
	DocPane  editor = (DocPane)ZInstance.map().get(Rid.PANEL_MAP);
	String szPanelId= editor.getPanelId();
	RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);

	boolean isTran = doc.isTransaction();
	if ( !isTran ) {
		doc.beginTransaction();
	}

	if ( szAction.equals( ALL_OMISSION ) ||
		 szAction.equals( ALL_EXPAND ) ) {
		boolean bOmi = szAction.equals( ALL_OMISSION ) ;
		Vector vec = getTopPages(doc,szPanelId);
		Enumeration elm = vec.elements();
		while ( elm.hasMoreElements() ) {
			DocElement page = (DocElement)elm.nextElement();
			DocElement vwi  = (DocElement)page.getChildElement(".ViewInfo."+szPanelId,null);
			vwi.setBooleanAttr("Omission",bOmi);
		}

		editor.updateGobs();
		editor.repaint();
	}

	if ( !isTran ) {
		doc.commit();
	}
	}

	/**
	 * UIXV
	 */
	public void update() {
	String szAction = getActionName();
	DocPane  editor = (DocPane)ZInstance.map().get(Rid.PANEL_MAP);
	String szPanelId= editor.getPanelId();
	RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);

	boolean bState = false;
	if ( szAction.equals( ALL_OMISSION ) ||
		 szAction.equals( ALL_EXPAND ) ) {
		boolean bOmi = szAction.equals( ALL_OMISSION ) ;
		Vector vec = getTopPages(doc,szPanelId);
		
		if ( vec.size() != 0 ) {
			Enumeration elm = vec.elements();
			while ( elm.hasMoreElements() ) {
				DocElement page = (DocElement)elm.nextElement();
				DocElement vwi  = (DocElement)page.getChildElement(".ViewInfo."+szPanelId,null);
				boolean bPage = vwi.getBooleanAttr("Omission",false);
				if ( bOmi != bPage ) {
					bState = true;
				}
			}
		}
	}

	firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
	}

	//## ŗL\bh #################################################
	/**
	 * MAPʂ̃gbvy[W擾
	 * @param doc       hLg
	 * @param szPanelId plʎq
	 */
	protected Vector getTopPages( RidDocumentSite doc, String szPanelId ) {
	Vector tops = new Vector();
	RidElementPage top = doc.getTopPage(szPanelId);
	if ( top != null ) {
		if ( top.getMapParent(szPanelId,"Auto").equals("root") ) {
			// gbv[g̏ꍇ͐eroot̃y[Wꗗ擾
			Vector pages = doc.getTopZone().getPages(true);
			Enumeration elm = pages.elements();
			while ( elm.hasMoreElements() ) {
				RidElementPage page = (RidElementPage)elm.nextElement();
				if ( page.getMapParent(szPanelId,"Auto").equals("root") ) {
					tops.add(page);
				}
			}
		} else {
			// gbv[głȂ΃gbv̂
			tops.add(top);
		}
	}
	return tops;
	}

	//## Agr[g ###############################################
    /**
     * ANVFׂďȗ
     */
	final static public String ALL_OMISSION	= "all_omission" ;

    /**
     * ANVFׂēWJ
     */
	final static public String ALL_EXPAND	= "all_expand" ;
}
