/*
 * @(#)RidChangeAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : plؑ֌n Action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/08/09
 */
package jp.co.nri.rid.doc;

import java.awt.event.ActionEvent;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JTabbedPane;

import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocElement;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidElement;
import jp.co.nri.rid.doc.RidElementZone;
import jp.co.nri.rid.doc.RidDocumentSite;

import jp.co.nri.rid.RUpdateManager;
/**
 * Rid plؑ֌n Action
 */
public class RidChangeAction extends RidAction {

	/**
	 * ftHgRXgN^
	 */
	public RidChangeAction() {
	}

	//## Agr[g################################################
	/**
	 * ANVs
	 */
	public void doAction(ActionEvent evt) {
	String szAction = getActionName();
	Vector targets  = getTargets();
	JTabbedPane     tab = (JTabbedPane)ZInstance.map().get(Rid.PANEL_TAB);
	RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);
	RidElementZone  top = doc.getTopZone();

	boolean isTran = doc.isTransaction();
	if ( !isTran ) {
		doc.beginTransaction();
	}

	if ( szAction.equals( ZONE ) ) {
		// ^uV[g̈ړ
		tab.setSelectedIndex(Rid.PANEL_ZONE_INDEX);

		// IԂ̕ύX
		setSelect( top, targets );

		// Zonepl̎擾
		DocPane  editor = (DocPane)ZInstance.map().get(Rid.PANEL_ZONE);
		DocElement root = (DocElement)doc.getRootElement(editor.getPanelId());

		// IĂ^[QbgP̏ꍇ́A^[Qbg̐eZonegbvɕύX
		RidElementZone newRoot = null ;
		if ( targets.size() == 1 ) {
			DocElement target = (DocElement)targets.firstElement() ;
			DocElement parent = (DocElement)target.getParentNode() ;
			if ( parent instanceof RidElementZone ) {
				if ( parent != root ) {
					newRoot = (RidElementZone)parent ;
				}
			} else {
				newRoot = top;
			}

		// ݂̃[gTOPłȂꍇ́ATOP[gɕύX
		} else {
			if ( top != root ) {
				newRoot = top;
			}
		}
		
		// [g̕ύX
		if ( newRoot != null ) {
			// updatechangeRootōŝŕsv
			newRoot.changeRoot(editor);
		} else {
			// ANeBupl̍ĕ`
			RUpdateManager.update(RUpdateManager.PANEL_ACTIVE, true);
		}

	} else if ( szAction.equals( SITE ) ||
				szAction.equals( HIER ) ||
				szAction.equals( CIRCLE ) ) {
		// ^uV[g̈ړ
		tab.setSelectedIndex(Rid.PANEL_MAP_INDEX);

		// IԂ̕ύX
		setSelect( top, targets );

		// ANeBu}bv̕ύX
		String[] szMap = ZString.tokenize( szAction, "_" );
		setActiveMap( top, szMap[1] );

		// Mappl̎擾
		DocPane editor = (DocPane)ZInstance.map().get(Rid.PANEL_MAP);
		RidElementPage defaultTop = doc.getDefaultTopPage(editor.getPanelId());
		RidElementPage currentTop = doc.getTopPage(editor.getPanelId());

		// gbvy[W̕ύX
		if ( defaultTop != currentTop ) {
			defaultTop.changeTop( editor );
		} else {
			// ANeBupl̍ĕ`
			RUpdateManager.update(RUpdateManager.PANEL_ACTIVE, true);
		}
	}

	if ( !isTran ) {
		doc.commit();
	}
	}

	/**
	 * UIXV
	 */
	public void update() {
	String szAction = getActionName();
	boolean bState = true;
	Vector targets  = getTargets();

	RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);
	RidElementZone  top = doc.getTopZone();

	if ( targets.size() == 0 ) {
		bState = false;
	}

	if ( szAction.equals( ZONE ) ) {
		// IĂ^[QbgPŃ[g̏ꍇ͐ؑւȂ
		RidElementZone newRoot = null ;
		if ( targets.size() == 1 ) {
			DocElement target = (DocElement)targets.firstElement() ;
			if ( target == top ) {
				bState = false;
			}
		}
	}

	firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
	}

	//## Agr[g ###############################################
    /**
     * ANVFzoneɐؑ
     */
	final static public String ZONE		= "change_zone" ;

    /**
     * ANVFsiteɐؑ
     */
	final static public String SITE		= "change_site" ;

    /**
     * ANVFhierɐؑ
     */
	final static public String HIER		= "change_hier" ;

    /**
     * ANVFcircleɐؑ
     */
	final static public String CIRCLE	= "change_circle" ;
}
