/*
 * @(#)MapModel.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Map paint model
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/12/10
 */
package jp.co.nri.rid.doc;

import java.awt.Shape;
import java.awt.Dimension;

import java.awt.geom.AffineTransform;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.GRectShape;

import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;
/**
 * Map`pfNX
 */
public class MapModel {

	/**
	 * RXgN^
	 */
    public MapModel() {
    }

	//## ϊ #########################################################
	/**
	 * y[W`IuWFNgɕϊ
	 * @param major W[ԍ
	 * @param minor }Ci[ԍ
	 * @param szShape `
	 */
	public Shape createPageShape( double major, double minor, String szShape ) {
	GRectShape gRect = new GRectShape();
	gRect.setShape(szShape);
	gRect.setRect( mPageRect );
	return createShape( gRect.getPath(), major, minor );
	}

	/**
	 * ViI`IuWFNgɕϊ
	 * @param major W[ԍ
	 * @param minor }Ci[ԍ
	 */
	public Shape createScenarioShape( double major, double minor ) {
	ZRectangle rt = new ZRectangle(mPageRect);
	double  inset = 20;
	rt.setX(rt.getX()-inset);
	rt.setY(rt.getY()-inset);
	rt.setWidth(rt.getWidth()+inset*2);
	rt.setHeight(rt.getHeight()+inset*2);
//	return createShape( rt.getEllipse2D(), major, minor );
	return createShape( rt, major, minor );
	}

	/**
	 * ^Cg`IuWFNgɕϊ
	 * @param major W[ԍ
	 * @param minor }Ci[ԍ
	 */
	public Shape createTitleShape( double major, double minor ) {
	return createShape( mTitleRect, major, minor );
	}

	/**
	 * ANZXJEg`IuWFNgɕϊ
	 * ̍őlFmPageRect2{
	 * @@@ŏlF1
	 * ߂鍂 h 
	 * h F count = mPageRect.getHeight()*2 F mAccessMax
	 *
	 * @param major W[ԍ
	 * @param minor }Ci[ԍ
	 * @param acc   ANZXJEg
	 */
	public Shape[] createAccessShapes( double major, double minor, AccessCounts acc ) {
	ZRectangle rt = new ZRectangle(mPageRect);

	// ́Ay[W2.5{őlƂ
	double height = rt.getHeight()*2.5 ;
	rt.setY(rt.getY()+rt.getHeight()-height);
	rt.setHeight(height);

	// ̓y[W藼[5pixׂ
	rt.setX(rt.getX()+5);
	rt.setWidth(rt.getWidth()-5*2);

	ZRectangle[] rts = mAcc.createAccessRects( rt, acc ) ;
	if ( rts == null ) {
		return null ;
	}
	Shape[] shs = new Shape[rts.length];
	for ( int nAt=0 ; nAt<rts.length ; nAt++ ) {
		shs[nAt] = createShape( rts[nAt], major, minor );
	}
	return shs;
	}

	/**
	 * ^Cg`IuWFNgɕϊ
	 * @param sh    `
	 * @param major W[ԍ
	 * @param minor }Ci[ԍ
	 */
	public Shape createShape( Shape sh, double major, double minor ) {
	Shape shObj = mAtObject.createTransformedShape( sh ) ;
	ZPoint ppt  = modelToView( new ZPoint(major,minor) );
	AffineTransform atOffset = new AffineTransform(1,0,0,1,ppt.getX(),ppt.getY());
	return atOffset.createTransformedShape(shObj);
	}

	/**
	 * N|Cg̎擾
	 * @param major W[ԍ
	 * @param minor }Ci[ԍ
	 */
	public ZPoint getLinkPoint( double major, double minor ) {
	ZPoint pt  = modelToView( new ZPoint(major,minor) );
	pt.translate( getLinkPointOffset() );
	return pt;
	}

	/**
	 * qւ̃N̒ԃ|Cg̎擾
	 * @param major W[ԍ
	 * @param minor }Ci[ԍ
	 */
	public ZPoint getLinkHarfPoint( double major, double minor ) {
	return getLinkPoint( major+0.5, minor );
	}

	/**
	 * N|CgItZbg̎擾
	 */
	public ZPoint getLinkPointOffset() {
	ZPoint ptLink = new ZPoint( mPageRect.getWidth()*mLinkOffset.getX(),
								mPageRect.getHeight()*mLinkOffset.getY() );

	// y[Wό`ɂ킹ăV[Oϊ
	ZPoint pt = new ZPoint();
	mAtObject.transform( ptLink, pt );
	return pt;
	}


	//## {ϊ #####################################################
	/**
	 * Major-MinorWXYWϊ
	 * @param  pt x:Major, y:Minor
	 * @return    x:XW, y:YW(Έʒu)
	 */
	public ZPoint modelToCoord(ZPoint pt) {
	ZPoint ptTrans = new ZPoint();
	if ( getCoordTransform() != null ) {
		// y[Wό`ɂ킹ăV[Oϊ
		getCoordTransform().transform(pt, ptTrans);
	} else {
		// CircleMap̏ꍇ PʃxNg [cos(minor),sin(minor)]
		// PʃxNgmajor{
		double dOff = getCircleOffset();
		ptTrans.setX( Math.cos(pt.getY())*(pt.getX()-1)*dOff );
		ptTrans.setY( Math.sin(pt.getY())*(pt.getX()-1)*dOff );
//		ZDebug.trace("MM["+pt.getX()+","+pt.getY()+"]=Coord:"+ptTrans);
	}
/*
	if ( boo ) {
		boo = false;
		
		for ( int nIndex=10; nIndex<360 ; nIndex+=10 ) {
			double mm   = (double)nIndex;
			double d0   = (2*Math.PI/360)*mm ;
		
			double dX = Math.cos(d0);
			double dY = Math.sin(d0);
			double ata = Math.atan(dY/dX);
			if ( dX < 0 ) {
				ata += Math.PI;
			} else if ( dY < 0 ) {
				ata += Math.PI*2;
			}
			ZDebug.trace("minor:"+mm+"  minor:"+d0+" ata:"+ata+" dX:"+dX+" dY"+dY+"  "+((ata==d0)?"":"~"));
//		ZDebug.trace("tan:"+Math.tan(dX/dY));
//		ZDebug.trace("tan:"+Math.tan(dY/dX));
//		ZDebug.trace("atan:"+Math.atan(dX/dY));
//		ZDebug.trace("atan:"+Math.atan(dY/dX));
		}
	}
*/
	return ptTrans;
	}


//	static boolean boo = true;

	/**
	 * Major-MinorWXYWϊ
	 * @param  pt x:Major, y:Minor
	 * @return    x:XW, y:YW(Jnʒul΍W)
	 */
	public ZPoint modelToView( ZPoint pt ) {
	ZPoint ptTrans = modelToCoord(pt);
//	ptTrans.translate( mBasePoint );
	ptTrans.translate( new ZPoint( mBasePoint.getX()-mBaseOffset.getX(),
								   mBasePoint.getY()-mBaseOffset.getY() ) );
	return ptTrans;
	}

	/**
	 * XYWMajor-MinorWϊ
	 * @param pt x:XW, y:YW(Έʒu)
	 * @return   x:Major, y:Minor
	 */
	public ZPoint coordToModel(ZPoint pt) {
	ZPoint ptTrans = new ZPoint();
	if ( getCoordTransform() != null ) {
		try {
			// y[Wό`ɂ킹ăV[Otϊ
			getCoordTransform().inverseTransform( pt, ptTrans );
		} catch (Exception exc) {
			ZDebug.err("inverse transform failed");
		}
	} else {
		// XẂAptxNg̒
		double dOff = getCircleOffset();
		ptTrans.setX(Math.sqrt((pt.getX()*pt.getX()+pt.getY()*pt.getY())/(dOff*dOff))+1);

		// YW͋t (A[N^WFgjł邪AẄʒuɂ PI,2PI Z
		//                |
		//   atan(y/x)+pi | atan(y/x)
		//                |
		//  --------------+-----------------
		//                |
		//   atan(y/x)+pi | atan(y/x)+2pi
		//                |
		double ata = Math.atan(pt.getY()/pt.getX());
		if ( pt.getX() < 0 ) {
			ata += Math.PI;
		} else if ( pt.getY() < 0 ) {
			ata += Math.PI*2;
		}
		ptTrans.setY(ata);

//		ZDebug.trace("MM["+pt.getX()+","+pt.getY()+"]=Coord:"+ptTrans);
	}
	return ptTrans;
	}

	/**
	 * XYWMajor-MinorWϊ
	 * @param pt x:XW, y:YW(Jnʒul΍W)
	 * @return   x:Major, y:Minor
	 */
	public ZPoint viewToModel( ZPoint pt ) {
//	pt.translate( -mBasePoint.getX(), -mBasePoint.getY() );
	pt.translate( -(mBasePoint.getX()-mBaseOffset.getX()),
				  -(mBasePoint.getY()-mBaseOffset.getY()) );
	ZPoint ptTrans = coordToModel(pt);
	return ptTrans;
	}

	//## vpeB ###################################################
	/**
	 * ANZXJEg̐ݒ
	 * @param acc ől
	 */
	public void setAccessCounts( AccessCounts acc ) {
	if ( acc != null ) {
		mAcc = acc;
	}
	}

	/**
	 * JnʒuF(0,0)W̐ݒ
	 */
	public void setBasePoint( ZPoint pt ) {
	mBasePoint = pt;
	}

	/**
	 * NItZbg̐ݒ
	 */
	public void setLinkOffset( ZPoint pt ) {
	mLinkOffset = pt;
	}

	/**
	 * IuWFNgϊ[`̐ݒ
	 */
	public void setObjectTransform(AffineTransform at) {
	mAtObject = at;
	}

	/**
	 * Wϊ[`̐ݒ
	 */
	public void setCoordTransform(AffineTransform at) {
	mAtCoord = at;
	}

	/**
	 * Wϊ[`̎擾
	 */
	protected AffineTransform getCoordTransform() {
	AffineTransform at = null;
	if ( mAtCoord != null ) {
		at = new AffineTransform( mAtCoord );
		at.scale( mScale,mScale );
	}
	return at;
	}

	/**
	 * CircleItZbg̎擾
	 */
	public double getCircleOffset() {
	return mCircleOffset*mScale;
	}

	/**
	 * ItZbg̏
	 * ČvZOɏALfitToPanelōĐݒ肳
	 */
	public void clearOffset() {
	mScale = 1;
	mBaseOffset = new ZPoint(0,0);
	}

	/**
	 * plɂ傤Ǎ悤ȃTCYɕ␳
	 * @param rect ̕``
	 * @param dim  plTCY
	 */
	public ZRectangle fitToPanel( ZRectangle rect, Dimension dim ) {
	// rect܂dim̒𒆐SƂ`擾
//	ZDebug.trace("  rect:"+rect+" dim:"+dim);

	// ӂ̈̒
	// c
	double dN = Math.max(0,-rect.getY());
	double dS = Math.max(0,rect.getY()+rect.getHeight()-dim.height);
	double dV = Math.max(dN,dS);
//	ZDebug.trace("  dV:"+dV+" dN:"+dN+" dS:"+dS);

	// 
	double dW = Math.max(0,-rect.getX());
	double dE = Math.max(0,rect.getX()+rect.getWidth()-dim.width);
	double dH = Math.max(dW,dE);
//	ZDebug.trace("  dH:"+dH+" dW:"+dW+" dE:"+dE);

	ZRectangle rt = new ZRectangle(rect);
	// ӂĂꍇ͕␳
	if ( dV > 0 || dH > 0 ) {
		// kڂ̌vZ
		mScale = Math.min( dim.height/rect.getHeight(),
						   dim.width /rect.getWidth() );
		if ( mScale > 1 ) {
			mScale = 1;
		}
//		ZDebug.trace("MapScale:"+mScale);

		// `JnʒǔvZ
		mBaseOffset.setX(mBasePoint.getX()-(mBasePoint.getX()-rect.getX())*mScale);
		mBaseOffset.setY(mBasePoint.getY()-(mBasePoint.getY()-rect.getY())*mScale);
//		ZDebug.trace("Offset:"+mBaseOffset);

		if ( mScale < 1 ) {
			// k̏ꍇAS
			rt = new ZRectangle(0,0,dim.width,dim.height);
		} else {
			// {
			rt = new ZRectangle(0,0,rect.getWidth(),rect.getHeight());
		}
	}

	return rt;
	}

	//## Agr[g ###############################################
	/**
	 * y[W`
	 */
	protected ZRectangle mPageRect = new ZRectangle(0,0,30,40);

	/**
	 * ^Cg`
	 */
	protected ZRectangle mTitleRect = new ZRectangle(0,0,30,10);

	/**
	 * `Jnʒu
	 */
	protected ZPoint mBasePoint = new ZPoint( 4000*Rid.PANELSIZE, 3000*Rid.PANELSIZE );

	/**
	 * `Jnʒu̕␳l
	 */
	protected ZPoint mBaseOffset = new ZPoint( 0, 0 );

	/**
	 * NItZbg
	 */
	protected ZPoint mLinkOffset = new ZPoint( 0.5, 0.5 );

	/**
	 * IuWFNgϊ[`
	 */
	protected AffineTransform mAtObject = new AffineTransform(1,0,0,1,0,0);

	/**
	 * Wϊ[`
	 */
	protected AffineTransform mAtCoord = new AffineTransform(100,0,0,100,0,0);

	/**
	 * Circlȅꍇ̃ItZbg
	 */
	protected double mCircleOffset = 100;

	/**
	 * Wϊk
	 */
	protected double mScale = 1;

	/**
	 * ANZXJEgz
	 */
	protected AccessCounts mAcc = new AccessCounts();

	/**
	 * ANZXJEgől
	 */
	protected int mAccessMax = 1000;
}
