/**
 * @(#)ScriptingMapper.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : Scripting Mapper
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2001/12/28
 * @see 
 */
package	jp.co.nri.rid.analyzer;

import	jp.co.nri.rid.xml.*;
import jp.co.nri.rid.error.*;

/**
 * AiCUoɉāȂ邽߂̓K؂iMappingScriptNB
 */

public class ScriptingMapper{
	private static final String PAGE = "Page";
	private static final String FILE = "File";
	
//--------[[ open method ]]----------------------------------------------------
	
	/**
	 * mappingBmappingScriptNScriptȂB
	 * @param	report	attributeLqꂽXML DOM Element
	 * @param	script	mappingscript
	 * @see		elementBooster
	 * @see		iMappingScript
	 * @since	1.00
	 */
	public void mapping(elementBooster report ,iMappingScript script)
		throws RidException ,RWarningException
	{
		RWarningException	warnings	= new RWarningException();
		elementBooster[]	elements	= report.children(PAGE);
		if(null==elements)	return;
		
		String[]			tagnames	= script.names();
		int					tagnamecount= tagnames.length;
		
		int mx = elements.length;
		for(int i=0;i<mx;i++){
			elementBooster element = elements[i];
			String file = element.attribute(FILE);
			
			for(int j=0;j<tagnamecount;j++){
				String tagname = tagnames[j];
				elementBooster[] children = element.children(tagname);
				if(null==children)	continue;
				
				int mx3 = children.length;
				for(int k=0;k<mx3;k++){
					try{ script.hit(file ,tagname ,children[k]); }
					catch(RWarningException e){
						warnings.add(e);
					}
				}
			}
		}
		
		if(0<warnings.length())	throw warnings;
	}
}