/*
 * @(#)RidViewAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid view action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/21
 */
package jp.co.nri.rid.action;

import java.awt.event.ActionEvent;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.rid.RUpdateManager;
/**
 * Rid View OptionnANV`
 */
public class RidViewAction extends ZAction {
	/**
	 * B̃RXgN^łB
	 * @param app AvP[V
	 * @param szAction ANV
	 */
	public RidViewAction(IZApp app,String szAction) {
    super(app,szAction);
	}

	/**
	 * ANVs
	 */
	public void doAction(ActionEvent e) {
	ZResource res = getApp().getResource();

	// Link
	if ( getActionName().equals( LINK_VIRTUAL ) ) {
		boolean bValue = res.getBoolean("view.Link.Virtual");
		res.putBoolean("view.Link.Virtual",!bValue);
	} else if ( getActionName().equals( LINK_REAL ) ) {
		boolean bValue = res.getBoolean("view.Link.Real");
		res.putBoolean("view.Link.Real",!bValue);
	} else if ( getActionName().equals( LINK_SELECT ) ) {
		boolean bValue = res.getBoolean("view.Link.Select");
		res.putBoolean("view.Link.Select",!bValue);

	// ZoneUnit
	} else if ( getActionName().equals( ZONE_NAM ) ) {
		res.putString("viewtext.Zone.ZoneUnit","Name");
	} else if ( getActionName().equals( ZONE_CMT ) ) {
		res.putString("viewtext.Zone.ZoneUnit","Comment");
	} else if ( getActionName().equals( ZONE_FIL ) ) {
		res.putString("viewtext.Zone.ZoneUnit","File");

	// PageUnit
	} else if ( getActionName().equals( PAGE_NAM ) ) {
		res.putString("viewtext.Zone.PageUnit","Name");
	} else if ( getActionName().equals( PAGE_TTL ) ) {
		res.putString("viewtext.Zone.PageUnit","Title");
	} else if ( getActionName().equals( PAGE_CMT ) ) {
		res.putString("viewtext.Zone.PageUnit","Comment");
	} else if ( getActionName().equals( PAGE_FIL ) ) {
		res.putString("viewtext.Zone.PageUnit","File");

	// PageUnit
	} else if ( getActionName().equals( URL_NAM ) ) {
		res.putString("viewtext.Zone.UrlUnit","Name");
	} else if ( getActionName().equals( URL_CMT ) ) {
		res.putString("viewtext.Zone.UrlUnit","Comment");

	// Access Count
	} else if ( getActionName().equals( PAGE_ACCESS ) ) {
		boolean bValue = res.getBoolean("view.Page.AccessCount");
		res.putBoolean("view.Page.AccessCount",!bValue);
	}

	RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);
	}

	/**
	 * UIXV
	 */
	public void update() {
	ZResource res = getApp().getResource();
	boolean bValue = true;

//	ZDebug.trace("Action:"+getActionName());

	// Link
	if ( getActionName().equals( LINK_VIRTUAL ) ) {
		bValue = res.getBoolean("view.Link.Virtual");
	} else if ( getActionName().equals( LINK_REAL ) ) {
		bValue = res.getBoolean("view.Link.Real");
	} else if ( getActionName().equals( LINK_SELECT ) ) {
		bValue = res.getBoolean("view.Link.Select");

	// ZoneUnit
	} else if ( getActionName().equals( ZONE_NAM ) ) {
		bValue = res.getString("viewtext.Zone.ZoneUnit").equals("Name");
	} else if ( getActionName().equals( ZONE_CMT ) ) {
		bValue = res.getString("viewtext.Zone.ZoneUnit").equals("Comment");
	} else if ( getActionName().equals( ZONE_FIL ) ) {
		bValue = res.getString("viewtext.Zone.ZoneUnit").equals("File");

	// PageUnit
	} else if ( getActionName().equals( PAGE_NAM ) ) {
		bValue = res.getString("viewtext.Zone.PageUnit").equals("Name");
	} else if ( getActionName().equals( PAGE_TTL ) ) {
		bValue = res.getString("viewtext.Zone.PageUnit").equals("Title");
	} else if ( getActionName().equals( PAGE_CMT ) ) {
		bValue = res.getString("viewtext.Zone.PageUnit").equals("Comment");
	} else if ( getActionName().equals( PAGE_FIL ) ) {
		bValue = res.getString("viewtext.Zone.PageUnit").equals("File");

	// URLUnit
	} else if ( getActionName().equals( URL_NAM ) ) {
		bValue = res.getString("viewtext.Zone.UrlUnit").equals("Name");
	} else if ( getActionName().equals( URL_CMT ) ) {
		bValue = res.getString("viewtext.Zone.UrlUnit").equals("Comment");

	// Access Count
	} else if ( getActionName().equals( PAGE_ACCESS ) ) {
		bValue = res.getBoolean("view.Page.AccessCount");
	}

	firePropertyChange(ZAction.CHECKED,null,new Boolean(bValue));
	}

	//## Agr[g ###############################################
    /**
     * ANVFN̕\Fvirtual
     */
	final static public String LINK_VIRTUAL		= "link_virtual" ;

    /**
     * ANVFN̕\Freal
     */
	final static public String LINK_REAL		= "link_real" ;

    /**
     * ANVFN̕\FI
     */
	final static public String LINK_SELECT		= "link_select" ;

    /**
     * ANVF][̕\FName
     */
	final static public String ZONE_NAM			= "zone_nam" ;

    /**
     * ANVF][̕\FComment
     */
	final static public String ZONE_CMT			= "zone_cmt" ;

    /**
     * ANVF][̕\FFile
     */
	final static public String ZONE_FIL			= "zone_fil" ;

    /**
     * ANVFy[W̕\FName
     */
	final static public String PAGE_NAM			= "page_nam" ;

    /**
     * ANVFy[W̕\FTitle
     */
	final static public String PAGE_TTL			= "page_ttl" ;

    /**
     * ANVFy[W̕\FComment
     */
	final static public String PAGE_CMT			= "page_cmt" ;

    /**
     * ANVFy[W̕\FFile
     */
	final static public String PAGE_FIL			= "page_fil" ;

    /**
     * ANVFURL̕\FName
     */
	final static public String URL_NAM			= "url_nam" ;

    /**
     * ANVFURL̕\FComment
     */
	final static public String URL_CMT			= "url_cmt" ;

    /**
     * ANVFANZXO̕\
     */
	final static public String PAGE_ACCESS		= "page_access" ;
}
