/*
 * @(#)RidToolAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid tool action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/22
 */
package jp.co.nri.rid.action;

import java.lang.Thread;

import java.awt.Frame;
import java.awt.Container; 
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.event.ActionListener; 
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JPanel;
import javax.swing.JDialog;
import javax.swing.JButton;
import javax.swing.JProgressBar;

import javax.swing.JOptionPane;
import javax.swing.table.TableModel;

import javax.swing.border.EmptyBorder;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ZSplashWindow;
import jp.co.iti.fagot.action.ZAction;
import jp.co.iti.fagot.ui.UDialog;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.doc.DocElement;

import jp.co.nri.Rid;
import jp.co.nri.Ridual;
import jp.co.nri.rid.RUpdateManager;
import jp.co.nri.rid.analyzer.RHTMLAnalyzer;
import jp.co.nri.rid.analyzer.BaseURL;
import jp.co.nri.rid.generator.RHTMLGenerator;
import jp.co.nri.rid.generator.GeneratorDialog;
import jp.co.nri.rid.importer.RStaticPageImporter;
import jp.co.nri.rid.importer.RDynamicPageImporter;
import jp.co.nri.rid.importer.RResourceImporter;
import jp.co.nri.rid.importer.RDocumentImporter;
import jp.co.nri.rid.synchronizer.RSynchronizer;
import jp.co.nri.rid.cleanup.RCleanup;

import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;

import jp.co.nri.rid.snapshot.snapshot;
import jp.co.nri.rid.snapshot.snapshotDocument;

import jp.co.nri.rid.web.RWebRoboTamer;

import jp.co.nri.rid.doc.RidDocument;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElementZone;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.XMLSerializer;

import java.io.*;
import java.util.*;

import jp.co.nri.rid.RidMIT;

import jp.co.nri.rid.environment.AnalyzerDialog;
import jp.co.nri.rid.environment.CleanupDialog;
import jp.co.nri.rid.environment.ImportDialog;
import jp.co.nri.rid.environment.ExistDialog;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.environment.SnapshotDialog;
import jp.co.nri.rid.environment.AccessLogDialog;
import jp.co.nri.rid.environment.DownloadDialog;
import jp.co.nri.rid.mapper.MapperAccessLog;

import jp.co.nri.rid.o3w.O3W_Importer;

/**
 * Ridc[nANV`
 * ec[j[ɑΉ邪@\obNOEhŋN
 */
public class RidToolAction extends ZAction {

  /**
   * B̃RXgN^łB
   * @param app AvP[V
   * @param szAction ANV
   */
  public RidToolAction(IZApp app,String szAction) {
    super(app,szAction);
  }


  /**
   * ANVs
   */
  public void doAction(ActionEvent e) {

      // hLg̎擾
      DocDocument doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);
      RidMessage ridMsg = new RidMessage();

      // vWFNgfBNg̎擾
      String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
      if ( szPjDir == null ) {
          ZDebug.trace("not yet save");
          return;
      }

      // n̏ꍇAy[W݂Ȃ΁AsȂ
      if ( getActionName().equals(GENERATE) ) {
          RidElementZone top = ((RidDocument)doc).getTopZone();
          Vector pages = top.getPages(true);
          if ( pages.size() == 0 ) {
              MessageDialog.showError(ridMsg.Warning("W4007",""));
              return;
          }
      }

      // c[nJn_CAOJ
      boolean bContinue = openOptionDialog(getActionName());
      if ( !bContinue ) {
          return;
      }

      // c[nXbh̊Jn
      // _CAO\ALZ{^ꂽ
      // XbhI
      //
      // ĂȂBjava.lang.Thread  stop()gp

      //_CAO\
      createDialog(getApp().getFrame(), getToolName());

      //c[nXbh̊Jn
      ZDebug.lapStart("Tool");

      mThread = new RToolThread(this);
      mThread.start();
  }

  /**
   * ANV̏I
   * @param bStatus I
   */
  public void endAction(Throwable tStatus) {
      //mSplashWindow.dispose();
      //mSplashWindow = null;

      //LZ_CAO
      mTooldlg.dispose();
//      mTooldlg.hide();
      
      //Tool̖O擾
      ZDebug.lapEnd("Tool",false);
      String szMsg = getToolName();

      //_CAO\AThrowableNXNULL̏ꍇ͐
      //szMsgNull/""̏ꍇ́AExceptiongetMessage()̂ݕ\
      //msgdlg.showException(null, tStatus); or msgdlg.showException(tStatus);
      //MessageDialog msgdlg = new MessageDialog();
      // ***fuku:20020319(start)***
      if ( tStatus != null ) {
    		tStatus.printStackTrace();
      }
      // ***fuku:20020319(end)***
      MessageDialog.showException(szMsg, tStatus);


  }


  /**
   * c[̎擾
   * @param szAction ANV
   */
  public String getToolName() {

      ZResource res = ZApp.getTheApp().getResource();
      if ( getActionName().equals(GENERATE) ) {
          return res.getString("msg.generate.title");
      } else if ( getActionName().equals(ANALYZE_HTML) ) {
          return res.getString("msg.analyzer.title");
      } else if ( getActionName().equals(IMPORT) ) {
          return res.getString("msg.import.title");
      } else if ( getActionName().equals(EXIST) ) {
          return res.getString("msg.exist.title");
      } else if ( getActionName().equals(SNAPSHOT) ) {
          return res.getString("msg.snapshot.title");
      } else if ( getActionName().equals(CLEANUP) ) {
          return res.getString("msg.cleanup.title");
      } else if ( getActionName().equals(ACCESSLOG) ) {
          return res.getString("msg.accesslog.title");
      } else if ( getActionName().equals(DOWNLOAD) ) {
          return res.getString("msg.download.title");
      }

      return "";
  }

  /**
   * UIXV
   */
  public void update() {
      // ***fuku:20020320(start)***
      boolean bState = true;
      DocDocument doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);

      // vWFNgfBNg̎擾
      String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
      if ( szPjDir == null ) {
        bState = false;
      }

      // n̏ꍇAy[W݂Ȃ΁AsȂ
      if ( getActionName().equals(GENERATE) ) {
          RidElementZone top = ((RidDocument)doc).getTopZone();
          Vector pages = top.getPages(true);
          if ( pages.size() == 0 ) {
            bState = false;
          }
      }
      firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
      // ***fuku:20020320(end)***
  }

  /**
   * IvV_CAOJ
   * @param szAction ANV
   */
  public boolean openOptionDialog(String szAction) {

      boolean bRet = true;

      if ( getActionName().equals(GENERATE) ) {
          //
          GeneratorDialog gdial = new GeneratorDialog();
          bRet = gdial.show();
      } else if ( getActionName().equals(ANALYZE_HTML) ) {
          //AiCY
          AnalyzerDialog gdial = new AnalyzerDialog();
          bRet = gdial.show();
      } else if ( getActionName().equals(IMPORT) ) {
          //C|[g
          // vWFNgfBNg̎擾
          String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
          ImportDialog gdial = new ImportDialog();
          bRet = gdial.show(szPjDir);
      } else if ( getActionName().equals(EXIST) ) {
          //݃`FbN
          ExistDialog gdial = new ExistDialog();
          bRet = gdial.show();
      } else if ( getActionName().equals(SNAPSHOT) ) {
          //XibvVbg
          SnapshotDialog gdial = new SnapshotDialog();
          bRet = gdial.show();
      } else if ( getActionName().equals(CLEANUP) ) {
          CleanupDialog gdial = new CleanupDialog();
          bRet = gdial.show();
      } else if ( getActionName().equals(ACCESSLOG) ) {
          AccessLogDialog gdial = new AccessLogDialog();
          bRet = gdial.show();
      } else if ( getActionName().equals(DOWNLOAD) ) {
          DownloadDialog gdial = new DownloadDialog();
          bRet = gdial.show();
      }



      return bRet;
  }

  //## TuNXFXbh #########################################
  /**
   * c[s
   */
  class RToolThread extends Thread {
  

  /**
   * RXgN^
   * @param act ANV
   */
  RToolThread(RidToolAction act) {
      super( act.getActionName() );
      mAct = act;
  }

  /**
   * Xbh̊Jn
   */
  public void run() {

        // R}hs
        Throwable tRet = execTool();

        // ʂ̍XV
        // G[̏ꍇǉłĂ邩Ȃ̂ŉʂXV
        if ( getActionName().equals(ANALYZE_HTML) ||
             getActionName().equals(IMPORT)       ) {
			// ČvZ
			RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get(Rid.DOCUMENT_SITE);
			doc.requestRecalcMap();

                // AiCYAC|[g͉ʕ␳
			RUpdateManager.update(RUpdateManager.PANEL_ACTIVE, true);
        } else {
			RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);
        }

        // bZG[W\
        mAct.endAction( tRet );
  }


  /**
   * NANV
   */
  protected RidToolAction mAct = null;
  }


  /**
   * R}h̎s
   */
  public Throwable execTool() {

      // hLg̎擾
      DocDocument doc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_SITE);

      // vWFNgfBNg̎擾
      String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);

      //boolean bRet = true;
      Throwable tRet = null;
      try {
          if ( getActionName().equals(GENERATE) ) {

              // wAŋATCg}bv
              RHTMLGenerator gen = new RHTMLGenerator();
              doc.beginTransaction();
              gen.generate(doc,szPjDir);
              doc.commit();

          } else if ( getActionName().equals(ANALYZE_HTML) ) {
              //AiCY
              doc.beginTransaction();
              try {

	              //nRvC|[g
	              ZResource res = ZApp.getTheApp().getResource();
	              boolean importPage = res.getBoolean("analyze.o3w.import");
	              if (importPage){
					ZDebug.trace("O3W");
                      O3W_Importer  o3w = new O3W_Importer();
                      o3w.Import();
                  }

				  //AiCY
				  ZDebug.trace("AiCY");
				  String topZoneURL = Ridual.getTopZoneURL();
				  try{
					BaseURL baseURL = (null == topZoneURL) ? null : new BaseURL(topZoneURL);
					
		          	RHTMLAnalyzer analyzer = new RHTMLAnalyzer(doc ,szPjDir);
		          	analyzer.analyze(progressBar, baseURL);
	              	doc.commit();
				  } catch(java.net.MalformedURLException e){
					throw new RidException("Bad setting: Top zone URL.");
				  }
              } catch ( Throwable t) {
                  doc.commit();
//                doc.rollback();
                  ZDebug.trace("Analyze failed");
                  tRet = t;
              }

          } else if ( getActionName().equals(IMPORT) ) {
              //C|[g(y[W^\[X^hLg)
              ZResource res = ZApp.getTheApp().getResource();

              // y[W̏ꍇ
              boolean importPage = res.getBoolean("import.page");
              if (importPage){
                  doc.beginTransaction();
                  try {
                      RStaticPageImporter imp_s = new RStaticPageImporter();
                      imp_s.Import();
                      RDynamicPageImporter imp_d = new RDynamicPageImporter();
                      imp_d.Import();
                      doc.commit();
                  } catch ( Throwable t ) {
                      doc.commit();
//                    doc.rollback();
                      ZDebug.trace("import(page) failed");
                      tRet = t;
                  }
              }

              // \[X̏ꍇ
              boolean importResource = res.getBoolean("import.resource");
              if(importResource) {
                  DocDocument resdoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
                  resdoc.beginTransaction();
                  try {
                      RResourceImporter importer = new RResourceImporter();
                      importer.Import();
                      resdoc.commit();
                  } catch ( Throwable t ) {
                      resdoc.commit();
//                    resdoc.rollback();
                      ZDebug.trace("import(resource) failed");
                      tRet = t;
                  }
              }

              // hLg̃`FbN
              boolean importDocument = res.getBoolean("import.document");
              if (importDocument) {
                  DocDocument docdoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
                  docdoc.beginTransaction();
                  try {
                      RDocumentImporter importer = new RDocumentImporter();
                      importer.Import();
                      docdoc.commit();
                  } catch ( Throwable t ) {
                      docdoc.commit();
//                    docdoc.rollback();
                      ZDebug.trace("import(document) failed");
                      tRet = t;
                  }
              }
          } else if ( getActionName().equals(EXIST) ) {
              //݃`FbN(y[W^\[X^hLg)
              ZResource res = ZApp.getTheApp().getResource();
        
              // y[W̏ꍇ
              boolean existPage = res.getBoolean("exist.page");
              if (existPage){
                  doc.beginTransaction();
                  try {
                      RSynchronizer synchronizer = new RSynchronizer();
                      synchronizer.sync("sync.page",doc.getDocumentElement(),"rid.html.dir");
                      doc.commit();
                  } catch ( Throwable t ) {
                      doc.commit();
//                    doc.rollback();
                      ZDebug.trace("Check alive(page) failed");
                      tRet = t;
                  }
              }

              // \[X̏ꍇ
              boolean existResource = res.getBoolean("exist.resource");
              if(existResource) {
                  DocDocument resdoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
                  resdoc.beginTransaction();
                  try {
                      RSynchronizer synchronizer = new RSynchronizer();
                      synchronizer.sync("sync.resource",resdoc.getDocumentElement(),"rid.html.dir");
                      resdoc.commit();
                  } catch ( Throwable t ) {
                      resdoc.commit();
//                    resdoc.rollback();
                      ZDebug.trace("Check alive(resource) failed");
                      tRet = t;
                  }
              }

              // hLg̏ꍇ
              boolean existDocument = res.getBoolean("exist.document");
              if (existDocument) {
                  DocDocument docdoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
                  docdoc.beginTransaction();
                  try {
                      RSynchronizer synchronizer = new RSynchronizer();
                      synchronizer.sync("sync.document",docdoc.getDocumentElement(),"rid.docs.dir");
                      docdoc.commit();
                  } catch ( Throwable t ) {
                      docdoc.commit();
//                    docdoc.rollback();
                      ZDebug.trace("Check alive(document) failed");
                      tRet = t;
                  }
              }
          } else if ( getActionName().equals(SNAPSHOT) ) {
              //XibvVbg
              boolean ret = false;
              ZResource res = ZApp.getTheApp().getResource();

              DocDocument snapDoc = (DocDocument)ZInstance.map().get( Rid.DOCUMENT_SNAPSHOT );
              snapDoc.beginTransaction();
              
              try {
                  // ^CX^v̎擾As
                  snapshot ss = new snapshot();
                  String time_stamp = ss.time_stamp();
                  ret = ss.exec(szPjDir,time_stamp);
                  if (ret) {
                      // SnapshotUnit̒ǉ
                      snapshotDocument sd = new snapshotDocument();
                      String file    = time_stamp + File.separator +res.getString("rid.work.dir");
                      String name    = time_stamp;
                      String comment = res.getString("snapshot.comment");
                      sd.document(snapDoc, file, name, comment);
                      snapDoc.commit();

                      //Snapshot.xml̕ۑ
                      String szName = ((DocElement)doc.getDocumentElement()).getChildElementAttribute(".ReferenceUnit.FileUnit","Type=snapshot","Name");
                      String docDir = szPjDir + File.separator + res.getString("rid.data.dir");
                      saveDocument(snapDoc, docDir+File.separator+szName);
                  }
              } catch ( Throwable t ) {
                  snapDoc.commit();
//                snapDoc.rollback();
                  ZDebug.trace("snapshot failed");
                  tRet = t;
              }
              
          } else if ( getActionName().equals(CLEANUP) ) {

              ZDebug.trace("Start Cleanup");

              // N[Abv(y[W^\[X^hLg)
              ZResource res = ZApp.getTheApp().getResource();
        
              // y[W̏ꍇ
              boolean cleanupPage = res.getBoolean("cleanup.page");
              if (cleanupPage){
                  doc.beginTransaction();
                  try {
                      //N[Abv
                      RCleanup clean = new RCleanup();
                      clean.cleanupSite(doc);
                      
                      //[g̕ύX
                      // ***fuku:20020319(start)***
                      DocPane panel = (DocPane)ZInstance.map().get(Rid.PANEL_ZONE);
                      DocElement root = (DocElement)doc.getRootElement(panel.getPanelId());
                      if ( !root.getBooleanAttr("Exist",true) ) {
                          RidElementZone top = ((RidDocument)doc).getTopZone();
                          top.changeRoot( panel );
                      }
                      // ***fuku:20020319(end)***
                      
                      doc.commit();
                  } catch ( Throwable t ) {
                      doc.commit();
//                    doc.rollback();
                      ZDebug.trace("Cleanup(page) failed");
                      tRet = t;
                  }
              }

              // \[X̏ꍇ
              boolean cleanupResource = res.getBoolean("cleanup.resource");
              if(cleanupResource) {
                  DocDocument resdoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_RESOURCE);
                  resdoc.beginTransaction();
                  try {
                      //N[Abv
                      RCleanup clean = new RCleanup();
                      clean.cleanupResource(resdoc);
                      resdoc.commit();
                  } catch ( Throwable t ) {
                      resdoc.commit();
//                    resdoc.rollback();
                      ZDebug.trace("Cleanup(resource) failed");
                      tRet = t;
                  }
              }

              // hLg̏ꍇ
              boolean cleanupDocument = res.getBoolean("cleanup.document");
              if (cleanupDocument) {
                  DocDocument docdoc = (DocDocument)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT);
                  docdoc.beginTransaction();
                  try {
                      //N[Abv
                      RCleanup clean = new RCleanup();
                      clean.cleanupDocument(docdoc);
                      docdoc.commit();
                  } catch ( Throwable t ) {
                      docdoc.commit();
//                    docdoc.rollback();
                      ZDebug.trace("Cleanup(document) failed");
                      tRet = t;
                  }
              }

          } else if ( getActionName().equals(ACCESSLOG) ) {

              ZDebug.trace("access log start");

              ZResource res = ZApp.getTheApp().getResource();
        
              doc.beginTransaction();
              try {
                  //ANZXO
                  MapperAccessLog al = new MapperAccessLog();
                  al.accesslog(szPjDir, doc, res.getString("accesslog.csvfile"));
                  doc.commit();
                  
                  // *** 2002/04/18 ***
                  ((RidDocumentSite)doc).requestUpdateAccessCount();
              } catch ( Throwable t ) {
                  doc.commit();
//                doc.rollback();
                  ZDebug.trace("access log failed");
                  tRet = t;
              }
              ZDebug.trace("access log end");

          } else if ( getActionName().equals(DOWNLOAD) ) {

              ZDebug.trace("download start");

              ZResource res = ZApp.getTheApp().getResource();
        
              try {
					// _E[h
					RWebRoboTamer tamer = new RWebRoboTamer();
					boolean bResource = res.getBoolean("download.resource");
					ZDebug.trace("resource:"+bResource);
					tamer.isResourceDownload = bResource;

					String szProxy = res.getString("download.proxy.host");
					int nPort  = res.getInt("download.proxy.port",0);
					/* 20021003 t3-nishimura@nri.co.jp RgAEg */
					//if ( szProxy != null ) {
						ZDebug.trace("proxy host:"+szProxy);
						ZDebug.trace("proxy port:"+nPort);
						tamer.setProxy(szProxy, nPort);
					//} /* 20021003 t3-nishimura@nri.co.jp RgAEg */
					String szUser = ZInstance.prop().getProperty("download.proxy.user");
					String szPass = ZInstance.prop().getProperty("rid.perform");

					// 20021002 proxyT[o̐ݒ폜ƂΉ
//					if ( szUser != null ) {
//						ZDebug.trace("proxy user:"+szUser);
//						ZDebug.trace("proxy pass:"+szPass);
						tamer.setAuthorization(szUser, szPass);
//					}

//					String szDir = ZInstance.prop().getProperty( Rid.PJ_DIR )+File.separator
//								  +res.getString("rid.html.dir");
					String szDir = Ridual.getHtmlDir();
					tamer.setSaveDir(new File(szDir));

					String szURL = res.getString("download.url");
					if ( szURL != null ) {
						ZDebug.trace("url:"+szURL);
						tamer.get(szURL);
					}


              } catch ( Throwable t ) {
                  ZDebug.trace("download failed");
                  tRet = t;
              }
              ZDebug.trace("download end");
          }

      } catch ( Throwable t ) {
          ZDebug.trace("exec tool failed");
          tRet = t;
      }
      return tRet;
  }

    /**
      * LZ_CAOݒ
      * @param  Frame       frame           eڰ
      * @param  String      szMsg           c[
      */
      public void createDialog(Frame frame, String szMsg) {

          //_CAO\
          mTooldlg = new JDialog(frame, "Ridual/" + szMsg);
//          mTooldlg = new JDialog(frame);
          // ^Cg̕\
//          mTooldlg.setTitle("Ridual");
          // no modal
          mTooldlg.setModal(false);

          //{^^x
          JPanel control = new JPanel();
          mCancel = new JButton("Cancel");
          //LZ_CAÓuLZv{^ꂽꍇ̏
          mCancel.addActionListener(
              new ActionListener() {
                  public void actionPerformed(ActionEvent e) {
                  //mThread.stop();
                  // stop()΁AO@ThreadDeath 𔭐
                  mThread.interrupt();
                  mThread.stop();
                  mTooldlg.dispose();
//                  mTooldlg.hide();
                  }
              }
          );
          control.add( mCancel );
			
			progressBar.setString(szMsg);
			progressBar.setStringPainted(true);
			try{ progressBar.setIndeterminate(true); }
			catch(NoSuchMethodError e){}	// for java 1.3
//			progressBar.setBorderPainted(false);
			
			
//          JLabel label = new JLabel("    "+ szMsg + "c    ");
			
			JPanel pnl = new JPanel(new BorderLayout());
			pnl.setBorder(new EmptyBorder(8, 8, 0, 8));
			pnl.add(BorderLayout.NORTH,progressBar);
			
			pnl.add(control, BorderLayout.SOUTH);
			
			mTooldlg.getContentPane().add(pnl, BorderLayout.CENTER);
			
          // ʒɕ\
          mTooldlg.pack();
          mTooldlg.setSize(280, mTooldlg.getHeight());
		  
          Dimension dim = mTooldlg.getToolkit().getScreenSize();
          mTooldlg.setLocation( dim.width/2 - mTooldlg.getWidth()/2, dim.height/2 - mTooldlg.getHeight()/2 );
          mTooldlg.show();
    }


  /**
   * hLg̕ۑ
   * @param doc    hLg
   * @param szFile t@C
   */

  protected DocDocument saveDocument(DocDocument doc,String szFile) {
  try {
    String  szEncoding = doc.getEncoding();
    boolean bIndenting = doc.getIndenting();
    // o
    ZDebug.trace("save:"+szFile);
    OutputFormat fm = new OutputFormat(doc,szEncoding,bIndenting);
    FileOutputStream out = new FileOutputStream(szFile);
    DOMSerializer ser = new XMLSerializer(out,fm).asDOMSerializer();
    ser.serialize(doc);
    return doc;
  } catch ( Throwable t ) {
    ZDebug.err("FileSave failed:"+szFile);
    t.printStackTrace();
  }
  return null;
  }

  //## Agr[g ###############################################
  /**
   * s_CAO
   */
  protected JDialog mTooldlg = null;

  /**
   * sLZ{^
   */
  protected JButton mCancel = null;

  /**
   * ANVsqXbh
   */
  protected RToolThread mThread = null;

	private	JProgressBar	progressBar = new JProgressBar();

  /**
   * ANVF
   */
  final static public String GENERATE       = "generate" ;

  /**
   * ANVFAiCY
   */
  final static public String ANALYZE_HTML   = "analyze_html" ;

  /**
   * ANVFC|[g
   */
  final static public String IMPORT         = "import" ;

  /**
   * ANVF݃`FbN
   */
  final static public String EXIST          = "exist" ;

  /**
   * ANVFXibvVbg
   */
  final static public String SNAPSHOT       = "snapshot" ;

  /**
   * ANVFN[Abv
   */
  final static public String CLEANUP        = "cleanup" ;

  /**
   * ANVFANZXO
   */
  final static public String ACCESSLOG      = "accesslog" ;

  /**
   * ANVF_E[h
   */
  final static public String DOWNLOAD       = "download" ;
}
