/*
 * @(#)RidHelpAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid help action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid.action;

import java.awt.event.ActionEvent;

import java.io.File;
import java.io.IOException;

import	java.awt.*;
import javax.swing.*;

import javax.swing.border.EmptyBorder;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Ridual;
import jp.co.nri.rid.RidMIT;

import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;

import jp.co.nri.rid.doc.RidExecAction;
/**
 * Rid HelpnANV`
 */
public class RidHelpAction extends ZAction {
	/**
	 * B̃RXgN^łB
	 * @param app AvP[V
	 * @param szAction ANV
	 */
	public RidHelpAction(IZApp app,String szAction) {
    super(app,szAction);
	}

	/**
	 * ANVs
	 */
	public void doAction(ActionEvent e) {
	// o[W
	if ( getActionName().equals( VERSION ) ) {
		((Ridual)getApp()).showVersion();
	} else if ( getActionName().equals( HELPDOC ) ) {
		ZResource res = getApp().getResource();
		String szCmd = res.getString("generate.browser_command");
		String szFil = res.getString("app.install.path")+File.separator+
						"help"+File.separator+"index.html";
		try{ szFil = new File(szFil).toURL().toExternalForm(); }
		catch( java.net.MalformedURLException ex){ ex.printStackTrace(); }
		if ( szCmd != null ) {
			if ( !RidExecAction.exec( szCmd, szFil ) ) {
				RidMessage ridMsg = new RidMessage();
				MessageDialog.showError(ridMsg.Error("E1901",szCmd+" "+szFil));
			}
		}
	} else if ( getActionName().equals( LICENSE ) ) {
		new LicenseDialog().show();
	}
	
	}

	/**
	 * UIXV
	 */
	public void update() {
	}
	
	private class LicenseDialog extends JDialog {
		public JTextField name = new JTextField();
		public JTextField mail = new JTextField();
		
		private GridBagConstraints	constraints	= new GridBagConstraints();
		private GridBagLayout		gridbag		= new GridBagLayout();
		
		public LicenseDialog(){
			super(getApp().getFrame());
			
			ZResource res = getApp().getResource();
			setTitle(res.getString("msg.license.title"));
			
			JPanel pnl = new JPanel(gridbag);
			pnl.setBorder(new EmptyBorder(6, 4, 0, 4));
			
			addCaptionedComponent(pnl, res.getString("msg.license.name"), name);
			addCaptionedComponent(pnl, res.getString("msg.license.mail"), mail);
			JPanel panel = new JPanel();
			panel.add(new JButton(new OkAction()));
			panel.add(new JButton(new CancelAction()));
			addButtonsComponent(pnl, panel);
			
			getContentPane().add(pnl ,BorderLayout.CENTER);
		}
		
		public void show(){
			ZResource res = getApp().getResource();
			name.setText(res.getString("license.name"));
			mail.setText(res.getString("license.mail"));
			
			super.show();
			pack();
			Dimension dim = getToolkit().getScreenSize();
			setLocation( dim.width/2 - getWidth()/2, dim.height/2 - getHeight()/2 );
		}
		
		private void addCaptionedComponent(JPanel pnl, String caption, Component c) {
			addConstraintsComponent(pnl, new JLabel(caption), 1);
			
			constraints.weightx = 1;
			constraints.fill = GridBagConstraints.HORIZONTAL;
			addConstraintsComponent(pnl, c, GridBagConstraints.REMAINDER);
			constraints.weightx = 0.0;
			constraints.fill = GridBagConstraints.NONE;
		}
		
		private void addButtonsComponent(JPanel pnl, Component c) {
			constraints.weightx = 1;
			constraints.fill = GridBagConstraints.HORIZONTAL;
	        constraints.insets  = new Insets(0,32,0,32) ;
			addConstraintsComponent(pnl, c, GridBagConstraints.REMAINDER);
			constraints.weightx = 0.0;
			constraints.fill = GridBagConstraints.NONE;
		}
		
		private void addConstraintsComponent(JPanel pnl, Component comp, int width){
			constraints.gridwidth = width;
			gridbag.setConstraints(comp, constraints);
			pnl.add(comp);
		}
		
		private class OkAction extends AbstractAction{
			public OkAction(){ super("OK"); }
			public void actionPerformed(ActionEvent evt){
				dispose();
				ZResource res = getApp().getResource();
				res.putString("license.name", name.getText());
				res.putString("license.mail", mail.getText());
			}
		}
		
		private class CancelAction extends AbstractAction{
			public CancelAction(){ super("cancel"); }
			public void actionPerformed(ActionEvent evt){
				dispose();
			}
		}
	}

	//## Agr[g ###############################################
    /**
     * ANVFo[W̕\
     */
	final static public String VERSION			= "version" ;
    
	/**
     * ANVFCZX
     */
	final static public String LICENSE			= "license" ;

    /**
     * ANVFwv̕\
     */
	final static public String HELPDOC			= "helpdoc" ;
}
